/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueEncoder;
import com.alicp.jetcache.support.CacheEncodeException;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class KryoValueEncoder
extends AbstractValueEncoder {
    public static final KryoValueEncoder INSTANCE = new KryoValueEncoder(true);
    protected static int IDENTITY_NUMBER = 1251293826;
    static ThreadLocal<Kryo> kryoThreadLocal = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.setDefaultSerializer(CompatibleFieldSerializer.class);
        return kryo;
    });

    public KryoValueEncoder(boolean useIdentityNumber) {
        super(useIdentityNumber);
    }

    @Override
    public byte[] apply(Object value) {
        try {
            Kryo kryo = kryoThreadLocal.get();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
            Output output = new Output((OutputStream)bos);
            if (this.useIdentityNumber) {
                output.writeInt(IDENTITY_NUMBER);
            }
            kryo.writeClassAndObject(output, value);
            output.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("Kryo Encode error. ");
            sb.append("msg=").append(e.getMessage());
            throw new CacheEncodeException(sb.toString(), e);
        }
    }
}

