/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.embedded;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.embedded.EmbeddedCacheConfig;
import com.alicp.jetcache.embedded.InnerMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractEmbeddedCache<K, V>
extends AbstractCache<K, V> {
    protected EmbeddedCacheConfig<K, V> config;
    protected InnerMap innerMap;

    protected abstract InnerMap createAreaCache();

    public AbstractEmbeddedCache(EmbeddedCacheConfig<K, V> config) {
        this.config = config;
        this.innerMap = this.createAreaCache();
    }

    @Override
    public CacheConfig<K, V> config() {
        return this.config;
    }

    public Object buildKey(K key) {
        if (key == null) {
            return null;
        }
        Object newKey = key;
        Function keyConvertor = this.config.getKeyConvertor();
        if (keyConvertor != null) {
            newKey = keyConvertor.apply(key);
        }
        return newKey;
    }

    @Override
    protected CacheGetResult<V> do_GET(K key) {
        if (key == null) {
            return new CacheGetResult(CacheResultCode.FAIL, "illegal argument", null);
        }
        Object newKey = this.buildKey(key);
        CacheValueHolder holder = (CacheValueHolder)this.innerMap.getValue(newKey);
        return this.parseHolderResult(holder);
    }

    protected CacheGetResult<V> parseHolderResult(CacheValueHolder<V> holder) {
        long expireAfterAccess;
        long now = System.currentTimeMillis();
        if (holder == null) {
            return CacheGetResult.NOT_EXISTS_WITHOUT_MSG;
        }
        if (now >= holder.getExpireTime()) {
            return CacheGetResult.EXPIRED_WITHOUT_MSG;
        }
        long accessTime = holder.getAccessTime();
        holder.setAccessTime(now);
        if (this.config.isExpireAfterAccess() && now >= accessTime + (expireAfterAccess = this.config.getExpireAfterAccessInMillis())) {
            return CacheGetResult.EXPIRED_WITHOUT_MSG;
        }
        return new CacheGetResult<V>(CacheResultCode.SUCCESS, null, holder);
    }

    @Override
    protected MultiGetResult<K, V> do_GET_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return new MultiGetResult(CacheResultCode.FAIL, "illegal argument", null);
        }
        ArrayList keyList = new ArrayList(keys.size());
        ArrayList newKeyList = new ArrayList(keys.size());
        keys.stream().forEach(k -> {
            Object newKey = this.buildKey(k);
            keyList.add(k);
            newKeyList.add(newKey);
        });
        Map innerResultMap = this.innerMap.getAllValues(newKeyList);
        HashMap resultMap = new HashMap();
        for (int i = 0; i < keyList.size(); ++i) {
            Object key = keyList.get(i);
            Object newKey = newKeyList.get(i);
            CacheValueHolder holder = (CacheValueHolder)innerResultMap.get(newKey);
            resultMap.put(key, this.parseHolderResult(holder));
        }
        MultiGetResult result = new MultiGetResult(CacheResultCode.SUCCESS, null, resultMap);
        return result;
    }

    @Override
    protected CacheResult do_PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        CacheValueHolder<V> cacheObject = new CacheValueHolder<V>(value, timeUnit.toMillis(expireAfterWrite));
        this.innerMap.putValue(this.buildKey(key), cacheObject);
        return CacheResult.SUCCESS_WITHOUT_MSG;
    }

    @Override
    protected CacheResult do_PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        if (map == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        HashMap<Object, CacheValueHolder<V>> newKeyMap = new HashMap<Object, CacheValueHolder<V>>();
        for (Map.Entry<K, V> en : map.entrySet()) {
            CacheValueHolder<V> cacheObject = new CacheValueHolder<V>(en.getValue(), timeUnit.toMillis(expireAfterWrite));
            newKeyMap.put(this.buildKey(en.getKey()), cacheObject);
        }
        this.innerMap.putAllValues(newKeyMap);
        HashMap resultMap = new HashMap();
        map.keySet().forEach(k -> resultMap.put(k, CacheResultCode.SUCCESS));
        return CacheResult.SUCCESS_WITHOUT_MSG;
    }

    @Override
    protected CacheResult do_REMOVE(K key) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        this.innerMap.removeValue(this.buildKey(key));
        return CacheResult.SUCCESS_WITHOUT_MSG;
    }

    @Override
    protected CacheResult do_REMOVE_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        Set newKeys = keys.stream().map(key -> this.buildKey(key)).collect(Collectors.toSet());
        this.innerMap.removeAllValues(newKeys);
        HashMap resultMap = new HashMap();
        keys.forEach(k -> resultMap.put(k, CacheResultCode.SUCCESS));
        return CacheResult.SUCCESS_WITHOUT_MSG;
    }

    @Override
    protected CacheResult do_PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        CacheValueHolder<V> cacheObject = new CacheValueHolder<V>(value, timeUnit.toMillis(expireAfterWrite));
        if (this.innerMap.putIfAbsentValue(this.buildKey(key), cacheObject)) {
            return CacheResult.SUCCESS_WITHOUT_MSG;
        }
        return CacheResult.EXISTS_WITHOUT_MSG;
    }
}

