/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.AutoReleaseLock;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheInvokeException;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.MultiGetResult;
import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public interface Cache<K, V>
extends Closeable {
    default public V get(K key) throws CacheInvokeException {
        CacheGetResult<V> result = this.GET(key);
        if (result.isSuccess()) {
            return result.getValue();
        }
        return null;
    }

    default public Map<K, V> getAll(Set<? extends K> keys) throws CacheInvokeException {
        MultiGetResult<K, V> cacheGetResults = this.GET_ALL(keys);
        return cacheGetResults.unwrapValues();
    }

    default public void put(K key, V value) {
        this.PUT(key, value);
    }

    default public void putAll(Map<? extends K, ? extends V> map) {
        this.PUT_ALL(map);
    }

    default public boolean putIfAbsent(K key, V value) {
        CacheResult result = this.PUT_IF_ABSENT(key, value, this.config().getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS);
        return result.getResultCode() == CacheResultCode.SUCCESS;
    }

    default public boolean remove(K key) {
        return this.REMOVE(key).isSuccess();
    }

    default public void removeAll(Set<? extends K> keys) {
        this.REMOVE_ALL(keys);
    }

    public <T> T unwrap(Class<T> var1);

    @Override
    default public void close() {
    }

    public CacheConfig<K, V> config();

    public AutoReleaseLock tryLock(K var1, long var2, TimeUnit var4);

    default public boolean tryLockAndRun(K key, long expire, TimeUnit timeUnit, Runnable action) {
        try (AutoReleaseLock lock = this.tryLock(key, expire, timeUnit);){
            if (lock != null) {
                action.run();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public CacheGetResult<V> GET(K var1);

    public MultiGetResult<K, V> GET_ALL(Set<? extends K> var1);

    default public V computeIfAbsent(K key, Function<K, V> loader) {
        return this.computeIfAbsent(key, loader, this.config().isCacheNullValue());
    }

    default public V computeIfAbsent(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull) {
        CacheGetResult<V> r = this.GET(key);
        if (r.isSuccess()) {
            return r.getValue();
        }
        V loadedValue = loader.apply(key);
        if (loadedValue != null || cacheNullWhenLoaderReturnNull) {
            this.put(key, loadedValue);
        }
        return loadedValue;
    }

    default public V computeIfAbsent(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull, long expireAfterWrite, TimeUnit timeUnit) {
        CacheGetResult<V> r = this.GET(key);
        if (r.isSuccess()) {
            return r.getValue();
        }
        V loadedValue = loader.apply(key);
        if (loadedValue != null || cacheNullWhenLoaderReturnNull) {
            this.PUT(key, loadedValue, expireAfterWrite, timeUnit);
        }
        return loadedValue;
    }

    default public void put(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        this.PUT(key, value, expireAfterWrite, timeUnit);
    }

    default public CacheResult PUT(K key, V value) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        return this.PUT(key, value, this.config().getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS);
    }

    public CacheResult PUT(K var1, V var2, long var3, TimeUnit var5);

    default public void putAll(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        this.PUT_ALL(map, expireAfterWrite, timeUnit);
    }

    default public CacheResult PUT_ALL(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        return this.PUT_ALL(map, this.config().getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS);
    }

    public CacheResult PUT_ALL(Map<? extends K, ? extends V> var1, long var2, TimeUnit var4);

    public CacheResult REMOVE(K var1);

    public CacheResult REMOVE_ALL(Set<? extends K> var1);

    public CacheResult PUT_IF_ABSENT(K var1, V var2, long var3, TimeUnit var5);
}

