/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.embedded;

import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.embedded.Cleaner;
import com.alicp.jetcache.embedded.EmbeddedCacheConfig;
import com.alicp.jetcache.embedded.InnerMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedHashMapCache<K, V>
extends AbstractEmbeddedCache<K, V> {
    private static Logger logger = LoggerFactory.getLogger(LinkedHashMapCache.class);

    public LinkedHashMapCache(EmbeddedCacheConfig<K, V> config) {
        super(config);
        this.addToCleaner();
    }

    protected void addToCleaner() {
        Cleaner.add(this);
    }

    @Override
    protected InnerMap createAreaCache() {
        return new LRUMap(this.config.getLimit(), this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.equals(LinkedHashMap.class)) {
            return (T)this.innerMap;
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    public void cleanExpiredEntry() {
        ((LRUMap)this.innerMap).cleanExpiredEntry();
    }

    static final class LRUMap
    extends LinkedHashMap
    implements InnerMap {
        private final int max;
        private Object lock;

        public LRUMap(int max, Object lock) {
            super((int)((float)max * 1.4f), 0.75f, true);
            this.max = max;
            this.lock = lock;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.max;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanExpiredEntry() {
            Object object = this.lock;
            synchronized (object) {
                Iterator it = this.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry en = it.next();
                    Object value = en.getValue();
                    if (value != null && value instanceof CacheValueHolder) {
                        CacheValueHolder h = (CacheValueHolder)value;
                        if (System.currentTimeMillis() < h.getExpireTime()) continue;
                        it.remove();
                        continue;
                    }
                    if (value == null) {
                        logger.error("key " + en.getKey() + " is null");
                        continue;
                    }
                    logger.error("value of key " + en.getKey() + " is not a CacheValueHolder. type=" + value.getClass());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(Object key) {
            Object object = this.lock;
            synchronized (object) {
                return this.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map getAllValues(Collection keys) {
            HashMap values = new HashMap();
            Object object = this.lock;
            synchronized (object) {
                for (Object key : keys) {
                    Object v = this.get(key);
                    if (v == null) continue;
                    values.put(key, v);
                }
            }
            return values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putValue(Object key, Object value) {
            Object object = this.lock;
            synchronized (object) {
                this.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAllValues(Map map) {
            Object object = this.lock;
            synchronized (object) {
                Set set = map.entrySet();
                for (Map.Entry en : set) {
                    this.put(en.getKey(), en.getValue());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeValue(Object key) {
            Object object = this.lock;
            synchronized (object) {
                return this.remove(key) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAllValues(Collection keys) {
            Object object = this.lock;
            synchronized (object) {
                for (Object k : keys) {
                    this.remove(k);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean putIfAbsentValue(Object key, Object value) {
            Object object = this.lock;
            synchronized (object) {
                if (this.get(key) == null) {
                    this.put(key, value);
                    return true;
                }
                return false;
            }
        }
    }
}

