/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.CacheMonitor;
import com.alicp.jetcache.RefreshPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class CacheConfig<K, V>
implements Cloneable {
    private long expireAfterWriteInMillis = 2147483647000L;
    private long expireAfterAccessInMillis = 0L;
    private Function<K, Object> keyConvertor;
    private CacheLoader<K, V> loader;
    private List<CacheMonitor> monitors = new ArrayList<CacheMonitor>();
    private boolean cacheNullValue = false;
    private RefreshPolicy refreshPolicy;

    public CacheConfig clone() {
        try {
            CacheConfig copy = (CacheConfig)super.clone();
            if (this.monitors != null) {
                copy.monitors = new ArrayList<CacheMonitor>(this.monitors);
            }
            if (this.refreshPolicy != null) {
                copy.refreshPolicy = this.refreshPolicy.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException(e);
        }
    }

    public Function<K, Object> getKeyConvertor() {
        return this.keyConvertor;
    }

    public void setKeyConvertor(Function<K, Object> keyConvertor) {
        this.keyConvertor = keyConvertor;
    }

    public boolean isExpireAfterAccess() {
        return this.expireAfterAccessInMillis > 0L;
    }

    public boolean isExpireAfterWrite() {
        return this.expireAfterWriteInMillis > 0L;
    }

    @Deprecated
    public long getDefaultExpireInMillis() {
        return this.expireAfterWriteInMillis;
    }

    @Deprecated
    public void setDefaultExpireInMillis(long defaultExpireInMillis) {
        this.expireAfterWriteInMillis = defaultExpireInMillis;
    }

    public long getExpireAfterWriteInMillis() {
        return this.expireAfterWriteInMillis;
    }

    public void setExpireAfterWriteInMillis(long expireAfterWriteInMillis) {
        this.expireAfterWriteInMillis = expireAfterWriteInMillis;
    }

    public long getExpireAfterAccessInMillis() {
        return this.expireAfterAccessInMillis;
    }

    public void setExpireAfterAccessInMillis(long expireAfterAccessInMillis) {
        this.expireAfterAccessInMillis = expireAfterAccessInMillis;
    }

    public CacheLoader<K, V> getLoader() {
        return this.loader;
    }

    public void setLoader(CacheLoader<K, V> loader) {
        this.loader = loader;
    }

    public boolean isCacheNullValue() {
        return this.cacheNullValue;
    }

    public void setCacheNullValue(boolean cacheNullValue) {
        this.cacheNullValue = cacheNullValue;
    }

    public List<CacheMonitor> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<CacheMonitor> monitors) {
        this.monitors = monitors;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void setRefreshPolicy(RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
    }
}

