/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.embedded;

import com.alicp.jetcache.AutoReleaseLock;
import com.alicp.jetcache.Cache;
import java.util.concurrent.TimeUnit;

public class SimpleLock
implements AutoReleaseLock {
    private Cache cache;
    private Object key;
    private long expireTimestamp;

    private SimpleLock(Cache cache, Object key, long expireTimestamp) {
        this.cache = cache;
        this.key = key;
        this.expireTimestamp = expireTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleLock tryLock(Cache cache, Object key, long expire, TimeUnit timeUnit) {
        long expireTimestamp = System.currentTimeMillis() + timeUnit.toMillis(expire);
        Cache cache2 = cache;
        synchronized (cache2) {
            Object fromCache = cache.get(key);
            if (fromCache == null) {
                SimpleLock lock = new SimpleLock(cache, key, expireTimestamp);
                cache.put(key, Boolean.TRUE, expire, timeUnit);
                return lock;
            }
            return null;
        }
    }

    @Override
    public void close() {
        long t = System.currentTimeMillis();
        if (t < this.expireTimestamp) {
            this.cache.remove(this.key);
        }
    }
}

