/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.embedded;

import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.embedded.EmbeddedCacheConfig;
import com.alicp.jetcache.embedded.InnerMap;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CaffeineCache<K, V>
extends AbstractEmbeddedCache<K, V> {
    private Cache cache;

    public CaffeineCache(EmbeddedCacheConfig<K, V> config) {
        super(config);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.equals(Cache.class)) {
            return (T)this.cache;
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    @Override
    protected InnerMap createAreaCache() {
        Caffeine builder = Caffeine.newBuilder();
        builder.maximumSize((long)this.config.getLimit());
        if (this.config.isExpireAfterAccess()) {
            builder.expireAfterAccess(this.config.getExpireAfterAccessInMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.config.isExpireAfterWrite()) {
            builder.expireAfterWrite(this.config.getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS);
        }
        this.cache = builder.build();
        return new InnerMap(){

            @Override
            public Object getValue(Object key) {
                return CaffeineCache.this.cache.getIfPresent(key);
            }

            @Override
            public Map getAllValues(Collection keys) {
                return CaffeineCache.this.cache.getAllPresent((Iterable)keys);
            }

            @Override
            public void putValue(Object key, Object value) {
                CaffeineCache.this.cache.put(key, value);
            }

            @Override
            public void putAllValues(Map map) {
                CaffeineCache.this.cache.putAll(map);
            }

            @Override
            public boolean removeValue(Object key) {
                return CaffeineCache.this.cache.asMap().remove(key) != null;
            }

            @Override
            public void removeAllValues(Collection keys) {
                CaffeineCache.this.cache.invalidateAll((Iterable)keys);
            }

            @Override
            public boolean putIfAbsentValue(Object key, Object value) {
                return CaffeineCache.this.cache.asMap().putIfAbsent(key, value) == null;
            }
        };
    }
}

