/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.ResultData;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public class CacheResult {
    public static final String MSG_ILLEGAL_ARGUMENT = "illegal argument";
    public static final CacheResult SUCCESS_WITHOUT_MSG = new CacheResult(CacheResultCode.SUCCESS, null);
    public static final CacheResult PART_SUCCESS_WITHOUT_MSG = new CacheResult(CacheResultCode.PART_SUCCESS, null);
    public static final CacheResult FAIL_WITHOUT_MSG = new CacheResult(CacheResultCode.FAIL, null);
    public static final CacheResult FAIL_ILLEGAL_ARGUMENT = new CacheResult(CacheResultCode.FAIL, "illegal argument");
    public static final CacheResult EXISTS_WITHOUT_MSG = new CacheResult(CacheResultCode.EXISTS, null);
    private CacheResultCode resultCode;
    private String message;
    private CompletionStage<ResultData> future;

    public CacheResult(CompletionStage<ResultData> future) {
        this.future = future;
    }

    public CacheResult(CacheResultCode resultCode, String message) {
        this(CompletableFuture.completedFuture(new ResultData(resultCode, message, null)));
    }

    public CacheResult(Throwable ex) {
        this.future = CompletableFuture.completedFuture(new ResultData(ex));
    }

    public boolean isSuccess() {
        return this.getResultCode() == CacheResultCode.SUCCESS;
    }

    protected void waitForResult() {
        if (this.resultCode != null) {
            return;
        }
        try {
            ResultData resultData = this.future.toCompletableFuture().get();
            this.fetchResultSuccess(resultData);
        }
        catch (InterruptedException | ExecutionException e) {
            this.fetchResultFail(e);
        }
    }

    protected void fetchResultSuccess(ResultData resultData) {
        this.resultCode = resultData.getResultCode();
        this.message = resultData.getMessage();
    }

    protected void fetchResultFail(Throwable e) {
        this.resultCode = CacheResultCode.FAIL;
        this.message = e.getClass() + ":" + e.getMessage();
    }

    public CacheResultCode getResultCode() {
        this.waitForResult();
        return this.resultCode;
    }

    public String getMessage() {
        this.waitForResult();
        return this.message;
    }

    public CompletionStage<ResultData> future() {
        return this.future;
    }
}

