/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.telnet.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.termd.core.function.Supplier;
import io.termd.core.telnet.TelnetHandler;
import io.termd.core.telnet.netty.NettyTelnetConnection;
import io.termd.core.util.Logging;

public class TelnetChannelHandler
extends ChannelInboundHandlerAdapter {
    private final Supplier<TelnetHandler> factory;
    private NettyTelnetConnection conn;

    public TelnetChannelHandler(Supplier<TelnetHandler> factory) {
        this.factory = factory;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf buf = (ByteBuf)msg;
        int size = buf.readableBytes();
        byte[] data = new byte[size];
        buf.getBytes(0, data);
        this.conn.receive(data);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.conn = new NettyTelnetConnection(this.factory.get(), ctx);
        this.conn.onInit();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.conn.onClose();
        this.conn = null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Logging.logReportedIoError(cause);
        ctx.close();
    }
}

