/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.ssh.netty;

import io.termd.core.function.Consumer;
import io.termd.core.ssh.netty.AsyncAuth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionHolder;

public class AsyncUserAuthService
extends AbstractCloseable
implements Service,
ServerSessionHolder {
    private final ServerSession serverSession;
    private List<NamedFactory<UserAuth>> userAuthFactories;
    private List<List<String>> authMethods;
    private String authUserName;
    private String authMethod;
    private String authService;
    private UserAuth currentAuth;
    private AsyncAuth async;
    private int maxAuthRequests;
    private int nbAuthRequests;

    public AsyncUserAuthService(Session s) throws SshException {
        ValidateUtils.checkTrue((boolean)(s instanceof ServerSession), (String)"Server side service used on client side");
        if (s.isAuthenticated()) {
            throw new SshException("Session already authenticated");
        }
        this.serverSession = (ServerSession)s;
        this.maxAuthRequests = PropertyResolverUtils.getIntProperty((PropertyResolver)s, (String)"max-auth-requests", (int)20);
        List factories = (List)ValidateUtils.checkNotNullAndNotEmpty((Collection)this.serverSession.getUserAuthFactories(), (String)"No user auth factories for %s", (Object[])new Object[]{s});
        this.userAuthFactories = new ArrayList<NamedFactory<UserAuth>>(factories);
        this.authMethods = new ArrayList<List<String>>();
        String mths = PropertyResolverUtils.getString((PropertyResolver)s, (String)"auth-methods");
        if (GenericUtils.isEmpty((CharSequence)mths)) {
            for (NamedFactory namedFactory : factories) {
                this.authMethods.add(new ArrayList<String>(Collections.singletonList(namedFactory.getName())));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ServerUserAuthService({}) using configured methods={}", (Object)s, (Object)mths);
            }
            for (String mthl : mths.split("\\s")) {
                this.authMethods.add(new ArrayList<String>(Arrays.asList(GenericUtils.split((String)mthl, (char)','))));
            }
        }
        for (List list : this.authMethods) {
            for (String m : list) {
                NamedFactory factory = (NamedFactory)NamedResource.Utils.findByName((String)m, (Comparator)String.CASE_INSENSITIVE_ORDER, this.userAuthFactories);
                if (factory != null) continue;
                throw new SshException("Configured method is not supported: " + m);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("ServerUserAuthService({}) authorized authentication methods: {}", (Object)s, (Object)NamedResource.Utils.getNames(this.userAuthFactories));
        }
    }

    public void start() {
    }

    public ServerSession getSession() {
        return this.getServerSession();
    }

    public ServerSession getServerSession() {
        return this.serverSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(int cmd, Buffer buffer) throws Exception {
        Boolean authed;
        block32: {
            authed = Boolean.FALSE;
            ServerSession session = this.getServerSession();
            if (cmd == 50) {
                Factory factory;
                if (this.currentAuth != null) {
                    try {
                        this.currentAuth.destroy();
                    }
                    finally {
                        this.currentAuth = null;
                    }
                }
                String username = buffer.getString();
                String service = buffer.getString();
                String method = buffer.getString();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Received SSH_MSG_USERAUTH_REQUEST user={}, service={}, method={}", new Object[]{session, username, service, method});
                }
                if (this.authUserName == null || this.authService == null) {
                    this.authUserName = username;
                    this.authService = service;
                } else if (this.authUserName.equals(username) && this.authService.equals(service)) {
                    if (this.nbAuthRequests++ > this.maxAuthRequests) {
                        session.disconnect(2, "Too many authentication failures: " + this.nbAuthRequests);
                        return;
                    }
                } else {
                    session.disconnect(2, "Change of username or service is not allowed (" + this.authUserName + ", " + this.authService + ") -> (" + username + ", " + service + ")");
                    return;
                }
                this.authMethod = method;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Authenticating user '{}' with service '{}' and method '{}' (attempt {} / {})", new Object[]{session, username, service, method, this.nbAuthRequests, this.maxAuthRequests});
                }
                if ((factory = (Factory)NamedResource.Utils.findByName((String)method, (Comparator)String.CASE_INSENSITIVE_ORDER, this.userAuthFactories)) != null) {
                    this.currentAuth = (UserAuth)ValidateUtils.checkNotNull((Object)factory.create(), (String)"No authenticator created for method=%s", (Object)method);
                    try {
                        authed = this.currentAuth.auth(session, username, service, buffer);
                    }
                    catch (Exception e) {
                        if (this.asyncAuth(cmd, buffer, e)) {
                            return;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("process({}) Failed ({}) to authenticate using factory method={}: {}", new Object[]{session, e.getClass().getSimpleName(), method, e.getMessage()});
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("process(" + session + ") factory authentication=" + method + " failure details", (Throwable)e);
                        }
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) no authentication factory for method={}", (Object)session, (Object)method);
                }
            } else {
                if (this.currentAuth == null) {
                    throw new IllegalStateException("No current authentication mechanism for cmd=" + SshConstants.getCommandMessageName((int)cmd));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Received authentication message={} for mechanism={}", new Object[]{session, SshConstants.getCommandMessageName((int)cmd), this.currentAuth.getName()});
                }
                buffer.rpos(buffer.rpos() - 1);
                try {
                    authed = this.currentAuth.next(buffer);
                }
                catch (Exception e) {
                    if (this.asyncAuth(cmd, buffer, e)) {
                        return;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("process({}) Failed ({}) to authenticate using current method={}: {}", new Object[]{session, e.getClass().getSimpleName(), this.currentAuth.getName(), e.getMessage()});
                    }
                    if (!this.log.isTraceEnabled()) break block32;
                    this.log.trace("process(" + session + ") current authentiaction=" + this.currentAuth.getName() + " failure details", (Throwable)e);
                }
            }
        }
        if (authed == null) {
            this.handleAuthenticationInProgress(cmd, buffer);
        } else if (authed.booleanValue()) {
            this.handleAuthenticationSuccess(cmd, buffer);
        } else {
            this.handleAuthenticationFailure(cmd, buffer);
        }
    }

    private boolean asyncAuth(final int cmd, final Buffer buffer, Exception e) {
        if (e instanceof AsyncAuth) {
            this.async = (AsyncAuth)e;
            this.async.setListener(new Consumer<Boolean>(){

                @Override
                public void accept(Boolean authenticated) {
                    AsyncUserAuthService.this.async = null;
                    try {
                        if (authenticated.booleanValue()) {
                            AsyncUserAuthService.this.handleAuthenticationSuccess(cmd, buffer);
                        } else {
                            AsyncUserAuthService.this.handleAuthenticationFailure(cmd, buffer);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            });
            return true;
        }
        return false;
    }

    protected void handleAuthenticationInProgress(int cmd, Buffer buffer) throws Exception {
        String username;
        String string = username = this.currentAuth == null ? null : this.currentAuth.getUsername();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleAuthenticationInProgress({}@{}) {}", new Object[]{username, this.getServerSession(), SshConstants.getCommandMessageName((int)cmd)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticationSuccess(int cmd, Buffer buffer) throws Exception {
        String username = ((UserAuth)ValidateUtils.checkNotNull((Object)this.currentAuth, (String)"No current auth")).getUsername();
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleAuthenticationSuccess({}@{}) {}", new Object[]{username, session, SshConstants.getCommandMessageName((int)cmd)});
        }
        boolean success = false;
        for (List<String> l : this.authMethods) {
            if (GenericUtils.size(l) <= 0 || !l.get(0).equals(this.authMethod)) continue;
            l.remove(0);
            success |= l.isEmpty();
        }
        if (success) {
            int currentSessionCount;
            Integer maxSessionCount = PropertyResolverUtils.getInteger((PropertyResolver)session, (String)"max-concurrent-sessions");
            if (maxSessionCount != null && (currentSessionCount = session.getActiveSessionCountForUser(username)) >= maxSessionCount) {
                session.disconnect(12, "Too many concurrent connections (" + currentSessionCount + ") - max. allowed: " + maxSessionCount);
                return;
            }
            String welcomeBanner = PropertyResolverUtils.getString((PropertyResolver)session, (String)"welcome-banner");
            if (GenericUtils.length((CharSequence)welcomeBanner) > 0) {
                String lang = PropertyResolverUtils.getStringProperty((PropertyResolver)session, (String)"welcome-banner-language", (String)"en");
                buffer = session.createBuffer((byte)53, welcomeBanner.length() + GenericUtils.length((CharSequence)lang) + 64);
                buffer.putString(welcomeBanner);
                buffer.putString(lang);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleAuthenticationSuccess({}@{}) send banner (length={}, lang={})", new Object[]{username, session, welcomeBanner.length(), lang});
                }
                session.writePacket(buffer);
            }
            buffer = session.createBuffer((byte)52, 8);
            session.writePacket(buffer);
            session.setUsername(username);
            session.setAuthenticated();
            session.startService(this.authService);
            session.resetIdleTimeout();
            this.log.info("Session {}@{} authenticated", (Object)username, (Object)session.getIoSession().getRemoteAddress());
        } else {
            StringBuilder sb = new StringBuilder();
            for (List<String> l : this.authMethods) {
                if (GenericUtils.size(l) <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(l.get(0));
            }
            String remaining = sb.toString();
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleAuthenticationSuccess({}@{}) remaining methods={}", new Object[]{username, session, remaining});
            }
            buffer = session.createBuffer((byte)51, remaining.length() + 8);
            buffer.putString(remaining);
            buffer.putBoolean(true);
            session.writePacket(buffer);
        }
        try {
            this.currentAuth.destroy();
        }
        finally {
            this.currentAuth = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticationFailure(int cmd, Buffer buffer) throws Exception {
        String username = this.currentAuth == null ? null : this.currentAuth.getUsername();
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleAuthenticationFailure({}@{}) {}", new Object[]{username, session, SshConstants.getCommandMessageName((int)cmd)});
        }
        StringBuilder sb = new StringBuilder((this.authMethods.size() + 1) * 8);
        for (List<String> l : this.authMethods) {
            String m;
            if (GenericUtils.size(l) <= 0 || "none".equals(m = l.get(0))) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(m);
        }
        String remaining = sb.toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleAuthenticationFailure({}@{}) remaining methods: {}", new Object[]{username, session, remaining});
        }
        buffer = session.createBuffer((byte)51, remaining.length() + 8);
        buffer.putString(remaining);
        buffer.putBoolean(false);
        session.writePacket(buffer);
        if (this.currentAuth != null) {
            try {
                this.currentAuth.destroy();
            }
            finally {
                this.currentAuth = null;
            }
        }
    }

    public ServerFactoryManager getFactoryManager() {
        return this.serverSession.getFactoryManager();
    }
}

