/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.telnet;

import io.termd.core.telnet.TelnetConnection;

public enum Option {
    BINARY(0){

        @Override
        void handleDo(TelnetConnection session) {
            session.sendBinary = true;
            session.handler.onSendBinary(true);
        }

        @Override
        void handleDont(TelnetConnection session) {
            session.sendBinary = false;
            session.handler.onSendBinary(false);
        }

        @Override
        void handleWill(TelnetConnection session) {
            session.receiveBinary = true;
            session.handler.onReceiveBinary(true);
        }

        @Override
        void handleWont(TelnetConnection session) {
            session.receiveBinary = false;
            session.handler.onReceiveBinary(false);
        }
    }
    ,
    ECHO(1){

        @Override
        void handleDo(TelnetConnection session) {
            session.handler.onEcho(true);
        }

        @Override
        void handleDont(TelnetConnection session) {
            session.handler.onEcho(false);
        }
    }
    ,
    SGA(3){

        @Override
        void handleDo(TelnetConnection session) {
            session.handler.onSGA(true);
        }

        @Override
        void handleDont(TelnetConnection session) {
            session.handler.onSGA(false);
        }
    }
    ,
    TERMINAL_TYPE(24){
        final byte BYTE_IS = 0;
        final byte BYTE_SEND = 1;

        @Override
        void handleWill(TelnetConnection session) {
            session.send(new byte[]{-1, -6, this.code, 1, -1, -16});
        }

        @Override
        void handleWont(TelnetConnection session) {
        }

        @Override
        void handleParameters(TelnetConnection session, byte[] parameters) {
            if (parameters.length > 0 && parameters[0] == 0) {
                String terminalType = new String(parameters, 1, parameters.length - 1);
                session.handler.onTerminalType(terminalType);
            }
        }
    }
    ,
    NAWS(31){

        @Override
        void handleWill(TelnetConnection session) {
            session.handler.onNAWS(true);
        }

        @Override
        void handleWont(TelnetConnection session) {
            session.handler.onNAWS(false);
        }

        @Override
        void handleParameters(TelnetConnection session, byte[] parameters) {
            if (parameters.length == 4) {
                int width = ((parameters[0] & 0xFF) << 8) + (parameters[1] & 0xFF);
                int height = ((parameters[2] & 0xFF) << 8) + (parameters[3] & 0xFF);
                session.handler.onSize(width, height);
            }
        }
    };

    final byte code;

    private Option(byte code) {
        this.code = code;
    }

    void handleDo(TelnetConnection session) {
    }

    void handleDont(TelnetConnection session) {
    }

    void handleWill(TelnetConnection session) {
    }

    void handleWont(TelnetConnection session) {
    }

    void handleParameters(TelnetConnection session, byte[] parameters) {
    }
}

