/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.readline;

import io.termd.core.readline.FunctionEvent;
import io.termd.core.readline.InputrcParser;
import io.termd.core.readline.KeyEvent;
import io.termd.core.readline.Keys;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Keymap {
    final List<KeyEvent> bindings;

    public static Keymap getDefault() {
        InputStream inputrc = Keymap.class.getResourceAsStream("inputrc");
        return new Keymap(inputrc);
    }

    public Keymap() {
        this.bindings = new ArrayList<KeyEvent>();
        Collections.addAll(this.bindings, Keys.values());
    }

    public Keymap(List<KeyEvent> keys) {
        this.bindings = new ArrayList<KeyEvent>(keys);
    }

    public Keymap(InputStream inputrc) {
        final ArrayList<KeyEvent> actions = new ArrayList<KeyEvent>();
        InputrcParser handler = new InputrcParser(){

            @Override
            public void bindFunction(int[] keySequence, String functionName) {
                actions.add(new FunctionEvent(functionName, keySequence));
            }
        };
        InputrcParser.parse(inputrc, handler);
        this.bindings = actions;
    }

    public Keymap bindFunction(String keyseq, String function) {
        return this.bindFunction(InputrcParser.parseKeySeq(keyseq), function);
    }

    public Keymap bindFunction(int[] keyseq, String function) {
        this.bindings.add(new FunctionEvent(function, keyseq));
        return this;
    }
}

