/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.telnet.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.termd.core.telnet.TelnetConnection;
import io.termd.core.telnet.TelnetHandler;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class NettyTelnetConnection
extends TelnetConnection {
    final ChannelHandlerContext context;

    public NettyTelnetConnection(TelnetHandler handler, ChannelHandlerContext context) {
        super(handler);
        this.context = context;
    }

    @Override
    protected void execute(Runnable task) {
        this.context.channel().eventLoop().execute(task);
    }

    @Override
    protected void schedule(Runnable task, long delay, TimeUnit unit) {
        this.context.channel().eventLoop().schedule(task, delay, unit);
    }

    @Override
    protected void send(byte[] data) {
        final byte[] copy = Arrays.copyOf(data, data.length);
        Runnable writeTask = new Runnable(){

            @Override
            public void run() {
                if (NettyTelnetConnection.this.context.channel().isActive()) {
                    NettyTelnetConnection.this.context.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])copy));
                }
            }
        };
        if (this.context.channel().eventLoop().inEventLoop()) {
            writeTask.run();
        } else {
            this.context.channel().eventLoop().execute(writeTask);
        }
    }

    @Override
    protected void onClose() {
        super.onClose();
    }

    @Override
    public void close() {
        Runnable closeTask = new Runnable(){

            @Override
            public void run() {
                NettyTelnetConnection.this.context.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        };
        if (this.context.channel().eventLoop().inEventLoop()) {
            closeTask.run();
        } else {
            this.context.channel().eventLoop().execute(closeTask);
        }
    }

    public ChannelHandlerContext channelHandlerContext() {
        return this.context;
    }
}

