/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.termd.core.function.Consumer;
import io.termd.core.http.HttpTtyConnection;
import io.termd.core.tty.TtyConnection;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class TtyWebSocketFrameHandler
extends SimpleChannelInboundHandler<TextWebSocketFrame> {
    private final ChannelGroup group;
    private final Consumer<TtyConnection> handler;
    private ChannelHandlerContext context;
    private HttpTtyConnection conn;
    private Class removingHandlerClass;

    public TtyWebSocketFrameHandler(ChannelGroup group, Consumer<TtyConnection> handler, Class removingHandlerClass) {
        this.group = group;
        this.handler = handler;
        this.removingHandlerClass = removingHandlerClass;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.context = ctx;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            if (this.removingHandlerClass != null) {
                ctx.pipeline().remove(this.removingHandlerClass);
            }
            this.group.add((Object)ctx.channel());
            this.conn = new HttpTtyConnection(){

                @Override
                protected void write(byte[] buffer) {
                    final ChannelHandlerContext ctx = TtyWebSocketFrameHandler.this.context;
                    if (ctx == null) {
                        return;
                    }
                    final byte[] copy = Arrays.copyOf(buffer, buffer.length);
                    Runnable writeTask = new Runnable(){

                        @Override
                        public void run() {
                            if (TtyWebSocketFrameHandler.this.context != null && ctx.channel().isActive()) {
                                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])copy);
                                ctx.writeAndFlush((Object)new TextWebSocketFrame(byteBuf));
                            }
                        }
                    };
                    if (ctx.executor().inEventLoop()) {
                        writeTask.run();
                    } else {
                        ctx.executor().execute(writeTask);
                    }
                }

                @Override
                public void schedule(Runnable task, long delay, TimeUnit unit) {
                    if (TtyWebSocketFrameHandler.this.context != null) {
                        TtyWebSocketFrameHandler.this.context.executor().schedule(task, delay, unit);
                    }
                }

                @Override
                public void execute(Runnable task) {
                    if (TtyWebSocketFrameHandler.this.context != null) {
                        TtyWebSocketFrameHandler.this.context.executor().execute(task);
                    }
                }

                @Override
                public void close() {
                    final ChannelHandlerContext ctx = TtyWebSocketFrameHandler.this.context;
                    if (ctx == null) {
                        return;
                    }
                    Runnable closeTask = new Runnable(){

                        @Override
                        public void run() {
                            if (TtyWebSocketFrameHandler.this.context != null) {
                                ctx.close();
                            }
                        }
                    };
                    if (ctx.executor().inEventLoop()) {
                        closeTask.run();
                    } else {
                        ctx.executor().execute(closeTask);
                    }
                }
            };
            this.handler.accept(this.conn);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Consumer<Void> closeHandler;
        HttpTtyConnection tmp = this.conn;
        this.context = null;
        this.conn = null;
        if (tmp != null && (closeHandler = tmp.getCloseHandler()) != null) {
            closeHandler.accept(null);
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame msg) throws Exception {
        this.conn.writeToDecoder(msg.text());
    }
}

