/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.instrument;

import com.alibaba.metrics.Counter;
import com.alibaba.metrics.Meter;
import com.alibaba.metrics.MetricRegistry;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class InstrumentedThreadFactory
implements ThreadFactory {
    private static final AtomicLong nameCounter = new AtomicLong();
    private final ThreadFactory delegate;
    private final Meter created;
    private final Counter running;
    private final Meter terminated;

    public InstrumentedThreadFactory(ThreadFactory delegate, MetricRegistry registry) {
        this(delegate, registry, "instrumented-thread-delegate-" + nameCounter.incrementAndGet());
    }

    public InstrumentedThreadFactory(ThreadFactory delegate, MetricRegistry registry, String name) {
        this.delegate = delegate;
        this.created = registry.meter(MetricRegistry.name((String)name, (String[])new String[]{"created"}));
        this.running = registry.counter(MetricRegistry.name((String)name, (String[])new String[]{"running"}));
        this.terminated = registry.meter(MetricRegistry.name((String)name, (String[])new String[]{"terminated"}));
    }

    @Override
    public Thread newThread(Runnable runnable) {
        InstrumentedRunnable wrappedRunnable = new InstrumentedRunnable(runnable);
        Thread thread = this.delegate.newThread(wrappedRunnable);
        this.created.mark();
        return thread;
    }

    private class InstrumentedRunnable
    implements Runnable {
        private final Runnable task;

        InstrumentedRunnable(Runnable task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InstrumentedThreadFactory.this.running.inc();
            try {
                this.task.run();
            }
            finally {
                InstrumentedThreadFactory.this.running.dec();
                InstrumentedThreadFactory.this.terminated.mark();
            }
        }
    }
}

