/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics;

import com.alibaba.metrics.BucketCounter;
import com.alibaba.metrics.BucketCounterImpl;
import com.alibaba.metrics.BucketReservoir;
import com.alibaba.metrics.Clock;
import com.alibaba.metrics.Compass;
import com.alibaba.metrics.EWMA;
import com.alibaba.metrics.ExponentiallyDecayingReservoir;
import com.alibaba.metrics.LongAdder;
import com.alibaba.metrics.Reservoir;
import com.alibaba.metrics.ReservoirType;
import com.alibaba.metrics.SlidingTimeWindowReservoir;
import com.alibaba.metrics.SlidingWindowReservoir;
import com.alibaba.metrics.Snapshot;
import com.alibaba.metrics.UniformReservoir;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class CompassImpl
implements Compass {
    private static final int MAX_ERROR_CODE_COUNT = Integer.getInteger("com.alibaba.metrics.maxCompassErrorCodeCount", 100);
    private static final int MAX_ADDON_COUNT = Integer.getInteger("com.alibaba.metrics.maxCompassAddonCount", 10);
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private final BucketCounter totalCount;
    private final BucketCounter successCount;
    private final ConcurrentHashMap<String, BucketCounter> errorCodes;
    private final ConcurrentHashMap<String, BucketCounter> addons;
    private final EWMA m1Rate = EWMA.oneMinuteEWMA();
    private final EWMA m5Rate = EWMA.fiveMinuteEWMA();
    private final EWMA m15Rate = EWMA.fifteenMinuteEWMA();
    private final long startTime;
    private final AtomicLong lastTick;
    private final LongAdder uncounted = new LongAdder();
    private final Clock clock;
    private final int maxErrorCodeCount;
    private final int maxAddonCount;
    private final int bucketInterval;
    private int numberOfBucket = 10;
    private Reservoir reservoir;

    public CompassImpl() {
        this(ReservoirType.EXPONENTIALLY_DECAYING, Clock.defaultClock(), 10, 60, MAX_ERROR_CODE_COUNT, MAX_ADDON_COUNT);
    }

    public CompassImpl(int bucketInterval) {
        this(ReservoirType.EXPONENTIALLY_DECAYING, Clock.defaultClock(), 10, bucketInterval, MAX_ERROR_CODE_COUNT, MAX_ADDON_COUNT);
    }

    public CompassImpl(int bucketInterval, ReservoirType type) {
        this(type, Clock.defaultClock(), 10, bucketInterval, MAX_ERROR_CODE_COUNT, MAX_ADDON_COUNT);
    }

    public CompassImpl(ReservoirType type, Clock clock, int numberOfBucket, int bucketInterval, int maxErrorCodeCount, int maxAddonCount) {
        this.bucketInterval = bucketInterval;
        this.numberOfBucket = numberOfBucket;
        this.totalCount = new BucketCounterImpl(bucketInterval, numberOfBucket, clock);
        this.clock = clock;
        this.startTime = this.clock.getTick();
        this.lastTick = new AtomicLong(this.startTime);
        this.successCount = new BucketCounterImpl(bucketInterval, numberOfBucket, clock);
        this.errorCodes = new ConcurrentHashMap();
        this.maxErrorCodeCount = maxErrorCodeCount;
        this.addons = new ConcurrentHashMap();
        this.maxAddonCount = maxAddonCount;
        switch (type) {
            case EXPONENTIALLY_DECAYING: {
                this.reservoir = new ExponentiallyDecayingReservoir(clock);
                break;
            }
            case SLIDING_TIME_WINDOW: {
                this.reservoir = new SlidingTimeWindowReservoir(bucketInterval, TimeUnit.SECONDS);
                break;
            }
            case SLIDING_WINDOW: {
                this.reservoir = new SlidingWindowReservoir(1024);
                break;
            }
            case UNIFORM: {
                this.reservoir = new UniformReservoir(1024);
                break;
            }
            case BUCKET: {
                this.reservoir = new BucketReservoir(bucketInterval, numberOfBucket, clock, this.totalCount);
                break;
            }
            default: {
                this.reservoir = new ExponentiallyDecayingReservoir(clock);
            }
        }
    }

    public void update(long duration, TimeUnit unit) {
        this.update(unit.toNanos(duration));
    }

    public void update(long duration, TimeUnit unit, boolean isSuccess, String errorCode, String addon) {
        this.update(unit.toNanos(duration));
        if (isSuccess) {
            this.successCount.update();
        }
        if (null != errorCode) {
            if (!this.errorCodes.containsKey(errorCode) && ((ConcurrentHashMap.CollectionView)((Object)this.errorCodes.keySet())).size() < this.maxErrorCodeCount) {
                this.errorCodes.putIfAbsent(errorCode, new BucketCounterImpl(this.bucketInterval, this.numberOfBucket, this.clock));
            }
            this.errorCodes.get(errorCode).update();
        }
        if (null != addon) {
            if (!this.addons.containsKey(addon) && ((ConcurrentHashMap.CollectionView)((Object)this.addons.keySet())).size() < this.maxAddonCount) {
                this.addons.putIfAbsent(addon, new BucketCounterImpl(this.bucketInterval, this.numberOfBucket, this.clock));
            }
            this.addons.get(addon).update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    public Compass.Context time() {
        return new ContextImpl(this, this.clock);
    }

    public long getCount() {
        return this.totalCount.getCount();
    }

    public double getFifteenMinuteRate() {
        this.tickIfNecessary();
        return this.m15Rate.getRate(TimeUnit.SECONDS);
    }

    public double getFiveMinuteRate() {
        this.tickIfNecessary();
        return this.m5Rate.getRate(TimeUnit.SECONDS);
    }

    public double getMeanRate() {
        if (this.getCount() == 0L) {
            return 0.0;
        }
        double elapsed = this.clock.getTick() - this.startTime;
        return (double)this.getCount() / elapsed * (double)TimeUnit.SECONDS.toNanos(1L);
    }

    public double getOneMinuteRate() {
        this.tickIfNecessary();
        return this.m1Rate.getRate(TimeUnit.SECONDS);
    }

    public Map<Long, Long> getInstantCount() {
        return this.totalCount.getBucketCounts();
    }

    public Snapshot getSnapshot() {
        return this.reservoir.getSnapshot();
    }

    public Map<String, BucketCounter> getErrorCodeCounts() {
        HashMap<String, BucketCounter> errorCodeMap = new HashMap<String, BucketCounter>();
        for (Map.Entry<String, BucketCounter> entry : this.errorCodes.entrySet()) {
            errorCodeMap.put(entry.getKey(), entry.getValue());
        }
        return errorCodeMap;
    }

    public double getSuccessRate() {
        return Double.NaN;
    }

    public long getSuccessCount() {
        return this.successCount.getCount();
    }

    public BucketCounter getBucketSuccessCount() {
        return this.successCount;
    }

    public int getInstantCountInterval() {
        return this.bucketInterval;
    }

    public Map<String, BucketCounter> getAddonCounts() {
        HashMap<String, BucketCounter> addonsMap = new HashMap<String, BucketCounter>();
        for (Map.Entry<String, BucketCounter> entry : this.addons.entrySet()) {
            addonsMap.put(entry.getKey(), entry.getValue());
        }
        return addonsMap;
    }

    public Map<Long, Long> getInstantCount(long startTime) {
        return this.totalCount.getBucketCounts(startTime);
    }

    public void setReservoir(Reservoir reservoir) {
        this.reservoir = reservoir;
    }

    public long lastUpdateTime() {
        return this.totalCount.lastUpdateTime();
    }

    private void update(long duration) {
        if (duration >= 0L) {
            this.tickIfNecessary();
            this.uncounted.add(1L);
            this.totalCount.update();
            if (this.reservoir instanceof BucketReservoir) {
                if (duration > 0L) {
                    this.reservoir.update(duration);
                }
            } else {
                this.reservoir.update(duration);
            }
        }
    }

    private void tickIfNecessary() {
        long newIntervalStartTick;
        long oldTick = this.lastTick.get();
        long newTick = this.clock.getTick();
        long age = newTick - oldTick;
        if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTick, newIntervalStartTick = newTick - age % TICK_INTERVAL)) {
            long requiredTicks = age / TICK_INTERVAL;
            for (long i = 0L; i < requiredTicks; ++i) {
                long count = this.uncounted.sumThenReset();
                this.m1Rate.tick(count);
                this.m5Rate.tick(count);
                this.m15Rate.tick(count);
            }
        }
    }

    public class ContextImpl
    implements Compass.Context {
        private final Compass compass;
        private final Clock clock;
        private final long startTime;

        private ContextImpl(Compass compass, Clock clock) {
            this.compass = compass;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.compass.update(elapsed, TimeUnit.NANOSECONDS);
            return elapsed;
        }

        public void close() {
            this.stop();
        }

        public void success() {
            CompassImpl.this.successCount.update();
        }

        public void error(String errorCode) {
            if (!CompassImpl.this.errorCodes.containsKey(errorCode)) {
                if (((ConcurrentHashMap.CollectionView)((Object)CompassImpl.this.errorCodes.keySet())).size() >= CompassImpl.this.maxErrorCodeCount) {
                    return;
                }
                CompassImpl.this.errorCodes.putIfAbsent(errorCode, new BucketCounterImpl(CompassImpl.this.bucketInterval, CompassImpl.this.numberOfBucket, this.clock));
            }
            ((BucketCounter)CompassImpl.this.errorCodes.get(errorCode)).update();
        }

        public void markAddon(String suffix) {
            if (!CompassImpl.this.addons.containsKey(suffix)) {
                if (((ConcurrentHashMap.CollectionView)((Object)CompassImpl.this.addons.keySet())).size() >= CompassImpl.this.maxAddonCount) {
                    return;
                }
                CompassImpl.this.addons.putIfAbsent(suffix, new BucketCounterImpl(CompassImpl.this.bucketInterval, CompassImpl.this.numberOfBucket, this.clock));
            }
            ((BucketCounter)CompassImpl.this.addons.get(suffix)).update();
        }
    }
}

