/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.support.csv.CSVWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.RyuDouble;
import com.alibaba.fastjson2.util.RyuFloat;
import java.io.ByteArrayOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Optional;

final class CSVWriterUTF8
extends CSVWriter
implements Flushable {
    static final byte[] BYTES_TRUE = "true".getBytes();
    static final byte[] BYTES_FALSE = "false".getBytes();
    final OutputStream out;
    final Charset charset;
    byte[] bytes;
    int off;

    public CSVWriterUTF8(OutputStream out, Charset charset) {
        this.out = out;
        this.charset = charset;
        this.bytes = new byte[65536];
    }

    @Override
    public void writeRow(Object ... values) {
        for (int i = 0; i < values.length; ++i) {
            Object value;
            if (i != 0) {
                if (this.off + 1 >= this.bytes.length) {
                    this.flush();
                }
                this.bytes[this.off++] = 44;
            }
            if ((value = values[i]) == null) continue;
            if (value instanceof Optional) {
                Optional optional = (Optional)value;
                if (!optional.isPresent()) continue;
                value = optional.get();
            }
            if (value instanceof Integer) {
                this.writeInt32((Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.writeInt64((Long)value);
                continue;
            }
            if (value instanceof String) {
                this.writeString((String)value);
                continue;
            }
            if (value instanceof Boolean) {
                boolean booleanValue = (Boolean)value;
                byte[] valueBytes = booleanValue ? BYTES_TRUE : BYTES_FALSE;
                this.writeRaw(valueBytes);
                continue;
            }
            if (value instanceof Float) {
                this.writeDouble(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                this.writeDouble((Double)value);
                continue;
            }
            if (value instanceof Short) {
                this.writeInt32(((Short)value).shortValue());
                continue;
            }
            if (value instanceof Byte) {
                this.writeInt32(((Byte)value).byteValue());
                continue;
            }
            if (value instanceof BigDecimal) {
                this.writeRaw(value.toString());
                continue;
            }
            if (value instanceof BigInteger) {
                this.writeRaw(value.toString());
                continue;
            }
            if (value instanceof Date) {
                this.writeDate((Date)value);
                continue;
            }
            if (value instanceof Instant) {
                this.writeInstant((Instant)value);
                continue;
            }
            if (value instanceof LocalDate) {
                this.writeDate((LocalDate)value);
                continue;
            }
            if (value instanceof LocalDateTime) {
                this.writeDateTime((LocalDateTime)value);
                continue;
            }
            String str = value.toString();
            this.writeString(str);
        }
        if (this.off + 1 >= this.bytes.length) {
            this.flush();
        }
        this.bytes[this.off++] = 10;
    }

    @Override
    public void flush() {
        try {
            this.out.write(this.bytes, 0, this.off);
            this.off = 0;
            this.out.flush();
        }
        catch (IOException e) {
            throw new JSONException("write csv error", (Throwable)e);
        }
    }

    protected void writeDirect(byte[] bytes, int off, int len) {
        try {
            this.out.write(bytes, off, len);
        }
        catch (IOException e) {
            throw new JSONException("write csv error", (Throwable)e);
        }
    }

    @Override
    protected void writeRaw(String str) {
        if (str == null || str.isEmpty()) {
            return;
        }
        byte[] strBytes = str.getBytes(this.charset);
        if (strBytes.length + this.off < this.bytes.length) {
            System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
            this.off += strBytes.length;
        } else {
            this.flush();
            if (strBytes.length >= this.bytes.length) {
                this.writeDirect(strBytes, 0, strBytes.length);
            } else {
                System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
                this.off += strBytes.length;
            }
        }
    }

    protected void writeRaw(byte[] strBytes) {
        if (strBytes.length + this.off < this.bytes.length) {
            System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
            this.off += strBytes.length;
        } else {
            this.flush();
            if (strBytes.length >= this.bytes.length) {
                this.writeDirect(strBytes, 0, strBytes.length);
            } else {
                System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
                this.off += strBytes.length;
            }
        }
    }

    public void writeInt32(int i) {
        int r;
        int q;
        int index;
        int minCapacity;
        int x;
        if (i == Integer.MIN_VALUE) {
            this.writeRaw("-2147483648");
            return;
        }
        int n = x = i < 0 ? -i : i;
        int size = x <= 9 ? 1 : (x <= 99 ? 2 : (x <= 999 ? 3 : (x <= 9999 ? 4 : (x <= 99999 ? 5 : (x <= 999999 ? 6 : (x <= 9999999 ? 7 : (x <= 99999999 ? 8 : (x <= 999999999 ? 9 : 10))))))));
        if (i < 0) {
            ++size;
        }
        if ((minCapacity = this.off + size) - this.bytes.length > 0) {
            this.flush();
        }
        int p = index = this.off + size;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            this.bytes[--p] = IOUtils.DigitOnes[r];
            this.bytes[--p] = IOUtils.DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            this.bytes[--p] = IOUtils.digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            this.bytes[--p] = sign;
        }
        this.off += size;
    }

    public void writeInt64(long i) {
        int q2;
        int r;
        int index;
        int minCapacity;
        long x;
        if (i == Long.MIN_VALUE) {
            this.writeRaw("-9223372036854775808");
            return;
        }
        long l = x = i < 0L ? -i : i;
        int size = x <= 9L ? 1 : (x <= 99L ? 2 : (x <= 999L ? 3 : (x <= 9999L ? 4 : (x <= 99999L ? 5 : (x <= 999999L ? 6 : (x <= 9999999L ? 7 : (x <= 99999999L ? 8 : (x <= 999999999L ? 9 : (x <= 9999999999L ? 10 : (x <= 99999999999L ? 11 : (x <= 999999999999L ? 12 : (x <= 9999999999999L ? 13 : (x <= 99999999999999L ? 14 : (x <= 999999999999999L ? 15 : (x <= 9999999999999999L ? 16 : (x <= 99999999999999999L ? 17 : (x <= 999999999999999999L ? 18 : 19)))))))))))))))));
        if (i < 0L) {
            ++size;
        }
        if ((minCapacity = this.off + size) - this.bytes.length > 0) {
            this.flush();
        }
        int charPos = index = this.off + size;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            this.bytes[--charPos] = IOUtils.DigitOnes[r];
            this.bytes[--charPos] = IOUtils.DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            this.bytes[--charPos] = IOUtils.DigitOnes[r];
            this.bytes[--charPos] = IOUtils.DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            this.bytes[--charPos] = IOUtils.digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            this.bytes[--charPos] = sign;
        }
        this.off += size;
    }

    @Override
    public void writeString(String str) {
        if (str == null) {
            return;
        }
        byte[] bytes = str.getBytes(this.charset);
        this.writeString(bytes);
    }

    private void writeString(byte[] utf8Bytes) {
        int j;
        byte ch;
        int i;
        if (utf8Bytes == null || utf8Bytes.length == 0) {
            return;
        }
        int len = utf8Bytes.length;
        int escapeCount = 0;
        boolean comma = false;
        if (utf8Bytes[0] == 34) {
            for (i = 0; i < len; ++i) {
                ch = utf8Bytes[i];
                if (ch != 34) continue;
                ++escapeCount;
            }
        } else {
            for (i = 0; i < len; ++i) {
                ch = utf8Bytes[i];
                if (ch == 44) {
                    comma = true;
                    continue;
                }
                if (ch != 34) continue;
                ++escapeCount;
            }
            if (!comma) {
                escapeCount = 0;
            }
        }
        if (escapeCount == 0) {
            this.writeRaw(utf8Bytes);
            return;
        }
        if (utf8Bytes[0] == 34) {
            byte[] bytes = new byte[utf8Bytes.length + 2 + escapeCount];
            j = 0;
            bytes[0] = 34;
            int end = this.off + len;
            for (int i2 = this.off; i2 < end; ++i2) {
                byte b = bytes[i2];
                bytes[j++] = b;
                if (b != 34) continue;
                bytes[j++] = b;
            }
            bytes[j] = 34;
            this.writeRaw(bytes);
        } else {
            byte[] bytes = new byte[utf8Bytes.length + 2 + escapeCount];
            j = 0;
            bytes[0] = 34;
            int end = this.off + len;
            for (int i3 = this.off; i3 < end; ++i3) {
                byte b = bytes[i3];
                bytes[j++] = b;
                if (b != 34) continue;
                bytes[j++] = b;
            }
            bytes[j] = 34;
            this.writeRaw(bytes);
        }
    }

    public void writeFloat(float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            return;
        }
        if (this.off + 24 > this.bytes.length) {
            this.flush();
        }
        int len = RyuFloat.toString((float)value, (byte[])this.bytes, (int)this.off);
        this.off += len;
    }

    public void writeDouble(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return;
        }
        if (this.off + 24 > this.bytes.length) {
            this.flush();
        }
        int len = RyuDouble.toString((double)value, (byte[])this.bytes, (int)this.off);
        this.off += len;
    }

    public void writeBoolean(boolean value) {
        byte[] valueBytes = value ? BYTES_TRUE : BYTES_FALSE;
        this.writeRaw(valueBytes);
    }

    public void writeDecimal(BigDecimal value) {
        if (value == null) {
            return;
        }
        this.writeRaw(value.toString());
    }

    public String toString() {
        if (this.out instanceof ByteArrayOutputStream) {
            this.flush();
            byte[] strBytes = ((ByteArrayOutputStream)this.out).toByteArray();
            return new String(strBytes, StandardCharsets.UTF_8);
        }
        return super.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.off > 0) {
            this.flush();
        }
        this.out.close();
    }
}

