/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.support.csv.CSVWriterUTF16;
import com.alibaba.fastjson2.support.csv.CSVWriterUTF8;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;

public abstract class CSVWriter
implements Closeable,
Flushable {
    public static CSVWriter of() {
        return CSVWriter.of(new ByteArrayOutputStream());
    }

    public static CSVWriter of(File file) throws FileNotFoundException {
        return CSVWriter.of(new FileOutputStream(file), StandardCharsets.UTF_8);
    }

    public void writeRowObject(Object object) {
        Class<?> objectClass;
        if (object == null) {
            this.writeRow(new Object[0]);
            return;
        }
        ObjectWriterProvider provider = JSONFactory.getDefaultObjectWriterProvider();
        ObjectWriter objectWriter = provider.getObjectWriter(objectClass = object.getClass());
        if (objectWriter instanceof ObjectWriterAdapter) {
            ObjectWriterAdapter adapter = (ObjectWriterAdapter)objectWriter;
            List fieldWriters = adapter.getFieldWriters();
            if (fieldWriters.size() == 1 && (((FieldWriter)fieldWriters.get((int)0)).features & 0x1000000000000L) != 0L) {
                Object fieldValue = ((FieldWriter)fieldWriters.get(0)).getFieldValue(object);
                this.writeRowObject(fieldValue);
                return;
            }
            Object[] values = new Object[fieldWriters.size()];
            for (int i = 0; i < fieldWriters.size(); ++i) {
                values[i] = ((FieldWriter)fieldWriters.get(i)).getFieldValue(object);
            }
            this.writeRow(values);
        } else {
            this.writeRow(object);
        }
    }

    public abstract void writeRow(Object ... var1);

    public abstract void writeString(String var1);

    public void writeDate(Date date) {
        if (date == null) {
            return;
        }
        long millis = date.getTime();
        this.writeInstant(Instant.ofEpochMilli(millis));
    }

    public void writeInstant(Instant instant) {
        if (instant == null) {
            return;
        }
        ZonedDateTime zdt = instant.atZone(ZoneOffset.UTC);
        String str = DateTimeFormatter.ISO_ZONED_DATE_TIME.format(zdt);
        this.writeRaw(str);
    }

    public void writeDate(LocalDate date) {
        if (date == null) {
            return;
        }
        String str = DateTimeFormatter.ISO_LOCAL_DATE.format(date);
        this.writeRaw(str);
    }

    public void writeDateTime(LocalDateTime instant) {
        if (instant == null) {
            return;
        }
        String str = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(instant);
        this.writeRaw(str);
    }

    protected abstract void writeRaw(String var1);

    public static CSVWriter of(OutputStream out) {
        return new CSVWriterUTF8(out, StandardCharsets.UTF_8);
    }

    public static CSVWriter of(OutputStream out, Charset charset) {
        if (charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new CSVWriterUTF16(new OutputStreamWriter(out, charset));
        }
        return new CSVWriterUTF8(out, charset);
    }
}

