/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring.messaging.converter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import java.nio.charset.Charset;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

public class MappingFastJsonMessageConverter
extends AbstractMessageConverter {
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    public MappingFastJsonMessageConverter() {
        super(new MimeType("application", "json", Charset.forName("UTF-8")));
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return this.supports(targetClass);
    }

    protected boolean canConvertTo(Object payload, MessageHeaders headers) {
        return this.supports(payload.getClass());
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object payload = message.getPayload();
        Object obj = null;
        if (payload instanceof byte[]) {
            obj = JSON.parseObject((byte[])((byte[])payload), targetClass, (JSONReader.Feature[])this.fastJsonConfig.getReaderFeatures());
        } else if (payload instanceof String) {
            obj = JSON.parseObject((String)((String)payload), targetClass, (JSONReader.Feature[])this.fastJsonConfig.getReaderFeatures());
        }
        return obj;
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        Object obj = byte[].class == this.getSerializedPayloadClass() ? (payload instanceof String && JSON.isValid((String)((String)payload)) ? (Object)((String)payload).getBytes(this.fastJsonConfig.getCharset()) : (Object)JSON.toJSONBytes((Object)payload, (Filter[])this.fastJsonConfig.getWriterFilters(), (JSONWriter.Feature[])this.fastJsonConfig.getWriterFeatures())) : (payload instanceof String && JSON.isValid((String)((String)payload)) ? payload : JSON.toJSONString((Object)payload, (Filter[])this.fastJsonConfig.getWriterFilters(), (JSONWriter.Feature[])this.fastJsonConfig.getWriterFeatures()));
        return obj;
    }
}

