/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring.data.redis;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class FastJsonRedisSerializer<T>
implements RedisSerializer<T> {
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();
    private Class<T> type;

    public FastJsonRedisSerializer(Class<T> type) {
        this.type = type;
    }

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    public byte[] serialize(T t) throws SerializationException {
        if (t == null) {
            return new byte[0];
        }
        try {
            return JSON.toJSONBytes(t, (Filter[])this.fastJsonConfig.getWriterFilters(), (JSONWriter.Feature[])this.fastJsonConfig.getWriterFeatures());
        }
        catch (Exception ex) {
            throw new SerializationException("Could not serialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public T deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return (T)JSON.parseObject((byte[])bytes, this.type, (JSONReader.Feature[])this.fastJsonConfig.getReaderFeatures());
        }
        catch (Exception ex) {
            throw new SerializationException("Could not deserialize: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

