/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring.data.redis;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.ContextAutoTypeBeforeHandler;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class GenericFastJsonRedisSerializer
implements RedisSerializer<Object> {
    private final FastJsonConfig config = new FastJsonConfig();

    public GenericFastJsonRedisSerializer() {
        this.config.setReaderFeatures(JSONReader.Feature.SupportAutoType);
        this.config.setWriterFeatures(JSONWriter.Feature.WriteClassName);
    }

    public GenericFastJsonRedisSerializer(String[] acceptNames, boolean jsonb) {
        this();
        this.config.setReaderFilters(new Filter[]{new ContextAutoTypeBeforeHandler(acceptNames)});
        this.config.setJSONB(jsonb);
    }

    public GenericFastJsonRedisSerializer(String[] acceptNames) {
        this(acceptNames, false);
    }

    public GenericFastJsonRedisSerializer(boolean jsonb) {
        this(new String[0], jsonb);
    }

    public byte[] serialize(Object object) throws SerializationException {
        if (object == null) {
            return new byte[0];
        }
        try {
            if (this.config.isJSONB()) {
                return JSONB.toBytes((Object)object, (JSONWriter.Feature[])this.config.getWriterFeatures());
            }
            return JSON.toJSONBytes((Object)object, (JSONWriter.Feature[])this.config.getWriterFeatures());
        }
        catch (Exception ex) {
            throw new SerializationException("Could not serialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            if (this.config.isJSONB()) {
                return JSONB.parseObject((byte[])bytes, Object.class, null, (Filter[])this.config.getReaderFilters(), (JSONReader.Feature[])this.config.getReaderFeatures());
            }
            return JSON.parseObject((byte[])bytes, Object.class, null, (Filter[])this.config.getReaderFilters(), (JSONReader.Feature[])this.config.getReaderFeatures());
        }
        catch (Exception ex) {
            throw new SerializationException("Could not deserialize: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

