/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring.http.converter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class FastJsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object>
implements GenericHttpMessageConverter<Object> {
    public static final MediaType APPLICATION_JAVASCRIPT = new MediaType("application", "javascript");
    private FastJsonConfig config = new FastJsonConfig();
    private static int REQUEST_BODY_INITIAL_CAPACITY = 8192;
    private static final int SOFT_MAX_ARRAY_LENGTH = 0x7FFFFFF7;

    public FastJsonHttpMessageConverter() {
        super(MediaType.ALL);
        this.setDefaultCharset(StandardCharsets.UTF_8);
    }

    public FastJsonConfig getFastJsonConfig() {
        return this.config;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.config = fastJsonConfig;
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        return super.canRead(contextClass, mediaType);
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        return super.canWrite(clazz, mediaType);
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.readType(this.getType(type, contextClass), inputMessage);
    }

    public void write(Object o, Type type, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        super.write(o, contentType, outputMessage);
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.readType(this.getType(clazz, null), inputMessage);
    }

    public static void setRequestBodyInitialCapacity(int initialCapacity) {
        if (initialCapacity < 128 || initialCapacity > 0x100000) {
            throw new IllegalArgumentException("invalid initialCapacity: " + initialCapacity);
        }
        REQUEST_BODY_INITIAL_CAPACITY = initialCapacity;
    }

    protected static int calcInitialCapacity(long contentLength) {
        return contentLength == -1L || contentLength > Integer.MAX_VALUE ? REQUEST_BODY_INITIAL_CAPACITY : (int)Math.min(contentLength, 0x100000L);
    }

    protected static byte[] fastRead(InputStream in, long contentLength) throws IOException {
        int expectSize = FastJsonHttpMessageConverter.calcInitialCapacity(contentLength);
        byte[] body = new byte[expectSize];
        int offset = in.read(body, 0, body.length);
        if (offset == -1) {
            body = new byte[]{};
        } else if (contentLength == -1L || (long)offset != contentLength) {
            byte[] buf = new byte[1024];
            int len = in.read(buf);
            while (len != -1) {
                int minRequired = offset + len;
                int oldLength = body.length;
                if (minRequired > oldLength) {
                    int newLength = FastJsonHttpMessageConverter.newLength(oldLength, minRequired - oldLength, oldLength);
                    byte[] newBody = Arrays.copyOf(body, newLength);
                    System.arraycopy(buf, 0, newBody, offset, len);
                    body = newBody;
                } else {
                    System.arraycopy(buf, 0, body, offset, len);
                }
                offset = minRequired;
                len = in.read(buf);
            }
            if (offset != body.length) {
                body = Arrays.copyOf(body, offset);
            }
        }
        return body;
    }

    private static int newLength(int oldLength, int minGrowth, int prefGrowth) {
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        if (0 < prefLength && prefLength <= 0x7FFFFFF7) {
            return prefLength;
        }
        return FastJsonHttpMessageConverter.hugeLength(oldLength, minGrowth);
    }

    private static int hugeLength(int oldLength, int minGrowth) {
        int minLength = oldLength + minGrowth;
        if (minLength < 0) {
            throw new OutOfMemoryError("Required array length " + oldLength + " + " + minGrowth + " is too large");
        }
        if (minLength <= 0x7FFFFFF7) {
            return 0x7FFFFFF7;
        }
        return minLength;
    }

    protected Object readType(Type type, HttpInputMessage inputMessage) {
        long contentLength = inputMessage.getHeaders().getContentLength();
        try {
            byte[] body = FastJsonHttpMessageConverter.fastRead(inputMessage.getBody(), contentLength);
            return JSON.parseObject((byte[])body, (Type)type, (JSONReader.Context)this.config.readerContext());
        }
        catch (JSONException ex) {
            throw new HttpMessageNotReadableException("JSON parse error: " + ex.getMessage(), (Throwable)ex, inputMessage);
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("I/O error while reading input message", (Throwable)ex, inputMessage);
        }
    }

    protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        HttpHeaders headers = outputMessage.getHeaders();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int contentLength;
            if (object instanceof String && JSON.isValidObject((String)((String)object))) {
                byte[] strBytes = ((String)object).getBytes(this.config.getCharset());
                contentLength = strBytes.length;
                outputMessage.getBody().write(strBytes, 0, strBytes.length);
            } else if (object instanceof byte[] && JSON.isValid((byte[])((byte[])object))) {
                byte[] strBytes = (byte[])object;
                contentLength = strBytes.length;
                outputMessage.getBody().write(strBytes, 0, strBytes.length);
            } else {
                if (object instanceof JSONPObject) {
                    headers.setContentType(APPLICATION_JAVASCRIPT);
                }
                contentLength = JSON.writeTo((OutputStream)baos, (Object)object, (JSONWriter.Context)this.config.writerContext());
            }
            if (headers.getContentLength() < 0L && this.config.isWriteContentLength()) {
                headers.setContentLength((long)contentLength);
            }
            baos.writeTo(outputMessage.getBody());
        }
        catch (JSONException ex) {
            throw new HttpMessageNotWritableException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new HttpMessageNotWritableException("I/O error while writing output message", (Throwable)ex);
        }
    }

    protected Type getType(Type type, Class<?> contextClass) {
        if (Spring4TypeResolvableHelper.isSupport()) {
            return Spring4TypeResolvableHelper.getType(type, contextClass);
        }
        return type;
    }

    private static class Spring4TypeResolvableHelper {
        private static boolean hasClazzResolvableType;

        private Spring4TypeResolvableHelper() {
        }

        private static boolean isSupport() {
            return hasClazzResolvableType;
        }

        private static Type getType(Type type, Class<?> contextClass) {
            if (contextClass != null) {
                ResolvableType resolvedType = ResolvableType.forType((Type)type);
                if (type instanceof TypeVariable) {
                    ResolvableType resolvedTypeVariable = Spring4TypeResolvableHelper.resolveVariable((TypeVariable)type, ResolvableType.forClass(contextClass));
                    if (resolvedTypeVariable != ResolvableType.NONE) {
                        return resolvedTypeVariable.resolve();
                    }
                } else if (type instanceof ParameterizedType && resolvedType.hasUnresolvableGenerics()) {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Class[] generics = new Class[parameterizedType.getActualTypeArguments().length];
                    Type[] typeArguments = parameterizedType.getActualTypeArguments();
                    for (int i = 0; i < typeArguments.length; ++i) {
                        Type typeArgument = typeArguments[i];
                        if (typeArgument instanceof TypeVariable) {
                            ResolvableType resolvedTypeArgument = Spring4TypeResolvableHelper.resolveVariable((TypeVariable)typeArgument, ResolvableType.forClass(contextClass));
                            if (resolvedTypeArgument != ResolvableType.NONE) {
                                generics[i] = resolvedTypeArgument.resolve();
                                continue;
                            }
                            generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
                            continue;
                        }
                        generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
                    }
                    return ResolvableType.forClassWithGenerics((Class)resolvedType.getRawClass(), (Class[])generics).getType();
                }
            }
            return type;
        }

        private static ResolvableType resolveVariable(TypeVariable<?> typeVariable, ResolvableType contextType) {
            ResolvableType resolvedType;
            if (contextType.hasGenerics() && (resolvedType = ResolvableType.forType(typeVariable, (ResolvableType)contextType)).resolve() != null) {
                return resolvedType;
            }
            ResolvableType superType = contextType.getSuperType();
            if (superType != ResolvableType.NONE && (resolvedType = Spring4TypeResolvableHelper.resolveVariable(typeVariable, superType)).resolve() != null) {
                return resolvedType;
            }
            for (ResolvableType ifc : contextType.getInterfaces()) {
                resolvedType = Spring4TypeResolvableHelper.resolveVariable(typeVariable, ifc);
                if (resolvedType.resolve() == null) continue;
                return resolvedType;
            }
            return ResolvableType.NONE;
        }

        static {
            try {
                Class.forName("org.springframework.core.ResolvableType");
                hasClazzResolvableType = true;
            }
            catch (ClassNotFoundException e) {
                hasClazzResolvableType = false;
            }
        }
    }
}

