/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.solon;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.ContextSerializer;

public class Fastjson2StringSerializer
implements ContextSerializer<String> {
    private static final String label = "/json";
    private JSONWriter.Context serializeConfig;
    private JSONReader.Context deserializeConfig;

    public JSONWriter.Context getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new JSONWriter.Context(new ObjectWriterProvider());
        }
        return this.serializeConfig;
    }

    public void cfgSerializeFeatures(boolean isReset, boolean isAdd, JSONWriter.Feature ... features) {
        if (isReset) {
            this.getSerializeConfig().setFeatures(JSONFactory.getDefaultWriterFeatures());
        }
        for (JSONWriter.Feature feature : features) {
            this.getSerializeConfig().config(feature, isAdd);
        }
    }

    public JSONReader.Context getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new JSONReader.Context(new ObjectReaderProvider());
        }
        return this.deserializeConfig;
    }

    public void cfgDeserializeFeatures(boolean isReset, boolean isAdd, JSONReader.Feature ... features) {
        if (isReset) {
            this.getDeserializeConfig().setFeatures(JSONFactory.getDefaultReaderFeatures());
        }
        for (JSONReader.Feature feature : features) {
            this.getDeserializeConfig().config(feature, isAdd);
        }
    }

    public String mimeType() {
        return "application/json";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label) || mime.startsWith("application/x-ndjson");
    }

    public String name() {
        return "fastjson2-json";
    }

    public String serialize(Object obj) throws IOException {
        return JSON.toJSONString((Object)obj, (JSONWriter.Context)this.getSerializeConfig());
    }

    public Object deserialize(String data, Type toType) throws IOException {
        if (toType == null) {
            return JSON.parse((String)data, (JSONReader.Context)this.getDeserializeConfig());
        }
        return JSON.parseObject((String)data, (Type)toType, (JSONReader.Context)this.getDeserializeConfig());
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return JSON.parse((String)data, (JSONReader.Context)this.getDeserializeConfig());
        }
        return null;
    }
}

