/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.solon;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.support.solon.Fastjson2StringSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.mvc.ActionExecuteHandlerDefault;
import org.noear.solon.core.util.LazyReference;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;

public class Fastjson2ActionExecutor
extends ActionExecuteHandlerDefault {
    private final Fastjson2StringSerializer serializer = new Fastjson2StringSerializer();

    public Fastjson2ActionExecutor() {
        this.serializer.getDeserializeConfig().config(new JSONReader.Feature[0]);
        this.serializer.getDeserializeConfig().config(new JSONReader.Feature[]{JSONReader.Feature.ErrorOnEnumNotMatch});
    }

    public Fastjson2StringSerializer getSerializer() {
        return this.serializer;
    }

    public JSONReader.Context config() {
        return this.getSerializer().getDeserializeConfig();
    }

    public boolean matched(Context ctx, String mime) {
        return this.serializer.matched(ctx, mime);
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return this.serializer.deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, LazyReference bodyRef) throws Throwable {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        Object bodyObj = bodyRef.get();
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (bodyObj instanceof JSONObject) {
            JSONObject tmp = (JSONObject)bodyObj;
            if (!p.spec().isRequiredBody() && tmp.containsKey(p.spec().getName())) {
                if (p.spec().isGenericType()) {
                    return tmp.getObject(p.spec().getName(), (Type)p.getGenericType(), new JSONReader.Feature[0]);
                }
                return tmp.getObject(p.spec().getName(), pt, new JSONReader.Feature[0]);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyRef);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.to((Type)p.getGenericType(), new JSONReader.Feature[0]);
            }
            return tmp.to(pt, new JSONReader.Feature[0]);
        }
        if (bodyObj instanceof JSONArray) {
            JSONArray tmp = (JSONArray)bodyObj;
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.to((Type)p.getGenericType());
            }
            return tmp.to(pt);
        }
        return bodyObj;
    }
}

