/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.processor;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.annotation.JSONCompiled;
import com.alibaba.fastjson2.internal.codegen.Label;
import com.alibaba.fastjson2.internal.graalmeta.ReflectionMetadata;
import com.alibaba.fastjson2.internal.processor.Analysis;
import com.alibaba.fastjson2.internal.processor.AttributeInfo;
import com.alibaba.fastjson2.internal.processor.CodeGenUtils;
import com.alibaba.fastjson2.internal.processor.JavacTreeUtils;
import com.alibaba.fastjson2.internal.processor.StructInfo;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaders;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriters;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.processing.JavacFiler;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.tools.Diagnostic;
import javax.tools.FileObject;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"com.alibaba.fastjson2.annotation.JSONCompiled", "com.alibaba.fastjson2.annotation.JSONBuilder", "com.alibaba.fastjson2.annotation.JSONCreator", "com.alibaba.fastjson2.annotation.JSONField", "com.alibaba.fastjson2.annotation.JSONType"})
public class JSONCompiledAnnotationProcessor
extends AbstractProcessor {
    private Messager messager;
    private JavacTrees javacTrees;
    private Names names;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        ProcessingEnvironment unwrappedProcessingEnv = JavacTreeUtils.unwrapProcessingEnv(processingEnv);
        super.init(unwrappedProcessingEnv);
        this.messager = unwrappedProcessingEnv.getMessager();
        this.javacTrees = JavacTrees.instance(unwrappedProcessingEnv);
        Context context = ((JavacProcessingEnvironment)unwrappedProcessingEnv).getContext();
        this.names = Names.instance(context);
        JavacTreeUtils.initialize(TreeMaker.instance(context), this.names, unwrappedProcessingEnv.getElementUtils());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Analysis analysis = new Analysis(this.processingEnv);
        Set<? extends Element> compiledJsons = roundEnv.getElementsAnnotatedWith(analysis.jsonCompiledElement);
        if (!compiledJsons.isEmpty()) {
            analysis.processAnnotation(analysis.jsonCompiledDeclaredType, compiledJsons);
        }
        Map<String, StructInfo> structs = analysis.analyze();
        Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(JSONCompiled.class);
        HashSet<ReflectionMetadata> reflects = new HashSet<ReflectionMetadata>(elementsAnnotatedWith.size() * 2);
        elementsAnnotatedWith.forEach(element -> {
            StructInfo structInfo = (StructInfo)structs.get(element.toString());
            java.util.List<AttributeInfo> attributeInfos = structInfo.getReaderAttributes();
            int fieldsSize = attributeInfos.size();
            Class readSuperClass = CodeGenUtils.getReadSuperClass(fieldsSize);
            Class writeSuperClass = CodeGenUtils.getWriteSuperClass(fieldsSize);
            JCTree tree = this.javacTrees.getTree((Element)element);
            JavacTreeUtils.pos(tree.pos);
            tree.accept(new TreeTranslator((Element)element, structInfo, readSuperClass, fieldsSize, attributeInfos, writeSuperClass, reflects){
                final /* synthetic */ Element val$element;
                final /* synthetic */ StructInfo val$structInfo;
                final /* synthetic */ Class val$readSuperClass;
                final /* synthetic */ int val$fieldsSize;
                final /* synthetic */ java.util.List val$attributeInfos;
                final /* synthetic */ Class val$writeSuperClass;
                final /* synthetic */ Set val$reflects;
                {
                    this.val$element = element;
                    this.val$structInfo = structInfo;
                    this.val$readSuperClass = clazz;
                    this.val$fieldsSize = n;
                    this.val$attributeInfos = list;
                    this.val$writeSuperClass = clazz2;
                    this.val$reflects = set;
                }

                @Override
                public void visitClassDef(JCTree.JCClassDecl beanClassDecl) {
                    super.visitClassDef(beanClassDecl);
                    String beanClassFQN = beanClassDecl.sym.toString();
                    if (this.val$element.toString().equals(beanClassFQN)) {
                        boolean generatedFields;
                        String innerReadClassFQN = JSONCompiledAnnotationProcessor.this.findConverterName(this.val$structInfo, "_FASTJSONReader");
                        String innerReadClassName = innerReadClassFQN.substring(innerReadClassFQN.lastIndexOf(46) + 1);
                        JCTree.JCExpression beanType = null;
                        if (beanClassFQN.contains(".")) {
                            if (this.val$element instanceof Symbol.ClassSymbol) {
                                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)this.val$element;
                                String owner = classSymbol.owner.toString();
                                int dotIdx = owner.indexOf(".");
                                beanType = JavacTreeUtils.field(dotIdx == -1 ? JavacTreeUtils.ident(owner) : JavacTreeUtils.qualIdent(owner), beanClassFQN.substring(beanClassFQN.lastIndexOf(".") + 1));
                            }
                        } else {
                            int dotIdx = beanClassFQN.indexOf(".");
                            beanType = dotIdx == -1 ? JavacTreeUtils.ident(beanClassFQN) : JavacTreeUtils.qualIdent(beanClassFQN);
                        }
                        JCTree.JCNewClass beanNew = JavacTreeUtils.newClass(null, null, beanType, null, null);
                        JCTree.JCIdent objectType = JavacTreeUtils.ident("Object");
                        JSONCompiledAnnotationProcessor.this.addInnerClassIfAbsent(beanClassDecl, beanClassFQN, innerReadClassName, "deserializer");
                        JCTree.JCClassDecl innerReadClass = JSONCompiledAnnotationProcessor.this.genInnerClass(innerReadClassName, this.val$readSuperClass);
                        boolean bl = generatedFields = this.val$fieldsSize < 128;
                        if (generatedFields) {
                            innerReadClass.defs = innerReadClass.defs.prependList(JSONCompiledAnnotationProcessor.this.genFields(this.val$attributeInfos, this.val$readSuperClass));
                        }
                        innerReadClass.defs = innerReadClass.defs.append(JSONCompiledAnnotationProcessor.this.genReadConstructor(beanType, beanNew, this.val$attributeInfos, this.val$readSuperClass, generatedFields));
                        innerReadClass.defs = innerReadClass.defs.append(JSONCompiledAnnotationProcessor.this.genCreateInstance(objectType, beanNew));
                        innerReadClass.defs = innerReadClass.defs.append(JSONCompiledAnnotationProcessor.this.genReadObject(objectType, beanType, beanNew, this.val$attributeInfos, this.val$structInfo, false));
                        innerReadClass.defs = innerReadClass.defs.append(JSONCompiledAnnotationProcessor.this.genReadObject(objectType, beanType, beanNew, this.val$attributeInfos, this.val$structInfo, true));
                        beanClassDecl.defs = beanClassDecl.defs.append(innerReadClass);
                        String innerWriteClassFQN = JSONCompiledAnnotationProcessor.this.findConverterName(this.val$structInfo, "_FASTJSONWriter");
                        String innerWriteClassName = innerWriteClassFQN.substring(innerWriteClassFQN.lastIndexOf(46) + 1);
                        JSONCompiledAnnotationProcessor.this.addInnerClassIfAbsent(beanClassDecl, beanClassFQN, innerWriteClassName, "serializer");
                        JCTree.JCClassDecl innerWriteClass = JSONCompiledAnnotationProcessor.this.genInnerClass(innerWriteClassName, this.val$writeSuperClass);
                        if (generatedFields) {
                            innerWriteClass.defs = innerWriteClass.defs.prependList(JSONCompiledAnnotationProcessor.this.genFields(this.val$attributeInfos, this.val$writeSuperClass));
                        }
                        innerWriteClass.defs = innerWriteClass.defs.append(JSONCompiledAnnotationProcessor.this.genWriteConstructor(beanType, beanNew, this.val$attributeInfos, this.val$writeSuperClass, generatedFields));
                        innerWriteClass.defs = innerWriteClass.defs.append(JSONCompiledAnnotationProcessor.this.genWrite(objectType, beanType, beanNew, this.val$attributeInfos, this.val$structInfo, false));
                        beanClassDecl.defs = beanClassDecl.defs.append(innerWriteClass);
                        if (JSONCompiledAnnotationProcessor.this.isDebug(beanClassDecl)) {
                            JSONCompiledAnnotationProcessor.this.messager.printMessage(Diagnostic.Kind.WARNING, "Whoops! You have changed the debug of JSONCompiled from false to true for " + this.val$structInfo.binaryName + ", which means the additional source file being generated. It's usually not recommended to enable debug until you are in developer mode");
                            JSONCompiledAnnotationProcessor.this.genSource(this.val$structInfo, JSONCompiledAnnotationProcessor.this.javacTrees.getPath(this.val$element));
                        }
                        if (JDKUtils.GRAAL) {
                            ReflectionMetadata readMeta = new ReflectionMetadata();
                            readMeta.setName(innerReadClassFQN);
                            readMeta.setAllPublicConstructors(true);
                            this.val$reflects.add(readMeta);
                            ReflectionMetadata writeMeta = new ReflectionMetadata();
                            writeMeta.setName(innerWriteClassFQN);
                            writeMeta.setAllPublicConstructors(true);
                            this.val$reflects.add(writeMeta);
                        }
                    }
                }
            });
        });
        if (!reflects.isEmpty()) {
            this.genReflect(reflects);
        }
        return true;
    }

    private void addInnerClassIfAbsent(JCTree.JCClassDecl beanClassDecl, String beanClassFQN, String innerClassName, String key) {
        JCTree.JCExpression jsonTypeIdent = JavacTreeUtils.qualIdent("com.alibaba.fastjson2.annotation.JSONType");
        List<JCTree.JCAnnotation> annotations = beanClassDecl.mods.annotations;
        Optional<JCTree.JCAnnotation> jsonTypeAnnoOpt = annotations.stream().filter(a -> a.getAnnotationType().type.tsym.toString().equals(jsonTypeIdent.type.tsym.toString())).findAny();
        String beanClassName = beanClassFQN.substring(beanClassFQN.lastIndexOf(46) + 1);
        JCTree.JCIdent lhs = JavacTreeUtils.ident(key);
        JCTree.JCFieldAccess rhs = JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(beanClassName), innerClassName), this.names._class);
        if (jsonTypeAnnoOpt.isPresent()) {
            JCTree.JCAnnotation jsonTypeAnno = jsonTypeAnnoOpt.get();
            Optional<JCTree.JCAssign> jsonTypeAsgOpt = jsonTypeAnno.args.stream().map(a -> (JCTree.JCAssign)a).filter(a2 -> key.equals(a2.lhs.toString())).findAny();
            if (jsonTypeAsgOpt.isPresent()) {
                JCTree.JCAssign deserializerAssign = jsonTypeAsgOpt.get();
                if ("Void.class".equals(deserializerAssign.rhs.toString())) {
                    deserializerAssign.rhs = rhs;
                }
            } else {
                jsonTypeAnno.args = jsonTypeAnno.args.prepend(JavacTreeUtils.assign(lhs, (JCTree.JCExpression)rhs));
            }
        } else {
            JCTree.JCAnnotation jsonTypeAnno = JavacTreeUtils.annotation(jsonTypeIdent, List.of(JavacTreeUtils.assign(lhs, (JCTree.JCExpression)rhs)));
            beanClassDecl.mods.annotations = annotations.prepend(jsonTypeAnno);
        }
    }

    private JCTree.JCClassDecl genInnerClass(String className, Class superClass) {
        if (ObjectReaderAdapter.class.isAssignableFrom(superClass)) {
            return JavacTreeUtils.defClass(25L, className, null, JavacTreeUtils.qualIdent(superClass.getName()), null, null);
        }
        if (ObjectWriterAdapter.class.isAssignableFrom(superClass)) {
            return JavacTreeUtils.defClass(25L, className, null, JavacTreeUtils.qualIdent(superClass.getName()), List.of(JavacTreeUtils.qualIdent("com.alibaba.fastjson2.writer.ObjectWriter")), null);
        }
        return null;
    }

    private List<JCTree> genFields(java.util.List<AttributeInfo> attributeInfos, Class superClass) {
        ListBuffer<JCTree.JCVariableDecl> stmts;
        block7: {
            int fieldsSize;
            block6: {
                int i;
                stmts = new ListBuffer<JCTree.JCVariableDecl>();
                fieldsSize = attributeInfos.size();
                if (!ObjectReaderAdapter.class.isAssignableFrom(superClass)) break block6;
                JCTree.JCExpression fieldReaderType = JavacTreeUtils.qualIdent(FieldReader.class.getName());
                JCTree.JCExpression objectReaderType = JavacTreeUtils.qualIdent(ObjectReader.class.getName());
                if (superClass == ObjectReaderAdapter.class) {
                    for (i = 0; i < fieldsSize; ++i) {
                        stmts.append(JavacTreeUtils.defVar(2L, CodeGenUtils.fieldReader(i), fieldReaderType));
                    }
                    for (i = 0; i < fieldsSize; ++i) {
                        stmts.append(JavacTreeUtils.defVar(2L, CodeGenUtils.fieldObjectReader(i), objectReaderType));
                    }
                }
                for (i = 0; i < fieldsSize; ++i) {
                    AttributeInfo field = attributeInfos.get(i);
                    String fieldType = field.type.toString();
                    if (!fieldType.startsWith("java.util.List<") && !fieldType.startsWith("java.util.Map<java.lang.String,")) continue;
                    stmts.append(JavacTreeUtils.defVar(2L, CodeGenUtils.fieldItemObjectReader(i), objectReaderType));
                }
                break block7;
            }
            if (!ObjectWriterAdapter.class.isAssignableFrom(superClass)) break block7;
            JCTree.JCExpression fieldWriterType = JavacTreeUtils.qualIdent(FieldWriter.class.getName());
            if (superClass == ObjectWriterAdapter.class) {
                for (int i = 0; i < fieldsSize; ++i) {
                    stmts.append(JavacTreeUtils.defVar(2L, CodeGenUtils.fieldWriter(i), fieldWriterType));
                }
            }
        }
        return stmts.toList();
    }

    private JCTree.JCMethodDecl genReadConstructor(JCTree.JCExpression beanType, JCTree.JCNewClass beanNew, java.util.List<AttributeInfo> fields, Class superClass, boolean generatedFields) {
        JCTree.JCMemberReference lambda = JavacTreeUtils.constructorRef(beanType);
        JCTree.JCExpression fieldReaderType = JavacTreeUtils.qualIdent(FieldReader.class.getName());
        ListBuffer<JCTree.JCMethodInvocation> fieldReaders = new ListBuffer<JCTree.JCMethodInvocation>();
        JCTree.JCExpression objectReadersType = JavacTreeUtils.qualIdent(ObjectReaders.class.getName());
        int fieldsSize = fields.size();
        for (int i = 0; i < fieldsSize; ++i) {
            JCTree.JCMethodInvocation readerMethod = this.genFieldReader(beanType, fields.get(i), objectReadersType);
            if (readerMethod == null) continue;
            fieldReaders.append(readerMethod);
        }
        JCTree.JCNewArray fieldReadersArray = JavacTreeUtils.newArray(fieldReaderType, null, List.from(fieldReaders));
        long features = 0L;
        JCTree.JCMethodInvocation superMethod = JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.ident(this.names._super), List.of(JavacTreeUtils.field(beanType, this.names._class), JavacTreeUtils.defNull(), JavacTreeUtils.defNull(), new JCTree.JCExpression[]{JavacTreeUtils.literal(features), lambda, JavacTreeUtils.defNull(), fieldReadersArray}));
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        stmts.append(JavacTreeUtils.exec(superMethod));
        if (superClass == ObjectReaderAdapter.class && generatedFields) {
            stmts.appendList(this.genInitFields(fieldsSize, superClass));
        }
        return JavacTreeUtils.defMethod(1L, this.names.init, (JCTree.JCExpression)JavacTreeUtils.type(TypeTag.VOID), null, null, null, JavacTreeUtils.block(stmts.toList()), null);
    }

    private JCTree.JCMethodDecl genWriteConstructor(JCTree.JCExpression beanType, JCTree.JCNewClass beanNew, java.util.List<AttributeInfo> fields, Class superClass, boolean generatedFields) {
        JCTree.JCExpression fieldWriterType = JavacTreeUtils.qualIdent(FieldWriter.class.getName());
        ListBuffer<JCTree.JCMethodInvocation> fieldWriters = new ListBuffer<JCTree.JCMethodInvocation>();
        JCTree.JCExpression objectWritersType = JavacTreeUtils.qualIdent(ObjectWriters.class.getName());
        int fieldsSize = fields.size();
        for (int i = 0; i < fieldsSize; ++i) {
            JCTree.JCMethodInvocation writerMethod = null;
            AttributeInfo attributeInfo = fields.get(i);
            if (attributeInfo.getMethod != null) {
                writerMethod = this.writerMethod(beanType, objectWritersType, attributeInfo, true);
            } else if (attributeInfo.field != null) {
                String fieldName = attributeInfo.field.getSimpleName().toString();
                writerMethod = fieldName.equals(attributeInfo.name) ? this.writerMethod(beanType, objectWritersType, attributeInfo, false) : this.writerMethod(beanType, objectWritersType, attributeInfo, false);
            } else {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "not implemented yet");
            }
            if (writerMethod == null) continue;
            fieldWriters.append(writerMethod);
        }
        JCTree.JCNewArray fieldReadersArray = JavacTreeUtils.newArray(fieldWriterType, null, List.from(fieldWriters));
        JCTree.JCMethodInvocation fieldReadersList = JavacTreeUtils.method(JavacTreeUtils.qualIdent("java.util.Arrays"), "asList", (JCTree.JCExpression)fieldReadersArray);
        JCTree.JCMethodInvocation superMethod = JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.ident(this.names._super), List.of(JavacTreeUtils.field(beanType, this.names._class), JavacTreeUtils.defNull(), JavacTreeUtils.defNull(), new JCTree.JCExpression[]{JavacTreeUtils.literal(0L), fieldReadersList}));
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        stmts.append(JavacTreeUtils.exec(superMethod));
        if (superClass == ObjectWriterAdapter.class && generatedFields) {
            stmts.appendList(this.genInitFields(fields.size(), superClass));
        }
        return JavacTreeUtils.defMethod(1L, this.names.init, (JCTree.JCExpression)JavacTreeUtils.type(TypeTag.VOID), null, null, null, JavacTreeUtils.block(stmts.toList()), null);
    }

    private JCTree.JCMethodInvocation writerMethod(JCTree.JCExpression beanType, JCTree.JCExpression objectWritersType, AttributeInfo attributeInfo, boolean isMethodReference) {
        JCTree.JCFieldAccess fieldClass;
        String type = attributeInfo.type.toString();
        if ("boolean".equals(type) || "char".equals(type) || "byte".equals(type) || "short".equals(type) || "int".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type)) {
            if (isMethodReference) {
                String methodName = attributeInfo.getMethod.getSimpleName().toString();
                JCTree.JCMemberReference memberedReference = JavacTreeUtils.methodRef(beanType, methodName);
                return JavacTreeUtils.method(objectWritersType, "fieldWriter", (JCTree.JCExpression)JavacTreeUtils.literal(attributeInfo.name), (JCTree.JCExpression)memberedReference);
            }
            String fieldName = attributeInfo.field.getSimpleName().toString();
            JCTree.JCLambda lambda = JavacTreeUtils.lambda(JavacTreeUtils.defVar("bean", beanType), (JCTree)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident("bean"), fieldName));
            return JavacTreeUtils.method(objectWritersType, "fieldWriter", (JCTree.JCExpression)JavacTreeUtils.literal(fieldName), (JCTree.JCExpression)lambda);
        }
        if ("java.lang.Class".equals(type)) {
            if (isMethodReference) {
                String methodName = attributeInfo.getMethod.getSimpleName().toString();
                JCTree.JCMemberReference memberedReference = JavacTreeUtils.methodRef(beanType, methodName);
                return JavacTreeUtils.method(objectWritersType, "fieldWriter", (JCTree.JCExpression)JavacTreeUtils.literal(attributeInfo.name), (JCTree.JCExpression)JavacTreeUtils.field(beanType, this.names._class), (JCTree.JCExpression)memberedReference);
            }
            String fieldName = attributeInfo.field.getSimpleName().toString();
            JCTree.JCLambda lambda = JavacTreeUtils.lambda(JavacTreeUtils.defVar("bean", beanType), (JCTree)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident("bean"), fieldName));
            return JavacTreeUtils.method(objectWritersType, "fieldWriter", (JCTree.JCExpression)JavacTreeUtils.literal(fieldName), (JCTree.JCExpression)JavacTreeUtils.field(beanType, this.names._class), (JCTree.JCExpression)lambda);
        }
        if ("java.lang.Type".equals(type)) {
            if (isMethodReference) {
                String methodName = attributeInfo.getMethod.getSimpleName().toString();
                JCTree.JCMemberReference memberedReference = JavacTreeUtils.methodRef(beanType, methodName);
                return JavacTreeUtils.method(objectWritersType, "fieldWriter", (JCTree.JCExpression)JavacTreeUtils.literal(attributeInfo.name), (JCTree.JCExpression)JavacTreeUtils.field(beanType, this.names._class), (JCTree.JCExpression)JavacTreeUtils.field(beanType, this.names._class), memberedReference);
            }
            String fieldName = attributeInfo.field.getSimpleName().toString();
            JCTree.JCLambda lambda = JavacTreeUtils.lambda(List.of(JavacTreeUtils.defVar("bean", beanType)), (JCTree)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident("bean"), fieldName));
            return JavacTreeUtils.method(objectWritersType, "fieldWriter", (JCTree.JCExpression)JavacTreeUtils.literal(fieldName), (JCTree.JCExpression)JavacTreeUtils.field(beanType, this.names._class), (JCTree.JCExpression)JavacTreeUtils.field(beanType, this.names._class), lambda);
        }
        if ("java.util.List<java.lang.String>".equals(type)) {
            if (isMethodReference) {
                String methodName = attributeInfo.getMethod.getSimpleName().toString();
                JCTree.JCMemberReference memberedReference = JavacTreeUtils.methodRef(beanType, methodName);
                return JavacTreeUtils.method(objectWritersType, "fieldWriterListString", (JCTree.JCExpression)JavacTreeUtils.literal(attributeInfo.name), (JCTree.JCExpression)memberedReference);
            }
            String fieldName = attributeInfo.field.getSimpleName().toString();
            JCTree.JCLambda lambda = JavacTreeUtils.lambda(JavacTreeUtils.defVar("bean", beanType), (JCTree)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident("bean"), fieldName));
            return JavacTreeUtils.method(objectWritersType, "fieldWriterListString", (JCTree.JCExpression)JavacTreeUtils.literal(fieldName), (JCTree.JCExpression)lambda);
        }
        if (type.startsWith("java.util.List") || type.startsWith("java.util.ArrayList") || type.startsWith("java.util.LinkedList") || type.startsWith("java.util.concurrent.CopyOnWriteArrayList")) {
            String itemType = type.contains("<") ? type.substring(type.indexOf("<") + 1, type.length() - 1) : type;
            JCTree.JCFieldAccess itemTypeClass = JavacTreeUtils.field(JavacTreeUtils.qualIdent(itemType), this.names._class);
            if (isMethodReference) {
                String methodName = attributeInfo.getMethod.getSimpleName().toString();
                JCTree.JCMemberReference memberedReference = JavacTreeUtils.methodRef(beanType, methodName);
                return JavacTreeUtils.method(objectWritersType, "fieldWriterList", (JCTree.JCExpression)JavacTreeUtils.literal(attributeInfo.name), (JCTree.JCExpression)itemTypeClass, (JCTree.JCExpression)memberedReference);
            }
            String fieldName = attributeInfo.field.getSimpleName().toString();
            JCTree.JCLambda lambda = JavacTreeUtils.lambda(JavacTreeUtils.defVar("bean", beanType), (JCTree)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident("bean"), fieldName));
            return JavacTreeUtils.method(objectWritersType, "fieldWriterList", (JCTree.JCExpression)JavacTreeUtils.literal(fieldName), (JCTree.JCExpression)itemTypeClass, (JCTree.JCExpression)lambda);
        }
        if (type.contains("[")) {
            fieldClass = JavacTreeUtils.field(JavacTreeUtils.arrayIdentType(type), this.names._class);
        } else {
            int idx = type.indexOf("<");
            if (idx != -1) {
                type = type.substring(0, idx);
            }
            fieldClass = JavacTreeUtils.field(JavacTreeUtils.identType(type), this.names._class);
        }
        if (isMethodReference) {
            String methodName = attributeInfo.getMethod.getSimpleName().toString();
            JCTree.JCMemberReference memberedReference = JavacTreeUtils.methodRef(beanType, methodName);
            return JavacTreeUtils.method(objectWritersType, "fieldWriter", (JCTree.JCExpression)JavacTreeUtils.literal(attributeInfo.name), (JCTree.JCExpression)fieldClass, (JCTree.JCExpression)memberedReference);
        }
        String fieldName = attributeInfo.field.getSimpleName().toString();
        JCTree.JCLambda lambda = JavacTreeUtils.lambda(JavacTreeUtils.defVar("bean", beanType), (JCTree)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident("bean"), fieldName));
        return JavacTreeUtils.method(objectWritersType, "fieldWriter", (JCTree.JCExpression)JavacTreeUtils.literal(fieldName), (JCTree.JCExpression)fieldClass, (JCTree.JCExpression)lambda);
    }

    private JCTree.JCMethodInvocation genFieldReader(JCTree.JCExpression beanType, AttributeInfo attributeInfo, JCTree.JCExpression objectReadersType) {
        JCTree.JCExpression identType;
        if (attributeInfo.setMethod == null && attributeInfo.field == null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "not implemented yet");
            return null;
        }
        String fieldType = attributeInfo.type.toString();
        JCTree.JCLiteral fieldName = JavacTreeUtils.literal(attributeInfo.name);
        JCTree.JCFunctionalExpression lambda = null;
        if (attributeInfo.setMethod != null) {
            lambda = JavacTreeUtils.methodRef(beanType, attributeInfo.setMethod.getSimpleName().toString());
        }
        String methodName = null;
        switch (fieldType) {
            case "byte": {
                methodName = "fieldReaderByte";
                identType = JavacTreeUtils.type(TypeTag.BYTE);
                break;
            }
            case "short": {
                identType = JavacTreeUtils.type(TypeTag.SHORT);
                methodName = "fieldReaderShort";
                break;
            }
            case "int": {
                identType = JavacTreeUtils.type(TypeTag.INT);
                methodName = "fieldReaderInt";
                break;
            }
            case "long": {
                identType = JavacTreeUtils.type(TypeTag.LONG);
                methodName = "fieldReaderLong";
                break;
            }
            case "char": {
                identType = JavacTreeUtils.type(TypeTag.CHAR);
                methodName = "fieldReaderChar";
                break;
            }
            case "float": {
                identType = JavacTreeUtils.type(TypeTag.FLOAT);
                methodName = "fieldReaderFloat";
                break;
            }
            case "double": {
                identType = JavacTreeUtils.type(TypeTag.DOUBLE);
                methodName = "fieldReaderDouble";
                break;
            }
            case "boolean": {
                identType = JavacTreeUtils.type(TypeTag.BOOLEAN);
                methodName = "fieldReaderBool";
                break;
            }
            case "java.lang.String": {
                identType = JavacTreeUtils.qualIdent("java.lang.String");
                methodName = "fieldReaderString";
                break;
            }
            default: {
                identType = this.getFieldValueType(fieldType);
            }
        }
        if (lambda == null) {
            JCTree.JCVariableDecl object = JavacTreeUtils.defVar("o", beanType);
            JCTree.JCExpression valueType = identType;
            if (fieldType.startsWith("java.util.Map<")) {
                valueType = JavacTreeUtils.qualIdent("java.util.Map");
            }
            JCTree.JCVariableDecl fieldValue = JavacTreeUtils.defVar("v", valueType);
            List<JCTree.JCVariableDecl> args = List.of(object, fieldValue);
            lambda = JavacTreeUtils.lambda(args, (JCTree)JavacTreeUtils.assign(JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident("o"), attributeInfo.field.getSimpleName().toString()), (JCTree.JCExpression)JavacTreeUtils.ident("v")));
        }
        if (methodName != null) {
            return JavacTreeUtils.method(objectReadersType, methodName, (JCTree.JCExpression)fieldName, (JCTree.JCExpression)lambda);
        }
        JCTree.JCMethodInvocation readerMethod = this.genFieldReaderList(objectReadersType, fieldType, fieldName, lambda);
        if (readerMethod != null) {
            return readerMethod;
        }
        readerMethod = this.genFieldReaderMap(objectReadersType, fieldType, fieldName, lambda);
        if (readerMethod != null) {
            return readerMethod;
        }
        if (fieldType.indexOf(60) == -1) {
            readerMethod = JavacTreeUtils.method(objectReadersType, "fieldReader", (JCTree.JCExpression)fieldName, (JCTree.JCExpression)JavacTreeUtils.field(this.getFieldValueType(fieldType), this.names._class), (JCTree.JCExpression)lambda);
        } else {
            List<JCTree.JCExpression> args;
            String fieldReaderMethodName;
            JCTree.JCFieldAccess fieldClassRef = JavacTreeUtils.field(beanType, this.names._class);
            if (attributeInfo.setMethod != null) {
                fieldReaderMethodName = "fieldReaderWithMethod";
                args = List.of(JavacTreeUtils.literal(attributeInfo.name), fieldClassRef, JavacTreeUtils.literal(methodName));
            } else {
                JCTree.JCLiteral fieldNameLiteral = JavacTreeUtils.literal(attributeInfo.field.getSimpleName().toString());
                args = fieldName.toString().equals(attributeInfo.name) ? List.of(fieldNameLiteral, fieldClassRef) : List.of(JavacTreeUtils.literal(attributeInfo.name), fieldClassRef, fieldNameLiteral);
                fieldReaderMethodName = "fieldReaderWithField";
            }
            readerMethod = JavacTreeUtils.method(objectReadersType, fieldReaderMethodName, args);
        }
        return readerMethod;
    }

    private JCTree.JCMethodInvocation genFieldReaderList(JCTree.JCExpression objectReadersType, String fieldType, JCTree.JCLiteral fieldName, JCTree.JCExpression lambda) {
        String[] listTypes;
        String listType = null;
        String itemType = null;
        for (String item : listTypes = new String[]{"java.util.List", "java.util.ArrayList"}) {
            if (!fieldType.startsWith(item) || fieldType.length() == item.length() || fieldType.charAt(item.length()) != '<') continue;
            int lastIndex = fieldType.lastIndexOf(62);
            String temp = fieldType.substring(item.length() + 1, lastIndex);
            if (temp.indexOf(44) != -1 || temp.indexOf(63) != -1) break;
            listType = item;
            itemType = temp;
            break;
        }
        if (listType == null) {
            return null;
        }
        JCTree.JCMethodInvocation readerMethod = "java.lang.String".equals(itemType) && "java.util.List".equals(listType) ? JavacTreeUtils.method(objectReadersType, "fieldReaderListStr", (JCTree.JCExpression)fieldName, lambda) : JavacTreeUtils.method(objectReadersType, "fieldReaderList", (JCTree.JCExpression)fieldName, (JCTree.JCExpression)JavacTreeUtils.field(this.getFieldValueType(itemType), this.names._class), (JCTree.JCExpression)JavacTreeUtils.constructorRef(JavacTreeUtils.qualIdent("java.util.ArrayList")), lambda);
        return readerMethod;
    }

    private JCTree.JCMethodInvocation genFieldReaderMap(JCTree.JCExpression objectReadersType, String fieldType, JCTree.JCLiteral fieldName, JCTree.JCExpression lambda) {
        String[] mapTypes;
        String mapType = null;
        String keyType = null;
        String valueType = null;
        for (String item : mapTypes = new String[]{"java.util.Map", "java.util.HashMap", "java.util.TreeMap"}) {
            if (!fieldType.startsWith(item) || fieldType.length() == item.length() || fieldType.charAt(item.length()) != '<') continue;
            int lastIndex = fieldType.lastIndexOf(62);
            String keyValueType = fieldType.substring(item.length() + 1, lastIndex);
            if (keyValueType.indexOf(60) != -1 || keyValueType.indexOf(63) != -1) break;
            int commaIndex = keyValueType.indexOf(44);
            if (commaIndex == -1) continue;
            keyType = keyValueType.substring(0, commaIndex);
            valueType = keyValueType.substring(commaIndex + 1);
            if (keyType.indexOf(60) != -1 || keyType.indexOf(63) != -1 || valueType.indexOf(60) != -1 || valueType.indexOf(63) != -1) {
                keyType = null;
                valueType = null;
                continue;
            }
            mapType = item;
            break;
        }
        if (mapType == null) {
            return null;
        }
        return JavacTreeUtils.method(objectReadersType, "fieldReaderMap", (JCTree.JCExpression)fieldName, (JCTree.JCExpression)JavacTreeUtils.field(this.getFieldValueType(mapType), this.names._class), (JCTree.JCExpression)JavacTreeUtils.field(this.getFieldValueType(keyType), this.names._class), JavacTreeUtils.field(this.getFieldValueType(valueType), this.names._class), lambda);
    }

    private List<JCTree.JCStatement> genInitFields(int fieldsSize, Class superClass) {
        ListBuffer<JCTree.JCExpressionStatement> stmts;
        block3: {
            block2: {
                stmts = new ListBuffer<JCTree.JCExpressionStatement>();
                if (!ObjectReaderAdapter.class.isAssignableFrom(superClass)) break block2;
                JCTree.JCFieldAccess fieldReaders = JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), "fieldReaders");
                for (int i = 0; i < fieldsSize; ++i) {
                    stmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(JavacTreeUtils.ident(CodeGenUtils.fieldReader(i)), (JCTree.JCExpression)JavacTreeUtils.indexed(fieldReaders, JavacTreeUtils.literal(i)))));
                }
                break block3;
            }
            if (!ObjectWriterAdapter.class.isAssignableFrom(superClass)) break block3;
            JCTree.JCFieldAccess fieldWriters = JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), "fieldWriterArray");
            for (int i = 0; i < fieldsSize; ++i) {
                stmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(JavacTreeUtils.ident(CodeGenUtils.fieldWriter(i)), (JCTree.JCExpression)JavacTreeUtils.cast(JavacTreeUtils.qualIdent(FieldWriter.class.getName()), (JCTree.JCExpression)JavacTreeUtils.indexed(fieldWriters, JavacTreeUtils.literal(i))))));
            }
        }
        return stmts.toList();
    }

    private JCTree.JCMethodDecl genCreateInstance(JCTree.JCIdent objectType, JCTree.JCNewClass beanNew) {
        JCTree.JCVariableDecl featuresVar = JavacTreeUtils.defVar("features", TypeTag.LONG);
        return JavacTreeUtils.defMethod(1L, "createInstance", objectType, List.of(featuresVar), JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.defReturn(beanNew)));
    }

    private JCTree.JCMethodDecl genReadObject(JCTree.JCIdent objectType, JCTree.JCExpression beanType, JCTree.JCNewClass beanNew, java.util.List<AttributeInfo> attributeInfos, StructInfo structInfo, boolean isJsonb) {
        int fieldNameLengthMin = 0;
        int fieldNameLengthMax = 0;
        for (int i = 0; i < attributeInfos.size(); ++i) {
            String fieldName = attributeInfos.get((int)i).name;
            int fieldNameLength = fieldName.getBytes(StandardCharsets.UTF_8).length;
            if (i == 0) {
                fieldNameLengthMin = fieldNameLength;
                fieldNameLengthMax = fieldNameLength;
                continue;
            }
            fieldNameLengthMin = Math.min(fieldNameLength, fieldNameLengthMin);
            fieldNameLengthMax = Math.max(fieldNameLength, fieldNameLengthMax);
        }
        JCTree.JCVariableDecl jsonReaderVar = JavacTreeUtils.defVar("jsonReader", JavacTreeUtils.qualIdent(JSONReader.class.getName()));
        JCTree.JCIdent jsonReaderIdent = JavacTreeUtils.ident(jsonReaderVar);
        JCTree.JCVariableDecl fieldTypeVar = JavacTreeUtils.defVar("fieldType", JavacTreeUtils.qualIdent(Type.class.getName()));
        JCTree.JCVariableDecl fieldNameVar = JavacTreeUtils.defVar("fieldName", objectType);
        JCTree.JCVariableDecl featuresVar = JavacTreeUtils.defVar("features", TypeTag.LONG);
        JCTree.JCReturn nullReturn = JavacTreeUtils.defReturn(JavacTreeUtils.defNull());
        ListBuffer<JCTree.JCStatement> readObjectBody = new ListBuffer<JCTree.JCStatement>();
        JCTree.JCMethodInvocation nextIfNullMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfNull");
        readObjectBody.append(JavacTreeUtils.defIf(nextIfNullMethod, nullReturn));
        readObjectBody.append(JavacTreeUtils.exec(JavacTreeUtils.method(jsonReaderIdent, "nextIfObjectStart")));
        JCTree.JCVariableDecl features2Var = JavacTreeUtils.defVar(0x200000000L, "features2", TypeTag.LONG, (JCTree.JCExpression)JavacTreeUtils.bitOr(JavacTreeUtils.ident("features"), JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), "features")));
        readObjectBody.append(features2Var);
        JCTree.JCVariableDecl objectVar = JavacTreeUtils.defVar("object", beanType, (JCTree.JCExpression)beanNew);
        JCTree.JCIdent objectIdent = JavacTreeUtils.ident(objectVar);
        readObjectBody.append(objectVar);
        int fieldsSize = attributeInfos.size();
        JCTree.JCLabeledStatement loopLabel = JavacTreeUtils.label("_while");
        JCTree.JCWhileLoop loopHead = JavacTreeUtils.whileLoop(JavacTreeUtils.unary(JCTree.Tag.NOT, JavacTreeUtils.method(jsonReaderIdent, "nextIfObjectEnd")), null);
        ListBuffer<JCTree.JCStatement> loopBody = new ListBuffer<JCTree.JCStatement>();
        boolean switchGen = false;
        if (fieldNameLengthMin >= 2 && fieldNameLengthMax <= 43) {
            loopBody.appendList(this.genRead243(attributeInfos, jsonReaderIdent, structInfo, loopLabel, objectIdent, beanType, isJsonb));
            switchGen = true;
        }
        JCTree.JCFieldAccess readFieldNameHashCode = JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "readFieldNameHashCode");
        JCTree.JCVariableDecl hashCode64Var = JavacTreeUtils.defVar("hashCode64", TypeTag.LONG, (JCTree.JCExpression)JavacTreeUtils.method(readFieldNameHashCode));
        JCTree.JCIdent hashCode64 = JavacTreeUtils.ident(hashCode64Var);
        loopBody.append(hashCode64Var);
        if (switchGen && !isJsonb) {
            loopBody.append(JavacTreeUtils.exec(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), "readFieldValue"), List.of(hashCode64, jsonReaderIdent, JavacTreeUtils.ident(features2Var), new JCTree.JCExpression[]{JavacTreeUtils.ident(objectVar)}))));
        } else {
            if (fieldsSize <= 6) {
                for (int i = 0; i < fieldsSize; ++i) {
                    AttributeInfo attributeInfo = attributeInfos.get(i);
                    List<JCTree.JCStatement> readFieldValueStmts = this.genReadFieldValue(attributeInfo, jsonReaderIdent, i, structInfo, loopLabel, objectIdent, beanType, isJsonb);
                    loopBody.appendList(List.of(JavacTreeUtils.defIf(JavacTreeUtils.eq((JCTree.JCExpression)hashCode64, attributeInfo.nameHashCode), JavacTreeUtils.block(readFieldValueStmts))));
                }
            } else {
                TreeMap<Integer, java.util.List> map = new TreeMap<Integer, java.util.List>();
                TreeMap<Long, AttributeInfo> mapping = new TreeMap<Long, AttributeInfo>();
                TreeMap<Long, Integer> mappingIndex = new TreeMap<Long, Integer>();
                for (int i = 0; i < fieldsSize; ++i) {
                    AttributeInfo attr = attributeInfos.get(i);
                    long fieldNameHash = attr.nameHashCode;
                    int hashCode32 = (int)(fieldNameHash ^ fieldNameHash >>> 32);
                    java.util.List hashCode64List = map.computeIfAbsent(hashCode32, k -> new ArrayList());
                    hashCode64List.add(fieldNameHash);
                    mapping.put(fieldNameHash, attr);
                    mappingIndex.put(fieldNameHash, i);
                }
                int[] hashCode32Keys = new int[map.size()];
                int off = 0;
                for (Integer key : map.keySet()) {
                    hashCode32Keys[off++] = key;
                }
                Arrays.sort(hashCode32Keys);
                JCTree.JCVariableDecl hashCode32Var = this.getHashCode32Var(hashCode64);
                loopBody.append(hashCode32Var);
                JCTree.JCIdent hashCode32 = JavacTreeUtils.ident(hashCode32Var);
                JCTree.JCLabeledStatement switchLabel = JavacTreeUtils.label("_switch");
                ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
                for (int i = 0; i < hashCode32Keys.length; ++i) {
                    java.util.List hashCode64Array = (java.util.List)map.get(hashCode32Keys[i]);
                    List<JCTree.JCStatement> stmts = List.nil();
                    Long fieldNameHash = null;
                    if (hashCode64Array.size() == 1 && (Long)hashCode64Array.get(0) == (long)hashCode32Keys[i]) {
                        fieldNameHash = (Long)hashCode64Array.get(0);
                        int index = (Integer)mappingIndex.get(fieldNameHash);
                        AttributeInfo attributeInfo = (AttributeInfo)mapping.get(fieldNameHash);
                        stmts = stmts.appendList(this.genReadFieldValue(attributeInfo, jsonReaderIdent, index, structInfo, loopLabel, objectIdent, beanType, isJsonb));
                        stmts.append(JavacTreeUtils.defContinue(loopLabel));
                    } else {
                        for (int j = 0; j < hashCode64Array.size(); ++j) {
                            fieldNameHash = (Long)hashCode64Array.get(j);
                            int index = (Integer)mappingIndex.get(fieldNameHash);
                            AttributeInfo field = (AttributeInfo)mapping.get(fieldNameHash);
                            List<JCTree.JCStatement> stmtsIf = this.genReadFieldValue(field, jsonReaderIdent, index, structInfo, loopLabel, objectIdent, beanType, isJsonb);
                            stmts = stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq((JCTree.JCExpression)hashCode64, fieldNameHash), JavacTreeUtils.block(stmtsIf)));
                            stmts.append(JavacTreeUtils.defContinue(loopLabel));
                        }
                        stmts.append(JavacTreeUtils.defBreak(switchLabel));
                    }
                    cases.append(JavacTreeUtils.defCase(this.getHashCode32Var(JavacTreeUtils.literal(fieldNameHash)).getInitializer(), stmts));
                }
                switchLabel.body = JavacTreeUtils.defSwitch(hashCode32, cases.toList());
                loopBody.append(switchLabel);
            }
            loopBody.append(JavacTreeUtils.defIf(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), "readFieldValueWithLCase", (JCTree.JCExpression)jsonReaderIdent, (JCTree.JCExpression)objectIdent, (JCTree.JCExpression)JavacTreeUtils.ident(hashCode64Var), JavacTreeUtils.ident(features2Var)), JavacTreeUtils.defContinue(loopLabel)));
            JCTree.JCFieldAccess processExtraField = JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), "processExtra");
            loopBody.append(JavacTreeUtils.exec(JavacTreeUtils.method((JCTree.JCExpression)processExtraField, jsonReaderIdent, (JCTree.JCExpression)objectIdent, (JCTree.JCExpression)JavacTreeUtils.ident(features2Var))));
        }
        loopHead.body = JavacTreeUtils.block(loopBody.toList());
        loopLabel.body = loopHead;
        readObjectBody.append(loopLabel);
        if (!isJsonb) {
            readObjectBody.append(JavacTreeUtils.exec(JavacTreeUtils.method(jsonReaderIdent, "nextIfComma")));
        }
        readObjectBody.append(JavacTreeUtils.defReturn(objectIdent));
        return JavacTreeUtils.defMethod(1L, isJsonb ? "readJSONBObject" : "readObject", objectType, List.of(jsonReaderVar, fieldTypeVar, fieldNameVar, new JCTree.JCVariableDecl[]{featuresVar}), JavacTreeUtils.block(readObjectBody.toList()));
    }

    private JCTree.JCMethodDecl genWrite(JCTree.JCIdent objectType, JCTree.JCExpression beanType, JCTree.JCNewClass beanNew, java.util.List<AttributeInfo> attributeInfos, StructInfo structInfo, boolean jsonb) {
        int fieldNameLengthMin = 0;
        int fieldNameLengthMax = 0;
        for (int i = 0; i < attributeInfos.size(); ++i) {
            String fieldName = attributeInfos.get((int)i).name;
            int fieldNameLength = fieldName.getBytes(StandardCharsets.UTF_8).length;
            if (i == 0) {
                fieldNameLengthMin = fieldNameLength;
                fieldNameLengthMax = fieldNameLength;
                continue;
            }
            fieldNameLengthMin = Math.min(fieldNameLength, fieldNameLengthMin);
            fieldNameLengthMax = Math.max(fieldNameLength, fieldNameLengthMax);
        }
        ListBuffer<JCTree.JCStatement> writeBody = new ListBuffer<JCTree.JCStatement>();
        MethodWriterContext mwc = new MethodWriterContext(beanType, objectType, jsonb);
        mwc.genVariantsMethodBefore(writeBody);
        writeBody.append(JavacTreeUtils.defIfReturn(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.IgnoreErrorGetter.mask | JSONWriter.Feature.UnquoteFieldName.mask), 0L), JavacTreeUtils.exec(JavacTreeUtils.method(this.names._super, "write", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)mwc.object, (JCTree.JCExpression)mwc.fieldName, mwc.fieldType, mwc.features))));
        writeBody.append(JavacTreeUtils.defIfReturn(mwc.jsonWriterField("jsonb"), JavacTreeUtils.defIf(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JavacTreeUtils.literal(JSONWriter.Feature.BeanToArray.mask)), 0L), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(JavacTreeUtils.method(this.names._this, "writeArrayMappingJSONB", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)mwc.object, (JCTree.JCExpression)mwc.fieldName, mwc.fieldType, mwc.features))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(JavacTreeUtils.method(this.names._this, "writeJSONB", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)mwc.object, (JCTree.JCExpression)mwc.fieldName, mwc.fieldType, mwc.features))))));
        writeBody.append(JavacTreeUtils.defIfReturn(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.BeanToArray.mask), 0L), JavacTreeUtils.exec(JavacTreeUtils.method(this.names._this, "writeArrayMapping", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)mwc.object, (JCTree.JCExpression)mwc.fieldName, mwc.fieldType, mwc.features))));
        writeBody.append(JavacTreeUtils.defIfReturn(JavacTreeUtils.method(this.names._this, "hasFilter", (JCTree.JCExpression)mwc.jsonWriter), JavacTreeUtils.exec(JavacTreeUtils.method(this.names._this, "writeWithFilter", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)mwc.object, (JCTree.JCExpression)mwc.fieldName, mwc.fieldType, mwc.features))));
        writeBody.append(JavacTreeUtils.defIfReturn(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.IgnoreNoneSerializable.mask), 0L), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeNull"))));
        writeBody.append(JavacTreeUtils.defIfReturn(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.ErrorOnNoneSerializable.mask), 0L), JavacTreeUtils.exec(JavacTreeUtils.method(this.names._this, "errorOnNoneSerializable"))));
        writeBody.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("startObject")));
        JCTree.JCVariableDecl var7Var = JavacTreeUtils.defVar("var7", true);
        writeBody.append(var7Var);
        writeBody.append(JavacTreeUtils.defIf(JavacTreeUtils.and(JavacTreeUtils.notNull(mwc.object), JavacTreeUtils.and(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.method(mwc.object, "getClass"), (JCTree.JCExpression)mwc.fieldType), JavacTreeUtils.method(mwc.jsonWriter, "isWriteTypeInfo", (JCTree.JCExpression)mwc.object, (JCTree.JCExpression)mwc.fieldType, (JCTree.JCExpression)mwc.features))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(JavacTreeUtils.assign(JavacTreeUtils.ident(var7Var), (JCTree.JCExpression)JavacTreeUtils.bitXor(JavacTreeUtils.method(this.names._this, "writeTypeInfo", (JCTree.JCExpression)mwc.jsonWriter), JavacTreeUtils.literal(true))))), null));
        for (int i = 0; i < attributeInfos.size(); ++i) {
            AttributeInfo attributeInfo = attributeInfos.get(i);
            writeBody.appendList(this.genWriteField(mwc, attributeInfo, i));
        }
        writeBody.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("endObject")));
        return JavacTreeUtils.defMethod(1L, "write", JavacTreeUtils.type(TypeTag.VOID), List.of(JavacTreeUtils.defVar("jsonWriter", JavacTreeUtils.qualIdent(JSONWriter.class.getName())), JavacTreeUtils.defVar("object", objectType), JavacTreeUtils.defVar("fieldName", objectType), new JCTree.JCVariableDecl[]{JavacTreeUtils.defVar("fieldType", JavacTreeUtils.qualIdent(Type.class.getName())), JavacTreeUtils.defVar("features", TypeTag.LONG)}), JavacTreeUtils.block(writeBody.toList()));
    }

    private JCTree.JCStatement genWriteFieldName(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        if (!mwc.jsonb) {
            int length;
            byte[] fieldNameUTF8 = attributeInfo.name.getBytes(StandardCharsets.UTF_8);
            boolean asciiName = true;
            for (int j = 0; j < fieldNameUTF8.length; ++j) {
                if (fieldNameUTF8[j] >= 0) continue;
                asciiName = false;
                break;
            }
            if ((length = fieldNameUTF8.length) >= 2 && length <= 16 && asciiName) {
                String methodName;
                long name1 = 0L;
                int name12 = 0;
                long name1SQ = 0L;
                int name1SQ2 = 0;
                byte[] bytes = new byte[8];
                switch (length) {
                    case 2: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 2);
                        bytes[3] = 34;
                        bytes[4] = 58;
                        methodName = "writeName2Raw";
                        break;
                    }
                    case 3: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 3);
                        bytes[4] = 34;
                        bytes[5] = 58;
                        methodName = "writeName3Raw";
                        break;
                    }
                    case 4: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 4);
                        bytes[5] = 34;
                        bytes[6] = 58;
                        methodName = "writeName4Raw";
                        break;
                    }
                    case 5: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 5);
                        bytes[6] = 34;
                        bytes[7] = 58;
                        methodName = "writeName5Raw";
                        break;
                    }
                    case 6: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 6);
                        bytes[7] = 34;
                        methodName = "writeName6Raw";
                        break;
                    }
                    case 7: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        methodName = "writeName7Raw";
                        break;
                    }
                    case 8: {
                        bytes = fieldNameUTF8;
                        methodName = "writeName8Raw";
                        break;
                    }
                    case 9: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        byte[] name1Bytes = new byte[]{fieldNameUTF8[7], fieldNameUTF8[8], 34, 58};
                        name12 = JDKUtils.UNSAFE.getInt(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[2] = 39;
                        name1SQ2 = JDKUtils.UNSAFE.getInt(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName9Raw";
                        break;
                    }
                    case 10: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        byte[] name1Bytes = new byte[8];
                        name1Bytes[0] = fieldNameUTF8[7];
                        name1Bytes[1] = fieldNameUTF8[8];
                        name1Bytes[2] = fieldNameUTF8[9];
                        name1Bytes[3] = 34;
                        name1Bytes[4] = 58;
                        name1 = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[3] = 39;
                        name1SQ = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName10Raw";
                        break;
                    }
                    case 11: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        byte[] name1Bytes = new byte[8];
                        name1Bytes[0] = fieldNameUTF8[7];
                        name1Bytes[1] = fieldNameUTF8[8];
                        name1Bytes[2] = fieldNameUTF8[9];
                        name1Bytes[3] = fieldNameUTF8[10];
                        name1Bytes[4] = 34;
                        name1Bytes[5] = 58;
                        name1 = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[4] = 39;
                        name1SQ = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName11Raw";
                        break;
                    }
                    case 12: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        byte[] name1Bytes = new byte[8];
                        name1Bytes[0] = fieldNameUTF8[7];
                        name1Bytes[1] = fieldNameUTF8[8];
                        name1Bytes[2] = fieldNameUTF8[9];
                        name1Bytes[3] = fieldNameUTF8[10];
                        name1Bytes[4] = fieldNameUTF8[11];
                        name1Bytes[5] = 34;
                        name1Bytes[6] = 58;
                        name1 = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[5] = 39;
                        name1SQ = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName12Raw";
                        break;
                    }
                    case 13: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        byte[] name1Bytes = new byte[]{fieldNameUTF8[7], fieldNameUTF8[8], fieldNameUTF8[9], fieldNameUTF8[10], fieldNameUTF8[11], fieldNameUTF8[12], 34, 58};
                        name1 = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[6] = 39;
                        name1SQ = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName13Raw";
                        break;
                    }
                    case 14: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        byte[] name1Bytes = new byte[]{fieldNameUTF8[7], fieldNameUTF8[8], fieldNameUTF8[9], fieldNameUTF8[10], fieldNameUTF8[11], fieldNameUTF8[12], fieldNameUTF8[13], 34};
                        name1 = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        name1Bytes[7] = 39;
                        name1SQ = JDKUtils.UNSAFE.getLong(name1Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        methodName = "writeName14Raw";
                        break;
                    }
                    case 15: {
                        bytes[0] = 34;
                        System.arraycopy(fieldNameUTF8, 0, bytes, 1, 7);
                        name1SQ = name1 = JDKUtils.UNSAFE.getLong(fieldNameUTF8, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 7L);
                        methodName = "writeName15Raw";
                        break;
                    }
                    case 16: {
                        System.arraycopy(fieldNameUTF8, 0, bytes, 0, 8);
                        name1SQ = name1 = JDKUtils.UNSAFE.getLong(fieldNameUTF8, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 8L);
                        methodName = "writeName16Raw";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("length : " + length);
                    }
                }
                long nameIn64DoubleQuote = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                for (int j = 0; j < bytes.length; ++j) {
                    if (bytes[j] != 34) continue;
                    bytes[j] = 39;
                }
                long nameIn64SingleQuote = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                JCTree.JCConditional ternary = JavacTreeUtils.ternary((JCTree.JCExpression)mwc.nameDirect, (JCTree.JCExpression)JavacTreeUtils.literal(nameIn64DoubleQuote), (JCTree.JCExpression)JavacTreeUtils.literal(nameIn64SingleQuote));
                if (length == 9) {
                    ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
                    JCTree.JCConditional ternary2 = JavacTreeUtils.ternary((JCTree.JCExpression)mwc.nameDirect, name12, name1SQ2);
                    JCTree.JCVariableDecl name1Var = JavacTreeUtils.defVar("name1", TypeTag.INT, (JCTree.JCExpression)ternary2);
                    stmts.append(JavacTreeUtils.defVar("name1", TypeTag.INT, (JCTree.JCExpression)ternary2));
                    stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod(methodName, (JCTree.JCExpression)ternary, name1Var)));
                    return JavacTreeUtils.block(stmts.toList());
                }
                if (length > 9) {
                    JCTree.JCConditional ternary2 = JavacTreeUtils.ternary((JCTree.JCExpression)mwc.nameDirect, name1, name1SQ);
                    return JavacTreeUtils.exec(mwc.jsonWriterMethod(methodName, (JCTree.JCExpression)ternary, ternary2));
                }
                return JavacTreeUtils.exec(mwc.jsonWriterMethod(methodName, ternary));
            }
        } else {
            byte[] fieldNameUTF8 = JSONB.toBytes((String)attributeInfo.name);
            int length = fieldNameUTF8.length;
            byte[] bytes = Arrays.copyOf(fieldNameUTF8, 16);
            switch (length) {
                case 2: {
                    String methodName = "writeName2Raw";
                    break;
                }
                case 3: {
                    String methodName = "writeName3Raw";
                    break;
                }
                case 4: {
                    String methodName = "writeName4Raw";
                    break;
                }
                case 5: {
                    String methodName = "writeName5Raw";
                    break;
                }
                case 6: {
                    String methodName = "writeName6Raw";
                    break;
                }
                case 7: {
                    String methodName = "writeName7Raw";
                    break;
                }
                case 8: {
                    String methodName = "writeName8Raw";
                    break;
                }
                case 9: {
                    String methodName = "writeName9Raw";
                    break;
                }
                case 10: {
                    String methodName = "writeName10Raw";
                    break;
                }
                case 11: {
                    String methodName = "writeName11Raw";
                    break;
                }
                case 12: {
                    String methodName = "writeName12Raw";
                    break;
                }
                case 13: {
                    String methodName = "writeName13Raw";
                    break;
                }
                case 14: {
                    String methodName = "writeName14Raw";
                    break;
                }
                case 15: {
                    String methodName = "writeName15Raw";
                    break;
                }
                case 16: {
                    String methodName = "writeName16Raw";
                    break;
                }
            }
        }
        return JavacTreeUtils.exec(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), mwc.jsonb ? "writeFieldNameJSONB" : "writeFieldName", (JCTree.JCExpression)mwc.jsonWriter));
    }

    private ListBuffer<JCTree.JCStatement> genWriteField(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        if ("boolean".equals(type)) {
            return this.genWriteFieldValueBooleanV(mwc, attributeInfo, i);
        }
        if ("boolean[]".equals(type) || "byte[]".equals(type) || "char[]".equals(type) || "short[]".equals(type) || "float[]".equals(type) || "double[]".equals(type)) {
            return stmts.appendList(this.genWriteFieldValueArray(mwc, attributeInfo, i));
        }
        if ("int".equals(type)) {
            return stmts.appendList(this.genWriteFieldValueInt32V(mwc, attributeInfo, i));
        }
        if ("char".equals(type) || "byte".equals(type) || "int".equals(type) || "short".equals(type) || "float".equals(type) || "double".equals(type)) {
            stmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
            return stmts.appendList(this.genWriteFieldValue(mwc, attributeInfo, i, null));
        }
        if ("int[]".equals(type)) {
            return stmts.appendList(this.genWriteFieldValueIntVA(mwc, attributeInfo, i));
        }
        if ("long".equals(type)) {
            return stmts.appendList(this.genWriteFieldValueInt64V(mwc, attributeInfo, i));
        }
        if ("long[]".equals(type)) {
            return stmts.appendList(this.genWriteFieldValueInt64VA(mwc, attributeInfo, i));
        }
        if ("java.lang.Integer".equals(type)) {
            return stmts.appendList(this.genWriteInt32(mwc, attributeInfo, i));
        }
        if ("java.lang.Long".equals(type)) {
            return stmts.appendList(this.genWriteInt64(mwc, attributeInfo, i));
        }
        if ("java.lang.Float".equals(type)) {
            return stmts.appendList(this.genWriteFloat(mwc, attributeInfo, i));
        }
        if ("java.lang.Double".equals(type)) {
            return stmts.appendList(this.genWriteDouble(mwc, attributeInfo, i));
        }
        if ("java.math.BigDecimal".equals(type)) {
            return stmts.appendList(this.genWriteBigDecimal(mwc, attributeInfo, i));
        }
        if ("java.lang.Boolean".equals(type)) {
            return stmts.appendList(this.genWriteBoolean(mwc, attributeInfo, i));
        }
        if ("java.lang.String".equals(type)) {
            return stmts.appendList(this.genWriteFieldValueString(mwc, attributeInfo, i));
        }
        if (attributeInfo.type instanceof Type.ClassType && ((Type.ClassType)attributeInfo.type).supertype_field != null && "java.lang.Enum".equals(((Type.ClassType)attributeInfo.type).supertype_field.tsym.toString())) {
            return stmts.appendList(this.genWriteFieldValueEnum(mwc, attributeInfo, i));
        }
        if ("java.util.Date".equals(type)) {
            return stmts.appendList(this.genWriteFieldValueDate(mwc, attributeInfo, i));
        }
        if (type.contains("java.util.List")) {
            return stmts.appendList(this.genWriteFieldValueList(mwc, attributeInfo, i));
        }
        return stmts.appendList(this.genWriteFieldValueObject(mwc, attributeInfo, i));
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValue(MethodWriterContext mwc, AttributeInfo attributeInfo, int i, JCTree.JCExpression fieldValue) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        if (fieldValue == null) {
            fieldValue = this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType);
        }
        List<JCTree.JCExpression> fieldValueExprs = List.of(fieldValue);
        JCTree.JCBinary writeAsStringBinary = JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), CodeGenUtils.fieldWriter(i)), "features"), JSONWriter.Feature.WriteNonStringValueAsString.mask), 0);
        if ("boolean".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeBool", fieldValueExprs)));
        } else if ("char".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeChar", fieldValueExprs)));
        } else if ("byte".equals(type)) {
            stmts.append(JavacTreeUtils.defIf(writeAsStringBinary, (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeString", fieldValueExprs))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt8", fieldValueExprs)))));
        } else if ("short".equals(type)) {
            stmts.append(JavacTreeUtils.defIf(writeAsStringBinary, (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeString", fieldValueExprs))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt16", fieldValueExprs)))));
        } else if ("int".equals(type)) {
            stmts.append(JavacTreeUtils.defIf(writeAsStringBinary, (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeString", fieldValueExprs))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt32", fieldValueExprs)))));
        } else if ("Integer".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt32", fieldValueExprs)));
        } else if ("long".equals(type)) {
            stmts.append(JavacTreeUtils.defIf(writeAsStringBinary, (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeString", fieldValueExprs))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt64", fieldValueExprs)))));
        } else if ("Long".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt64", fieldValueExprs)));
        } else if ("float".equals(type)) {
            stmts.append(JavacTreeUtils.defIf(writeAsStringBinary, (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeString", fieldValueExprs))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeFloat", fieldValueExprs)))));
        } else if ("double".equals(type)) {
            stmts.append(JavacTreeUtils.defIf(writeAsStringBinary, (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeString", fieldValueExprs))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeDouble", fieldValueExprs)))));
        } else if ("boolean[]".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeBool", fieldValueExprs)));
        } else if ("char[]".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeString", fieldValueExprs)));
        } else if ("byte[]".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeBinary", fieldValueExprs)));
        } else if ("short[]".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt16", fieldValueExprs)));
        } else if ("int[]".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt32", fieldValueExprs)));
        } else if ("long[]".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt64", fieldValueExprs)));
        } else if ("float[]".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeFloat", fieldValueExprs)));
        } else if ("double[]".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeDouble", fieldValueExprs)));
        } else if ("BigDecimal".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeDecimal", fieldValueExprs)));
        } else if ("Enum".equals(type)) {
            stmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeEnum", fieldValueExprs)));
        } else {
            throw new UnsupportedOperationException();
        }
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValueBooleanV(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        JCTree.JCVariableDecl boolVar = JavacTreeUtils.defVar("bool" + i, TypeTag.BOOLEAN, this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(boolVar);
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.unary(JCTree.Tag.NOT, JavacTreeUtils.ident(boolVar)), JavacTreeUtils.block(List.nil())));
        stmts.append(JavacTreeUtils.exec(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), "writeBool", (JCTree.JCExpression)mwc.jsonWriter, boolVar)));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValueArray(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        String methodName;
        String type = attributeInfo.type.toString();
        ListBuffer<JCTree.JCExpressionStatement> stmts = new ListBuffer<JCTree.JCExpressionStatement>();
        List<JCTree.JCExpression> fieldValueExprs = List.of(mwc.jsonWriter, this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        if ("char[]".equals(type)) {
            methodName = "writeString";
        } else if ("boolean[]".equals(type)) {
            methodName = "writeBool";
        } else if ("byte[]".equals(type)) {
            methodName = "writeBinary";
        } else if ("short[]".equals(type)) {
            methodName = "writeInt16";
        } else if ("float[]".equals(type)) {
            methodName = "writeFloat";
        } else if ("double[]".equals(type)) {
            methodName = "writeDouble";
        } else if ("enum".equals(type)) {
            methodName = "writeEnumJSONB";
        } else {
            throw new UnsupportedOperationException();
        }
        return stmts.append(JavacTreeUtils.exec(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), methodName, fieldValueExprs)));
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValueInt32V(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        JCTree.JCVariableDecl int32Var = JavacTreeUtils.defVar("int32" + i, TypeTag.INT, this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(int32Var);
        ListBuffer<JCTree.JCStatement> ifStmts = new ListBuffer<JCTree.JCStatement>();
        ifStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
        ifStmts.appendList(this.genWriteFieldValue(mwc, attributeInfo, i, JavacTreeUtils.ident(int32Var)));
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.or(JavacTreeUtils.ne(int32Var, 0), JavacTreeUtils.not(mwc.notWriteDefaultValue)), JavacTreeUtils.block(ifStmts.toList())));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValueIntVA(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String elemType = ((ArrayType)attributeInfo.type).getComponentType().toString();
        JCTree.JCVariableDecl intArrayVar = JavacTreeUtils.defVar("intArray" + i, JavacTreeUtils.arrayIdentType(elemType), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(intArrayVar);
        ListBuffer<JCTree.JCStatement> notZeroStmts = new ListBuffer<JCTree.JCStatement>();
        notZeroStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
        notZeroStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeArrayNull")));
        ListBuffer<JCTree.JCIf> nullStmts = new ListBuffer<JCTree.JCIf>();
        nullStmts.append(JavacTreeUtils.defIf(mwc.writeNulls, JavacTreeUtils.block(notZeroStmts.toList())));
        ListBuffer<JCTree.JCStatement> notNullStmts = new ListBuffer<JCTree.JCStatement>();
        notNullStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
        notNullStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt32", intArrayVar)));
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq(intArrayVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), (JCTree.JCStatement)JavacTreeUtils.block(nullStmts.toList()), (JCTree.JCStatement)JavacTreeUtils.block(notNullStmts.toList())));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValueInt64V(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        JCTree.JCVariableDecl int64Var = JavacTreeUtils.defVar("int64" + i, TypeTag.LONG, this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(int64Var);
        ListBuffer<JCTree.JCStatement> ifStmts = new ListBuffer<JCTree.JCStatement>();
        ifStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
        ifStmts.appendList(this.genWriteFieldValue(mwc, attributeInfo, i, JavacTreeUtils.ident(int64Var)));
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.or(JavacTreeUtils.ne(int64Var, 0), JavacTreeUtils.not(mwc.notWriteDefaultValue)), (JCTree.JCStatement)JavacTreeUtils.block(ifStmts.toList()), null));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValueInt64VA(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String elemType = ((ArrayType)attributeInfo.type).getComponentType().toString();
        JCTree.JCVariableDecl longArrayVar = JavacTreeUtils.defVar("longArray" + i, JavacTreeUtils.arrayIdentType(elemType), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(longArrayVar);
        ListBuffer<JCTree.JCStatement> notZeroStmts = new ListBuffer<JCTree.JCStatement>();
        notZeroStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
        notZeroStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeArrayNull")));
        ListBuffer<JCTree.JCIf> nullStmts = new ListBuffer<JCTree.JCIf>();
        nullStmts.append(JavacTreeUtils.defIf(mwc.writeNulls, JavacTreeUtils.block(notZeroStmts.toList())));
        ListBuffer<JCTree.JCStatement> notNullStmts = new ListBuffer<JCTree.JCStatement>();
        notNullStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
        notNullStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt64", longArrayVar)));
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq(longArrayVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), (JCTree.JCStatement)JavacTreeUtils.block(nullStmts.toList()), (JCTree.JCStatement)JavacTreeUtils.block(notNullStmts.toList())));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteBigDecimal(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        JCTree.JCVariableDecl fieldValue = JavacTreeUtils.defVar("bigDecimal" + i, JavacTreeUtils.qualIdent(type), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(fieldValue);
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.or(JavacTreeUtils.notNull(fieldValue), JavacTreeUtils.isEnable(mwc.contextFeatures, JSONWriter.Feature.WriteNulls)), JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeDecimal", fieldValue)))));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteBoolean(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        JCTree.JCVariableDecl fieldValue = JavacTreeUtils.defVar("Boolean" + i, JavacTreeUtils.qualIdent(type), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(fieldValue);
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.or(JavacTreeUtils.notNull(fieldValue), JavacTreeUtils.isEnable(mwc.contextFeatures, JSONWriter.Feature.WriteNulls)), JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.defIf(JavacTreeUtils.notNull(fieldValue), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeBool", fieldValue))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeNull")))))));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteInt32(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        JCTree.JCVariableDecl integerVar = JavacTreeUtils.defVar("integer" + i, JavacTreeUtils.qualIdent(type), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(integerVar);
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne(integerVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), (JCTree.JCStatement)JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt32", integerVar))), (JCTree.JCStatement)JavacTreeUtils.defIf(JavacTreeUtils.isEnable(mwc.contextFeatures, JSONWriter.Feature.WriteNulls, JSONWriter.Feature.NullAsDefaultValue, JSONWriter.Feature.WriteNullNumberAsZero), JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeNumberNull"))))));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteInt64(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        JCTree.JCVariableDecl integerVar = JavacTreeUtils.defVar("long" + i, JavacTreeUtils.qualIdent(type), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(integerVar);
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne(integerVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), (JCTree.JCStatement)JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt64", integerVar))), (JCTree.JCStatement)JavacTreeUtils.defIf(JavacTreeUtils.isEnable(mwc.contextFeatures, JSONWriter.Feature.WriteNulls, JSONWriter.Feature.NullAsDefaultValue, JSONWriter.Feature.WriteNullNumberAsZero), JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeInt64Null"))))));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteFloat(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        JCTree.JCVariableDecl floatVar = JavacTreeUtils.defVar("float" + i, JavacTreeUtils.qualIdent(type), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(floatVar);
        ListBuffer<JCTree.JCStatement> notZeroStmts = new ListBuffer<JCTree.JCStatement>();
        notZeroStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
        notZeroStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeNumberNull")));
        ListBuffer<JCTree.JCIf> nullStmts = new ListBuffer<JCTree.JCIf>();
        JCTree.JCLiteral writeAsStringBinary = JavacTreeUtils.literal(JSONWriter.Feature.BrowserCompatible.mask | JSONWriter.Feature.WriteBooleanAsNumber.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask);
        nullStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, writeAsStringBinary), 0), JavacTreeUtils.block(notZeroStmts.toList())));
        ListBuffer<JCTree.JCExpressionStatement> notNullStmts = new ListBuffer<JCTree.JCExpressionStatement>();
        notNullStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), "writeFloat", (JCTree.JCExpression)mwc.jsonWriter, floatVar)));
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq(floatVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), (JCTree.JCStatement)JavacTreeUtils.block(nullStmts.toList()), (JCTree.JCStatement)JavacTreeUtils.block(notNullStmts.toList())));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteDouble(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        JCTree.JCVariableDecl doubleVar = JavacTreeUtils.defVar("double" + i, JavacTreeUtils.qualIdent(type), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(doubleVar);
        ListBuffer<JCTree.JCStatement> notZeroStmts = new ListBuffer<JCTree.JCStatement>();
        notZeroStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
        notZeroStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeNumberNull")));
        ListBuffer<JCTree.JCIf> nullStmts = new ListBuffer<JCTree.JCIf>();
        JCTree.JCLiteral writeAsStringBinary = JavacTreeUtils.literal(JSONWriter.Feature.BrowserCompatible.mask | JSONWriter.Feature.WriteBooleanAsNumber.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask);
        nullStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, writeAsStringBinary), 0), JavacTreeUtils.block(notZeroStmts.toList())));
        ListBuffer<JCTree.JCExpressionStatement> notNullStmts = new ListBuffer<JCTree.JCExpressionStatement>();
        notNullStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), "writeDouble", (JCTree.JCExpression)mwc.jsonWriter, doubleVar)));
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq(doubleVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), (JCTree.JCStatement)JavacTreeUtils.block(nullStmts.toList()), (JCTree.JCStatement)JavacTreeUtils.block(notNullStmts.toList())));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValueString(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        long writeNullFeatures = JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask;
        long writeNullAsEmptyFeatures = JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask;
        JCTree.JCIdent fieldValue = JavacTreeUtils.ident("string" + i);
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        stmts.append(JavacTreeUtils.defVar(fieldValue.name, JavacTreeUtils.qualIdent(attributeInfo.type.toString()), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType)));
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.notNull(fieldValue), (JCTree.JCStatement)JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeString", fieldValue))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.defIf(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, writeNullFeatures), 0L), JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.defIf(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, writeNullAsEmptyFeatures), 0L), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeString", ""))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(mwc.jsonWriterMethod("writeStringNull")))))))));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValueEnum(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        JCTree.JCVariableDecl enumVar = JavacTreeUtils.defVar("enum" + i, JavacTreeUtils.qualIdent(type), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(enumVar);
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne(enumVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), (JCTree.JCStatement)JavacTreeUtils.block(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), "writeEnum", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)JavacTreeUtils.ident(enumVar))), (JCTree.JCStatement)JavacTreeUtils.defIf(mwc.writeNulls, JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeNull"))))));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValueDate(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        JCTree.JCVariableDecl dateVar = JavacTreeUtils.defVar("date" + i, JavacTreeUtils.qualIdent(type), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(dateVar);
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne(dateVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), "writeDate", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)JavacTreeUtils.method(dateVar, "getTime")))), (JCTree.JCStatement)JavacTreeUtils.defIf(mwc.writeNulls, JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeNull"))))));
        return stmts;
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValueList(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        JCTree.JCVariableDecl listStrVar = JavacTreeUtils.defVar("listStr" + i, (JCTree.JCExpression)JavacTreeUtils.ident("String"), (JCTree.JCExpression)JavacTreeUtils.defNull());
        stmts.append(listStrVar);
        JCTree.JCVariableDecl listVar = JavacTreeUtils.defVar("list" + i, JavacTreeUtils.qualIdent("java.util.List"), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
        stmts.append(listVar);
        JCTree.JCLabeledStatement label = JavacTreeUtils.label("listLabel" + i);
        ListBuffer<JCTree.JCLabeledStatement> notNullStmts = new ListBuffer<JCTree.JCLabeledStatement>();
        ListBuffer<JCTree.JCIf> labelStmts = new ListBuffer<JCTree.JCIf>();
        ListBuffer<JCTree.JCStatement> notZeroStmts = new ListBuffer<JCTree.JCStatement>();
        notZeroStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq((JCTree.JCExpression)mwc.object, listVar), JavacTreeUtils.block(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeReference", "..")), JavacTreeUtils.defBreak(label))));
        notZeroStmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(listStrVar, mwc.jsonWriterMethod("setPath", (JCTree.JCExpression)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), CodeGenUtils.fieldWriter(i)), listVar))));
        notZeroStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne(listStrVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), JavacTreeUtils.block(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeReference", listStrVar)), JavacTreeUtils.exec(mwc.jsonWriterMethod("popPath", listVar)), JavacTreeUtils.defBreak(label))));
        labelStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.ReferenceDetection.mask), 0L), JavacTreeUtils.block(notZeroStmts.toList())));
        JCTree.JCBinary binary = JavacTreeUtils.eq((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.NotWriteEmptyArray), 0L);
        JCTree.JCUnary unary = JavacTreeUtils.unary(JCTree.Tag.NOT, JavacTreeUtils.method(listVar, "isEmpty"));
        ListBuffer<JCTree.JCStatement> notEmptyStmts = new ListBuffer<JCTree.JCStatement>();
        notEmptyStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
        String type = attributeInfo.type.toString();
        if ("java.util.List<java.lang.String>".equals(type)) {
            notEmptyStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeString", listVar)));
        } else {
            notEmptyStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), "writeListValue", (JCTree.JCExpression)mwc.jsonWriter, listVar)));
        }
        notEmptyStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("popPath", listVar)));
        labelStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.or(binary, unary), JavacTreeUtils.block(notEmptyStmts.toList())));
        JCTree.JCLiteral writeAsStringBinary = JavacTreeUtils.literal(JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask);
        JCTree.JCIf notNUllIf = JavacTreeUtils.defIf(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, writeAsStringBinary), 0L), JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeArrayNull"))));
        label.body = JavacTreeUtils.block(labelStmts.toList());
        notNullStmts.append(label);
        stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne(listVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), (JCTree.JCStatement)JavacTreeUtils.block(notNullStmts.toList()), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)notNUllIf)));
        return stmts;
    }

    private JCTree.JCExpression genWriteFieldValue(AttributeInfo attributeInfo, JCTree.JCIdent objectIdent, JCTree.JCExpression beanType) {
        String fieldName;
        Name symbolName;
        if (attributeInfo.getMethod != null) {
            return JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.cast(beanType, (JCTree.JCExpression)objectIdent), attributeInfo.getMethod.getSimpleName().toString());
        }
        String name = attributeInfo.name;
        VariableElement field = attributeInfo.field;
        if (field instanceof Symbol.VarSymbol && (symbolName = ((Symbol.VarSymbol)field).name) != null && !name.equals(fieldName = ((Object)symbolName).toString())) {
            name = fieldName;
        }
        return JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.cast(beanType, (JCTree.JCExpression)objectIdent), name);
    }

    private ListBuffer<JCTree.JCStatement> genWriteFieldValueObject(MethodWriterContext mwc, AttributeInfo attributeInfo, int i) {
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        if (type.contains("[")) {
            JCTree.JCVariableDecl objectStrVar = JavacTreeUtils.defVar("objectStr" + i, (JCTree.JCExpression)JavacTreeUtils.ident("String"), (JCTree.JCExpression)JavacTreeUtils.defNull());
            stmts.append(objectStrVar);
            JCTree.JCVariableDecl objectIntVar = JavacTreeUtils.defVar("objectInt" + i, 0);
            stmts.append(objectIntVar);
            JCTree.JCLabeledStatement outerLabel = JavacTreeUtils.label("objectOuterLabel" + i);
            ListBuffer<JCTree.JCStatement> outerLabelStmts = new ListBuffer<JCTree.JCStatement>();
            String elemType = ((ArrayType)attributeInfo.type).getComponentType().toString();
            JCTree.JCVariableDecl objectVar = JavacTreeUtils.defVar("object" + i, JavacTreeUtils.arrayIdentType(elemType), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
            outerLabelStmts.append(objectVar);
            JCTree.JCLabeledStatement innerLabel = JavacTreeUtils.label("objectInnerLabel" + i);
            ListBuffer<JCTree.JCStatement> innerLabelStmts = new ListBuffer<JCTree.JCStatement>();
            ListBuffer<JCTree.JCStatement> notNullStmts = new ListBuffer<JCTree.JCStatement>();
            JCTree.JCVariableDecl objectLongVar = JavacTreeUtils.defVar("objectLong" + i, TypeTag.LONG, (JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.ReferenceDetection.mask));
            notNullStmts.append(objectLongVar);
            notNullStmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(objectIntVar, (JCTree.JCExpression)JavacTreeUtils.ternary((JCTree.JCExpression)JavacTreeUtils.eq(objectLongVar, 0), (JCTree.JCExpression)JavacTreeUtils.literal(0), (JCTree.JCExpression)JavacTreeUtils.ternary((JCTree.JCExpression)JavacTreeUtils.lt(objectLongVar, 0), -1, 1)))));
            notNullStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq(objectIntVar, 0), JavacTreeUtils.defBreak(innerLabel)));
            ListBuffer<JCTree.JCStatement> eqStmts = new ListBuffer<JCTree.JCStatement>();
            eqStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
            eqStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeReference", JavacTreeUtils.literal(".."))));
            eqStmts.append(JavacTreeUtils.defBreak(outerLabel));
            notNullStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq((JCTree.JCExpression)mwc.object, objectVar), JavacTreeUtils.block(eqStmts.toList())));
            notNullStmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(objectStrVar, (JCTree.JCExpression)JavacTreeUtils.method(mwc.jsonWriter, "setPath", (JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), objectVar))));
            notNullStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq(objectStrVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.defBreak(innerLabel))));
            notNullStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
            notNullStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeReference", "..")));
            innerLabelStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.ident(objectVar), (JCTree.JCExpression)JavacTreeUtils.defNull()), JavacTreeUtils.block(notNullStmts.toList())));
            ListBuffer<JCTree.JCStatement> notZeroStmts = new ListBuffer<JCTree.JCStatement>();
            notZeroStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
            notZeroStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeArrayNull")));
            JCTree.JCLiteral writeAsStringBinary = JavacTreeUtils.literal(JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask);
            innerLabelStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, writeAsStringBinary), 0), JavacTreeUtils.block(notZeroStmts.toList())));
            innerLabelStmts.append(JavacTreeUtils.defBreak(outerLabel));
            innerLabel.body = JavacTreeUtils.block(innerLabelStmts.toList());
            outerLabelStmts.append(innerLabel);
            ListBuffer<JCTree.JCStatement> notEmptyArrayStmts = new ListBuffer<JCTree.JCStatement>();
            notEmptyArrayStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
            notEmptyArrayStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), "getObjectWriter", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)JavacTreeUtils.field(JavacTreeUtils.arrayIdentType(type), this.names._class)), "write", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)JavacTreeUtils.ident(objectVar), (JCTree.JCExpression)JavacTreeUtils.literal(attributeInfo), JavacTreeUtils.method(objectVar, "getClass"), JavacTreeUtils.literal(0L))));
            notEmptyArrayStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne(objectIntVar, 0), JavacTreeUtils.exec(mwc.jsonWriterMethod("popPath", objectVar))));
            JCTree.JCBinary binary1 = JavacTreeUtils.eq((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.NotWriteEmptyArray.mask), 0);
            JCTree.JCBinary binary2 = JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.field(objectVar, "length"), 0);
            outerLabelStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.and(binary1, binary2), JavacTreeUtils.block(notEmptyArrayStmts.toList())));
            outerLabel.body = JavacTreeUtils.block(outerLabelStmts.toList());
            stmts.append(outerLabel);
        } else if (type.contains("java.util.Map<")) {
            JCTree.JCLabeledStatement outerLabel = JavacTreeUtils.label("objectOuterLabel" + i);
            ListBuffer<JCTree.JCStatement> outerLabelStmts = new ListBuffer<JCTree.JCStatement>();
            JCTree.JCVariableDecl objectStrVar = JavacTreeUtils.defVar("objectStr" + i, (JCTree.JCExpression)JavacTreeUtils.ident("String"), (JCTree.JCExpression)JavacTreeUtils.defNull());
            outerLabelStmts.append(objectStrVar);
            JCTree.JCVariableDecl objectVar = JavacTreeUtils.defVar("object" + i, this.getFieldValueType(type), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
            outerLabelStmts.append(objectVar);
            JCTree.JCVariableDecl objectIntVar = JavacTreeUtils.defVar("objectInt" + i, TypeTag.INT, (JCTree.JCExpression)JavacTreeUtils.literal(0));
            outerLabelStmts.append(objectIntVar);
            JCTree.JCLabeledStatement innerLabel = JavacTreeUtils.label("objectInnerLabel" + i);
            ListBuffer<JCTree.JCStatement> notNullStmts = new ListBuffer<JCTree.JCStatement>();
            notNullStmts.append(JavacTreeUtils.defIf(mwc.jsonWriterMethod("isIgnoreNoneSerializable", objectVar), JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.defBreak(outerLabel))));
            JCTree.JCVariableDecl objectLongVar = JavacTreeUtils.defVar("objectLong" + i, TypeTag.LONG, (JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.ReferenceDetection.mask));
            notNullStmts.append(objectLongVar);
            notNullStmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(objectIntVar, (JCTree.JCExpression)JavacTreeUtils.ternary((JCTree.JCExpression)JavacTreeUtils.eq(objectLongVar, 0), (JCTree.JCExpression)JavacTreeUtils.literal(0), (JCTree.JCExpression)JavacTreeUtils.ternary((JCTree.JCExpression)JavacTreeUtils.lt(objectLongVar, 0), -1, 1)))));
            notNullStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq(objectIntVar, 0), JavacTreeUtils.defBreak(innerLabel)));
            notNullStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq((JCTree.JCExpression)mwc.object, objectVar), (JCTree.JCStatement)JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeReference", JavacTreeUtils.literal(".."))), JavacTreeUtils.defBreak(outerLabel)), null));
            notNullStmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(objectStrVar, mwc.jsonWriterMethod("setPath", (JCTree.JCExpression)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), CodeGenUtils.fieldWriter(i)), JavacTreeUtils.ident(objectVar)))));
            notNullStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq(objectStrVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), JavacTreeUtils.defBreak(innerLabel)));
            notNullStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
            notNullStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeReference", objectStrVar)));
            notNullStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("popPath", objectVar)));
            ListBuffer<JCTree.JCStatement> innerLabelStmts = new ListBuffer<JCTree.JCStatement>();
            innerLabelStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.ident(objectVar), (JCTree.JCExpression)JavacTreeUtils.defNull()), JavacTreeUtils.block(notNullStmts.toList())));
            JCTree.JCBinary binary = JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.WriteMapNullValue.mask), 0);
            innerLabelStmts.append(JavacTreeUtils.defIf(binary, JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeNull")))));
            innerLabelStmts.append(JavacTreeUtils.defBreak(outerLabel));
            innerLabel.body = JavacTreeUtils.block(innerLabelStmts.toList());
            outerLabelStmts.append(innerLabel);
            outerLabelStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
            outerLabelStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), "getObjectWriter", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)JavacTreeUtils.method(objectVar, "getClass")), "write", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)JavacTreeUtils.ident(objectVar), (JCTree.JCExpression)JavacTreeUtils.literal(attributeInfo.name), JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), "fieldType"), JavacTreeUtils.literal(0L))));
            outerLabelStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne(objectIntVar, 0), JavacTreeUtils.exec(mwc.jsonWriterMethod("popPath", objectVar))));
            outerLabel.body = JavacTreeUtils.block(outerLabelStmts.toList());
            stmts.append(outerLabel);
        } else {
            List<com.sun.tools.javac.code.Type> interfacesField;
            String WRITE_NULL_METHOD = "AtomicLongArray".equals(type) || "AtomicIntegerArray".equals(type) || "Collection.class.isAssignableFrom".equals(type) || "isArray".equals(type) ? "writeArrayNull" : ("java.lang.Number".equals(type) ? "writeNumberNull" : ("Boolean".equals(type) ? "writeBooleanNull" : ("String".equals(type) || "Appendable".equals(type) || "StringBuffer".equals(type) || "StringBuilder".equals(type) ? "writeStringNull" : "writeNull")));
            JCTree.JCLabeledStatement outerLabel = JavacTreeUtils.label("objectOuterLabel" + i);
            ListBuffer<JCTree.JCStatement> outerLabelStmts = new ListBuffer<JCTree.JCStatement>();
            JCTree.JCVariableDecl objectStrVar = JavacTreeUtils.defVar("objectStr" + i, (JCTree.JCExpression)JavacTreeUtils.ident("String"), (JCTree.JCExpression)JavacTreeUtils.defNull());
            outerLabelStmts.append(objectStrVar);
            JCTree.JCVariableDecl objectVar = JavacTreeUtils.defVar("object" + i, this.getFieldValueType(type), this.genWriteFieldValue(attributeInfo, mwc.object, mwc.beanType));
            outerLabelStmts.append(objectVar);
            JCTree.JCVariableDecl objectIntVar = JavacTreeUtils.defVar("objectInt" + i, TypeTag.INT, (JCTree.JCExpression)JavacTreeUtils.literal(0));
            outerLabelStmts.append(objectIntVar);
            JCTree.JCLabeledStatement innerLabel = JavacTreeUtils.label("objectInnerLabel" + i);
            ListBuffer<JCTree.JCStatement> notNullStmts = new ListBuffer<JCTree.JCStatement>();
            boolean noneSerializable = false;
            if (attributeInfo.type instanceof Type.ClassType && ((interfacesField = ((Type.ClassType)attributeInfo.type).interfaces_field) == null || interfacesField.stream().noneMatch(f -> "java.io.Serializable".equals(f.toString())))) {
                noneSerializable = true;
            }
            if (noneSerializable) {
                notNullStmts.append(JavacTreeUtils.defIf(mwc.jsonWriterMethod("isIgnoreNoneSerializable", objectVar), JavacTreeUtils.defBreak(outerLabel)));
            }
            JCTree.JCVariableDecl objectLongVar = JavacTreeUtils.defVar("objectLong" + i, TypeTag.LONG, (JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.ReferenceDetection.mask));
            notNullStmts.append(objectLongVar);
            notNullStmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(objectIntVar, (JCTree.JCExpression)JavacTreeUtils.ternary((JCTree.JCExpression)JavacTreeUtils.eq(objectLongVar, 0), (JCTree.JCExpression)JavacTreeUtils.literal(0), (JCTree.JCExpression)JavacTreeUtils.ternary((JCTree.JCExpression)JavacTreeUtils.lt(objectLongVar, 0), -1, 1)))));
            notNullStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq(objectIntVar, 0), JavacTreeUtils.defBreak(innerLabel)));
            notNullStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq((JCTree.JCExpression)mwc.object, (JCTree.JCExpression)JavacTreeUtils.ident(objectVar)), JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod("writeReference", "..")), JavacTreeUtils.defBreak(outerLabel))));
            notNullStmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(objectStrVar, (JCTree.JCExpression)JavacTreeUtils.method(mwc.jsonWriter, "setPath", (JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), objectVar))));
            notNullStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq(objectStrVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), JavacTreeUtils.defBreak(innerLabel)));
            notNullStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
            notNullStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("writeReference", objectStrVar)));
            notNullStmts.append(JavacTreeUtils.exec(mwc.jsonWriterMethod("popPath", objectVar)));
            ListBuffer<JCTree.JCStatement> innerLabelStmts = new ListBuffer<JCTree.JCStatement>();
            innerLabelStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne(objectVar, (JCTree.JCExpression)JavacTreeUtils.defNull()), JavacTreeUtils.block(notNullStmts.toList())));
            JCTree.JCBinary binary = JavacTreeUtils.ne((JCTree.JCExpression)JavacTreeUtils.bitAnd((JCTree.JCExpression)mwc.contextFeatures, JSONWriter.Feature.WriteMapNullValue.mask), 0);
            innerLabelStmts.append(JavacTreeUtils.defIf(binary, (JCTree.JCStatement)JavacTreeUtils.block(this.genWriteFieldName(mwc, attributeInfo, i), JavacTreeUtils.exec(mwc.jsonWriterMethod(WRITE_NULL_METHOD))), null));
            innerLabelStmts.append(JavacTreeUtils.defBreak(outerLabel));
            innerLabel.body = JavacTreeUtils.block(innerLabelStmts.toList());
            outerLabelStmts.append(innerLabel);
            outerLabelStmts.append(this.genWriteFieldName(mwc, attributeInfo, i));
            outerLabelStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.method((JCTree.JCExpression)JavacTreeUtils.field(this.names._this, CodeGenUtils.fieldWriter(i)), "getObjectWriter", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)JavacTreeUtils.method(objectVar, "getClass")), "write", (JCTree.JCExpression)mwc.jsonWriter, (JCTree.JCExpression)JavacTreeUtils.ident(objectVar), (JCTree.JCExpression)JavacTreeUtils.literal(attributeInfo.name), JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), CodeGenUtils.fieldWriter(i)), "fieldType"), JavacTreeUtils.literal(0L))));
            outerLabelStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.ne(objectIntVar, 0), JavacTreeUtils.exec(mwc.jsonWriterMethod("popPath", objectVar))));
            outerLabel.body = JavacTreeUtils.block(outerLabelStmts.toList());
            stmts.append(outerLabel);
        }
        return stmts;
    }

    private JCTree.JCVariableDecl getHashCode32Var(JCTree.JCExpression hashCode64) {
        JCTree.JCBinary usrBinary = JavacTreeUtils.binary(JCTree.Tag.USR, hashCode64, JavacTreeUtils.literal(32));
        JCTree.JCPrimitiveTypeTree intType = JavacTreeUtils.type(TypeTag.INT);
        JCTree.JCTypeCast hashCode32Cast = JavacTreeUtils.cast(intType, (JCTree.JCExpression)JavacTreeUtils.bitXor(hashCode64, JavacTreeUtils.parens(usrBinary)));
        return JavacTreeUtils.defVar("hashCode32", (JCTree.JCExpression)intType, (JCTree.JCExpression)hashCode32Cast);
    }

    private List<JCTree.JCStatement> genReadFieldValue(AttributeInfo attributeInfo, JCTree.JCIdent jsonReaderIdent, int i, StructInfo structInfo, JCTree.JCLabeledStatement loopLabel, JCTree.JCIdent objectIdent, JCTree.JCExpression beanType, boolean isJsonb) {
        String readDirectMethod;
        JCTree.JCExpression valueExpr = null;
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        boolean referenceDetect = structInfo.referenceDetect;
        if (referenceDetect) {
            referenceDetect = CodeGenUtils.isReference(type);
        }
        JCTree.JCFieldAccess fieldReaderField = JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), CodeGenUtils.fieldReader(i));
        if (referenceDetect) {
            ListBuffer<JCTree.JCStatement> thenStmts = new ListBuffer<JCTree.JCStatement>();
            JCTree.JCMethodInvocation readReferenceMethod = JavacTreeUtils.method(jsonReaderIdent, "readReference");
            JCTree.JCVariableDecl refVar = JavacTreeUtils.defVar("ref", (JCTree.JCExpression)JavacTreeUtils.ident("String"), (JCTree.JCExpression)readReferenceMethod);
            thenStmts.append(refVar);
            JCTree.JCMethodInvocation addResolveTaskMethod = JavacTreeUtils.method(fieldReaderField, "addResolveTask", (JCTree.JCExpression)jsonReaderIdent, (JCTree.JCExpression)objectIdent, (JCTree.JCExpression)JavacTreeUtils.ident(refVar));
            thenStmts.append(JavacTreeUtils.exec(addResolveTaskMethod));
            thenStmts.append(JavacTreeUtils.defContinue(loopLabel));
            stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.method(jsonReaderIdent, "isReference"), JavacTreeUtils.block(thenStmts.toList())));
        }
        if ((readDirectMethod = CodeGenUtils.getReadDirectMethod(type)) != null) {
            valueExpr = JavacTreeUtils.method(jsonReaderIdent, readDirectMethod);
        } else {
            JCTree.JCExpression fieldValueType = this.getFieldValueType(type);
            JCTree.JCVariableDecl fieldValueVar = JavacTreeUtils.defVar(attributeInfo.name, fieldValueType);
            stmts.append(fieldValueVar);
            if (type.startsWith("java.util.List<")) {
                valueExpr = this.genFieldValueList(type, attributeInfo, jsonReaderIdent, fieldValueVar, loopLabel, stmts, i, referenceDetect, fieldReaderField, beanType, isJsonb);
            } else if (type.startsWith("java.util.Map<java.lang.String,")) {
                valueExpr = this.genFieldValueMap(type, attributeInfo, jsonReaderIdent, fieldValueVar, loopLabel, stmts, i, referenceDetect, isJsonb);
            }
            if (valueExpr == null) {
                JCTree.JCIdent objectReaderIdent = JavacTreeUtils.ident(CodeGenUtils.fieldObjectReader(i));
                JCTree.JCMethodInvocation getObjectReaderMethod = JavacTreeUtils.method((JCTree.JCExpression)fieldReaderField, "getObjectReader", (JCTree.JCExpression)jsonReaderIdent);
                JCTree.JCAssign objectReaderAssign = JavacTreeUtils.assign(objectReaderIdent, (JCTree.JCExpression)getObjectReaderMethod);
                stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq((JCTree.JCExpression)objectReaderIdent, (JCTree.JCExpression)JavacTreeUtils.defNull()), JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(objectReaderAssign))));
                JCTree.JCMethodInvocation objectMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), CodeGenUtils.fieldObjectReader(i)), isJsonb ? "readJSONBObject" : "readObject", (JCTree.JCExpression)jsonReaderIdent, (JCTree.JCExpression)JavacTreeUtils.field((JCTree.JCExpression)fieldReaderField, "fieldType"), (JCTree.JCExpression)JavacTreeUtils.literal(attributeInfo.name), JavacTreeUtils.literal(0L));
                stmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(fieldValueVar, (JCTree.JCExpression)JavacTreeUtils.cast(fieldValueType, (JCTree.JCExpression)objectMethod))));
                valueExpr = JavacTreeUtils.ident(fieldValueVar);
            }
        }
        if (attributeInfo.setMethod != null) {
            stmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(objectIdent, attributeInfo.setMethod.getSimpleName().toString(), valueExpr)));
        } else if (attributeInfo.field != null) {
            stmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(JavacTreeUtils.field((JCTree.JCExpression)objectIdent, attributeInfo.field.getSimpleName().toString()), valueExpr)));
        } else {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "not implemented yet");
        }
        stmts.append(JavacTreeUtils.defContinue(loopLabel));
        return stmts.toList();
    }

    private List<JCTree.JCStatement> genRead243(java.util.List<AttributeInfo> attributeInfos, JCTree.JCIdent jsonReaderIdent, StructInfo structInfo, JCTree.JCLabeledStatement loopLabel, JCTree.JCIdent objectIdent, JCTree.JCExpression beanType, boolean isJsonb) {
        IdentityHashMap<AttributeInfo, Integer> readerIndexMap = new IdentityHashMap<AttributeInfo, Integer>();
        TreeMap<Integer, ArrayList<AttributeInfo>> name0Map = new TreeMap<Integer, ArrayList<AttributeInfo>>();
        for (int i = 0; i < attributeInfos.size(); ++i) {
            AttributeInfo field = attributeInfos.get(i);
            readerIndexMap.put(field, i);
            byte[] fieldName = field.name.getBytes(StandardCharsets.UTF_8);
            byte[] name0Bytes = new byte[4];
            name0Bytes[0] = 34;
            if (fieldName.length == 2) {
                System.arraycopy(fieldName, 0, name0Bytes, 1, 2);
                name0Bytes[3] = 34;
            } else {
                System.arraycopy(fieldName, 0, name0Bytes, 1, 3);
            }
            int name0 = JDKUtils.UNSAFE.getInt(name0Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
            ArrayList<AttributeInfo> fieldReaders = (ArrayList<AttributeInfo>)name0Map.get(name0);
            if (fieldReaders == null) {
                fieldReaders = new ArrayList<AttributeInfo>();
                name0Map.put(name0, fieldReaders);
            }
            fieldReaders.add(field);
        }
        int[] switchKeys = new int[name0Map.size()];
        Label[] labels = new Label[name0Map.size()];
        Iterator it = name0Map.keySet().iterator();
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = new Label();
            switchKeys[i] = (Integer)it.next();
        }
        List<JCTree.JCStatement> stmts = List.nil();
        ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
        JCTree.JCLabeledStatement switchLabel = JavacTreeUtils.label("_switch2");
        for (int i = 0; i < labels.length; ++i) {
            int name0 = switchKeys[i];
            java.util.List fieldReaders = (java.util.List)name0Map.get(name0);
            ListBuffer<JCTree.JCStatement> caseStmts = new ListBuffer<JCTree.JCStatement>();
            for (int j = 0; j < fieldReaders.size(); ++j) {
                JCTree.JCMethodInvocation nextIfMethod;
                AttributeInfo fieldReader = (AttributeInfo)fieldReaders.get(j);
                int fieldReaderIndex = (Integer)readerIndexMap.get(fieldReader);
                byte[] fieldName = fieldReader.name.getBytes(StandardCharsets.UTF_8);
                int fieldNameLength = fieldName.length;
                switch (fieldNameLength) {
                    case 2: {
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match2");
                        break;
                    }
                    case 3: {
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match3");
                        break;
                    }
                    case 4: {
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match4", JavacTreeUtils.literal(fieldName[3]));
                        break;
                    }
                    case 5: {
                        byte[] bytes4 = new byte[]{fieldName[3], fieldName[4], 34, 58};
                        int name1 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match5", (JCTree.JCExpression)JavacTreeUtils.literal(name1));
                        break;
                    }
                    case 6: {
                        byte[] bytes4 = new byte[]{fieldName[3], fieldName[4], fieldName[5], 34};
                        int name1 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match6", (JCTree.JCExpression)JavacTreeUtils.literal(name1));
                        break;
                    }
                    case 7: {
                        int name1 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match7", (JCTree.JCExpression)JavacTreeUtils.literal(name1));
                        break;
                    }
                    case 8: {
                        int name1 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match8", (JCTree.JCExpression)JavacTreeUtils.literal(name1), JavacTreeUtils.literal(fieldName[7]));
                        break;
                    }
                    case 9: {
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 3, bytes8, 0, 6);
                        bytes8[6] = 34;
                        bytes8[7] = 58;
                        long name1 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match9", (JCTree.JCExpression)JavacTreeUtils.literal(name1));
                        break;
                    }
                    case 10: {
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 3, bytes8, 0, 7);
                        bytes8[7] = 34;
                        long name1 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match10", (JCTree.JCExpression)JavacTreeUtils.literal(name1));
                        break;
                    }
                    case 11: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match11", (JCTree.JCExpression)JavacTreeUtils.literal(name1));
                        break;
                    }
                    case 12: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match12", (JCTree.JCExpression)JavacTreeUtils.literal(name1), JavacTreeUtils.literal(fieldName[11]));
                        break;
                    }
                    case 13: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        byte[] bytes4 = new byte[]{fieldName[11], fieldName[12], 34, 58};
                        int name2 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match13", (JCTree.JCExpression)JavacTreeUtils.literal(name1), (JCTree.JCExpression)JavacTreeUtils.literal(name2));
                        break;
                    }
                    case 14: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        byte[] bytes4 = new byte[]{fieldName[11], fieldName[12], fieldName[13], 34};
                        int name2 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match14", name1, name2);
                        break;
                    }
                    case 15: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        int name2 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match15", name1, name2);
                        break;
                    }
                    case 16: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        int name2 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match16", name1, name2, fieldName[15]);
                        break;
                    }
                    case 17: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 11, bytes8, 0, 6);
                        bytes8[6] = 34;
                        bytes8[7] = 58;
                        long name2 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match17", name1, name2);
                        break;
                    }
                    case 18: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 11, bytes8, 0, 7);
                        bytes8[7] = 34;
                        long name2 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match18", name1, name2);
                        break;
                    }
                    case 19: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match19", name1, name2);
                        break;
                    }
                    case 20: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match20", name1, name2, fieldName[19]);
                        break;
                    }
                    case 21: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        byte[] bytes4 = new byte[]{fieldName[19], fieldName[20], 34, 58};
                        int name3 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match21", name1, name2, name3);
                        break;
                    }
                    case 22: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        byte[] bytes4 = new byte[]{fieldName[19], fieldName[20], fieldName[21], 34};
                        int name3 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match22", name1, name2, name3);
                        break;
                    }
                    case 23: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        int name3 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match23", name1, name2, name3);
                        break;
                    }
                    case 24: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        int name3 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match24", name1, name2, name3, fieldName[23]);
                        break;
                    }
                    case 25: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 19, bytes8, 0, 6);
                        bytes8[6] = 34;
                        bytes8[7] = 58;
                        long name3 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match25", name1, name2, name3);
                        break;
                    }
                    case 26: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 19, bytes8, 0, 7);
                        bytes8[7] = 34;
                        long name3 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match26", name1, name2, name3);
                        break;
                    }
                    case 27: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match27", name1, name2, name3);
                        break;
                    }
                    case 28: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match28", name1, name2, name3, fieldName[27]);
                        break;
                    }
                    case 29: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        byte[] bytes4 = new byte[]{fieldName[27], fieldName[28], 34, 58};
                        int name4 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match29", name1, name2, name3, name4);
                        break;
                    }
                    case 30: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        byte[] bytes4 = new byte[]{fieldName[27], fieldName[28], fieldName[29], 34};
                        int name4 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match30", name1, name2, name3, name4);
                        break;
                    }
                    case 31: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        int name4 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match31", name1, name2, name3, name4);
                        break;
                    }
                    case 32: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        int name4 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match32", name1, name2, name3, name4, fieldName[31]);
                        break;
                    }
                    case 33: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 27, bytes8, 0, 6);
                        bytes8[6] = 34;
                        bytes8[7] = 58;
                        long name4 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match33", name1, name2, name3, name4);
                        break;
                    }
                    case 34: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 27, bytes8, 0, 7);
                        bytes8[7] = 34;
                        long name4 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match34", name1, name2, name3, name4);
                        break;
                    }
                    case 35: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match35", name1, name2, name3, name4);
                        break;
                    }
                    case 36: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match36", name1, name2, name3, name4, fieldName[35]);
                        break;
                    }
                    case 37: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        byte[] bytes4 = new byte[]{fieldName[35], fieldName[36], 34, 58};
                        int name5 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match37", name1, name2, name3, name4, name5);
                        break;
                    }
                    case 38: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        byte[] bytes4 = new byte[]{fieldName[35], fieldName[36], fieldName[37], 34};
                        int name5 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match38", name1, name2, name3, name4, name5);
                        break;
                    }
                    case 39: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        int name5 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 35L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match39", name1, name2, name3, name4, name5);
                        break;
                    }
                    case 40: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        int name5 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 35L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match40", name1, name2, name3, name4, name5, fieldName[39]);
                        break;
                    }
                    case 41: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 35, bytes8, 0, 6);
                        bytes8[6] = 34;
                        bytes8[7] = 58;
                        long name5 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match41", name1, name2, name3, name4, name5);
                        break;
                    }
                    case 42: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 35, bytes8, 0, 7);
                        bytes8[7] = 34;
                        long name5 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match42", name1, name2, name3, name4, name5);
                        break;
                    }
                    case 43: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        long name5 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 35L);
                        nextIfMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfName4Match43", name1, name2, name3, name4, name5);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("fieldNameLength " + fieldNameLength);
                    }
                }
                List<JCTree.JCStatement> readFieldValueStmts = this.genReadFieldValue(fieldReader, jsonReaderIdent, fieldReaderIndex, structInfo, loopLabel, objectIdent, beanType, isJsonb);
                caseStmts.append(JavacTreeUtils.defIf(nextIfMethod, JavacTreeUtils.block(readFieldValueStmts)));
            }
            caseStmts.append(JavacTreeUtils.defBreak(switchLabel));
            cases.append(JavacTreeUtils.defCase(JavacTreeUtils.literal(name0), caseStmts.toList()));
        }
        switchLabel.body = JavacTreeUtils.defSwitch(JavacTreeUtils.method(jsonReaderIdent, "getRawInt"), cases.toList());
        stmts = stmts.append(switchLabel);
        return stmts;
    }

    private JCTree.JCExpression genFieldValueList(String type, AttributeInfo attributeInfo, JCTree.JCIdent jsonReaderIdent, JCTree.JCVariableDecl fieldValueVar, JCTree.JCLabeledStatement loopLabel, ListBuffer<JCTree.JCStatement> stmts, int i, boolean referenceDetect, JCTree.JCFieldAccess fieldReaderField, JCTree.JCExpression beanType, boolean isJsonb) {
        boolean itemTypeIsClass;
        String itemType = type.substring(15, type.length() - 1);
        boolean bl = itemTypeIsClass = itemType.indexOf(60) == -1;
        if (itemTypeIsClass) {
            JCTree.JCMethodInvocation nextIfNullMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfNull");
            stmts.append(JavacTreeUtils.defIf(nextIfNullMethod, (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(JavacTreeUtils.assign(fieldValueVar, (JCTree.JCExpression)JavacTreeUtils.defNull()))), (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(JavacTreeUtils.assign(fieldValueVar, (JCTree.JCExpression)JavacTreeUtils.newClass(null, null, JavacTreeUtils.qualIdent("java.util.ArrayList"), null, null))))));
            String readDirectMethod = CodeGenUtils.getReadDirectMethod(itemType);
            JCTree.JCIdent itemReaderIdent = JavacTreeUtils.ident(CodeGenUtils.fieldItemObjectReader(i));
            if (readDirectMethod == null) {
                JCTree.JCFieldAccess getItemObjectReaderField = JavacTreeUtils.field((JCTree.JCExpression)fieldReaderField, "getItemObjectReader");
                JCTree.JCExpressionStatement getItemObjectReaderExec = JavacTreeUtils.exec(JavacTreeUtils.assign(itemReaderIdent, (JCTree.JCExpression)JavacTreeUtils.method((JCTree.JCExpression)getItemObjectReaderField, jsonReaderIdent)));
                stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq((JCTree.JCExpression)itemReaderIdent, (JCTree.JCExpression)JavacTreeUtils.defNull()), JavacTreeUtils.block((JCTree.JCStatement)getItemObjectReaderExec)));
            }
            if (referenceDetect) {
                referenceDetect = CodeGenUtils.isReference(itemType);
            }
            JCTree.JCVariableDecl for_iVar = "i".equals(attributeInfo.name) ? JavacTreeUtils.defVar("j", TypeTag.INT, (JCTree.JCExpression)JavacTreeUtils.literal(0)) : JavacTreeUtils.defVar("i", TypeTag.INT, (JCTree.JCExpression)JavacTreeUtils.literal(0));
            JCTree.JCMethodInvocation nextIfArrayStartMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfArrayStart");
            JCTree.JCMethodInvocation nextIfArrayEndMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfArrayEnd");
            ListBuffer<JCTree.JCStatement> whileStmts = new ListBuffer<JCTree.JCStatement>();
            JCTree.JCExpression item = readDirectMethod != null ? JavacTreeUtils.method(jsonReaderIdent, readDirectMethod) : JavacTreeUtils.cast(JavacTreeUtils.qualIdent(itemType), (JCTree.JCExpression)JavacTreeUtils.method((JCTree.JCExpression)itemReaderIdent, isJsonb ? "readJSONBObject" : "readObject", (JCTree.JCExpression)jsonReaderIdent, (JCTree.JCExpression)JavacTreeUtils.defNull(), (JCTree.JCExpression)JavacTreeUtils.defNull(), JavacTreeUtils.literal(0L)));
            if (referenceDetect) {
                JCTree.JCVariableDecl listItemVar = JavacTreeUtils.defVar(attributeInfo.name + "_item", this.getFieldValueType(itemType), item);
                ListBuffer<JCTree.JCStatement> isReferenceStmts = new ListBuffer<JCTree.JCStatement>();
                JCTree.JCMethodInvocation readReferenceMethod = JavacTreeUtils.method(jsonReaderIdent, "readReference");
                JCTree.JCVariableDecl refVar = JavacTreeUtils.defVar("ref", (JCTree.JCExpression)JavacTreeUtils.ident("String"), (JCTree.JCExpression)readReferenceMethod);
                isReferenceStmts.append(refVar);
                JCTree.JCMethodInvocation addResolveTaskMethod = JavacTreeUtils.method(jsonReaderIdent, "addResolveTask", (JCTree.JCExpression)JavacTreeUtils.ident(fieldValueVar), (JCTree.JCExpression)JavacTreeUtils.ident(for_iVar), (JCTree.JCExpression)JavacTreeUtils.method(JavacTreeUtils.qualIdent("com.alibaba.fastjson2.JSONPath"), "of", (JCTree.JCExpression)JavacTreeUtils.ident(refVar)));
                isReferenceStmts.append(JavacTreeUtils.exec(addResolveTaskMethod));
                isReferenceStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(fieldValueVar, "add", (JCTree.JCExpression)JavacTreeUtils.defNull())));
                isReferenceStmts.append(JavacTreeUtils.defContinue(loopLabel));
                whileStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.method(jsonReaderIdent, "isReference"), JavacTreeUtils.block(isReferenceStmts.toList())));
                whileStmts.append(listItemVar);
                item = JavacTreeUtils.ident(listItemVar);
            }
            whileStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(fieldValueVar, "add", item)));
            ListBuffer<JCTree.JCStatement> condStmts = new ListBuffer<JCTree.JCStatement>();
            if (referenceDetect) {
                condStmts.append(JavacTreeUtils.forLoop(List.of(for_iVar), JavacTreeUtils.unary(JCTree.Tag.NOT, nextIfArrayEndMethod), List.of(JavacTreeUtils.exec(JavacTreeUtils.unary(JCTree.Tag.PREINC, JavacTreeUtils.ident(for_iVar)))), JavacTreeUtils.block(whileStmts.toList())));
            } else {
                condStmts.append(JavacTreeUtils.whileLoop(JavacTreeUtils.unary(JCTree.Tag.NOT, nextIfArrayEndMethod), JavacTreeUtils.block(whileStmts.toList())));
            }
            stmts.append(JavacTreeUtils.defIf(nextIfArrayStartMethod, JavacTreeUtils.block(condStmts.toList())));
            return JavacTreeUtils.ident(fieldValueVar.name);
        }
        return null;
    }

    private JCTree.JCExpression genFieldValueMap(String type, AttributeInfo attributeInfo, JCTree.JCIdent jsonReaderIdent, JCTree.JCVariableDecl fieldValueVar, JCTree.JCLabeledStatement loopLabel, ListBuffer<JCTree.JCStatement> stmts, int i, boolean referenceDetect, boolean isJsonb) {
        String itemType = type.substring(31, type.length() - 1);
        JCTree.JCMethodInvocation nextIfNullMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfNull");
        boolean readDirect = CodeGenUtils.supportReadDirect(itemType);
        ListBuffer<JCTree.JCStatement> elseStmts = new ListBuffer<JCTree.JCStatement>();
        JCTree.JCIdent itemReaderIdent = JavacTreeUtils.ident(CodeGenUtils.fieldItemObjectReader(i));
        if (!readDirect) {
            JCTree.JCFieldAccess getObjectReaderField = JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "getObjectReader");
            JCTree.JCExpressionStatement getItemObjectReaderExec = JavacTreeUtils.exec(JavacTreeUtils.assign(itemReaderIdent, (JCTree.JCExpression)JavacTreeUtils.method((JCTree.JCExpression)getObjectReaderField, JavacTreeUtils.field(JavacTreeUtils.qualIdent(itemType), this.names._class))));
            elseStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.eq((JCTree.JCExpression)itemReaderIdent, (JCTree.JCExpression)JavacTreeUtils.defNull()), JavacTreeUtils.block((JCTree.JCStatement)getItemObjectReaderExec)));
        }
        elseStmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(fieldValueVar, (JCTree.JCExpression)JavacTreeUtils.newClass(null, null, JavacTreeUtils.qualIdent("java.util.HashMap"), null, null))));
        JCTree.JCMethodInvocation nextIfObjectStartMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfObjectStart");
        elseStmts.append(JavacTreeUtils.exec(nextIfObjectStartMethod));
        JCTree.JCMethodInvocation nextIfObjectEndMethod = JavacTreeUtils.method(jsonReaderIdent, "nextIfObjectEnd");
        ListBuffer<JCTree.JCStatement> whileStmts = new ListBuffer<JCTree.JCStatement>();
        if (referenceDetect) {
            referenceDetect = CodeGenUtils.isReference(itemType);
        }
        JCTree.JCTypeCast mapEntryValueExpr = readDirect ? JavacTreeUtils.cast(JavacTreeUtils.qualIdent(itemType), (JCTree.JCExpression)JavacTreeUtils.method(jsonReaderIdent, CodeGenUtils.getReadDirectMethod(itemType))) : JavacTreeUtils.cast(JavacTreeUtils.qualIdent(itemType), (JCTree.JCExpression)JavacTreeUtils.method((JCTree.JCExpression)itemReaderIdent, isJsonb ? "readJSONBObject" : "readObject", (JCTree.JCExpression)jsonReaderIdent, (JCTree.JCExpression)JavacTreeUtils.field(JavacTreeUtils.qualIdent(itemType), this.names._class), (JCTree.JCExpression)JavacTreeUtils.literal(attributeInfo.name), JavacTreeUtils.ident("features")));
        JCTree.JCVariableDecl mapKeyVar = JavacTreeUtils.defVar(attributeInfo.name + "_key", (JCTree.JCExpression)JavacTreeUtils.ident("String"), (JCTree.JCExpression)JavacTreeUtils.method(jsonReaderIdent, "readFieldName"));
        whileStmts.append(mapKeyVar);
        JCTree.JCIdent mapKeyIdent = JavacTreeUtils.ident(mapKeyVar);
        if (referenceDetect) {
            ListBuffer<JCTree.JCStatement> isReferenceStmts = new ListBuffer<JCTree.JCStatement>();
            JCTree.JCMethodInvocation readReferenceMethod = JavacTreeUtils.method(jsonReaderIdent, "readReference");
            JCTree.JCVariableDecl refVar = JavacTreeUtils.defVar("ref", (JCTree.JCExpression)JavacTreeUtils.ident("String"), (JCTree.JCExpression)readReferenceMethod);
            isReferenceStmts.append(refVar);
            JCTree.JCMethodInvocation addResolveTaskMethod = JavacTreeUtils.method(jsonReaderIdent, "addResolveTask", (JCTree.JCExpression)JavacTreeUtils.ident(fieldValueVar), (JCTree.JCExpression)mapKeyIdent, (JCTree.JCExpression)JavacTreeUtils.method(JavacTreeUtils.qualIdent("com.alibaba.fastjson2.JSONPath"), "of", (JCTree.JCExpression)JavacTreeUtils.ident(refVar)));
            isReferenceStmts.append(JavacTreeUtils.exec(addResolveTaskMethod));
            whileStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.method(jsonReaderIdent, "isReference"), (JCTree.JCStatement)JavacTreeUtils.block(isReferenceStmts.toList()), (JCTree.JCStatement)JavacTreeUtils.exec(JavacTreeUtils.method(fieldValueVar, "put", (JCTree.JCExpression)mapKeyIdent, (JCTree.JCExpression)mapEntryValueExpr))));
        } else {
            whileStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(fieldValueVar, "put", (JCTree.JCExpression)mapKeyIdent, (JCTree.JCExpression)mapEntryValueExpr)));
        }
        elseStmts.append(JavacTreeUtils.whileLoop(JavacTreeUtils.unary(JCTree.Tag.NOT, nextIfObjectEndMethod), JavacTreeUtils.block(whileStmts.toList())));
        elseStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(jsonReaderIdent, "nextIfComma")));
        stmts.append(JavacTreeUtils.defIf(nextIfNullMethod, (JCTree.JCStatement)JavacTreeUtils.block((JCTree.JCStatement)JavacTreeUtils.exec(JavacTreeUtils.assign(fieldValueVar, (JCTree.JCExpression)JavacTreeUtils.defNull()))), (JCTree.JCStatement)JavacTreeUtils.block(elseStmts.toList())));
        return JavacTreeUtils.ident(fieldValueVar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genSource(StructInfo structInfo, TreePath treePath) {
        block17: {
            Filer filer = this.processingEnv.getFiler();
            String fullQualifiedName = structInfo.binaryName;
            FileObject converterFile = null;
            try {
                if (treePath.getCompilationUnit() instanceof JCTree.JCCompilationUnit) {
                    JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)treePath.getCompilationUnit();
                    converterFile = filer.createSourceFile(fullQualifiedName, structInfo.element);
                    String fileName = converterFile.getName() + ".txt";
                    Path filePath = Paths.get(fileName, new String[0]);
                    String dirName = fileName.substring(0, fileName.lastIndexOf(File.separator));
                    Path dirPath = Paths.get(dirName, new String[0]);
                    if (!Files.exists(dirPath, new LinkOption[0])) {
                        Files.createDirectories(dirPath, new FileAttribute[0]);
                    }
                    if (!Files.exists(filePath, new LinkOption[0])) {
                        Files.createFile(filePath, new FileAttribute[0]);
                    }
                    try (FileWriter writer = new FileWriter(filePath.toString());){
                        writer.write(compilationUnit.toString());
                        break block17;
                    }
                    catch (Exception e) {
                        this.messager.printMessage(Diagnostic.Kind.WARNING, "Failed to generate source file for " + fullQualifiedName + " caused by " + e.getMessage());
                    }
                    break block17;
                }
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Failed to generate source file for " + fullQualifiedName + " caused by invalid compilation unit");
            }
            catch (Exception e) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Failed to generate source file for " + fullQualifiedName + " caused by " + e.getMessage());
            }
            finally {
                if (converterFile != null) {
                    converterFile.delete();
                }
                if (filer instanceof JavacFiler) {
                    ((JavacFiler)filer).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genReflect(Set<ReflectionMetadata> reflects) {
        File file = null;
        try {
            file = new File("");
            String absolutePath = file.getAbsolutePath() + File.separator + ((Stream)Arrays.stream("src/main/resources/META-INF/native-image/reflect-config.json".split("/")).sequential()).collect(Collectors.joining(File.separator));
            int idx = absolutePath.lastIndexOf(File.separator);
            Path dirPath = Paths.get(absolutePath.substring(0, idx), new String[0]);
            Path filePath = Paths.get(absolutePath, new String[0]);
            if (!Files.exists(dirPath, new LinkOption[0])) {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            if (!Files.exists(filePath, new LinkOption[0])) {
                Files.createFile(filePath, new FileAttribute[0]);
            }
            try (BufferedReader reader = Files.newBufferedReader(filePath);){
                String content = reader.lines().collect(Collectors.joining());
                java.util.List reflectionMetadata = JSON.parseArray((String)content, ReflectionMetadata.class);
                if (reflectionMetadata != null) {
                    reflects.addAll(reflectionMetadata);
                }
                String jsonString = JSON.toJSONString(reflects, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat});
                try (BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);){
                    writer.write(jsonString);
                }
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Failed to generate reflect-config.json caused by " + e.getMessage());
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }

    private boolean isDebug(JCTree.JCClassDecl beanClassDecl) {
        JCTree.JCExpression jsonCompiledIdent = JavacTreeUtils.qualIdent(JSONCompiled.class.getName());
        List<JCTree.JCAnnotation> annotations = beanClassDecl.mods.annotations;
        Optional<JCTree.JCAnnotation> jsonCompiledAnnoOpt = annotations.stream().filter(a -> a.getAnnotationType().type.tsym.toString().equals(jsonCompiledIdent.type.tsym.toString())).findAny();
        if (jsonCompiledAnnoOpt.isPresent()) {
            JCTree.JCAnnotation jsonCompiledAnno = jsonCompiledAnnoOpt.get();
            Optional<JCTree.JCAssign> jsonCompiledAsgOpt = jsonCompiledAnno.args.stream().map(a -> (JCTree.JCAssign)a).filter(a2 -> "debug".equals(a2.lhs.toString())).findAny();
            if (jsonCompiledAsgOpt.isPresent()) {
                JCTree.JCAssign jcAssign = jsonCompiledAsgOpt.get();
                return "true".equals(jcAssign.rhs.toString());
            }
        }
        return false;
    }

    private JCTree.JCExpression getFieldValueType(String type) {
        if (type.contains("[")) {
            return JavacTreeUtils.arrayIdentType(type);
        }
        if (type.contains("<")) {
            return JavacTreeUtils.collectionIdent(type);
        }
        return JavacTreeUtils.qualIdent(type);
    }

    private String findConverterName(StructInfo structInfo, String suffix) {
        int dotIndex = structInfo.binaryName.lastIndexOf(36);
        if (dotIndex != -1) {
            dotIndex = structInfo.binaryName.lastIndexOf(46);
        }
        String className = structInfo.binaryName.substring(dotIndex + 1);
        if (dotIndex == -1) {
            return className + suffix;
        }
        String packageName = structInfo.binaryName.substring(0, dotIndex);
        return packageName + '.' + className + suffix;
    }

    static final class MethodWriterContext {
        final JCTree.JCExpression beanType;
        final JCTree.JCIdent objectType;
        final JCTree.JCIdent jsonWriter = JavacTreeUtils.ident("jsonWriter");
        final JCTree.JCIdent object = JavacTreeUtils.ident("object");
        final JCTree.JCIdent fieldName = JavacTreeUtils.ident("fieldName");
        final JCTree.JCIdent fieldType = JavacTreeUtils.ident("fieldType");
        final JCTree.JCIdent features = JavacTreeUtils.ident("features");
        final JCTree.JCIdent contextFeatures = JavacTreeUtils.ident("contextFeatures");
        final JCTree.JCIdent notWriteDefaultValue = JavacTreeUtils.ident("notWriteDefaultValue");
        final JCTree.JCIdent nameDirect = JavacTreeUtils.ident("nameDirect");
        final JCTree.JCIdent writeNulls = JavacTreeUtils.ident("writeNulls");
        final boolean jsonb;

        public MethodWriterContext(JCTree.JCExpression beanType, JCTree.JCIdent objectType, boolean jsonb) {
            this.beanType = beanType;
            this.objectType = objectType;
            this.jsonb = jsonb;
        }

        void genVariantsMethodBefore(ListBuffer<JCTree.JCStatement> body) {
            JCTree.JCVariableDecl contextFeaturesVar = JavacTreeUtils.defVar("contextFeatures", TypeTag.LONG, this.jsonWriterMethod("getFeatures"));
            body.append(contextFeaturesVar);
            JCTree.JCVariableDecl nameDirect = !this.jsonb ? JavacTreeUtils.defVar("nameDirect", TypeTag.BOOLEAN, (JCTree.JCExpression)JavacTreeUtils.and(JavacTreeUtils.not(this.jsonWriterField("useSingleQuote")), JavacTreeUtils.isDisable(this.contextFeatures, JSONWriter.Feature.UnquoteFieldName, JSONWriter.Feature.UseSingleQuotes))) : JavacTreeUtils.defVar("nameDirect", TypeTag.BOOLEAN, (JCTree.JCExpression)JavacTreeUtils.ternary((JCTree.JCExpression)JavacTreeUtils.notNull(this.jsonWriterField("symbolTable")), (JCTree.JCExpression)JavacTreeUtils.literal(false), (JCTree.JCExpression)JavacTreeUtils.isDisable(this.contextFeatures, JSONWriter.Feature.WriteNameAsSymbol)));
            body.append(nameDirect);
            body.append(JavacTreeUtils.defVar("notWriteDefaultValue", TypeTag.BOOLEAN, (JCTree.JCExpression)JavacTreeUtils.isEnable(this.contextFeatures, JSONWriter.Feature.NotWriteDefaultValue)));
            body.append(JavacTreeUtils.defVar("writeNulls", TypeTag.BOOLEAN, (JCTree.JCExpression)JavacTreeUtils.ternary((JCTree.JCExpression)this.notWriteDefaultValue, (JCTree.JCExpression)JavacTreeUtils.isEnable(this.contextFeatures, JSONWriter.Feature.WriteNulls, JSONWriter.Feature.NullAsDefaultValue), false)));
        }

        JCTree.JCExpression jsonWriterField(String fieldName) {
            return JavacTreeUtils.field((JCTree.JCExpression)this.jsonWriter, fieldName);
        }

        JCTree.JCExpression jsonWriterMethod(String fieldName) {
            return JavacTreeUtils.method(this.jsonWriter, fieldName);
        }

        JCTree.JCExpression jsonWriterMethod(String fieldName, List<JCTree.JCExpression> args) {
            return JavacTreeUtils.method((JCTree.JCExpression)this.jsonWriter, fieldName, args);
        }

        JCTree.JCExpression jsonWriterMethod(String fieldName, JCTree.JCExpression arg) {
            return JavacTreeUtils.method((JCTree.JCExpression)this.jsonWriter, fieldName, List.of(arg));
        }

        JCTree.JCExpression jsonWriterMethod(String fieldName, JCTree.JCVariableDecl arg) {
            return JavacTreeUtils.method((JCTree.JCExpression)this.jsonWriter, fieldName, List.of(JavacTreeUtils.ident(arg)));
        }

        JCTree.JCExpression jsonWriterMethod(String fieldName, String arg) {
            return JavacTreeUtils.method((JCTree.JCExpression)this.jsonWriter, fieldName, List.of(JavacTreeUtils.literal(arg)));
        }

        JCTree.JCExpression jsonWriterMethod(String fieldName, JCTree.JCExpression arg0, JCTree.JCExpression arg1) {
            return JavacTreeUtils.method((JCTree.JCExpression)this.jsonWriter, fieldName, List.of(arg0, arg1));
        }

        JCTree.JCExpression jsonWriterMethod(String fieldName, JCTree.JCExpression arg0, JCTree.JCVariableDecl arg1) {
            return JavacTreeUtils.method((JCTree.JCExpression)this.jsonWriter, fieldName, List.of(arg0, JavacTreeUtils.ident(arg1)));
        }
    }
}

