/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.codegen;

import com.alibaba.fastjson2.internal.codegen.Block;
import com.alibaba.fastjson2.internal.codegen.ClassWriter;
import java.lang.reflect.Modifier;

public class MethodWriter
extends Block {
    final ClassWriter classWriter;
    final int modifiers;
    final String name;
    final Class returnType;
    final Class[] paramTypes;
    final String[] paramNames;

    MethodWriter(ClassWriter classWriter, int modifiers, String name, Class returnType, Class[] paramTypes, String[] paramNames) {
        this.classWriter = classWriter;
        this.modifiers = modifiers;
        this.name = name;
        this.returnType = returnType;
        this.paramTypes = paramTypes;
        this.paramNames = paramNames;
    }

    public void toString(StringBuilder buf) {
        int i;
        if (Modifier.isPublic(this.modifiers)) {
            buf.append("\tpublic ");
        }
        if ("<init>".equals(this.name)) {
            buf.append(this.classWriter.name);
        } else {
            buf.append(ClassWriter.getTypeName(this.returnType)).append(' ').append(this.name);
        }
        boolean newLine = this.paramTypes.length > 3;
        buf.append('(');
        if (newLine) {
            buf.append("\n\t\t\t");
        }
        for (i = 0; i < this.paramTypes.length; ++i) {
            if (i != 0) {
                if (newLine) {
                    buf.append(",\n\t\t\t");
                } else {
                    buf.append(", ");
                }
            }
            Class paramType = this.paramTypes[i];
            String paramName = this.paramNames[i];
            buf.append(ClassWriter.getTypeName(paramType)).append(' ').append(paramName);
        }
        if (newLine) {
            buf.append("\n\t");
        }
        buf.append(") {\n");
        for (i = 0; i < this.statements.size(); ++i) {
            if (i != 0) {
                buf.append('\n');
            }
            Block.Statement stmt = (Block.Statement)this.statements.get(i);
            stmt.toString(this, buf, 2);
        }
        buf.append("\n\t}");
    }

    public void ident(StringBuilder buf, int indent) {
        for (int i = 0; i < indent; ++i) {
            buf.append('\t');
        }
    }
}

