/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.codegen;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.internal.codegen.ClassWriter;
import com.alibaba.fastjson2.internal.codegen.MethodWriter;

public class Opcodes {
    public static OpName THIS = Opcodes.var("this");
    public static OpName SUPER = Opcodes.var("super");

    public static Op arrayGet(Op owner, Op index) {
        return new ArrayGet(owner, index);
    }

    public static Op ldc(Object value) {
        return new OpConstant(value);
    }

    public static OpName var(String name) {
        return new OpName(name);
    }

    public static Op invoke(Op owner, String method, Op ... args) {
        return new OpInvoke(owner, method, args);
    }

    public static Op invoke(String method, Op ... args) {
        return new OpInvoke(THIS, method, args);
    }

    public static Op invokeStatic(Class type, String method, Op ... args) {
        return new OpInvoke(Opcodes.var(ClassWriter.getTypeName(type)), method, args);
    }

    public static MethodRef methodRef(String type, String method) {
        return new MethodRef(type, method);
    }

    public static Lambda lambda(String type, String name, Op op) {
        return new Lambda(new String[]{type}, new String[]{name}, op);
    }

    public static Lambda lambda(String type0, String name0, String type1, String name1, Op op) {
        return new Lambda(new String[]{type0, type1}, new String[]{name0, name1}, op);
    }

    public static Op allocate(Class type, Op ... args) {
        return new OpAllocate(ClassWriter.getTypeName(type), args);
    }

    public static Op allocate(String type, Op ... args) {
        return new OpAllocate(type, args);
    }

    public static Op allocateArray(Class type, Op size, Op ... values) {
        return new OpAllocateArray(ClassWriter.getTypeName(type), size, values);
    }

    public static Op allocateArray(String type, Op size, Op ... values) {
        return new OpAllocateArray(type, size, values);
    }

    public static Op putField(Op owner, String fieldName, Op value) {
        return new PutField(owner, fieldName, value);
    }

    public static Op getStatic(Class type, String field) {
        return new GetStatic(ClassWriter.getTypeName(type), field);
    }

    public static Op getStatic(String type, String field) {
        return new GetStatic(type, field);
    }

    public static Op getField(String field) {
        return new GetField(THIS, field);
    }

    public static Op getField(Op owner, String field) {
        return new GetField(owner, field);
    }

    public static Op getField(String owner, String field) {
        return new GetField(Opcodes.var(owner), field);
    }

    public static Op eqNull(Op value) {
        return new OpBinary(value, "==", Opcodes.ldc(null));
    }

    public static Op notNull(Op value) {
        return new OpBinary(value, "!=", Opcodes.ldc(null));
    }

    public static Op cast(Op value, Class type) {
        return new Cast(ClassWriter.getTypeName(type), value);
    }

    public static Op cast(Op value, String type) {
        return new Cast(type, value);
    }

    public static Op bitOr(Op a, Op b) {
        return new OpBinary(a, "|", b);
    }

    public static Op and(Op a, Op b) {
        return new OpBinary(a, "&&", b);
    }

    public static Op and(Op a, Op b, Op c) {
        return new OpBinary(new OpBinary(a, "&&", b), "&&", c);
    }

    public static Op assign(Op a, Op b) {
        return new OpBinary(a, "=", b);
    }

    public static Op assign(String name, Op b) {
        return new OpBinary(Opcodes.var(name), "=", b);
    }

    public static Op ne(Op a, Op b) {
        return new OpBinary(a, "!=", b);
    }

    public static Op eq(Op a, Op b) {
        return new OpBinary(a, "==", b);
    }

    public static Op urs(Op a, Op b) {
        return new OpBinary(a, ">>>", b);
    }

    public static Op eor(Op a, Op b) {
        return new OpBinary(a, "^", b);
    }

    public static Op lt(Op a, Op b) {
        return new OpBinary(a, "<", b);
    }

    public static Op increment(Op value) {
        return new OpUnary(value, "++");
    }

    public static Op not(Op value) {
        return new OpUnary(value, "!");
    }

    static class OpUnary
    implements Op {
        public final Op left;
        public final String op;

        public OpUnary(Op left, String op) {
            this.left = left;
            this.op = op;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            boolean prefix = "!".equals(this.op);
            if (prefix) {
                buf.append(this.op);
                this.left.toString(mw, buf, indent);
            } else {
                this.left.toString(mw, buf, indent);
                buf.append(this.op);
            }
        }
    }

    static class OpBinary
    implements Op {
        public final Op left;
        public final String op;
        public final Op right;

        public OpBinary(Op left, String op, Op right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            boolean lq = this.left instanceof OpBinary;
            if (lq) {
                buf.append('(');
            }
            this.left.toString(mw, buf, indent);
            if (lq) {
                buf.append(')');
            }
            buf.append(' ').append(this.op).append(' ');
            boolean rq = this.right instanceof OpBinary;
            if (rq) {
                buf.append('(');
            }
            this.right.toString(mw, buf, indent);
            if (rq) {
                buf.append(')');
            }
        }
    }

    public static class OpName
    implements Op {
        public final String name;

        public OpName(String name) {
            this.name = name;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            buf.append(this.name);
        }
    }

    static class OpConstant
    implements Op {
        public final Object value;

        public OpConstant(Object value) {
            this.value = value;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            if (this.value == null) {
                buf.append("null");
                return;
            }
            if (this.value instanceof String) {
                buf.append('\"');
                buf.append(((String)this.value).replace("\"", "\\\""));
                buf.append('\"');
                return;
            }
            if (this.value instanceof Byte) {
                buf.append("(byte) ").append(((Byte)this.value).intValue());
                return;
            }
            if (this.value instanceof Integer) {
                buf.append((Integer)this.value);
                return;
            }
            if (this.value instanceof Long) {
                buf.append((Long)this.value);
                buf.append('L');
                return;
            }
            if (this.value instanceof Character) {
                buf.append('\'').append(((Character)this.value).charValue()).append('\'');
                return;
            }
            if (this.value instanceof Class) {
                buf.append(ClassWriter.getTypeName((Class)this.value)).append(".class");
                return;
            }
            if (this.value instanceof Op) {
                ((Op)this.value).toString(mw, buf, indent);
                return;
            }
            throw new JSONException("TODO : " + this.value.getClass().getName());
        }
    }

    public static class OpAllocateArray
    implements Op {
        public final String type;
        public final Op size;
        public final Op[] values;

        public OpAllocateArray(String type, Op size, Op[] values) {
            this.type = type;
            this.size = size;
            this.values = values;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            buf.append("new ").append(this.type).append('[');
            if (this.size != null) {
                this.size.toString(mw, buf, indent);
            }
            buf.append(']');
            if (this.values != null) {
                int length = this.values.length;
                if (length > 0) {
                    buf.append('{');
                    buf.append('\n');
                    mw.ident(buf, indent + 2);
                    for (int i = 0; i < length; ++i) {
                        if (i != 0) {
                            buf.append(",\n");
                            mw.ident(buf, indent + 2);
                        }
                        this.values[i].toString(mw, buf, indent + 2);
                    }
                    buf.append('\n');
                    mw.ident(buf, indent);
                    buf.append('}');
                } else if (length == 0) {
                    buf.append("{}");
                }
            }
        }
    }

    public static class OpAllocate
    implements Op {
        public final String type;
        public final Op[] args;

        public OpAllocate(String type, Op[] args) {
            this.type = type;
            this.args = args;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            buf.append("new ").append(this.type).append('(');
            for (int i = 0; i < this.args.length; ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                this.args[i].toString(mw, buf, indent);
            }
            buf.append(')');
        }
    }

    public static class Lambda
    implements Op {
        public final String[] paramTypes;
        public final String[] paramNames;
        public final Op op;

        public Lambda(String[] paramTypes, String[] paramNames, Op op) {
            this.paramTypes = paramTypes;
            this.paramNames = paramNames;
            this.op = op;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            buf.append('(');
            for (int i = 0; i < this.paramNames.length; ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                String paramName = this.paramNames[i];
                String type = this.paramTypes[i];
                if (type != null) {
                    buf.append(type);
                    buf.append(' ');
                }
                buf.append(paramName);
            }
            buf.append(") -> ");
            this.op.toString(mw, buf, indent);
        }
    }

    public static class MethodRef
    implements Op {
        public final String type;
        public final String method;

        public MethodRef(String type, String method) {
            this.type = type;
            this.method = method;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            buf.append(this.type);
            buf.append("::");
            buf.append(this.method);
        }
    }

    public static class OpInvoke
    implements Op {
        public final Op owner;
        public final String method;
        public final Op[] args;

        public OpInvoke(Op owner, String method, Op[] args) {
            this.owner = owner;
            this.method = method;
            this.args = args;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            boolean hasNewLine;
            if ("<init>".equals(this.method)) {
                this.owner.toString(mw, buf, indent);
            } else {
                if (this.owner != null) {
                    this.owner.toString(mw, buf, indent);
                    buf.append('.');
                }
                buf.append(this.method);
            }
            buf.append('(');
            int start = buf.length();
            boolean newLine = this.args.length > 3;
            for (Op arg : this.args) {
                if (!(arg instanceof OpInvoke)) continue;
                newLine = true;
            }
            if (newLine) {
                buf.append('\n');
                mw.ident(buf, indent + 2);
            }
            for (int i = 0; i < this.args.length; ++i) {
                if (i != 0) {
                    if (newLine) {
                        buf.append(",\n");
                        mw.ident(buf, indent + 2);
                    } else {
                        buf.append(", ");
                    }
                }
                this.args[i].toString(mw, buf, indent + 2);
            }
            boolean bl = hasNewLine = buf.toString().indexOf(10, start) != -1;
            if (newLine) {
                buf.append('\n');
                mw.ident(buf, indent);
            } else if (hasNewLine) {
                for (int i = 0; i < indent + 2; ++i) {
                    buf.insert(start, '\t');
                }
                buf.insert(start, '\n');
                buf.append('\n');
                mw.ident(buf, indent);
            }
            buf.append(')');
        }
    }

    public static interface Op {
        default public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            throw new JSONException("TODO " + this.getClass().getName());
        }
    }

    static class Cast
    implements Op {
        public final String type;
        public final Op value;

        public Cast(String type, Op value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            buf.append('(').append(this.type).append(") ");
            boolean quote = this.value instanceof OpBinary;
            if (quote) {
                buf.append('(');
            }
            this.value.toString(mw, buf, indent);
            if (quote) {
                buf.append(')');
            }
        }
    }

    static class GetField
    implements Op {
        public final Op owner;
        public final String fieldName;

        public GetField(Op owner, String fieldName) {
            this.owner = owner;
            this.fieldName = fieldName;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            this.owner.toString(mw, buf, indent);
            buf.append('.').append(this.fieldName);
        }
    }

    static class GetStatic
    implements Op {
        public final String type;
        public final String fieldName;

        public GetStatic(String type, String fieldName) {
            this.type = type;
            this.fieldName = fieldName;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            buf.append(this.type).append('.').append(this.fieldName);
        }
    }

    static class PutField
    implements Op {
        public final Op owner;
        public final String fieldName;
        public final Op value;

        public PutField(Op owner, String fieldName, Op value) {
            this.owner = owner;
            this.fieldName = fieldName;
            this.value = value;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            this.owner.toString(mw, buf, indent);
            buf.append('.');
            buf.append(this.fieldName).append(" = ");
            this.value.toString(mw, buf, indent);
        }
    }

    static class ArrayGet
    implements Op {
        final Op array;
        final Op index;

        public ArrayGet(Op array, Op index) {
            this.array = array;
            this.index = index;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            this.array.toString(mw, buf, indent);
            buf.append('[');
            this.index.toString(mw, buf, indent);
            buf.append(']');
        }
    }
}

