/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.infra.Blackhole;

public class LargeFile2MTest {
    static String str;
    static ObjectMapper mapper;
    static final int COUNT = 100;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.parseObject((String)str));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.parseObject((String)str));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(str, HashMap.class));
    }

    public void perfTest(Runnable task) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            task.run();
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("millis : " + millis);
    }

    public void fastjson1_perf_test() {
        this.perfTest(() -> com.alibaba.fastjson.JSON.parseObject((String)str));
    }

    public void fastjson2_perf_test() {
        this.perfTest(() -> JSON.parseObject((String)str));
    }

    public void jackson_perf_test() throws Exception {
        this.perfTest(() -> {
            try {
                mapper.readValue(str, HashMap.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static void main(String[] args) throws Exception {
        new LargeFile2MTest().fastjson2_perf_test();
    }

    static {
        mapper = new ObjectMapper();
        try (InputStream fis = LargeFile2MTest.class.getClassLoader().getResourceAsStream("data/large-file-2m.json.zip");
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zipIn = new ZipInputStream(bis);){
            zipIn.getNextEntry();
            str = IOUtils.toString((InputStream)zipIn, (String)"UTF-8");
            zipIn.closeEntry();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

