/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.fastcode;

import com.alibaba.fastjson2.benchmark.fastcode.SimpleDateFormatX;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.util.DateUtils;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.FastDateFormat;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class DateFormat19 {
    static final String pattern = "yyyy-MM-dd HH:mm:ss";
    static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    static Date date = new Date(1340424794000L);
    static FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    static String str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    static ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat(pattern));

    public void commonsFastFormat(Blackhole bh) throws Throwable {
        String str = fastDateFormat.format(date);
        bh.consume((Object)str);
    }

    public void simpleDateFormat(Blackhole bh) throws Throwable {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        String str = format.format(date);
        bh.consume((Object)str);
    }

    public void simpleDateFormatThreadLocal(Blackhole bh) throws Throwable {
        SimpleDateFormat format = SIMPLE_DATE_FORMAT_LOCAL.get();
        String str = format.format(date);
        bh.consume((Object)str);
    }

    public void fastjsonFormat(Blackhole bh) throws Throwable {
        bh.consume((Object)DateUtils.format((Date)date, (String)pattern));
    }

    public void formatYMDHMS19(Blackhole bh) throws Throwable {
        bh.consume((Object)DateUtils.formatYMDHMS19((Date)date, (ZoneId)ZoneId.DEFAULT_ZONE_ID));
    }

    @Benchmark
    public void simpleFormat(Blackhole bh) throws Throwable {
        bh.consume((Object)new SimpleDateFormat(pattern).format(date));
    }

    @Benchmark
    public void simpleFormatX(Blackhole bh) throws Throwable {
        bh.consume((Object)new SimpleDateFormatX(pattern).format(date));
    }

    @Benchmark
    public void simpleParse(Blackhole bh) throws Throwable {
        bh.consume((Object)new SimpleDateFormat(pattern).parse(str));
    }

    @Benchmark
    public void simpleParseX(Blackhole bh) throws Throwable {
        bh.consume((Object)new SimpleDateFormatX(pattern).parse(str));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(DateFormat19.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(1).forks(1).build();
        new Runner(options).run();
    }
}

