/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.primitves;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class Double20Tree {
    static String str;
    static ObjectMapper mapper;

    public Double20Tree() {
        try {
            InputStream is = Double20Tree.class.getClassLoader().getResourceAsStream("data/dec20.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(JSON.parseObject((String)str, Map.class, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.UseBigDecimalForDoubles}));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(str, Map.class));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(Double20Tree.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
    }
}

