/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.fury.Fury;
import org.apache.fury.ThreadSafeFury;
import org.apache.fury.config.CompatibleMode;
import org.apache.fury.config.Language;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayFuryCompatibleWrite {
    static MediaContent mc;
    static JSONWriter.Feature[] features;
    static JSONWriter.Context context;
    static ThreadSafeFury furyCompatible;

    @Benchmark
    public void jsonb(Blackhole bh) {
        byte[] bytes = JSONB.toBytes((Object)mc, (JSONWriter.Context)context);
        bh.consume((Object)bytes);
    }

    public int jsonbSize() {
        return JSONB.toBytes((Object)mc, (JSONWriter.Context)context).length;
    }

    @Benchmark
    public void fury(Blackhole bh) {
        byte[] bytes = furyCompatible.serialize((Object)mc);
        bh.consume((Object)bytes);
    }

    public int furySize() {
        return furyCompatible.serialize((Object)mc).length;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayFuryCompatibleWrite.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(16).build();
        new Runner(options).run();
    }

    static {
        features = new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName, JSONWriter.Feature.IgnoreNoneSerializable, JSONWriter.Feature.FieldBased, JSONWriter.Feature.ReferenceDetection, JSONWriter.Feature.WriteNulls, JSONWriter.Feature.NotWriteDefaultValue, JSONWriter.Feature.NotWriteHashMapArrayListClassName};
        context = new JSONWriter.Context(JSONFactory.getDefaultObjectWriterProvider(), features);
        furyCompatible = Fury.builder().withLanguage(Language.JAVA).withRefTracking(true).requireClassRegistration(false).withCompatibleMode(CompatibleMode.COMPATIBLE).buildThreadSafeFury();
        try {
            InputStream is = EishayFuryCompatibleWrite.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            mc = (MediaContent)JSONReader.of((String)str).read(MediaContent.class);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

