/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.jsonpath;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.benchmark.jsonpath.BookStore;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class JSONPathMultiBenchmark {
    private static String str;
    static JSONPath jsonPath;
    static JSONPath path0;
    static JSONPath path1;

    @Benchmark
    public void extract(Blackhole bh) throws Exception {
        bh.consume(jsonPath.extract(str));
    }

    @Benchmark
    public void eval(Blackhole bh) throws Exception {
        JSONObject object = JSON.parseObject((String)str);
        bh.consume(jsonPath.eval((Object)object));
    }

    @Benchmark
    public void evalMulti(Blackhole bh) throws Exception {
        JSONObject object = JSON.parseObject((String)str);
        Object[] values = new Object[]{TypeUtils.cast((Object)path0.eval((Object)object), String.class), TypeUtils.cast((Object)path1.eval((Object)object), BigDecimal.class)};
        bh.consume((Object)values);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(JSONPathMultiBenchmark.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        try {
            InputStream is = BookStore.class.getClassLoader().getResourceAsStream("data/path_02.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        jsonPath = JSONPath.of((String[])new String[]{"$.store.bicycle.color", "$.store.bicycle.price"}, (Type[])new Type[]{String.class, BigDecimal.class});
        path0 = JSONPath.of((String)"$.store.bicycle.color");
        path1 = JSONPath.of((String)"$.store.bicycle.price");
    }
}

