/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.benchmark.vo.CartItemDO2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@Warmup(iterations=3)
@Measurement(iterations=1000, time=5)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class CartItemDO2Benchmark {
    private static volatile List<CartItemDO2> list;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CartItemDO2> newCartsItem() {
        if (list != null) {
            return list;
        }
        Class<CartItemDO2Benchmark> clazz = CartItemDO2Benchmark.class;
        synchronized (CartItemDO2Benchmark.class) {
            if (list == null) {
                list = new ArrayList<CartItemDO2>();
                for (long i = 90000000000L; i < 90000001000L; ++i) {
                    CartItemDO2 cartItemDO2 = new CartItemDO2();
                    cartItemDO2.setUserId(i);
                    cartItemDO2.setAttributes(new HashMap<String, String>());
                    cartItemDO2.setCartId(i * 100L);
                    cartItemDO2.setCityCode(i * 12L);
                    cartItemDO2.setItemId(i * 3L);
                    cartItemDO2.setMainType(11);
                    cartItemDO2.setQuantity(900);
                    cartItemDO2.setSkuId(i * 5L);
                    cartItemDO2.setSubType(i * 6L);
                    cartItemDO2.setTpId(i * 7L);
                    cartItemDO2.setTrackId(String.valueOf(i * 8L));
                    list.add(cartItemDO2);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return list;
        }
    }

    @Benchmark
    public byte[] testCartItem() throws Exception {
        return JSONB.toBytes(CartItemDO2Benchmark.newCartsItem(), (SymbolTable)JSONB.symbolTable((String[])new String[]{"myId"}), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray});
    }
}

