/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson2.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayParseTreeUTF8BytesPretty {
    static byte[] utf8Bytes;
    static ObjectMapper mapper;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume(com.alibaba.fastjson.JSON.parse((byte[])utf8Bytes, (Feature[])new Feature[0]));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.parseObject((byte[])utf8Bytes));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(utf8Bytes, HashMap.class));
    }

    public void fastjson2_perf_test() {
        for (int i = 0; i < 10; ++i) {
            EishayParseTreeUTF8BytesPretty.fastjson2_perf();
        }
    }

    public static void fastjson2_perf() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            JSON.parseObject((byte[])utf8Bytes);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("millis : " + millis);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayParseTreeUTF8BytesPretty.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        try {
            InputStream is = EishayParseTreeUTF8BytesPretty.class.getClassLoader().getResourceAsStream("data/eishay.json");
            utf8Bytes = IOUtils.toString((InputStream)is, (String)"UTF-8").getBytes(StandardCharsets.UTF_8);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

