/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.benchmark.eishay.EishayParseBinary;
import com.alibaba.fastjson2.support.csv.CSVReader;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvRoutines;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

public class CSVCOVID19 {
    static final String file = "csv/COVID-19_Public_Therapeutic_Locator.csv";
    static byte[] byteArray;

    @Benchmark
    public void fastjson2(Blackhole BH) {
        CSVReader.of((InputStream)new ByteArrayInputStream(byteArray), Covid19.class).readLineObjectAll(arg_0 -> ((Blackhole)BH).consume(arg_0));
    }

    @Benchmark
    public void univocity(Blackhole BH) {
        CsvParserSettings settings = new CsvParserSettings();
        CsvRoutines processor = new CsvRoutines(settings);
        ((CsvFormat)settings.getFormat()).setLineSeparator("\n");
        settings.setNumberOfRowsToSkip(1L);
        processor.iterate(Covid19.class, (InputStream)new ByteArrayInputStream(byteArray)).forEach(arg_0 -> ((Blackhole)BH).consume(arg_0));
    }

    public void cainiao(Blackhole BH) {
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(CSVCOVID19.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).measurementTime(TimeValue.seconds((long)30L)).build();
        new Runner(options).run();
    }

    static {
        try (InputStream is = EishayParseBinary.class.getClassLoader().getResourceAsStream(file);){
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            byteArray = str.getBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Covid19 {
        @Parsed(index=0)
        public String providerName;
        @Parsed(index=1)
        public String address1;
        @Parsed(index=2)
        public String address2;
        @Parsed(index=3)
        public String city;
        @Parsed(index=4)
        public String county;
        @Parsed(index=5)
        public String stateCode;
        @Parsed(index=6)
        public Integer zip;
        @Parsed(index=7)
        public String nationalDrugCode;
        @Parsed(index=8)
        public String orderLabel;
        @Parsed(index=9)
        public Integer coursesAvailable;
        @Parsed(index=10)
        public String geocodedAddress;
        @Parsed(index=11)
        public String npi;
        @Parsed(index=12)
        public String lastReportDate;
        @Parsed(index=13)
        public String providerStatus;
        @Parsed(index=14)
        public String providerNote;
    }
}

