/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.benchmark.eishay.EishayParseStringNoneCache;
import com.alibaba.fastjson2.benchmark.eishay.EishayParseStringPretty;
import com.alibaba.fastjson2.benchmark.eishay.mixin.ImageMixin;
import com.alibaba.fastjson2.benchmark.eishay.mixin.MediaContentMixin;
import com.alibaba.fastjson2.benchmark.eishay.mixin.MediaMixin;
import com.alibaba.fastjson2.benchmark.eishay.vo.Image;
import com.alibaba.fastjson2.benchmark.eishay.vo.Media;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayParseString {
    static String str;
    static final ObjectMapper mapper;
    static final Gson gson;
    static final ObjectReaderProvider provider;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume(JSON.parseObject((String)str, MediaContent.class));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(com.alibaba.fastjson2.JSON.parseObject((String)str, MediaContent.class));
    }

    public void fastjson2Mixin(Blackhole bh) {
        bh.consume(com.alibaba.fastjson2.JSON.parseObject((String)str, MediaContent.class, (JSONReader.Context)JSONFactory.createReadContext((ObjectReaderProvider)provider, (JSONReader.Feature[])new JSONReader.Feature[0])));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(str, MediaContent.class));
    }

    public void wastjson(Blackhole bh) throws Exception {
        bh.consume(io.github.wycst.wast.json.JSON.parseObject((String)str, MediaContent.class, (ReadOption[])new ReadOption[0]));
    }

    @Benchmark
    public void gson(Blackhole bh) throws Exception {
        bh.consume(gson.fromJson(str, MediaContent.class));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayParseString.class.getName()).exclude(EishayParseStringPretty.class.getName()).exclude(EishayParseStringNoneCache.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
        provider = new ObjectReaderProvider();
        try {
            InputStream is = EishayParseString.class.getClassLoader().getResourceAsStream("data/eishay_compact.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            com.alibaba.fastjson2.JSON.parseObject((String)str, MediaContent.class);
            provider.mixIn(MediaContent.class, MediaContentMixin.class);
            provider.mixIn(Image.class, ImageMixin.class);
            provider.mixIn(Media.class, MediaMixin.class);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

