/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.jsonpath;

import com.alibaba.fastjson2.JSONPath;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;

public class JSONPathPerf {
    private static String str;

    public void fastjsonReaderAuthors_perf() throws Exception {
        for (int i = 0; i < 10; ++i) {
            long start = System.currentTimeMillis();
            for (int j = 0; j < 1000000; ++j) {
                this.fastjsonReaderAuthors();
            }
            long millis = System.currentTimeMillis() - start;
            System.out.println(millis);
        }
    }

    @Benchmark
    public Object fastjsonReaderAuthors() {
        return JSONPath.extract((String)str, (String)"$.store.book[*].author");
    }

    @Benchmark
    public List<String> jaywayReadAuthors() {
        return (List)JsonPath.read((String)str, (String)"$.store.book[*].author", (Predicate[])new Predicate[0]);
    }

    public static void main(String[] args) throws Exception {
        new JSONPathPerf().fastjsonReaderAuthors_perf();
    }

    static {
        try {
            InputStream is = JSONPathPerf.class.getClassLoader().getResourceAsStream("data/path_02.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

