/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.example.springtest.controller;

import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/{name}")
public class WebSocket {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocket.class);
    private Session session;
    private String name;
    private static ConcurrentHashMap<String, WebSocket> webSocketSet = new ConcurrentHashMap();

    @OnOpen
    public void OnOpen(Session session, @PathParam(value="name") String name) {
        log.info("----------------------------------");
        this.session = session;
        this.name = name;
        webSocketSet.put(name, this);
        log.info("[WebSocket] \u8fde\u63a5\u6210\u529f\uff0c\u5f53\u524d\u8fde\u63a5\u4eba\u6570\u4e3a\uff1a={}", (Object)webSocketSet.size());
        log.info("----------------------------------");
        log.info("");
        this.GroupSending(name + " \u6765\u4e86");
    }

    @OnClose
    public void OnClose() {
        webSocketSet.remove(this.name);
        log.info("[WebSocket] \u9000\u51fa\u6210\u529f\uff0c\u5f53\u524d\u8fde\u63a5\u4eba\u6570\u4e3a\uff1a={}", (Object)webSocketSet.size());
        this.GroupSending(this.name + " \u8d70\u4e86");
    }

    @OnMessage
    public void OnMessage(String messageStr) {
        log.info("[WebSocket] \u6536\u5230\u6d88\u606f\uff1a{}", (Object)messageStr);
        if (messageStr.indexOf("TOUSER") == 0) {
            String[] split = messageStr.split(";");
            String[] split1 = split[0].split(":");
            String[] split2 = split[1].split(":");
            String name = split1[1];
            String message = split2[1];
            this.AppointSending(name, message);
        } else {
            this.GroupSending(messageStr);
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        log.info("\u53d1\u751f\u9519\u8bef");
        error.printStackTrace();
    }

    public void GroupSending(String message) {
        for (String name : webSocketSet.keySet()) {
            try {
                WebSocket.webSocketSet.get((Object)name).session.getBasicRemote().sendText(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void AppointSending(String name, String message) {
        try {
            WebSocket.webSocketSet.get((Object)name).session.getBasicRemote().sendText(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

