/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.SymbolTable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class JSONLexer {
    public static final char EOI = '\u001a';
    public static final int NOT_MATCH = -1;
    public static final int NOT_MATCH_NAME = -2;
    public static final int UNKNOWN = 0;
    public static final int VALUE = 3;
    public static final int END = 4;
    private static boolean V6;
    protected int token;
    protected int pos;
    public int features = JSON.DEFAULT_PARSER_FEATURE;
    protected char ch;
    protected int bp;
    protected int eofPos;
    protected char[] sbuf;
    protected int sp;
    protected boolean exp = false;
    protected boolean isDouble = false;
    protected int np;
    protected boolean hasSpecial;
    public TimeZone timeZone = JSON.defaultTimeZone;
    public Locale locale = JSON.defaultLocale;
    public Calendar calendar = null;
    public int matchStat = 0;
    private static final ThreadLocal<char[]> sbufLocal;
    protected final String text;
    protected final int len;
    protected String stringDefaultValue;
    public boolean disableCircularReferenceDetect;
    protected long fieldHash;
    protected static final int[] digits;
    public static final char[] CA;
    static final int[] IA;
    public static final boolean[] firstIdentifierFlags;
    public static final boolean[] identifierFlags;

    public JSONLexer(String input) {
        this(input, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONLexer(char[] input, int inputLength) {
        this(input, inputLength, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONLexer(char[] input, int inputLength, int features) {
        this(new String(input, 0, inputLength), features);
    }

    public JSONLexer(String input, int features) {
        int index;
        this.sbuf = sbufLocal.get();
        if (this.sbuf == null) {
            this.sbuf = new char[512];
        }
        this.features = features;
        this.text = input;
        this.len = this.text.length();
        this.bp = -1;
        this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        if (this.ch == '\ufeff') {
            this.next();
        }
        this.stringDefaultValue = (features & Feature.InitStringFieldAsEmpty.mask) != 0 ? "" : null;
        this.disableCircularReferenceDetect = (features & Feature.DisableCircularReferenceDetect.mask) != 0;
    }

    public final int token() {
        return this.token;
    }

    public void close() {
        if (this.sbuf.length <= 8196) {
            sbufLocal.set(this.sbuf);
        }
        this.sbuf = null;
    }

    public char next() {
        int index;
        char c = (index = ++this.bp) >= this.len ? (char)'\u001a' : (char)this.text.charAt(index);
        this.ch = c;
        return c;
    }

    public final void config(Feature feature, boolean state) {
        this.features = state ? (this.features |= feature.mask) : (this.features &= ~feature.mask);
        if (feature == Feature.InitStringFieldAsEmpty) {
            this.stringDefaultValue = state ? "" : null;
        }
        this.disableCircularReferenceDetect = (this.features & Feature.DisableCircularReferenceDetect.mask) != 0;
    }

    public final boolean isEnabled(Feature feature) {
        return (this.features & feature.mask) != 0;
    }

    public final void nextTokenWithChar(char expect) {
        this.sp = 0;
        while (true) {
            if (this.ch == expect) {
                int index;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                this.nextToken();
                return;
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        throw new JSONException("not match " + expect + " - " + this.ch);
    }

    public final String numberString() {
        int index = this.np + this.sp - 1;
        char chLocal = this.text.charAt(index);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        return this.subString(this.np, sp);
    }

    protected char charAt(int index) {
        return index >= this.len ? (char)'\u001a' : this.text.charAt(index);
    }

    public final void nextToken() {
        block31: {
            this.sp = 0;
            block15: while (true) {
                boolean eof;
                this.pos = this.bp;
                if (this.ch == '/') {
                    this.skipComment();
                    continue;
                }
                if (this.ch == '\"') {
                    this.scanString();
                    return;
                }
                if (this.ch >= '0' && this.ch <= '9' || this.ch == '-') {
                    this.scanNumber();
                    return;
                }
                if (this.ch == ',') {
                    this.next();
                    this.token = 16;
                    return;
                }
                switch (this.ch) {
                    case '\'': {
                        this.scanString();
                        return;
                    }
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        this.next();
                        continue block15;
                    }
                    case 't': {
                        if (this.text.startsWith("true", this.bp)) {
                            this.bp += 4;
                            this.ch = this.charAt(this.bp);
                            if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b' || this.ch == ':') {
                                this.token = 6;
                                return;
                            }
                        }
                        throw new JSONException("scan true error");
                    }
                    case 'S': 
                    case 'T': 
                    case 'u': {
                        this.scanIdent();
                        return;
                    }
                    case 'f': {
                        if (this.text.startsWith("false", this.bp)) {
                            this.bp += 5;
                            this.ch = this.charAt(this.bp);
                            if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b' || this.ch == ':') {
                                this.token = 7;
                                return;
                            }
                        }
                        throw new JSONException("scan false error");
                    }
                    case 'n': {
                        int token = 0;
                        if (this.text.startsWith("null", this.bp)) {
                            this.bp += 4;
                            token = 8;
                        } else if (this.text.startsWith("new", this.bp)) {
                            this.bp += 3;
                            token = 9;
                        }
                        if (token != 0) {
                            this.ch = this.charAt(this.bp);
                            if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b') {
                                this.token = token;
                                return;
                            }
                        }
                        throw new JSONException("scan null/new error");
                    }
                    case '(': {
                        this.next();
                        this.token = 10;
                        return;
                    }
                    case ')': {
                        this.next();
                        this.token = 11;
                        return;
                    }
                    case '[': {
                        int index = ++this.bp;
                        this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
                        this.token = 14;
                        return;
                    }
                    case ']': {
                        this.next();
                        this.token = 15;
                        return;
                    }
                    case '{': {
                        int index = ++this.bp;
                        this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
                        this.token = 12;
                        return;
                    }
                    case '}': {
                        int index = ++this.bp;
                        this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
                        this.token = 13;
                        return;
                    }
                    case ':': {
                        this.next();
                        this.token = 17;
                        return;
                    }
                }
                boolean bl = eof = this.bp == this.len || this.ch == '\u001a' && this.bp + 1 == this.len;
                if (eof) {
                    if (this.token == 20) {
                        throw new JSONException("EOF error");
                    }
                    this.token = 20;
                    this.pos = this.bp = this.eofPos;
                    break block31;
                }
                if (this.ch > '\u001f' && this.ch != '\u007f') break;
                this.next();
            }
            this.token = 1;
            this.next();
        }
    }

    public final void nextToken(int expect) {
        this.sp = 0;
        while (true) {
            switch (expect) {
                case 12: {
                    int index;
                    if (this.ch == '{') {
                        int index2;
                        this.token = 12;
                        this.ch = (char)((index2 = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index2));
                        return;
                    }
                    if (this.ch != '[') break;
                    this.token = 14;
                    this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                    return;
                }
                case 16: {
                    if (this.ch == ',') {
                        int index;
                        this.token = 16;
                        this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                        return;
                    }
                    if (this.ch == '}') {
                        int index;
                        this.token = 13;
                        this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                        return;
                    }
                    if (this.ch == ']') {
                        int index;
                        this.token = 15;
                        this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                        return;
                    }
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 2: {
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 4: {
                    int index;
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                    return;
                }
                case 14: {
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 15: {
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                }
                case 20: {
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 18: {
                    this.nextIdent();
                    return;
                }
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        this.nextToken();
    }

    public final void nextIdent() {
        while (true) {
            boolean whitespace;
            boolean bl = whitespace = this.ch <= ' ' && (this.ch == ' ' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b');
            if (!whitespace) break;
            this.next();
        }
        if (this.ch == '_' || Character.isLetter(this.ch)) {
            this.scanIdent();
        } else {
            this.nextToken();
        }
    }

    public final Number integerValue() throws NumberFormatException {
        int digit;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        int type = 32;
        int charIndex = max - 1;
        int chLocal = charIndex >= this.len ? 26 : (int)this.text.charAt(charIndex);
        switch (chLocal) {
            case 76: {
                --max;
                type = 76;
                break;
            }
            case 83: {
                --max;
                type = 83;
                break;
            }
            case 66: {
                --max;
                type = 66;
                break;
            }
        }
        int n = chLocal = this.np >= this.len ? 26 : (int)this.text.charAt(this.np);
        if (chLocal == 45) {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        if (i < max) {
            chLocal = (charIndex = i++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            digit = chLocal - 48;
            result = -digit;
        }
        while (i < max) {
            chLocal = (charIndex = i++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            digit = chLocal - 48;
            if (result < -922337203685477580L) {
                return new BigInteger(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                if (result >= Integer.MIN_VALUE && type != 76) {
                    if (type == 83) {
                        return (short)result;
                    }
                    if (type == 66) {
                        return (byte)result;
                    }
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((result = -result) <= Integer.MAX_VALUE && type != 76) {
            if (type == 83) {
                return (short)result;
            }
            if (type == 66) {
                return (byte)result;
            }
            return (int)result;
        }
        return result;
    }

    public final String scanSymbol(SymbolTable symbolTable) {
        while (this.ch == ' ' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b') {
            this.next();
        }
        if (this.ch == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.ch == '\'') {
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.ch == '}') {
            this.next();
            this.token = 13;
            return null;
        }
        if (this.ch == ',') {
            this.next();
            this.token = 16;
            return null;
        }
        if (this.ch == '\u001a') {
            this.token = 20;
            return null;
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    public String scanSymbol(SymbolTable symbolTable, char quoteChar) {
        String strVal;
        int i;
        int hash = 0;
        boolean hasSpecial = false;
        int startIndex = this.bp + 1;
        int endIndex = this.text.indexOf(quoteChar, startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str, " + this.info());
        }
        int chars_len = endIndex - startIndex;
        char[] chars = this.sub_chars(this.bp + 1, chars_len);
        while (chars_len > 0 && chars[chars_len - 1] == '\\') {
            int slashCount = 1;
            for (i = chars_len - 2; i >= 0 && chars[i] == '\\'; --i) {
                ++slashCount;
            }
            if (slashCount % 2 == 0) break;
            int nextIndex = this.text.indexOf(quoteChar, endIndex + 1);
            int nextLen = nextIndex - endIndex;
            int next_chars_len = chars_len + nextLen;
            if (next_chars_len >= chars.length) {
                int newLen = chars.length * 3 / 2;
                if (newLen < next_chars_len) {
                    newLen = next_chars_len;
                }
                char[] newChars = new char[newLen];
                System.arraycopy(chars, 0, newChars, 0, chars.length);
                chars = newChars;
            }
            this.text.getChars(endIndex, nextIndex, chars, chars_len);
            chars_len = next_chars_len;
            endIndex = nextIndex;
            hasSpecial = true;
        }
        if (!hasSpecial) {
            for (i = 0; i < chars_len; ++i) {
                char ch = chars[i];
                hash = 31 * hash + ch;
                if (ch != '\\') continue;
                hasSpecial = true;
            }
            strVal = hasSpecial ? JSONLexer.readString(chars, chars_len) : (chars_len < 20 ? symbolTable.addSymbol(chars, 0, chars_len, hash) : new String(chars, 0, chars_len));
        } else {
            strVal = JSONLexer.readString(chars, chars_len);
        }
        int index = this.bp = endIndex + 1;
        this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
        return strVal;
    }

    private static String readString(char[] chars, int chars_len) {
        char[] sbuf = new char[chars_len];
        int len = 0;
        block22: for (int i = 0; i < chars_len; ++i) {
            char ch = chars[i];
            if (ch != '\\') {
                sbuf[len++] = ch;
                continue;
            }
            ch = chars[++i];
            switch (ch) {
                case '0': {
                    sbuf[len++] = '\u0000';
                    continue block22;
                }
                case '1': {
                    sbuf[len++] = '\u0001';
                    continue block22;
                }
                case '2': {
                    sbuf[len++] = 2;
                    continue block22;
                }
                case '3': {
                    sbuf[len++] = 3;
                    continue block22;
                }
                case '4': {
                    sbuf[len++] = 4;
                    continue block22;
                }
                case '5': {
                    sbuf[len++] = 5;
                    continue block22;
                }
                case '6': {
                    sbuf[len++] = 6;
                    continue block22;
                }
                case '7': {
                    sbuf[len++] = 7;
                    continue block22;
                }
                case 'b': {
                    sbuf[len++] = 8;
                    continue block22;
                }
                case 't': {
                    sbuf[len++] = 9;
                    continue block22;
                }
                case 'n': {
                    sbuf[len++] = 10;
                    continue block22;
                }
                case 'v': {
                    sbuf[len++] = 11;
                    continue block22;
                }
                case 'F': 
                case 'f': {
                    sbuf[len++] = 12;
                    continue block22;
                }
                case 'r': {
                    sbuf[len++] = 13;
                    continue block22;
                }
                case '\"': {
                    sbuf[len++] = 34;
                    continue block22;
                }
                case '\'': {
                    sbuf[len++] = 39;
                    continue block22;
                }
                case '/': {
                    sbuf[len++] = 47;
                    continue block22;
                }
                case '\\': {
                    sbuf[len++] = 92;
                    continue block22;
                }
                case 'x': {
                    sbuf[len++] = (char)(digits[chars[++i]] * 16 + digits[chars[++i]]);
                    continue block22;
                }
                case 'u': {
                    sbuf[len++] = (char)Integer.parseInt(new String(new char[]{chars[++i], chars[++i], chars[++i], chars[++i]}), 16);
                    continue block22;
                }
                default: {
                    throw new JSONException("unclosed.str.lit");
                }
            }
        }
        return new String(sbuf, 0, len);
    }

    public String info() {
        return "pos " + this.bp + ", json : " + (this.len < 65536 ? this.text : this.text.substring(0, 65536));
    }

    protected void skipComment() {
        this.next();
        if (this.ch == '/') {
            do {
                this.next();
            } while (this.ch != '\n');
            this.next();
            return;
        }
        if (this.ch == '*') {
            this.next();
            while (this.ch != '\u001a') {
                if (this.ch == '*') {
                    this.next();
                    if (this.ch != '/') continue;
                    this.next();
                    break;
                }
                this.next();
            }
        } else {
            throw new JSONException("invalid comment");
        }
    }

    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char ch;
        boolean firstFlag;
        int first = this.ch;
        boolean bl = firstFlag = this.ch >= firstIdentifierFlags.length || firstIdentifierFlags[first];
        if (!firstFlag) {
            throw new JSONException("illegal identifier : " + this.ch + ", " + this.info());
        }
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        while ((ch = this.next()) >= identifierFlags.length || identifierFlags[ch]) {
            hash = 31 * hash + ch;
            ++this.sp;
        }
        this.ch = this.charAt(this.bp);
        this.token = 18;
        if (this.sp == 4 && this.text.startsWith("null", this.np)) {
            return null;
        }
        return symbolTable.addSymbol(this.text, this.np, this.sp, hash);
    }

    public final void scanString() {
        char quoteChar = this.ch;
        boolean hasSpecial = false;
        int startIndex = this.bp + 1;
        int endIndex = this.text.indexOf(quoteChar, startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str, " + this.info());
        }
        int chars_len = endIndex - startIndex;
        char[] chars = this.sub_chars(this.bp + 1, chars_len);
        while (chars_len > 0 && chars[chars_len - 1] == '\\') {
            int slashCount = 1;
            for (int i = chars_len - 2; i >= 0 && chars[i] == '\\'; --i) {
                ++slashCount;
            }
            if (slashCount % 2 == 0) break;
            int nextIndex = this.text.indexOf(quoteChar, endIndex + 1);
            int nextLen = nextIndex - endIndex;
            int next_chars_len = chars_len + nextLen;
            if (next_chars_len >= chars.length) {
                int newLen = chars.length * 3 / 2;
                if (newLen < next_chars_len) {
                    newLen = next_chars_len;
                }
                char[] newChars = new char[newLen];
                System.arraycopy(chars, 0, newChars, 0, chars.length);
                chars = newChars;
            }
            this.text.getChars(endIndex, nextIndex, chars, chars_len);
            chars_len = next_chars_len;
            endIndex = nextIndex;
            hasSpecial = true;
        }
        if (!hasSpecial) {
            for (int i = 0; i < chars_len; ++i) {
                if (chars[i] != '\\') continue;
                hasSpecial = true;
            }
        }
        this.sbuf = chars;
        this.sp = chars_len;
        this.np = this.bp;
        this.hasSpecial = hasSpecial;
        this.bp = endIndex + 1;
        int index = this.bp;
        this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
        this.token = 4;
    }

    public String scanStringValue(char quoteChar) {
        int index;
        int chars_len;
        int startIndex = this.bp + 1;
        int endIndex = this.text.indexOf(quoteChar, startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str, " + this.info());
        }
        String strVal = null;
        if (V6) {
            strVal = this.text.substring(startIndex, endIndex);
        } else {
            chars_len = endIndex - startIndex;
            char[] chars = this.sub_chars(this.bp + 1, chars_len);
            strVal = new String(chars, 0, chars_len);
        }
        if (strVal.indexOf(92) != -1) {
            while (true) {
                int slashCount = 0;
                for (int i = endIndex - 1; i >= 0 && this.text.charAt(i) == '\\'; --i) {
                    ++slashCount;
                }
                if (slashCount % 2 == 0) break;
                endIndex = this.text.indexOf(quoteChar, endIndex + 1);
            }
            chars_len = endIndex - startIndex;
            char[] chars = this.sub_chars(this.bp + 1, chars_len);
            strVal = JSONLexer.readString(chars, chars_len);
        }
        this.ch = (char)((index = (this.bp = endIndex + 1)) >= this.len ? 26 : (int)this.text.charAt(index));
        return strVal;
    }

    public final int intValue() {
        int digit;
        int charIndex;
        int limit;
        int chLocal;
        int result = 0;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        int n = chLocal = this.np >= this.len ? 26 : (int)this.text.charAt(this.np);
        if (chLocal == 45) {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int multmin = -214748364;
        if (i < max) {
            chLocal = (charIndex = i++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            digit = chLocal - 48;
            result = -digit;
        }
        while (i < max) {
            int ch;
            int n2 = ch = (charIndex = i++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            if (ch == 76 || ch == 83 || ch == 66) break;
            digit = ch - 48;
            if (result < -214748364) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10) < limit + digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    public byte[] bytesValue() {
        return JSONLexer.decodeFast(this.text, this.np + 1, this.sp);
    }

    private void scanIdent() {
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            ++this.sp;
            this.next();
        } while (Character.isLetterOrDigit(this.ch));
        String ident = this.stringVal();
        this.token = ident.equals("null") ? 8 : (ident.equals("true") ? 6 : (ident.equals("false") ? 7 : (ident.equals("new") ? 9 : (ident.equals("undefined") ? 23 : (ident.equals("Set") ? 21 : (ident.equals("TreeSet") ? 22 : 18))))));
    }

    public final String stringVal() {
        return this.hasSpecial ? JSONLexer.readString(this.sbuf, this.sp) : this.subString(this.np + 1, this.sp);
    }

    private final String subString(int offset, int count) {
        if (count < this.sbuf.length) {
            this.text.getChars(offset, offset + count, this.sbuf, 0);
            return new String(this.sbuf, 0, count);
        }
        char[] chars = new char[count];
        this.text.getChars(offset, offset + count, chars, 0);
        return new String(chars);
    }

    final char[] sub_chars(int offset, int count) {
        if (count < this.sbuf.length) {
            this.text.getChars(offset, offset + count, this.sbuf, 0);
            return this.sbuf;
        }
        this.sbuf = new char[count];
        char[] chars = this.sbuf;
        this.text.getChars(offset, offset + count, chars, 0);
        return chars;
    }

    public final boolean isBlankInput() {
        char ch;
        int i = 0;
        while ((ch = this.charAt(i)) != '\u001a') {
            boolean whitespace;
            boolean bl = whitespace = ch <= ' ' && (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f' || ch == '\b');
            if (!whitespace) {
                return false;
            }
            ++i;
        }
        return true;
    }

    final void skipWhitespace() {
        while (this.ch <= '/') {
            if (this.ch == ' ' || this.ch == '\r' || this.ch == '\n' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b') {
                this.next();
                continue;
            }
            if (this.ch != '/') break;
            this.skipComment();
        }
    }

    public final void scanNumber() {
        int index;
        this.np = this.bp++;
        this.exp = false;
        if (this.ch == '-') {
            ++this.sp;
            index = this.bp;
            this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        }
        this.isDouble = false;
        if (this.ch == '.') {
            ++this.sp;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            this.isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            }
        }
        if (this.ch == 'L') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'S') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'B') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'F') {
            ++this.sp;
            this.next();
            this.isDouble = true;
        } else if (this.ch == 'D') {
            ++this.sp;
            this.next();
            this.isDouble = true;
        } else if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            }
            if (this.ch == 'D' || this.ch == 'F') {
                ++this.sp;
                this.next();
            }
            this.exp = true;
            this.isDouble = true;
        }
        this.token = this.isDouble ? 3 : 2;
    }

    public boolean scanBoolean() {
        boolean value;
        int offset;
        if (this.text.startsWith("false", this.bp)) {
            offset = 5;
            value = false;
        } else if (this.text.startsWith("true", this.bp)) {
            offset = 4;
            value = true;
        } else if (this.ch == '1') {
            offset = 1;
            value = true;
        } else if (this.ch == '0') {
            offset = 1;
            value = false;
        } else {
            this.matchStat = -1;
            return false;
        }
        this.bp += offset;
        this.ch = this.charAt(this.bp);
        return value;
    }

    public final Number scanNumberValue() {
        int len;
        long limit;
        boolean negative;
        int start = this.bp++;
        boolean overflow = false;
        Number number = null;
        this.np = 0;
        if (this.ch == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++this.np;
            int index = this.bp;
            this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
        } else {
            negative = false;
            limit = -9223372036854775807L;
        }
        long longValue = 0L;
        int precision = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            int digit = this.ch - 48;
            if (precision < 18) {
                longValue = longValue * 10L - (long)digit;
            } else {
                if (longValue < -922337203685477580L) {
                    overflow = true;
                }
                if ((longValue *= 10L) < limit + (long)digit) {
                    overflow = true;
                }
                longValue -= (long)digit;
            }
            ++this.np;
            int index = ++this.bp;
            this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
            ++precision;
        }
        boolean isDouble = false;
        boolean exp = false;
        int scale = 0;
        if (this.ch == '.') {
            int index;
            isDouble = true;
            ++this.np;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            while (this.ch >= '0' && this.ch <= '9') {
                ++scale;
                int digit = this.ch - 48;
                if (precision < 18) {
                    longValue = longValue * 10L - (long)digit;
                } else {
                    if (longValue < -922337203685477580L) {
                        overflow = true;
                    }
                    if ((longValue *= 10L) < limit + (long)digit) {
                        overflow = true;
                    }
                    longValue -= (long)digit;
                }
                ++this.np;
                index = ++this.bp;
                this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
                ++precision;
            }
            if (!negative) {
                longValue = -longValue;
            }
        } else {
            if (!negative) {
                longValue = -longValue;
            }
            if (this.ch == 'L') {
                ++this.np;
                this.next();
                number = longValue;
            } else if (this.ch == 'S') {
                ++this.np;
                this.next();
                number = (short)longValue;
            } else if (this.ch == 'B') {
                ++this.np;
                this.next();
                number = (byte)longValue;
            } else if (this.ch == 'F') {
                ++this.np;
                this.next();
                number = Float.valueOf(longValue);
            } else if (this.ch == 'D') {
                ++this.np;
                this.next();
                number = longValue;
            }
        }
        int type = 0;
        if (this.ch == 'e' || this.ch == 'E') {
            int index;
            ++this.np;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            if (this.ch == '+' || this.ch == '-') {
                ++this.np;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.np;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            }
            if (this.ch == 'D' || this.ch == 'F') {
                ++this.np;
                type = this.ch;
                this.next();
            }
            exp = true;
        }
        if (!isDouble && !exp) {
            if (overflow) {
                len = this.bp - start;
                char[] chars = new char[len];
                this.text.getChars(start, this.bp, chars, 0);
                String strVal = new String(chars);
                number = new BigInteger(strVal);
            }
            if (number == null) {
                number = longValue > Integer.MIN_VALUE && longValue < Integer.MAX_VALUE ? (Number)((int)longValue) : (Number)longValue;
            }
            return number;
        }
        len = this.bp - start;
        if (type != 0) {
            --len;
        }
        if (!exp && (this.features & Feature.UseBigDecimal.mask) != 0) {
            if (!overflow) {
                number = BigDecimal.valueOf(longValue, scale);
            } else {
                char[] chars;
                if (len < this.sbuf.length) {
                    this.text.getChars(start, start + len, this.sbuf, 0);
                    chars = this.sbuf;
                } else {
                    chars = new char[len];
                    this.text.getChars(start, start + len, chars, 0);
                }
                number = new BigDecimal(chars, 0, len);
            }
        } else {
            char[] chars;
            if (len < this.sbuf.length) {
                this.text.getChars(start, start + len, this.sbuf, 0);
                chars = this.sbuf;
            } else {
                chars = new char[len];
                this.text.getChars(start, start + len, chars, 0);
            }
            try {
                if (len <= 9 && !exp) {
                    char c;
                    int i = 0;
                    if ((c = chars[i++]) == '-' || c == '+') {
                        c = chars[i++];
                    }
                    int intVal = c - 48;
                    int power = 0;
                    while (i < len) {
                        c = chars[i];
                        if (c == '.') {
                            power = 1;
                        } else {
                            int digit = c - 48;
                            intVal = intVal * 10 + digit;
                            if (power != 0) {
                                power *= 10;
                            }
                        }
                        ++i;
                    }
                    if (type == 70) {
                        float floatVal = (float)intVal / (float)power;
                        if (negative) {
                            floatVal = -floatVal;
                        }
                        return Float.valueOf(floatVal);
                    }
                    double doubleVal = (double)intVal / (double)power;
                    if (negative) {
                        doubleVal = -doubleVal;
                    }
                    return doubleVal;
                }
                String strVal = new String(chars, 0, len);
                number = type == 70 ? (Number)Float.valueOf(strVal) : (Number)Double.parseDouble(strVal);
            }
            catch (NumberFormatException ex) {
                throw new JSONException(ex.getMessage() + ", " + this.info(), ex);
            }
        }
        return number;
    }

    public final long scanLongValue() {
        long limit;
        boolean negative;
        this.np = 0;
        if (this.ch == '-') {
            int index;
            negative = true;
            limit = Long.MIN_VALUE;
            ++this.np;
            if ((index = ++this.bp) >= this.len) {
                throw new JSONException("syntax error, " + this.info());
            }
            this.ch = this.text.charAt(index);
        } else {
            negative = false;
            limit = -9223372036854775807L;
        }
        long longValue = 0L;
        while (this.ch >= '0' && this.ch <= '9') {
            int index;
            int digit = this.ch - 48;
            if (longValue < -922337203685477580L) {
                throw new JSONException("error long value, " + longValue + ", " + this.info());
            }
            if ((longValue *= 10L) < limit + (long)digit) {
                throw new JSONException("error long value, " + longValue + ", " + this.info());
            }
            longValue -= (long)digit;
            ++this.np;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        }
        if (!negative) {
            longValue = -longValue;
        }
        return longValue;
    }

    public final long longValue() throws NumberFormatException {
        int digit;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        if (i < max) {
            digit = this.charAt(i++) - 48;
            result = -digit;
        }
        while (i < max) {
            int index;
            int chLocal;
            int n = chLocal = (index = i++) >= this.len ? 26 : (int)this.text.charAt(index);
            if (chLocal == 76 || chLocal == 83 || chLocal == 66) break;
            digit = chLocal - 48;
            if (result < -922337203685477580L) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    public final Number decimalValue(boolean decimal) {
        int charIndex = this.np + this.sp - 1;
        int chLocal = charIndex >= this.len ? 26 : (int)this.text.charAt(charIndex);
        try {
            char[] chars;
            if (chLocal == 70) {
                return Float.valueOf(Float.parseFloat(this.numberString()));
            }
            if (chLocal == 68) {
                return Double.parseDouble(this.numberString());
            }
            if (decimal) {
                return this.decimalValue();
            }
            int index = this.np + this.sp - 1;
            chLocal = this.text.charAt(index);
            int sp = this.sp;
            if (chLocal == 76 || chLocal == 83 || chLocal == 66 || chLocal == 70 || chLocal == 68) {
                --sp;
            }
            int offset = this.np;
            int count = sp;
            if (count < this.sbuf.length) {
                this.text.getChars(offset, offset + count, this.sbuf, 0);
                chars = this.sbuf;
            } else {
                chars = new char[count];
                this.text.getChars(offset, offset + count, chars, 0);
            }
            if (count <= 9 && !this.exp) {
                boolean off;
                char c;
                boolean negative = false;
                int i = 0;
                if ((c = chars[i++]) == '-') {
                    negative = true;
                    c = chars[i++];
                    off = true;
                } else if (c == '+') {
                    c = chars[i++];
                    off = true;
                } else {
                    off = false;
                }
                int intVal = c - 48;
                int power = 0;
                while (i < count) {
                    c = chars[i];
                    if (c == '.') {
                        power = 1;
                    } else {
                        int digit = c - 48;
                        intVal = intVal * 10 + digit;
                        if (power != 0) {
                            power *= 10;
                        }
                    }
                    ++i;
                }
                double doubleVal = (double)intVal / (double)power;
                if (negative) {
                    doubleVal = -doubleVal;
                }
                return doubleVal;
            }
            String str = new String(chars, 0, count);
            return Double.parseDouble(str);
        }
        catch (NumberFormatException ex) {
            throw new JSONException(ex.getMessage() + ", " + this.info());
        }
    }

    public final BigDecimal decimalValue() {
        int index = this.np + this.sp - 1;
        char chLocal = this.text.charAt(index);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        int offset = this.np;
        int count = sp;
        if (count < this.sbuf.length) {
            this.text.getChars(offset, offset + count, this.sbuf, 0);
            return new BigDecimal(this.sbuf, 0, count);
        }
        char[] chars = new char[count];
        this.text.getChars(offset, offset + count, chars, 0);
        return new BigDecimal(chars);
    }

    public boolean matchField(long fieldHashCode) {
        int chLocal;
        int charIndex;
        int offset;
        block10: {
            offset = 1;
            char fieldQuote = this.ch;
            int fieldStartIndex = this.bp + 1;
            while (fieldQuote != '\"' && fieldQuote != '\'') {
                if (fieldQuote <= ' ' && (fieldQuote == ' ' || fieldQuote == '\n' || fieldQuote == '\r' || fieldQuote == '\t' || fieldQuote == '\f' || fieldQuote == '\b')) {
                    fieldQuote = (charIndex = this.bp + offset++) >= this.len ? (char)'\u001a' : (char)this.text.charAt(charIndex);
                    continue;
                }
                this.fieldHash = 0L;
                this.matchStat = -2;
                return false;
            }
            long hash = -3750763034362895579L;
            for (int i = fieldStartIndex; i < this.len; ++i) {
                char ch = this.text.charAt(i);
                if (ch == fieldQuote) {
                    offset += i - fieldStartIndex + 1;
                    break;
                }
                hash ^= (long)ch;
                hash *= 1099511628211L;
            }
            if (hash != fieldHashCode) {
                this.matchStat = -2;
                this.fieldHash = hash;
                return false;
            }
            int n = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            while (true) {
                if (chLocal == 58) break block10;
                if (chLocal > 32 || chLocal != 32 && chLocal != 10 && chLocal != 13 && chLocal != 9 && chLocal != 12 && chLocal != 8) break;
                chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            }
            throw new JSONException("match feild error expect ':'");
        }
        chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (chLocal == 123) {
            this.bp = charIndex + 1;
            this.ch = (char)(this.bp >= this.len ? 26 : (int)this.text.charAt(this.bp));
            this.token = 12;
        } else if (chLocal == 91) {
            this.bp = charIndex + 1;
            this.ch = (char)(this.bp >= this.len ? 26 : (int)this.text.charAt(this.bp));
            this.token = 14;
        } else {
            this.bp = charIndex;
            this.ch = (char)(this.bp >= this.len ? 26 : (int)this.text.charAt(this.bp));
            this.nextToken();
        }
        return true;
    }

    private int matchFieldHash(long fieldHashCode) {
        int chLocal;
        int charIndex;
        int offset = 1;
        char fieldQuote = this.ch;
        int fieldStartIndex = this.bp + 1;
        while (fieldQuote != '\"' && fieldQuote != '\'') {
            if (fieldQuote == ' ' || fieldQuote == '\n' || fieldQuote == '\r' || fieldQuote == '\t' || fieldQuote == '\f' || fieldQuote == '\b') {
                fieldQuote = (charIndex = this.bp + offset++) >= this.len ? (char)'\u001a' : this.text.charAt(charIndex);
                continue;
            }
            this.fieldHash = 0L;
            this.matchStat = -2;
            return 0;
        }
        long hash = -3750763034362895579L;
        for (int i = this.bp + offset; i < this.len; ++i) {
            char ch = this.text.charAt(i);
            if (ch == fieldQuote) {
                offset += i - this.bp - offset;
                break;
            }
            hash ^= (long)ch;
            hash *= 1099511628211L;
        }
        if (hash != fieldHashCode) {
            this.fieldHash = hash;
            this.matchStat = -2;
            return 0;
        }
        int n = chLocal = (charIndex = this.bp + ++offset) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        while (chLocal != 58) {
            if (chLocal <= 32 && (chLocal == 32 || chLocal == 10 || chLocal == 13 || chLocal == 9 || chLocal == 12 || chLocal == 8)) {
                chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                continue;
            }
            throw new JSONException("match feild error expect ':'");
        }
        return ++offset;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanFieldInt(long fieldHashCode) {
        int n;
        int index;
        boolean negative;
        boolean quote;
        int charIndex;
        this.matchStat = 0;
        int offset = this.matchFieldHash(fieldHashCode);
        if (offset == 0) {
            return 0;
        }
        int chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        boolean bl = quote = chLocal == 34;
        if (quote) {
            quote = true;
            chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        }
        boolean bl2 = negative = chLocal == 45;
        if (negative) {
            int n2 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        }
        if (chLocal < 48 || chLocal > 57) {
            this.matchStat = -1;
            return 0;
        }
        int value = chLocal - 48;
        while (true) {
            int n3 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            if (chLocal < 48 || chLocal > 57) break;
            value = value * 10 + (chLocal - 48);
        }
        if (chLocal == 46) {
            this.matchStat = -1;
            return 0;
        }
        if (chLocal == 34) {
            if (!quote) {
                this.matchStat = -1;
                return 0;
            }
            int n4 = chLocal = (index = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index);
        }
        if (value < 0) {
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (chLocal == 44) {
                int n5;
                this.bp += offset - 1;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                this.matchStat = 3;
                this.token = 16;
                if (negative) {
                    n5 = -value;
                    return n5;
                }
                n5 = value;
                return n5;
            }
            if (chLocal > 32 || chLocal != 32 && chLocal != 10 && chLocal != 13 && chLocal != 9 && chLocal != 12 && chLocal != 8) break;
            chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return 0;
        }
        if ((chLocal = (int)this.charAt(this.bp + offset++)) == 44) {
            this.token = 16;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return 0;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        if (!negative) {
            n = value;
            return n;
        }
        n = -value;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int[] scanFieldIntArray(long fieldHashCode) {
        int charIndex;
        int chLocal;
        this.matchStat = 0;
        int offset = this.matchFieldHash(fieldHashCode);
        if (offset == 0) {
            return null;
        }
        int n = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (chLocal != 91) {
            this.matchStat = -1;
            return null;
        }
        chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        int[] array = new int[16];
        int arrayIndex = 0;
        if (chLocal == 93) {
            chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        } else {
            while (true) {
                boolean nagative = false;
                if (chLocal == 45) {
                    chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    nagative = true;
                }
                if (chLocal < 48 || chLocal > 57) {
                    this.matchStat = -1;
                    return null;
                }
                int value = chLocal - 48;
                while (true) {
                    int n2 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    if (chLocal < 48 || chLocal > 57) break;
                    value = value * 10 + (chLocal - 48);
                }
                if (arrayIndex >= array.length) {
                    int[] tmp = new int[array.length * 3 / 2];
                    System.arraycopy(array, 0, tmp, 0, arrayIndex);
                    array = tmp;
                }
                int n3 = array[arrayIndex++] = nagative ? -value : value;
                if (chLocal == 44) {
                    chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    continue;
                }
                if (chLocal == 93) break;
            }
            int n4 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        }
        if (arrayIndex != array.length) {
            int[] tmp = new int[arrayIndex];
            System.arraycopy(array, 0, tmp, 0, arrayIndex);
            array = tmp;
        }
        if (chLocal == 44) {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return array;
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return null;
        }
        if ((chLocal = (int)this.charAt(this.bp + offset++)) == 44) {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return null;
            }
            this.bp += offset - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return array;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(long fieldHashCode) {
        long l;
        int index;
        boolean negative;
        boolean quote;
        int index2;
        this.matchStat = 0;
        int offset = this.matchFieldHash(fieldHashCode);
        if (offset == 0) {
            return 0L;
        }
        int chLocal = (index2 = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index2);
        boolean bl = quote = chLocal == 34;
        if (quote) {
            int index3;
            chLocal = (index3 = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index3);
        }
        boolean bl2 = negative = chLocal == 45;
        if (negative) {
            int n = chLocal = (index = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index);
        }
        if (chLocal < 48 || chLocal > 57) {
            this.matchStat = -1;
            return 0L;
        }
        long value = chLocal - 48;
        while (true) {
            int n = chLocal = (index = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index);
            if (chLocal < 48 || chLocal > 57) break;
            value = value * 10L + (long)(chLocal - 48);
        }
        if (chLocal == 46) {
            this.matchStat = -1;
            return 0L;
        }
        if (chLocal == 34) {
            if (!quote) {
                this.matchStat = -1;
                return 0L;
            }
            int n = chLocal = (index = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index);
        }
        if (value < 0L) {
            this.matchStat = -1;
            return 0L;
        }
        if (chLocal == 44) {
            long l2;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            this.matchStat = 3;
            this.token = 16;
            if (negative) {
                l2 = -value;
                return l2;
            }
            l2 = value;
            return l2;
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return 0L;
        }
        if ((chLocal = (int)this.charAt(this.bp + offset++)) == 44) {
            this.token = 16;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        if (!negative) {
            l = value;
            return l;
        }
        l = -value;
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(long fieldHashCode) {
        int charIndex;
        int index;
        String strVal;
        int endIndex;
        int chLocal;
        block22: {
            char[] chars;
            int chars_len;
            int index2;
            this.matchStat = 0;
            int offset = this.matchFieldHash(fieldHashCode);
            if (offset == 0) {
                return null;
            }
            if ((index2 = this.bp + offset++) >= this.len) {
                throw new JSONException("unclosed str, " + this.info());
            }
            chLocal = this.text.charAt(index2);
            if (chLocal != 34) {
                this.matchStat = -1;
                return this.stringDefaultValue;
            }
            int quoteChar = 34;
            boolean hasSpecial = false;
            int startIndex = this.bp + offset;
            endIndex = this.text.indexOf(34, startIndex);
            if (endIndex == -1) {
                throw new JSONException("unclosed str, " + this.info());
            }
            strVal = null;
            if (V6) {
                strVal = this.text.substring(startIndex, endIndex);
            } else {
                chars_len = endIndex - startIndex;
                chars = this.sub_chars(this.bp + offset, chars_len);
                strVal = new String(chars, 0, chars_len);
            }
            if (strVal.indexOf(92) != -1) {
                block21: {
                    while (true) {
                        int slashCount = 0;
                        for (int i = endIndex - 1; i >= 0 && this.text.charAt(i) == '\\'; ++slashCount, --i) {
                            hasSpecial = true;
                        }
                        if (slashCount % 2 == 0) {
                            chars_len = endIndex - startIndex;
                            chars = this.sub_chars(this.bp + offset, chars_len);
                            if (hasSpecial) {
                                break;
                            }
                            break block21;
                        }
                        endIndex = this.text.indexOf(34, endIndex + 1);
                    }
                    strVal = JSONLexer.readString(chars, chars_len);
                    break block22;
                }
                strVal = new String(chars, 0, chars_len);
                if (strVal.indexOf(92) != -1) {
                    strVal = JSONLexer.readString(chars, chars_len);
                }
            }
        }
        int n = chLocal = (index = ++endIndex) >= this.len ? 26 : (int)this.text.charAt(index);
        if (chLocal == 44) {
            this.bp = endIndex;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            this.matchStat = 3;
            this.token = 16;
            return strVal;
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return this.stringDefaultValue;
        }
        int n2 = chLocal = (charIndex = ++endIndex) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (chLocal == 44) {
            this.token = 16;
            this.bp = endIndex;
            this.next();
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp = endIndex;
            this.next();
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp = endIndex;
            this.next();
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return this.stringDefaultValue;
            }
            this.token = 20;
            this.bp = endIndex;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return strVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Date scanFieldDate(long fieldHashCode) {
        int index;
        Date dateVal;
        int index2;
        int chLocal;
        this.matchStat = 0;
        int offset = this.matchFieldHash(fieldHashCode);
        if (offset == 0) {
            return null;
        }
        int startPos = this.bp;
        char startChar = this.ch;
        int n = chLocal = (index2 = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index2);
        if (chLocal == 34) {
            int index3;
            boolean quote = true;
            int startIndex = this.bp + offset;
            chLocal = (index3 = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index3);
            int endIndex = this.text.indexOf(34, this.bp + offset);
            if (endIndex == -1) {
                throw new JSONException("unclosed str");
            }
            int rest = endIndex - startIndex;
            this.bp = startIndex;
            if (!this.scanISO8601DateIfMatch(false, rest)) {
                this.bp = startPos;
                this.matchStat = -1;
                return null;
            }
            dateVal = this.calendar.getTime();
            offset += rest;
            chLocal = this.charAt(startPos + offset++);
            this.bp = startPos;
        } else {
            if (chLocal < 48 || chLocal > 57) {
                this.matchStat = -1;
                return null;
            }
            long millis = chLocal - 48;
            while (true) {
                int n2 = chLocal = (index = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index);
                if (chLocal < 48 || chLocal > 57) break;
                millis = millis * 10L + (long)(chLocal - 48);
            }
            if (chLocal == 46) {
                this.matchStat = -1;
                return null;
            }
            if (chLocal == 34) {
                int n3 = chLocal = (index = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index);
            }
            if (millis < 0L) {
                this.matchStat = -1;
                return null;
            }
            dateVal = new Date(millis);
        }
        if (chLocal == 44) {
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            this.matchStat = 3;
            this.token = 16;
            return dateVal;
        }
        if (chLocal != 125) {
            this.bp = startPos;
            this.ch = startChar;
            this.matchStat = -1;
            return null;
        }
        if ((chLocal = (int)this.charAt(this.bp + offset++)) == 44) {
            this.token = 16;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else {
            if (chLocal != 26) {
                this.bp = startPos;
                this.ch = startChar;
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return dateVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean scanFieldBoolean(long fieldHashCode) {
        int chLocal;
        boolean value;
        this.matchStat = 0;
        int offset = this.matchFieldHash(fieldHashCode);
        if (offset == 0) {
            return false;
        }
        if (this.text.startsWith("false", this.bp + offset)) {
            offset += 5;
            value = false;
        } else if (this.text.startsWith("true", this.bp + offset)) {
            offset += 4;
            value = true;
        } else if (this.text.startsWith("\"false\"", this.bp + offset)) {
            offset += 7;
            value = false;
        } else if (this.text.startsWith("\"true\"", this.bp + offset)) {
            offset += 6;
            value = true;
        } else if (this.text.charAt(this.bp + offset) == '1') {
            value = true;
        } else if (this.text.charAt(this.bp + offset) == '0') {
            ++offset;
            value = false;
        } else if (this.text.startsWith("\"1\"", this.bp + offset)) {
            offset += 3;
            value = true;
        } else {
            if (!this.text.startsWith("\"0\"", this.bp + offset)) {
                this.matchStat = -1;
                return false;
            }
            offset += 3;
            value = false;
        }
        int n = ++offset;
        ++offset;
        int charIndex = this.bp + n;
        int n2 = chLocal = charIndex >= this.len ? 26 : (int)this.text.charAt(charIndex);
        while (true) {
            if (chLocal == 44) {
                int index;
                this.bp += offset - 1;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                this.matchStat = 3;
                this.token = 16;
                return value;
            }
            if (chLocal == 125 || chLocal != 32 && chLocal != 10 && chLocal != 13 && chLocal != 9 && chLocal != 12 && chLocal != 8) break;
            chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return false;
        }
        if ((chLocal = (int)this.charAt(this.bp + offset++)) == 44) {
            int index;
            this.token = 16;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 93) {
            int index;
            this.token = 15;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 125) {
            int index;
            this.token = 13;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return false;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final float scanFieldFloat(long fieldHashCode) {
        float value;
        char chLocal;
        int offset;
        block23: {
            block22: {
                boolean exp;
                boolean small;
                boolean negative;
                this.matchStat = 0;
                offset = this.matchFieldHash(fieldHashCode);
                if (offset == 0) {
                    return 0.0f;
                }
                chLocal = this.charAt(this.bp + offset++);
                int start = this.bp + offset - 1;
                boolean bl = negative = chLocal == '-';
                if (negative) {
                    chLocal = this.charAt(this.bp + offset++);
                }
                if (chLocal < '0' || chLocal > '9') break block22;
                int intVal = chLocal - 48;
                while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                    intVal = intVal * 10 + (chLocal - 48);
                }
                int power = 1;
                boolean bl2 = small = chLocal == '.';
                if (small) {
                    if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                        intVal = intVal * 10 + (chLocal - 48);
                        power = 10;
                        while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            intVal = intVal * 10 + (chLocal - 48);
                            power *= 10;
                        }
                    } else {
                        this.matchStat = -1;
                        return 0.0f;
                    }
                }
                boolean bl3 = exp = chLocal == 'e' || chLocal == 'E';
                if (exp) {
                    if ((chLocal = this.charAt(this.bp + offset++)) == '+' || chLocal == '-') {
                        chLocal = this.charAt(this.bp + offset++);
                    }
                    while (chLocal >= '0' && chLocal <= '9') {
                        chLocal = this.charAt(this.bp + offset++);
                    }
                }
                int count = this.bp + offset - start - 1;
                if (!exp && count < 10) {
                    value = (float)intVal / (float)power;
                    if (negative) {
                        value = -value;
                    }
                    break block23;
                } else {
                    String text = this.subString(start, count);
                    value = Float.parseFloat(text);
                }
                break block23;
            }
            this.matchStat = -1;
            return 0.0f;
        }
        if (chLocal == ',') {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0.0f;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0.0f;
            }
            this.bp += offset - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final float[] scanFieldFloatArray(long fieldHashCode) {
        int charIndex;
        int chLocal;
        this.matchStat = 0;
        int offset = this.matchFieldHash(fieldHashCode);
        if (offset == 0) {
            return null;
        }
        int n = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (chLocal != 91) {
            this.matchStat = -1;
            return null;
        }
        chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        float[] array = new float[16];
        int arrayIndex = 0;
        while (true) {
            float value;
            boolean exp;
            boolean small;
            boolean negative;
            int start = this.bp + offset - 1;
            boolean bl = negative = chLocal == 45;
            if (negative) {
                int n2 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            }
            if (chLocal < 48 || chLocal > 57) {
                this.matchStat = -1;
                return null;
            }
            int intVal = chLocal - 48;
            while (true) {
                int n3 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                if (chLocal < 48 || chLocal > 57) break;
                intVal = intVal * 10 + (chLocal - 48);
            }
            int power = 1;
            boolean bl2 = small = chLocal == 46;
            if (small) {
                chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                power *= 10;
                if (chLocal < 48 || chLocal > 57) {
                    this.matchStat = -1;
                    return null;
                }
                intVal = intVal * 10 + (chLocal - 48);
                while (true) {
                    int n4 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    if (chLocal < 48 || chLocal > 57) break;
                    intVal = intVal * 10 + (chLocal - 48);
                    power *= 10;
                }
            }
            boolean bl3 = exp = chLocal == 101 || chLocal == 69;
            if (exp) {
                int n5 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                if (chLocal == 43 || chLocal == 45) {
                    int n6 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                }
                while (chLocal >= 48 && chLocal <= 57) {
                    chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                }
            }
            int count = this.bp + offset - start - 1;
            if (!exp && count < 10) {
                value = (float)intVal / (float)power;
                if (negative) {
                    value = -value;
                }
            } else {
                String text = this.subString(start, count);
                value = Float.parseFloat(text);
            }
            if (arrayIndex >= array.length) {
                float[] tmp = new float[array.length * 3 / 2];
                System.arraycopy(array, 0, tmp, 0, arrayIndex);
                array = tmp;
            }
            array[arrayIndex++] = value;
            if (chLocal == 44) {
                chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                continue;
            }
            if (chLocal == 93) break;
        }
        int n7 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (arrayIndex != array.length) {
            float[] tmp = new float[arrayIndex];
            System.arraycopy(array, 0, tmp, 0, arrayIndex);
            array = tmp;
        }
        if (chLocal == 44) {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return array;
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return null;
        }
        int n8 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (chLocal == 44) {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return null;
            }
            this.bp += offset - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return array;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final float[][] scanFieldFloatArray2(long fieldHashCode) {
        int charIndex;
        int chLocal;
        this.matchStat = 0;
        int offset = this.matchFieldHash(fieldHashCode);
        if (offset == 0) {
            return null;
        }
        int n = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (chLocal != 91) {
            this.matchStat = -1;
            return null;
        }
        chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        float[][] arrayarray = new float[16][];
        int arrayarrayIndex = 0;
        while (true) {
            if (chLocal != 91) continue;
            chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            float[] array = new float[16];
            int arrayIndex = 0;
            while (true) {
                float value;
                boolean exp;
                boolean negative;
                int start = this.bp + offset - 1;
                boolean bl = negative = chLocal == 45;
                if (negative) {
                    int n2 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                }
                if (chLocal < 48 || chLocal > 57) {
                    this.matchStat = -1;
                    return null;
                }
                int intVal = chLocal - 48;
                while (true) {
                    int n3 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    if (chLocal < 48 || chLocal > 57) break;
                    intVal = intVal * 10 + (chLocal - 48);
                }
                int power = 1;
                if (chLocal == 46) {
                    int n4 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    if (chLocal >= 48 && chLocal <= 57) {
                        intVal = intVal * 10 + (chLocal - 48);
                        power *= 10;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                    while (true) {
                        int n5 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                        if (chLocal < 48 || chLocal > 57) break;
                        intVal = intVal * 10 + (chLocal - 48);
                        power *= 10;
                    }
                }
                boolean bl2 = exp = chLocal == 101 || chLocal == 69;
                if (exp) {
                    int n6 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    if (chLocal == 43 || chLocal == 45) {
                        int n7 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    }
                    while (chLocal >= 48 && chLocal <= 57) {
                        chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    }
                }
                int count = this.bp + offset - start - 1;
                if (!exp && count < 10) {
                    value = (float)intVal / (float)power;
                    if (negative) {
                        value = -value;
                    }
                } else {
                    String text = this.subString(start, count);
                    value = Float.parseFloat(text);
                }
                if (arrayIndex >= array.length) {
                    float[] tmp = new float[array.length * 3 / 2];
                    System.arraycopy(array, 0, tmp, 0, arrayIndex);
                    array = tmp;
                }
                array[arrayIndex++] = value;
                if (chLocal == 44) {
                    chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    continue;
                }
                if (chLocal == 93) break;
            }
            int n8 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            if (arrayIndex != array.length) {
                float[] tmp = new float[arrayIndex];
                System.arraycopy(array, 0, tmp, 0, arrayIndex);
                array = tmp;
            }
            if (arrayarrayIndex >= arrayarray.length) {
                float[][] tmp = new float[arrayarray.length * 3 / 2][];
                System.arraycopy(array, 0, tmp, 0, arrayIndex);
                arrayarray = tmp;
            }
            arrayarray[arrayarrayIndex++] = array;
            if (chLocal == 44) {
                chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                continue;
            }
            if (chLocal == 93) break;
        }
        int n9 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (arrayarrayIndex != arrayarray.length) {
            float[][] tmp = new float[arrayarrayIndex][];
            System.arraycopy(arrayarray, 0, tmp, 0, arrayarrayIndex);
            arrayarray = tmp;
        }
        if (chLocal == 44) {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return arrayarray;
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return null;
        }
        if ((chLocal = (int)this.charAt(this.bp + offset++)) == 44) {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return null;
            }
            this.bp += offset - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return arrayarray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final double scanFieldDouble(long fieldHashCode) {
        double value;
        char chLocal;
        int offset;
        block23: {
            block22: {
                boolean exp;
                boolean small;
                boolean negative;
                this.matchStat = 0;
                offset = this.matchFieldHash(fieldHashCode);
                if (offset == 0) {
                    return 0.0;
                }
                chLocal = this.charAt(this.bp + offset++);
                int start = this.bp + offset - 1;
                boolean bl = negative = chLocal == '-';
                if (negative) {
                    chLocal = this.charAt(this.bp + offset++);
                }
                if (chLocal < '0' || chLocal > '9') break block22;
                int intVal = chLocal - 48;
                while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                    intVal = intVal * 10 + (chLocal - 48);
                }
                int power = 1;
                boolean bl2 = small = chLocal == '.';
                if (small) {
                    if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                        intVal = intVal * 10 + (chLocal - 48);
                        power *= 10;
                        while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            intVal = intVal * 10 + (chLocal - 48);
                            power *= 10;
                        }
                    } else {
                        this.matchStat = -1;
                        return 0.0;
                    }
                }
                boolean bl3 = exp = chLocal == 'e' || chLocal == 'E';
                if (exp) {
                    if ((chLocal = this.charAt(this.bp + offset++)) == '+' || chLocal == '-') {
                        chLocal = this.charAt(this.bp + offset++);
                    }
                    while (chLocal >= '0' && chLocal <= '9') {
                        chLocal = this.charAt(this.bp + offset++);
                    }
                }
                int count = this.bp + offset - start - 1;
                if (!exp && count < 10) {
                    value = (double)intVal / (double)power;
                    if (negative) {
                        value = -value;
                    }
                    break block23;
                } else {
                    String text = this.subString(start, count);
                    value = Double.parseDouble(text);
                }
                break block23;
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (chLocal == ',') {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0.0;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0.0;
            }
            this.bp += offset - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final double[] scanFieldDoubleArray(long fieldHashCode) {
        int charIndex;
        int chLocal;
        this.matchStat = 0;
        int offset = this.matchFieldHash(fieldHashCode);
        if (offset == 0) {
            return null;
        }
        int n = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (chLocal != 91) {
            this.matchStat = -1;
            return null;
        }
        chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        double[] array = new double[16];
        int arrayIndex = 0;
        while (true) {
            double value;
            boolean exp;
            boolean small;
            boolean negative;
            int start = this.bp + offset - 1;
            boolean bl = negative = chLocal == 45;
            if (negative) {
                int n2 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            }
            if (chLocal < 48 || chLocal > 57) {
                this.matchStat = -1;
                return null;
            }
            int intVal = chLocal - 48;
            while (true) {
                int n3 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                if (chLocal < 48 || chLocal > 57) break;
                intVal = intVal * 10 + (chLocal - 48);
            }
            int power = 1;
            boolean bl2 = small = chLocal == 46;
            if (small) {
                chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                power *= 10;
                if (chLocal < 48 || chLocal > 57) {
                    this.matchStat = -1;
                    return null;
                }
                intVal = intVal * 10 + (chLocal - 48);
                while (true) {
                    int n4 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    if (chLocal < 48 || chLocal > 57) break;
                    intVal = intVal * 10 + (chLocal - 48);
                    power *= 10;
                }
            }
            boolean bl3 = exp = chLocal == 101 || chLocal == 69;
            if (exp) {
                int n5 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                if (chLocal == 43 || chLocal == 45) {
                    int n6 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                }
                while (chLocal >= 48 && chLocal <= 57) {
                    chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                }
            }
            int count = this.bp + offset - start - 1;
            if (!exp && count < 10) {
                value = (double)intVal / (double)power;
                if (negative) {
                    value = -value;
                }
            } else {
                String text = this.subString(start, count);
                value = Double.parseDouble(text);
            }
            if (arrayIndex >= array.length) {
                double[] tmp = new double[array.length * 3 / 2];
                System.arraycopy(array, 0, tmp, 0, arrayIndex);
                array = tmp;
            }
            array[arrayIndex++] = value;
            if (chLocal == 44) {
                chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                continue;
            }
            if (chLocal == 93) break;
        }
        int n7 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (arrayIndex != array.length) {
            double[] tmp = new double[arrayIndex];
            System.arraycopy(array, 0, tmp, 0, arrayIndex);
            array = tmp;
        }
        if (chLocal == 44) {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return array;
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return null;
        }
        int n8 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (chLocal == 44) {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return null;
            }
            this.bp += offset - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return array;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final double[][] scanFieldDoubleArray2(long fieldHashCode) {
        int charIndex;
        int chLocal;
        this.matchStat = 0;
        int offset = this.matchFieldHash(fieldHashCode);
        if (offset == 0) {
            return null;
        }
        int n = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (chLocal != 91) {
            this.matchStat = -1;
            return null;
        }
        chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        double[][] arrayarray = new double[16][];
        int arrayarrayIndex = 0;
        while (true) {
            if (chLocal != 91) continue;
            chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            double[] array = new double[16];
            int arrayIndex = 0;
            while (true) {
                double value;
                boolean exp;
                boolean negative;
                int start = this.bp + offset - 1;
                boolean bl = negative = chLocal == 45;
                if (negative) {
                    int n2 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                }
                if (chLocal < 48 || chLocal > 57) {
                    this.matchStat = -1;
                    return null;
                }
                int intVal = chLocal - 48;
                while (true) {
                    int n3 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    if (chLocal < 48 || chLocal > 57) break;
                    intVal = intVal * 10 + (chLocal - 48);
                }
                int power = 1;
                if (chLocal == 46) {
                    int n4 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    if (chLocal >= 48 && chLocal <= 57) {
                        intVal = intVal * 10 + (chLocal - 48);
                        power *= 10;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                    while (true) {
                        int n5 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                        if (chLocal < 48 || chLocal > 57) break;
                        intVal = intVal * 10 + (chLocal - 48);
                        power *= 10;
                    }
                }
                boolean bl2 = exp = chLocal == 101 || chLocal == 69;
                if (exp) {
                    int n6 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    if (chLocal == 43 || chLocal == 45) {
                        int n7 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    }
                    while (chLocal >= 48 && chLocal <= 57) {
                        chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    }
                }
                int count = this.bp + offset - start - 1;
                if (!exp && count < 10) {
                    value = (double)intVal / (double)power;
                    if (negative) {
                        value = -value;
                    }
                } else {
                    String text = this.subString(start, count);
                    value = Double.parseDouble(text);
                }
                if (arrayIndex >= array.length) {
                    double[] tmp = new double[array.length * 3 / 2];
                    System.arraycopy(array, 0, tmp, 0, arrayIndex);
                    array = tmp;
                }
                array[arrayIndex++] = value;
                if (chLocal == 44) {
                    chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    continue;
                }
                if (chLocal == 93) break;
            }
            int n8 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
            if (arrayIndex != array.length) {
                double[] tmp = new double[arrayIndex];
                System.arraycopy(array, 0, tmp, 0, arrayIndex);
                array = tmp;
            }
            if (arrayarrayIndex >= arrayarray.length) {
                double[][] tmp = new double[arrayarray.length * 3 / 2][];
                System.arraycopy(array, 0, tmp, 0, arrayIndex);
                arrayarray = tmp;
            }
            arrayarray[arrayarrayIndex++] = array;
            if (chLocal == 44) {
                chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                continue;
            }
            if (chLocal == 93) break;
        }
        int n9 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (arrayarrayIndex != arrayarray.length) {
            double[][] tmp = new double[arrayarrayIndex][];
            System.arraycopy(arrayarray, 0, tmp, 0, arrayarrayIndex);
            arrayarray = tmp;
        }
        if (chLocal == 44) {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return arrayarray;
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return null;
        }
        if ((chLocal = (int)this.charAt(this.bp + offset++)) == 44) {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return null;
            }
            this.bp += offset - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return arrayarray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldSymbol(long fieldHashCode) {
        long hash;
        int charIndex;
        int chLocal;
        int offset;
        block12: {
            int index;
            block13: {
                this.matchStat = 0;
                offset = this.matchFieldHash(fieldHashCode);
                if (offset == 0) {
                    return 0L;
                }
                int n = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                if (chLocal != 34) {
                    this.matchStat = -1;
                    return 0L;
                }
                hash = -3750763034362895579L;
                int start = this.bp + offset;
                do {
                    int n2 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                    if (chLocal == 34) {
                        int n3 = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
                        if (chLocal != 44) break block12;
                        break block13;
                    }
                    hash ^= (long)chLocal;
                    hash *= 1099511628211L;
                } while (chLocal != 92);
                this.matchStat = -1;
                return 0L;
            }
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            this.matchStat = 3;
            return hash;
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return 0L;
        }
        int n = chLocal = (charIndex = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(charIndex);
        if (chLocal == 44) {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return hash;
    }

    public boolean scanISO8601DateIfMatch(boolean strict) {
        return this.scanISO8601DateIfMatch(strict, this.len - this.bp);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean scanISO8601DateIfMatch(boolean strict, int rest) {
        char S2;
        char S1;
        char s1;
        char s0;
        char m1;
        char m0;
        char h1;
        void var18_39;
        void var15_29;
        int d1;
        int d0;
        char M1;
        char M0;
        int y2;
        int y1;
        char c10;
        if (!strict && rest > 13) {
            char c0 = this.charAt(this.bp);
            char c1 = this.charAt(this.bp + 1);
            char c2 = this.charAt(this.bp + 2);
            char c3 = this.charAt(this.bp + 3);
            char c4 = this.charAt(this.bp + 4);
            char c5 = this.charAt(this.bp + 5);
            char c_r0 = this.charAt(this.bp + rest - 1);
            char c_r1 = this.charAt(this.bp + rest - 2);
            if (c0 == '/' && c1 == 'D' && c2 == 'a' && c3 == 't' && c4 == 'e' && c5 == '(' && c_r0 == '/' && c_r1 == ')') {
                int plusIndex = -1;
                for (int i = 6; i < rest; ++i) {
                    char c = this.charAt(this.bp + i);
                    if (c == '+') {
                        plusIndex = i;
                        continue;
                    }
                    if (c < '0' || c > '9') break;
                }
                if (plusIndex == -1) {
                    return false;
                }
                int offset = this.bp + 6;
                String numberText = this.subString(offset, plusIndex - offset);
                long millis = Long.parseLong(numberText);
                this.calendar = Calendar.getInstance(this.timeZone, this.locale);
                this.calendar.setTimeInMillis(millis);
                this.token = 5;
                return true;
            }
        }
        if (rest == 8 || rest == 14 || rest == 16 && ((c10 = this.charAt(this.bp + 10)) == 'T' || c10 == ' ') || rest == 17 && this.charAt(this.bp + 6) != '-') {
            int seconds;
            int minute;
            int hour;
            int millis;
            char d12;
            char d02;
            char M12;
            char M02;
            char y3;
            char y22;
            char y12;
            char y0;
            boolean sperate17;
            if (strict) {
                return false;
            }
            char c0 = this.charAt(this.bp);
            char c1 = this.charAt(this.bp + 1);
            char c2 = this.charAt(this.bp + 2);
            char c = this.charAt(this.bp + 3);
            char c4 = this.charAt(this.bp + 4);
            char c5 = this.charAt(this.bp + 5);
            char c3 = this.charAt(this.bp + 6);
            char c7 = this.charAt(this.bp + 7);
            char c8 = this.charAt(this.bp + 8);
            boolean c_47 = c4 == '-' && c7 == '-';
            boolean sperate16 = c_47 && rest == 16;
            boolean bl = sperate17 = c_47 && rest == 17;
            if (sperate17 || sperate16) {
                y0 = c0;
                y12 = c1;
                y22 = c2;
                y3 = c;
                M02 = c5;
                M12 = c3;
                d02 = c8;
                d12 = this.charAt(this.bp + 9);
            } else {
                y0 = c0;
                y12 = c1;
                y22 = c2;
                y3 = c;
                M02 = c4;
                M12 = c5;
                d02 = c3;
                d12 = c7;
            }
            if (!JSONLexer.checkDate(y0, y12, y22, y3, M02, M12, d02, d12)) {
                return false;
            }
            this.setCalendar(y0, y12, y22, y3, M02, M12, d02, d12);
            if (rest != 8) {
                int s12;
                int s02;
                char m12;
                char m02;
                int h12;
                char h0;
                int c9 = this.charAt(this.bp + 9);
                c10 = this.charAt(this.bp + 10);
                char c11 = this.charAt(this.bp + 11);
                int c12 = this.charAt(this.bp + 12);
                int c13 = this.charAt(this.bp + 13);
                if (sperate17 && c10 == 'T' && c13 == 58 && this.charAt(this.bp + 16) == 'Z' || sperate16 && (c10 == ' ' || c10 == 'T') && c13 == 58) {
                    h0 = c11;
                    h12 = c12;
                    m02 = this.charAt(this.bp + 14);
                    m12 = this.charAt(this.bp + 15);
                    s02 = 48;
                    s12 = 48;
                } else {
                    h0 = c8;
                    h12 = c9;
                    m02 = c10;
                    m12 = c11;
                    s02 = c12;
                    s12 = c13;
                }
                if (!JSONLexer.checkTime(h0, (char)h12, m02, m12, (char)s02, (char)s12)) {
                    return false;
                }
                if (rest == 17 && !sperate17) {
                    char S0 = this.charAt(this.bp + 14);
                    char S12 = this.charAt(this.bp + 15);
                    char S22 = this.charAt(this.bp + 16);
                    if (S0 < '0' || S0 > '9') {
                        return false;
                    }
                    if (S12 < '0' || S12 > '9') {
                        return false;
                    }
                    if (S22 < '0' || S22 > '9') {
                        return false;
                    }
                    millis = (S0 - 48) * 100 + (S12 - 48) * 10 + (S22 - 48);
                } else {
                    millis = 0;
                }
                hour = (h0 - 48) * 10 + (h12 - 48);
                minute = (m02 - 48) * 10 + (m12 - 48);
                seconds = (s02 - 48) * 10 + (s12 - 48);
            } else {
                hour = 0;
                minute = 0;
                seconds = 0;
                millis = 0;
            }
            this.calendar.set(11, hour);
            this.calendar.set(12, minute);
            this.calendar.set(13, seconds);
            this.calendar.set(14, millis);
            this.token = 5;
            return true;
        }
        if (rest < 9) {
            return false;
        }
        int c0 = this.charAt(this.bp);
        int c1 = this.charAt(this.bp + 1);
        char c2 = this.charAt(this.bp + 2);
        char c3 = this.charAt(this.bp + 3);
        char c4 = this.charAt(this.bp + 4);
        char c5 = this.charAt(this.bp + 5);
        char c6 = this.charAt(this.bp + 6);
        int c7 = this.charAt(this.bp + 7);
        int c8 = this.charAt(this.bp + 8);
        int c9 = this.charAt(this.bp + 9);
        int date_len = 10;
        if (c4 == '-' && c7 == 45 || c4 == '/' && c7 == 47) {
            int n = c0;
            y1 = c1;
            y2 = c2;
            char c = c3;
            M0 = c5;
            M1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == '-' && c6 == '-') {
            int n = c0;
            y1 = c1;
            y2 = c2;
            char c = c3;
            M0 = '0';
            M1 = c5;
            if (c8 == 32) {
                d0 = 48;
                d1 = c7;
                date_len = 8;
            } else {
                d0 = c7;
                d1 = c8;
                date_len = 9;
            }
        } else if (c2 == '.' && c5 == '.' || c2 == '-' && c5 == '-') {
            d0 = c0;
            d1 = c1;
            M0 = c3;
            M1 = c4;
            char c = c6;
            y1 = c7;
            y2 = c8;
            int n = c9;
        } else {
            if (c4 != '\u5e74' && c4 != '\ub144') return false;
            int n = c0;
            y1 = c1;
            y2 = c2;
            char c = c3;
            if (c7 == 26376 || c7 == 50900) {
                M0 = c5;
                M1 = c6;
                if (c9 == 26085 || c9 == 51068) {
                    d0 = 48;
                    d1 = c8;
                } else {
                    if (this.charAt(this.bp + 10) != '\u65e5' && this.charAt(this.bp + 10) != '\uc77c') return false;
                    d0 = c8;
                    d1 = c9;
                    date_len = 11;
                }
            } else {
                if (c6 != '\u6708' && c6 != 50900) return false;
                M0 = '0';
                M1 = c5;
                if (c8 == 26085 || c8 == 51068) {
                    d0 = 48;
                    d1 = c7;
                } else {
                    if (c9 != 26085 && c9 != 51068) return false;
                    d0 = c7;
                    d1 = c8;
                }
            }
        }
        if (!JSONLexer.checkDate((char)var15_29, (char)y1, (char)y2, (char)var18_39, M0, M1, d0, d1)) {
            return false;
        }
        this.setCalendar((char)var15_29, (char)y1, (char)y2, (char)var18_39, M0, M1, (char)d0, (char)d1);
        char t = this.charAt(this.bp + date_len);
        if (t == 'T' || t == ' ' && !strict) {
            if (rest < date_len + 9) {
                return false;
            }
        } else {
            if (t == '\"' || t == '\u001a' || t == '\u65e5' || t == '\uc77c') {
                this.calendar.set(11, 0);
                this.calendar.set(12, 0);
                this.calendar.set(13, 0);
                this.calendar.set(14, 0);
                this.ch = this.charAt(this.bp += date_len);
                this.token = 5;
                return true;
            }
            if (t != '+' && t != '-') return false;
            if (this.len != date_len + 6) return false;
            if (this.charAt(this.bp + date_len + 3) != ':' || this.charAt(this.bp + date_len + 4) != '0' || this.charAt(this.bp + date_len + 5) != '0') {
                return false;
            }
            this.setTime('0', '0', '0', '0', '0', '0');
            this.calendar.set(14, 0);
            this.setTimeZone(t, this.charAt(this.bp + date_len + 1), this.charAt(this.bp + date_len + 2));
            return true;
        }
        if (this.charAt(this.bp + date_len + 3) != ':') {
            return false;
        }
        if (this.charAt(this.bp + date_len + 6) != ':') {
            return false;
        }
        char h0 = this.charAt(this.bp + date_len + 1);
        if (!JSONLexer.checkTime(h0, h1 = this.charAt(this.bp + date_len + 2), m0 = this.charAt(this.bp + date_len + 4), m1 = this.charAt(this.bp + date_len + 5), s0 = this.charAt(this.bp + date_len + 7), s1 = this.charAt(this.bp + date_len + 8))) {
            return false;
        }
        this.setTime(h0, h1, m0, m1, s0, s1);
        char dot = this.charAt(this.bp + date_len + 9);
        if (dot == '.') {
            if (rest < date_len + 11) {
                return false;
            }
        } else {
            String[] timeZoneIDs;
            this.calendar.set(14, 0);
            this.ch = this.charAt(this.bp += date_len + 9);
            this.token = 5;
            if (dot != 'Z' || this.calendar.getTimeZone().getRawOffset() == 0 || (timeZoneIDs = TimeZone.getAvailableIDs(0)).length <= 0) return true;
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
            this.calendar.setTimeZone(timeZone);
            return true;
        }
        char S0 = this.charAt(this.bp + date_len + 10);
        if (S0 < '0' || S0 > '9') {
            return false;
        }
        int millis = S0 - 48;
        int millisLen = 1;
        if (rest > date_len + 11 && (S1 = this.charAt(this.bp + date_len + 11)) >= '0' && S1 <= '9') {
            millis = millis * 10 + (S1 - 48);
            millisLen = 2;
        }
        if (millisLen == 2 && (S2 = this.charAt(this.bp + date_len + 12)) >= '0' && S2 <= '9') {
            millis = millis * 10 + (S2 - 48);
            millisLen = 3;
        }
        this.calendar.set(14, millis);
        int timzeZoneLength = 0;
        char timeZoneFlag = this.charAt(this.bp + date_len + 10 + millisLen);
        if (timeZoneFlag == '+' || timeZoneFlag == '-') {
            char t0 = this.charAt(this.bp + date_len + 10 + millisLen + 1);
            if (t0 < '0' || t0 > '1') {
                return false;
            }
            char t1 = this.charAt(this.bp + date_len + 10 + millisLen + 2);
            if (t1 < '0' || t1 > '9') {
                return false;
            }
            char t2 = this.charAt(this.bp + date_len + 10 + millisLen + 3);
            if (t2 == ':') {
                char t3 = this.charAt(this.bp + date_len + 10 + millisLen + 4);
                if (t3 != '0') {
                    return false;
                }
                char t4 = this.charAt(this.bp + date_len + 10 + millisLen + 5);
                if (t4 != '0') {
                    return false;
                }
                timzeZoneLength = 6;
            } else if (t2 == '0') {
                char t3 = this.charAt(this.bp + date_len + 10 + millisLen + 4);
                if (t3 != '0') {
                    return false;
                }
                timzeZoneLength = 5;
            } else {
                timzeZoneLength = 3;
            }
            this.setTimeZone(timeZoneFlag, t0, t1);
        } else if (timeZoneFlag == 'Z') {
            String[] timeZoneIDs;
            timzeZoneLength = 1;
            if (this.calendar.getTimeZone().getRawOffset() != 0 && (timeZoneIDs = TimeZone.getAvailableIDs(0)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
                this.calendar.setTimeZone(timeZone);
            }
        }
        char end = this.charAt(this.bp + (date_len + 10 + millisLen + timzeZoneLength));
        if (end != '\u001a' && end != '\"') {
            return false;
        }
        this.ch = this.charAt(this.bp += date_len + 10 + millisLen + timzeZoneLength);
        this.token = 5;
        return true;
    }

    protected void setTime(char h0, char h1, char m0, char m1, char s0, char s1) {
        int hour = (h0 - 48) * 10 + (h1 - 48);
        int minute = (m0 - 48) * 10 + (m1 - 48);
        int seconds = (s0 - 48) * 10 + (s1 - 48);
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, seconds);
    }

    protected void setTimeZone(char timeZoneFlag, char t0, char t1) {
        String[] timeZoneIDs;
        int timeZoneOffset = ((t0 - 48) * 10 + (t1 - 48)) * 3600 * 1000;
        if (timeZoneFlag == '-') {
            timeZoneOffset = -timeZoneOffset;
        }
        if (this.calendar.getTimeZone().getRawOffset() != timeZoneOffset && (timeZoneIDs = TimeZone.getAvailableIDs(timeZoneOffset)).length > 0) {
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
            this.calendar.setTimeZone(timeZone);
        }
    }

    static boolean checkTime(char h0, char h1, char m0, char m1, char s0, char s1) {
        if (h0 == '0') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '1') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '2') {
            if (h1 < '0' || h1 > '4') {
                return false;
            }
        } else {
            return false;
        }
        if (m0 >= '0' && m0 <= '5') {
            if (m1 < '0' || m1 > '9') {
                return false;
            }
        } else if (m0 == '6') {
            if (m1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        if (s0 >= '0' && s0 <= '5') {
            if (s1 < '0' || s1 > '9') {
                return false;
            }
        } else if (s0 == '6') {
            if (s1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void setCalendar(char y0, char y1, char y2, char y3, char M0, char M1, char d0, char d1) {
        this.calendar = Calendar.getInstance(this.timeZone, this.locale);
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        int month = (M0 - 48) * 10 + (M1 - 48) - 1;
        int day = (d0 - 48) * 10 + (d1 - 48);
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, day);
    }

    static boolean checkDate(char y0, char y1, char y2, char y3, char M0, char M1, int d0, int d1) {
        if (y0 < '1' || y0 > '3') {
            return false;
        }
        if (y1 < '0' || y1 > '9') {
            return false;
        }
        if (y2 < '0' || y2 > '9') {
            return false;
        }
        if (y3 < '0' || y3 > '9') {
            return false;
        }
        if (M0 == '0') {
            if (M1 < '1' || M1 > '9') {
                return false;
            }
        } else if (M0 == '1') {
            if (M1 != '0' && M1 != '1' && M1 != '2') {
                return false;
            }
        } else {
            return false;
        }
        if (d0 == 48) {
            if (d1 < 49 || d1 > 57) {
                return false;
            }
        } else if (d0 == 49 || d0 == 50) {
            if (d1 < 48 || d1 > 57) {
                return false;
            }
        } else if (d0 == 51) {
            if (d1 != 48 && d1 != 49) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static final byte[] decodeFast(String chars, int offset, int charsLen) {
        int sIx;
        if (charsLen == 0) {
            return new byte[0];
        }
        int eIx = offset + charsLen - 1;
        for (sIx = offset; sIx < eIx && IA[chars.charAt(sIx)] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[chars.charAt(eIx)] < 0) {
            --eIx;
        }
        int pad = chars.charAt(eIx) == '=' ? (chars.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = charsLen > 76 ? (chars.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] bytes = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[chars.charAt(sIx++)] << 18 | IA[chars.charAt(sIx++)] << 12 | IA[chars.charAt(sIx++)] << 6 | IA[chars.charAt(sIx++)];
            bytes[d++] = (byte)(i >> 16);
            bytes[d++] = (byte)(i >> 8);
            bytes[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[chars.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                bytes[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return bytes;
    }

    static {
        int c;
        int i;
        int version = -1;
        try {
            Class<?> clazz = Class.forName("android.os.Build$VERSION");
            Field field = clazz.getField("SDK_INT");
            version = field.getInt(null);
        }
        catch (Exception clazz) {
            // empty catch block
        }
        V6 = version >= 23;
        sbufLocal = new ThreadLocal();
        digits = new int[103];
        for (i = 48; i <= 57; ++i) {
            JSONLexer.digits[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            JSONLexer.digits[i] = i - 97 + 10;
        }
        for (i = 65; i <= 70; ++i) {
            JSONLexer.digits[i] = i - 65 + 10;
        }
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (i = 0; i < iS; ++i) {
            JSONLexer.IA[JSONLexer.CA[i]] = i;
        }
        JSONLexer.IA[61] = 0;
        firstIdentifierFlags = new boolean[256];
        for (c = 0; c < firstIdentifierFlags.length; c = (int)((char)(c + 1))) {
            if (c >= 65 && c <= 90) {
                JSONLexer.firstIdentifierFlags[c] = true;
                continue;
            }
            if (c >= 97 && c <= 122) {
                JSONLexer.firstIdentifierFlags[c] = true;
                continue;
            }
            if (c != 95) continue;
            JSONLexer.firstIdentifierFlags[c] = true;
        }
        identifierFlags = new boolean[256];
        for (c = 0; c < identifierFlags.length; c = (int)((char)(c + 1))) {
            if (c >= 65 && c <= 90) {
                JSONLexer.identifierFlags[c] = true;
                continue;
            }
            if (c >= 97 && c <= 122) {
                JSONLexer.identifierFlags[c] = true;
                continue;
            }
            if (c == 95) {
                JSONLexer.identifierFlags[c] = true;
                continue;
            }
            if (c < 48 || c > 57) continue;
            JSONLexer.identifierFlags[c] = true;
        }
    }
}

