/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableDeserializer
extends JavaBeanDeserializer {
    public ThrowableDeserializer(ParserConfig mapping, Class<?> clazz) {
        super(mapping, clazz, clazz);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        HashMap<String, Object> otherValues;
        StackTraceElement[] stackTrace;
        String message;
        Class<?> exClass;
        Throwable cause;
        block42: {
            Class<?> clazz;
            JSONLexer lexer = parser.lexer;
            if (lexer.token == 8) {
                lexer.nextToken();
                return null;
            }
            if (parser.resolveStatus == 2) {
                parser.resolveStatus = 0;
            } else if (lexer.token != 12) {
                throw new JSONException("syntax error");
            }
            cause = null;
            exClass = null;
            if (type != null && type instanceof Class && Throwable.class.isAssignableFrom(clazz = (Class<?>)type)) {
                exClass = clazz;
            }
            message = null;
            stackTrace = null;
            otherValues = null;
            while (true) {
                String key;
                if ((key = lexer.scanSymbol(parser.symbolTable)) == null) {
                    if (lexer.token == 13) {
                        lexer.nextToken(16);
                        break block42;
                    }
                    if (lexer.token == 16) continue;
                }
                lexer.nextTokenWithChar(':');
                if ("@type".equals(key)) {
                    if (lexer.token != 4) {
                        throw new JSONException("syntax error");
                    }
                    String exClassName = lexer.stringVal();
                    exClass = TypeUtils.loadClass(exClassName, parser.config.defaultClassLoader);
                    lexer.nextToken(16);
                } else if ("message".equals(key)) {
                    if (lexer.token == 8) {
                        message = null;
                    } else if (lexer.token == 4) {
                        message = lexer.stringVal();
                    } else {
                        throw new JSONException("syntax error");
                    }
                    lexer.nextToken();
                } else if ("cause".equals(key)) {
                    cause = (Throwable)this.deserialze(parser, null, "cause");
                } else if ("stackTrace".equals(key)) {
                    stackTrace = parser.parseObject(StackTraceElement[].class);
                } else {
                    if (otherValues == null) {
                        otherValues = new HashMap<String, Object>();
                    }
                    otherValues.put(key, parser.parse());
                }
                if (lexer.token == 13) break;
            }
            lexer.nextToken(16);
        }
        Throwable ex = null;
        if (exClass == null) {
            ex = new Exception(message, cause);
        } else {
            try {
                Constructor<?> defaultConstructor = null;
                Constructor<?> messageConstructor = null;
                Constructor<?> causeConstructor = null;
                for (Constructor<?> constructor : exClass.getConstructors()) {
                    if (constructor.getParameterTypes().length == 0) {
                        defaultConstructor = constructor;
                        continue;
                    }
                    if (constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == String.class) {
                        messageConstructor = constructor;
                        continue;
                    }
                    if (constructor.getParameterTypes().length != 2 || constructor.getParameterTypes()[0] != String.class || constructor.getParameterTypes()[1] != Throwable.class) continue;
                    causeConstructor = constructor;
                }
                if (causeConstructor != null) {
                    ex = (Throwable)causeConstructor.newInstance(message, cause);
                } else if (messageConstructor != null) {
                    ex = (Throwable)messageConstructor.newInstance(message);
                } else if (defaultConstructor != null) {
                    ex = (Throwable)defaultConstructor.newInstance(new Object[0]);
                }
                if (ex == null) {
                    ex = new Exception(message, cause);
                }
            }
            catch (Exception e) {
                throw new JSONException("create instance error", e);
            }
        }
        if (stackTrace != null) {
            ex.setStackTrace(stackTrace);
        }
        if (otherValues != null) {
            JavaBeanDeserializer exBeanDeser = null;
            if (exClass != null) {
                if (exClass == this.clazz) {
                    exBeanDeser = this;
                } else {
                    ObjectDeserializer exDeser = parser.config.getDeserializer(exClass);
                    if (exDeser instanceof JavaBeanDeserializer) {
                        exBeanDeser = (JavaBeanDeserializer)exDeser;
                    }
                }
            }
            for (Map.Entry entry : otherValues.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                FieldDeserializer fieldDeserializer = exBeanDeser.getFieldDeserializer(key);
                if (fieldDeserializer == null) continue;
                fieldDeserializer.setValue((Object)ex, value);
            }
        }
        return (T)ex;
    }
}

