/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONStreamAware;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.ArrayCodec;
import com.alibaba.fastjson.serializer.ArraySerializer;
import com.alibaba.fastjson.serializer.BigDecimalCodec;
import com.alibaba.fastjson.serializer.BooleanCodec;
import com.alibaba.fastjson.serializer.CollectionCodec;
import com.alibaba.fastjson.serializer.DateCodec;
import com.alibaba.fastjson.serializer.EnumSerializer;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.JSONSerializable;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ListSerializer;
import com.alibaba.fastjson.serializer.MapSerializer;
import com.alibaba.fastjson.serializer.MiscCodec;
import com.alibaba.fastjson.serializer.NumberCodec;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.util.IdentityHashMap;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.AbstractSequentialList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializeConfig {
    public static final SerializeConfig globalInstance = new SerializeConfig();
    private final IdentityHashMap<ObjectSerializer> serializers = new IdentityHashMap(1024);
    protected String typeKey = "@type";
    public PropertyNamingStrategy propertyNamingStrategy;

    public static final SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public ObjectSerializer registerIfNotExists(Class<?> clazz) {
        return this.registerIfNotExists(clazz, clazz.getModifiers(), false, true, true, true);
    }

    public ObjectSerializer registerIfNotExists(Class<?> clazz, int classModifers, boolean fieldOnly, boolean jsonTypeSupport, boolean jsonFieldSupport, boolean fieldGenericSupport) {
        ObjectSerializer serializer = this.serializers.get(clazz);
        if (serializer == null) {
            serializer = new JavaBeanSerializer(clazz, classModifers, null, fieldOnly, jsonTypeSupport, jsonFieldSupport, fieldGenericSupport, this.propertyNamingStrategy);
            this.serializers.put(clazz, serializer);
        }
        return serializer;
    }

    public SerializeConfig() {
        this.serializers.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.serializers.put((Type)((Object)Character.class), MiscCodec.instance);
        this.serializers.put((Type)((Object)Byte.class), IntegerCodec.instance);
        this.serializers.put((Type)((Object)Short.class), IntegerCodec.instance);
        this.serializers.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.serializers.put((Type)((Object)Long.class), IntegerCodec.instance);
        this.serializers.put((Type)((Object)Float.class), NumberCodec.instance);
        this.serializers.put((Type)((Object)Double.class), NumberCodec.instance);
        this.serializers.put((Type)((Object)Number.class), NumberCodec.instance);
        this.serializers.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.serializers.put((Type)((Object)BigInteger.class), BigDecimalCodec.instance);
        this.serializers.put((Type)((Object)String.class), StringCodec.instance);
        this.serializers.put((Type)((Object)Object[].class), ArrayCodec.instance);
        this.serializers.put((Type)((Object)Class.class), MiscCodec.instance);
        this.serializers.put((Type)((Object)SimpleDateFormat.class), MiscCodec.instance);
        this.serializers.put((Type)((Object)Locale.class), MiscCodec.instance);
        this.serializers.put((Type)((Object)Currency.class), MiscCodec.instance);
        this.serializers.put((Type)((Object)TimeZone.class), MiscCodec.instance);
        this.serializers.put((Type)((Object)UUID.class), MiscCodec.instance);
        this.serializers.put((Type)((Object)URI.class), MiscCodec.instance);
        this.serializers.put((Type)((Object)URL.class), MiscCodec.instance);
        this.serializers.put((Type)((Object)Pattern.class), MiscCodec.instance);
        this.serializers.put((Type)((Object)Charset.class), MiscCodec.instance);
    }

    public ObjectSerializer get(Class<?> clazz) {
        ObjectSerializer writer = this.serializers.get(clazz);
        if (writer == null) {
            Class<?> superClass;
            if (Map.class.isAssignableFrom(clazz)) {
                writer = new MapSerializer();
                this.serializers.put(clazz, writer);
            } else if (AbstractSequentialList.class.isAssignableFrom(clazz)) {
                writer = CollectionCodec.instance;
                this.serializers.put(clazz, writer);
            } else if (List.class.isAssignableFrom(clazz)) {
                writer = new ListSerializer();
                this.serializers.put(clazz, writer);
            } else if (Collection.class.isAssignableFrom(clazz)) {
                writer = CollectionCodec.instance;
                this.serializers.put(clazz, writer);
            } else if (Date.class.isAssignableFrom(clazz)) {
                writer = DateCodec.instance;
                this.serializers.put(clazz, writer);
            } else if (JSONAware.class.isAssignableFrom(clazz)) {
                writer = MiscCodec.instance;
                this.serializers.put(clazz, writer);
            } else if (JSONSerializable.class.isAssignableFrom(clazz)) {
                writer = MiscCodec.instance;
                this.serializers.put(clazz, writer);
            } else if (JSONStreamAware.class.isAssignableFrom(clazz)) {
                writer = MiscCodec.instance;
                this.serializers.put(clazz, writer);
            } else if (clazz.isEnum() || (superClass = clazz.getSuperclass()) != null && superClass != Object.class && superClass.isEnum()) {
                writer = new EnumSerializer();
                this.serializers.put(clazz, writer);
            } else if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                ObjectSerializer compObjectSerializer = this.get(componentType);
                writer = new ArraySerializer(componentType, compObjectSerializer);
                this.serializers.put(clazz, writer);
            } else if (Throwable.class.isAssignableFrom(clazz)) {
                JavaBeanSerializer serializer = new JavaBeanSerializer(clazz, this.propertyNamingStrategy);
                serializer.features |= SerializerFeature.WriteClassName.mask;
                writer = serializer;
                this.serializers.put(clazz, writer);
            } else if (TimeZone.class.isAssignableFrom(clazz)) {
                writer = MiscCodec.instance;
                this.serializers.put(clazz, writer);
            } else if (Charset.class.isAssignableFrom(clazz)) {
                writer = MiscCodec.instance;
                this.serializers.put(clazz, writer);
            } else if (Enumeration.class.isAssignableFrom(clazz)) {
                writer = MiscCodec.instance;
                this.serializers.put(clazz, writer);
            } else if (Calendar.class.isAssignableFrom(clazz)) {
                writer = DateCodec.instance;
                this.serializers.put(clazz, writer);
            } else {
                boolean isCglibProxy = false;
                boolean isJavassistProxy = false;
                for (Class<?> item : clazz.getInterfaces()) {
                    if (item.getName().equals("net.sf.cglib.proxy.Factory") || item.getName().equals("org.springframework.cglib.proxy.Factory")) {
                        isCglibProxy = true;
                        break;
                    }
                    if (!item.getName().equals("javassist.util.proxy.ProxyObject")) continue;
                    isJavassistProxy = true;
                    break;
                }
                if (isCglibProxy || isJavassistProxy) {
                    Class<?> superClazz = clazz.getSuperclass();
                    ObjectSerializer superWriter = this.get(superClazz);
                    this.serializers.put(clazz, superWriter);
                    return superWriter;
                }
                String className = clazz.getName();
                writer = className.startsWith("android.net.Uri$") ? MiscCodec.instance : new JavaBeanSerializer(clazz, this.propertyNamingStrategy);
                this.serializers.put(clazz, writer);
            }
            if (writer == null) {
                writer = this.serializers.get(clazz);
            }
        }
        return writer;
    }

    public boolean put(Type key, ObjectSerializer value) {
        return this.serializers.put(key, value);
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public void setTypeKey(String typeKey) {
        this.typeKey = typeKey;
    }
}

