/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.ResolveFieldDeserializer;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ExtraTypeProvider;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldTypeResolver;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJSONParser
implements Closeable {
    public final SymbolTable symbolTable;
    public ParserConfig config;
    private String dateFormatPattern = JSON.DEFFAULT_DATE_FORMAT;
    private DateFormat dateFormat;
    public final JSONLexer lexer;
    protected ParseContext contex;
    private ParseContext[] contextArray;
    private int contextArrayIndex = 0;
    private List<ResolveTask> resolveTaskList;
    public static final int NONE = 0;
    public static final int NeedToResolve = 1;
    public static final int TypeNameRedirect = 2;
    public int resolveStatus = 0;
    protected List<ExtraTypeProvider> extraTypeProviders = null;
    protected List<ExtraProcessor> extraProcessors = null;
    public FieldTypeResolver fieldTypeResolver = null;

    public String getDateFomartPattern() {
        return this.dateFormatPattern;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(this.dateFormatPattern, this.lexer.locale);
            this.dateFormat.setTimeZone(this.lexer.timeZone);
        }
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormatPattern = dateFormat;
        this.dateFormat = null;
    }

    public void setDateFomrat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DefaultJSONParser(String input) {
        this(input, ParserConfig.global, JSON.DEFAULT_PARSER_FEATURE);
    }

    public DefaultJSONParser(String input, ParserConfig config) {
        this(new JSONLexer(input, JSON.DEFAULT_PARSER_FEATURE), config);
    }

    public DefaultJSONParser(String input, ParserConfig config, int features) {
        this(new JSONLexer(input, features), config);
    }

    public DefaultJSONParser(char[] input, int length, ParserConfig config, int features) {
        this(new JSONLexer(input, length, features), config);
    }

    public DefaultJSONParser(JSONLexer lexer) {
        this(lexer, ParserConfig.global);
    }

    public DefaultJSONParser(JSONLexer lexer, ParserConfig config) {
        this.lexer = lexer;
        this.config = config;
        this.symbolTable = config.symbolTable;
        if (lexer.ch == '{') {
            int index;
            lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
            lexer.token = 12;
        } else if (lexer.ch == '[') {
            int index;
            lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
            lexer.token = 14;
        } else {
            lexer.nextToken();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object parseObject(Map object, Object fieldName) {
        boolean isJSONObject;
        Map<String, Object> innerMap;
        JSONLexer lexer = this.lexer;
        int token = lexer.token;
        if (token == 8) {
            lexer.nextToken();
            return null;
        }
        if (token != 12 && token != 16) {
            throw new JSONException("syntax error, expect {, actual " + JSONToken.name(token) + ", " + lexer.info());
        }
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            innerMap = jsonObject.getInnerMap();
            isJSONObject = true;
        } else {
            isJSONObject = false;
            innerMap = null;
        }
        boolean allowISO8601DateFormat = (lexer.features & Feature.AllowISO8601DateFormat.mask) != 0;
        boolean disableCircularReferenceDetect = lexer.disableCircularReferenceDetect;
        ParseContext context = this.contex;
        try {
            int index;
            int ch;
            boolean setContextFlag = false;
            while (true) {
                int index2;
                Object thisObj;
                Object key;
                block111: {
                    Object refValue;
                    block109: {
                        String ref;
                        block112: {
                            if ((ch = lexer.ch) != 34 && ch != 125) {
                                lexer.skipWhitespace();
                                ch = lexer.ch;
                            }
                            while (ch == 44) {
                                lexer.next();
                                lexer.skipWhitespace();
                                ch = lexer.ch;
                            }
                            boolean isObjectKey = false;
                            if (ch == 34) {
                                key = lexer.scanSymbol(this.symbolTable, '\"');
                                ch = lexer.ch;
                                if (ch != 58) {
                                    lexer.skipWhitespace();
                                    ch = lexer.ch;
                                    if (ch != 58) {
                                        throw new JSONException("expect ':' at " + lexer.pos + ", name " + key);
                                    }
                                }
                            } else {
                                if (ch == 125) {
                                    int index222;
                                    lexer.ch = (char)((index222 = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index222));
                                    lexer.sp = 0;
                                    lexer.nextToken(16);
                                    Map index222 = object;
                                    return index222;
                                }
                                if (ch == 39) {
                                    key = lexer.scanSymbol(this.symbolTable, '\'');
                                    if (lexer.ch != ':') {
                                        lexer.skipWhitespace();
                                    }
                                    if ((ch = lexer.ch) != 58) {
                                        throw new JSONException("expect ':' at " + lexer.pos);
                                    }
                                } else {
                                    if (ch == 26) {
                                        throw new JSONException("syntax error, " + lexer.info());
                                    }
                                    if (ch == 44) {
                                        throw new JSONException("syntax error, " + lexer.info());
                                    }
                                    if (ch >= 48 && ch <= 57 || ch == 45) {
                                        lexer.sp = 0;
                                        lexer.scanNumber();
                                        try {
                                            key = lexer.token == 2 ? (Number)lexer.integerValue() : (Number)lexer.decimalValue(true);
                                            if (isJSONObject) {
                                                key = key.toString();
                                            }
                                        }
                                        catch (NumberFormatException ex) {
                                            throw new JSONException("parse number key error, " + lexer.info());
                                        }
                                        ch = lexer.ch;
                                        if (ch != 58) {
                                            throw new JSONException("parse number key error, " + lexer.info());
                                        }
                                    } else if (ch == 123 || ch == 91) {
                                        lexer.nextToken();
                                        key = this.parse();
                                        isObjectKey = true;
                                        if (isJSONObject) {
                                            key = key.toString();
                                        }
                                    } else {
                                        key = lexer.scanSymbolUnQuoted(this.symbolTable);
                                        lexer.skipWhitespace();
                                        ch = lexer.ch;
                                        if (ch != 58) {
                                            throw new JSONException("expect ':' at " + lexer.bp + ", actual " + (char)ch);
                                        }
                                        if (isJSONObject) {
                                            key = key.toString();
                                        }
                                    }
                                }
                            }
                            if (!isObjectKey) {
                                int index3;
                                int n = (index3 = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index3);
                                lexer.ch = (char)n;
                                ch = n;
                                while (ch <= 32 && (ch == 32 || ch == 10 || ch == 13 || ch == 9 || ch == 12 || ch == 8)) {
                                    lexer.next();
                                    ch = lexer.ch;
                                }
                            } else {
                                ch = lexer.ch;
                            }
                            lexer.sp = 0;
                            if (key == "@type" && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                                ObjectDeserializer deserializer;
                                String typeName = lexer.scanSymbol(this.symbolTable, '\"');
                                Class<?> clazz = TypeUtils.loadClass(typeName, this.config.defaultClassLoader);
                                if (clazz == null) {
                                    object.put("@type", typeName);
                                    continue;
                                }
                                lexer.nextToken(16);
                                if (lexer.token == 13) {
                                    lexer.nextToken(16);
                                    try {
                                        Map instance = null;
                                        deserializer = this.config.getDeserializer(clazz);
                                        if (deserializer instanceof JavaBeanDeserializer) {
                                            instance = ((JavaBeanDeserializer)deserializer).createInstance(this, clazz);
                                        }
                                        if (instance == null) {
                                            instance = clazz == Cloneable.class ? new HashMap() : ("java.util.Collections$EmptyMap".equals(typeName) ? Collections.emptyMap() : clazz.newInstance());
                                        }
                                        HashMap hashMap = instance;
                                        return hashMap;
                                    }
                                    catch (Exception e) {
                                        throw new JSONException("create instance error", e);
                                    }
                                }
                                this.resolveStatus = 2;
                                if (this.contex != null && !(fieldName instanceof Integer)) {
                                    this.popContext();
                                }
                                if (object.size() > 0) {
                                    Object newObj = TypeUtils.cast((Object)object, clazz, this.config);
                                    this.parseObject(newObj);
                                    deserializer = newObj;
                                    return deserializer;
                                }
                                ObjectDeserializer deserializer2 = this.config.getDeserializer(clazz);
                                deserializer = deserializer2.deserialze(this, clazz, fieldName);
                                return deserializer;
                            }
                            if (key != "$ref" || lexer.isEnabled(Feature.DisableSpecialKeyDetect)) break block111;
                            lexer.nextToken(4);
                            if (lexer.token != 4) throw new JSONException("illegal ref, " + JSONToken.name(lexer.token));
                            ref = lexer.stringVal();
                            lexer.nextToken(13);
                            refValue = null;
                            if (!"@".equals(ref)) break block112;
                            if (this.contex != null) {
                                ParseContext thisContext = this.contex;
                                thisObj = thisContext.object;
                                if (thisObj instanceof Object[] || thisObj instanceof Collection) {
                                    refValue = thisObj;
                                    break block109;
                                } else if (thisContext.parent != null) {
                                    refValue = thisContext.parent.object;
                                }
                            }
                            break block109;
                        }
                        if ("..".equals(ref)) {
                            if (context.object != null) {
                                refValue = context.object;
                            } else {
                                this.addResolveTask(new ResolveTask(context, ref));
                                this.resolveStatus = 1;
                            }
                        } else if ("$".equals(ref)) {
                            ParseContext rootContext = context;
                            while (rootContext.parent != null) {
                                rootContext = rootContext.parent;
                            }
                            if (rootContext.object != null) {
                                refValue = rootContext.object;
                            } else {
                                this.addResolveTask(new ResolveTask(rootContext, ref));
                                this.resolveStatus = 1;
                            }
                        } else {
                            this.addResolveTask(new ResolveTask(context, ref));
                            this.resolveStatus = 1;
                        }
                    }
                    if (lexer.token != 13) {
                        throw new JSONException("syntax error, " + lexer.info());
                    }
                    lexer.nextToken(16);
                    Object rootContext = refValue;
                    return rootContext;
                }
                if (!disableCircularReferenceDetect && !setContextFlag) {
                    ParseContext contextR = this.setContext(this.contex, object, fieldName);
                    if (context == null) {
                        context = contextR;
                    }
                    setContextFlag = true;
                }
                if (ch == 34) {
                    String strValue = lexer.scanStringValue('\"');
                    Object value = strValue;
                    if (allowISO8601DateFormat) {
                        JSONLexer iso8601Lexer = new JSONLexer(strValue);
                        if (iso8601Lexer.scanISO8601DateIfMatch(true)) {
                            value = iso8601Lexer.calendar.getTime();
                        }
                        iso8601Lexer.close();
                    }
                    if (innerMap != null) {
                        innerMap.put((String)key, value);
                    } else {
                        object.put(key, value);
                    }
                } else if (ch >= 48 && ch <= 57 || ch == 45) {
                    Number value = lexer.scanNumberValue();
                    object.put(key, value);
                } else {
                    if (ch == 91) {
                        boolean parentIsArray;
                        int index4;
                        lexer.token = 14;
                        lexer.ch = (char)((index4 = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index4));
                        ArrayList<Object> list = new ArrayList<Object>();
                        boolean bl = parentIsArray = fieldName != null && fieldName.getClass() == Integer.class;
                        if (!parentIsArray) {
                            this.setContext(context);
                        }
                        this.parseArray(list, key);
                        JSONArray value = new JSONArray(list);
                        if (innerMap != null) {
                            innerMap.put((String)key, value);
                        } else {
                            object.put(key, value);
                        }
                        token = lexer.token;
                        if (token == 13) {
                            lexer.nextToken(16);
                            thisObj = object;
                            return thisObj;
                        }
                        if (token != 16) throw new JSONException("syntax error, " + lexer.info());
                        continue;
                    }
                    if (ch == 123) {
                        String resolveFieldName;
                        Type fieldType;
                        int index5;
                        lexer.ch = (char)((index5 = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index5));
                        lexer.token = 12;
                        boolean parentIsArray = fieldName instanceof Integer;
                        JSONObject input = (lexer.features & Feature.OrderedField.mask) != 0 ? new JSONObject(new LinkedHashMap<String, Object>()) : new JSONObject();
                        ParseContext ctxLocal = null;
                        if (!disableCircularReferenceDetect && !parentIsArray) {
                            ctxLocal = this.setContext(context, input, key);
                        }
                        Object obj = null;
                        boolean objParsed = false;
                        if (this.fieldTypeResolver != null && (fieldType = this.fieldTypeResolver.resolve(object, resolveFieldName = key != null ? key.toString() : null)) != null) {
                            ObjectDeserializer fieldDeser = this.config.getDeserializer(fieldType);
                            obj = fieldDeser.deserialze(this, fieldType, key);
                            objParsed = true;
                        }
                        if (!objParsed) {
                            obj = this.parseObject(input, key);
                        }
                        if (ctxLocal != null && input != obj) {
                            ctxLocal.object = object;
                        }
                        if (this.resolveStatus == 1) {
                            this.checkMapResolve(object, key.toString());
                        }
                        if (innerMap != null) {
                            innerMap.put((String)key, obj);
                        } else {
                            object.put(key, obj);
                        }
                        if (parentIsArray) {
                            this.setContext(context, obj, key);
                        }
                        if ((token = lexer.token) == 13) {
                            lexer.nextToken(16);
                            if (!disableCircularReferenceDetect) {
                                this.contex = context;
                            }
                            Map map = object;
                            return map;
                        }
                        if (token != 16) throw new JSONException("syntax error, " + lexer.info());
                        continue;
                    }
                    if (ch == 116) {
                        if (lexer.text.startsWith("true", lexer.bp)) {
                            lexer.bp += 3;
                            lexer.next();
                            object.put(key, Boolean.TRUE);
                        }
                    } else if (ch == 102) {
                        if (lexer.text.startsWith("false", lexer.bp)) {
                            lexer.bp += 4;
                            lexer.next();
                            object.put(key, Boolean.FALSE);
                        }
                    } else {
                        lexer.nextToken();
                        Object value = this.parse();
                        object.put(object.getClass() == JSONObject.class ? key.toString() : key, value);
                        if (lexer.token == 13) {
                            lexer.nextToken(16);
                            Map parentIsArray = object;
                            return parentIsArray;
                        }
                        if (lexer.token != 16) throw new JSONException("syntax error, " + lexer.info());
                        continue;
                    }
                }
                ch = lexer.ch;
                if (ch != 44 && ch != 125) {
                    lexer.skipWhitespace();
                    ch = lexer.ch;
                }
                if (ch != 44) break;
                lexer.ch = (char)((index2 = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index2));
            }
            if (ch != 125) throw new JSONException("syntax error, " + lexer.info());
            int n = (index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index);
            lexer.ch = (char)n;
            ch = n;
            lexer.sp = 0;
            if (ch == 44) {
                lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                lexer.token = 16;
            } else if (ch == 125) {
                lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                lexer.token = 13;
            } else if (ch == 93) {
                lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                lexer.token = 15;
            } else {
                lexer.nextToken();
            }
            if (!disableCircularReferenceDetect) {
                this.setContext(this.contex, object, fieldName);
            }
            Map map = object;
            return map;
        }
        finally {
            if (!disableCircularReferenceDetect) {
                this.contex = context;
            }
        }
    }

    public <T> T parseObject(Class<T> clazz) {
        return this.parseObject(clazz, null);
    }

    public <T> T parseObject(Type type) {
        return this.parseObject(type, null);
    }

    public <T> T parseObject(Type type, Object fieldName) {
        if (this.lexer.token == 8) {
            this.lexer.nextToken();
            return null;
        }
        if (this.lexer.token == 4) {
            if (type == byte[].class) {
                byte[] bytes = this.lexer.bytesValue();
                this.lexer.nextToken();
                return (T)bytes;
            }
            if (type == char[].class) {
                String strVal = this.lexer.stringVal();
                this.lexer.nextToken();
                return (T)strVal.toCharArray();
            }
        }
        ObjectDeserializer derializer = this.config.getDeserializer(type);
        try {
            return derializer.deserialze(this, type, fieldName);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public <T> List<T> parseArray(Class<T> clazz) {
        ArrayList array = new ArrayList();
        this.parseArray(clazz, array);
        return array;
    }

    public void parseArray(Class<?> clazz, Collection array) {
        this.parseArray((Type)clazz, array);
    }

    public void parseArray(Type type, Collection array) {
        this.parseArray(type, array, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseArray(Type type, Collection array, Object fieldName) {
        if (this.lexer.token == 21 || this.lexer.token == 22) {
            this.lexer.nextToken();
        }
        if (this.lexer.token != 14) {
            throw new JSONException("exepct '[', but " + JSONToken.name(this.lexer.token) + ", " + this.lexer.info());
        }
        ObjectDeserializer deserializer = null;
        if (Integer.TYPE == type) {
            deserializer = IntegerCodec.instance;
            this.lexer.nextToken(2);
        } else if (String.class == type) {
            deserializer = StringCodec.instance;
            this.lexer.nextToken(4);
        } else {
            deserializer = this.config.getDeserializer(type);
            this.lexer.nextToken(12);
        }
        ParseContext context = this.contex;
        if (!this.lexer.disableCircularReferenceDetect) {
            this.setContext(this.contex, array, fieldName);
        }
        try {
            int i = 0;
            while (true) {
                Object val;
                if (this.lexer.token == 16) {
                    this.lexer.nextToken();
                    continue;
                }
                if (this.lexer.token == 15) {
                    break;
                }
                if (Integer.TYPE == type) {
                    val = IntegerCodec.instance.deserialze(this, null, null);
                    array.add(val);
                } else if (String.class == type) {
                    String value;
                    if (this.lexer.token == 4) {
                        value = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        Object obj = this.parse();
                        value = obj == null ? null : obj.toString();
                    }
                    array.add(value);
                } else {
                    if (this.lexer.token == 8) {
                        this.lexer.nextToken();
                        val = null;
                    } else {
                        val = deserializer.deserialze(this, type, i);
                    }
                    array.add(val);
                    if (this.resolveStatus == 1) {
                        this.checkListResolve(array);
                    }
                }
                if (this.lexer.token == 16) {
                    this.lexer.nextToken();
                }
                ++i;
            }
        }
        finally {
            this.contex = context;
        }
        this.lexer.nextToken(16);
    }

    public Object[] parseArray(Type[] types) {
        if (this.lexer.token == 8) {
            this.lexer.nextToken(16);
            return null;
        }
        if (this.lexer.token != 14) {
            throw new JSONException("syntax error, " + this.lexer.info());
        }
        Object[] list = new Object[types.length];
        if (types.length == 0) {
            this.lexer.nextToken(15);
            if (this.lexer.token != 15) {
                throw new JSONException("syntax error, " + this.lexer.info());
            }
            this.lexer.nextToken(16);
            return new Object[0];
        }
        this.lexer.nextToken(2);
        for (int i = 0; i < types.length; ++i) {
            Object value;
            if (this.lexer.token == 8) {
                value = null;
                this.lexer.nextToken(16);
            } else {
                Type type = types[i];
                if (type == Integer.TYPE || type == Integer.class) {
                    if (this.lexer.token == 2) {
                        value = this.lexer.intValue();
                        this.lexer.nextToken(16);
                    } else {
                        value = this.parse();
                        value = TypeUtils.cast(value, type, this.config);
                    }
                } else if (type == String.class) {
                    if (this.lexer.token == 4) {
                        value = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        value = this.parse();
                        value = TypeUtils.cast(value, type, this.config);
                    }
                } else {
                    boolean isArray = false;
                    Class<?> componentType = null;
                    if (i == types.length - 1 && type instanceof Class) {
                        Class clazz = (Class)type;
                        isArray = clazz.isArray();
                        componentType = clazz.getComponentType();
                    }
                    if (isArray && this.lexer.token != 14) {
                        ArrayList varList = new ArrayList();
                        ObjectDeserializer derializer = this.config.getDeserializer(componentType);
                        if (this.lexer.token != 15) {
                            while (true) {
                                varList.add(derializer.deserialze(this, type, null));
                                if (this.lexer.token != 16) break;
                                this.lexer.nextToken(12);
                            }
                            if (this.lexer.token != 15) {
                                throw new JSONException("syntax error, " + this.lexer.info());
                            }
                        }
                        value = TypeUtils.cast(varList, type, this.config);
                    } else {
                        ObjectDeserializer derializer = this.config.getDeserializer(type);
                        value = derializer.deserialze(this, type, null);
                    }
                }
            }
            list[i] = value;
            if (this.lexer.token == 15) break;
            if (this.lexer.token != 16) {
                throw new JSONException("syntax error, " + this.lexer.info());
            }
            if (i == types.length - 1) {
                this.lexer.nextToken(15);
                continue;
            }
            this.lexer.nextToken(2);
        }
        if (this.lexer.token != 15) {
            throw new JSONException("syntax error, " + this.lexer.info());
        }
        this.lexer.nextToken(16);
        return list;
    }

    public void parseObject(Object object) {
        block14: {
            int token;
            Class<?> clazz = object.getClass();
            JavaBeanDeserializer beanDeser = null;
            ObjectDeserializer deserizer = this.config.getDeserializer(clazz);
            if (deserizer instanceof JavaBeanDeserializer) {
                beanDeser = (JavaBeanDeserializer)deserizer;
            }
            if ((token = this.lexer.token) != 12 && token != 16) {
                throw new JSONException("syntax error, expect {, actual " + JSONToken.name(token));
            }
            while (true) {
                Object fieldValue;
                String key;
                if ((key = this.lexer.scanSymbol(this.symbolTable)) == null) {
                    if (this.lexer.token != 13) {
                        if (this.lexer.token == 16) continue;
                    }
                    break block14;
                }
                FieldDeserializer fieldDeser = null;
                if (beanDeser != null) {
                    fieldDeser = beanDeser.getFieldDeserializer(key);
                }
                if (fieldDeser == null) {
                    if ((this.lexer.features & Feature.IgnoreNotMatch.mask) == 0) {
                        throw new JSONException("setter not found, class " + clazz.getName() + ", property " + key);
                    }
                    this.lexer.nextTokenWithChar(':');
                    this.parse();
                    if (this.lexer.token != 13) continue;
                    this.lexer.nextToken();
                    return;
                }
                Class<?> fieldClass = fieldDeser.fieldInfo.fieldClass;
                Type fieldType = fieldDeser.fieldInfo.fieldType;
                if (fieldClass == Integer.TYPE) {
                    this.lexer.nextTokenWithChar(':');
                    fieldValue = IntegerCodec.instance.deserialze(this, fieldType, null);
                } else if (fieldClass == String.class) {
                    this.lexer.nextTokenWithChar(':');
                    fieldValue = this.parseString();
                } else if (fieldClass == Long.TYPE) {
                    this.lexer.nextTokenWithChar(':');
                    fieldValue = IntegerCodec.instance.deserialze(this, fieldType, null);
                } else {
                    ObjectDeserializer fieldValueDeserializer = this.config.getDeserializer(fieldClass, fieldType);
                    this.lexer.nextTokenWithChar(':');
                    fieldValue = fieldValueDeserializer.deserialze(this, fieldType, null);
                }
                fieldDeser.setValue(object, fieldValue);
                if (this.lexer.token != 16 && this.lexer.token == 13) break;
            }
            this.lexer.nextToken(16);
            return;
        }
        this.lexer.nextToken(16);
    }

    public Object parseArrayWithType(Type collectionType) {
        if (this.lexer.token == 8) {
            this.lexer.nextToken();
            return null;
        }
        Type[] actualTypes = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (actualTypes.length != 1) {
            throw new JSONException("not support type " + collectionType);
        }
        Type actualTypeArgument = actualTypes[0];
        if (actualTypeArgument instanceof Class) {
            ArrayList array = new ArrayList();
            this.parseArray((Class)actualTypeArgument, array);
            return array;
        }
        if (actualTypeArgument instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)actualTypeArgument;
            Type upperBoundType = wildcardType.getUpperBounds()[0];
            if (Object.class.equals((Object)upperBoundType)) {
                if (wildcardType.getLowerBounds().length == 0) {
                    return this.parse();
                }
                throw new JSONException("not support type : " + collectionType);
            }
            ArrayList array = new ArrayList();
            this.parseArray((Class)upperBoundType, array);
            return array;
        }
        if (actualTypeArgument instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualTypeArgument;
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length != 1) {
                throw new JSONException("not support : " + typeVariable);
            }
            Type boundType = bounds[0];
            if (boundType instanceof Class) {
                ArrayList array = new ArrayList();
                this.parseArray((Class)boundType, array);
                return array;
            }
        }
        if (actualTypeArgument instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actualTypeArgument;
            ArrayList array = new ArrayList();
            this.parseArray(parameterizedType, array);
            return array;
        }
        throw new JSONException("TODO : " + collectionType);
    }

    protected void checkListResolve(Collection array) {
        if (array instanceof List) {
            ResolveTask task = this.getLastResolveTask();
            task.fieldDeserializer = new ResolveFieldDeserializer(this, (List)array, array.size() - 1);
            task.ownerContext = this.contex;
            this.resolveStatus = 0;
        } else {
            ResolveTask task = this.getLastResolveTask();
            task.fieldDeserializer = new ResolveFieldDeserializer(array);
            task.ownerContext = this.contex;
            this.resolveStatus = 0;
        }
    }

    protected void checkMapResolve(Map object, Object fieldName) {
        ResolveFieldDeserializer fieldResolver = new ResolveFieldDeserializer(object, fieldName);
        ResolveTask task = this.getLastResolveTask();
        task.fieldDeserializer = fieldResolver;
        task.ownerContext = this.contex;
        this.resolveStatus = 0;
    }

    public Object parseObject(Map object) {
        return this.parseObject(object, null);
    }

    public JSONObject parseObject() {
        JSONObject object = (this.lexer.features & Feature.OrderedField.mask) != 0 ? new JSONObject(new LinkedHashMap<String, Object>()) : new JSONObject();
        return (JSONObject)this.parseObject(object, null);
    }

    public final void parseArray(Collection array) {
        this.parseArray(array, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseArray(Collection array, Object fieldName) {
        int token = this.lexer.token;
        if (token == 21 || token == 22) {
            this.lexer.nextToken();
            token = this.lexer.token;
        }
        if (token != 14) {
            throw new JSONException("syntax error, expect [, actual " + JSONToken.name(token) + ", pos " + this.lexer.pos);
        }
        boolean disableCircularReferenceDetect = this.lexer.disableCircularReferenceDetect;
        ParseContext context = this.contex;
        if (!disableCircularReferenceDetect) {
            this.setContext(this.contex, array, fieldName);
        }
        try {
            boolean first_quote;
            int ch = this.lexer.ch;
            if (ch != 34) {
                if (ch == 93) {
                    this.lexer.next();
                    this.lexer.nextToken(16);
                    return;
                }
                if (ch == 123) {
                    int index;
                    this.lexer.ch = (char)((index = ++this.lexer.bp) >= this.lexer.len ? 26 : (int)this.lexer.text.charAt(index));
                    this.lexer.token = 12;
                } else {
                    this.lexer.nextToken(12);
                }
                first_quote = false;
            } else if ((this.lexer.features & Feature.AllowISO8601DateFormat.mask) == 0) {
                first_quote = true;
            } else {
                this.lexer.nextToken(4);
                first_quote = false;
            }
            int i = 0;
            while (true) {
                block46: {
                    int index;
                    Object value;
                    block44: {
                        block45: {
                            if (!first_quote || this.lexer.ch != '\"') break block44;
                            value = this.lexer.scanStringValue('\"');
                            ch = this.lexer.ch;
                            if (ch != 44) break block45;
                            int n = (index = ++this.lexer.bp) >= this.lexer.len ? 26 : (int)this.lexer.text.charAt(index);
                            this.lexer.ch = (char)n;
                            ch = n;
                            array.add(value);
                            if (this.resolveStatus == 1) {
                                this.checkListResolve(array);
                            }
                            if (ch == 34) break block46;
                            first_quote = false;
                            this.lexer.nextToken();
                            break block44;
                        }
                        if (ch == 93) {
                            this.lexer.ch = (char)((index = ++this.lexer.bp) >= this.lexer.len ? 26 : (int)this.lexer.text.charAt(index));
                            array.add(value);
                            if (this.resolveStatus == 1) {
                                this.checkListResolve(array);
                            }
                            this.lexer.nextToken(16);
                            break;
                        }
                        this.lexer.nextToken();
                    }
                    token = this.lexer.token;
                    while (token == 16) {
                        this.lexer.nextToken();
                        token = this.lexer.token;
                    }
                    switch (token) {
                        case 2: {
                            value = this.lexer.integerValue();
                            this.lexer.nextToken(16);
                            break;
                        }
                        case 3: {
                            value = (this.lexer.features & Feature.UseBigDecimal.mask) != 0 ? (Number)this.lexer.decimalValue(true) : (Number)this.lexer.decimalValue(false);
                            this.lexer.nextToken(16);
                            break;
                        }
                        case 4: {
                            String stringLiteral = this.lexer.stringVal();
                            this.lexer.nextToken(16);
                            if ((this.lexer.features & Feature.AllowISO8601DateFormat.mask) != 0) {
                                JSONLexer iso8601Lexer = new JSONLexer(stringLiteral);
                                value = iso8601Lexer.scanISO8601DateIfMatch(true) ? iso8601Lexer.calendar.getTime() : stringLiteral;
                                iso8601Lexer.close();
                                break;
                            }
                            value = stringLiteral;
                            break;
                        }
                        case 6: {
                            value = Boolean.TRUE;
                            this.lexer.nextToken(16);
                            break;
                        }
                        case 7: {
                            value = Boolean.FALSE;
                            this.lexer.nextToken(16);
                            break;
                        }
                        case 12: {
                            JSONObject object = (this.lexer.features & Feature.OrderedField.mask) != 0 ? new JSONObject(new LinkedHashMap<String, Object>()) : new JSONObject();
                            value = this.parseObject(object, (Object)i);
                            break;
                        }
                        case 14: {
                            JSONArray items = new JSONArray();
                            this.parseArray(items, i);
                            value = items;
                            break;
                        }
                        case 8: {
                            value = null;
                            this.lexer.nextToken(4);
                            break;
                        }
                        case 23: {
                            value = null;
                            this.lexer.nextToken(4);
                            break;
                        }
                        case 15: {
                            this.lexer.nextToken(16);
                            return;
                        }
                        case 20: {
                            throw new JSONException("unclosed jsonArray");
                        }
                        default: {
                            value = this.parse();
                        }
                    }
                    array.add(value);
                    if (this.resolveStatus == 1) {
                        this.checkListResolve(array);
                    }
                    if (this.lexer.token == 16) {
                        ch = this.lexer.ch;
                        if (ch == 34) {
                            this.lexer.pos = this.lexer.bp;
                            this.lexer.scanString();
                        } else if (ch >= 48 && ch <= 57) {
                            this.lexer.pos = this.lexer.bp;
                            this.lexer.scanNumber();
                        } else if (ch == 123) {
                            this.lexer.token = 12;
                            this.lexer.ch = (char)((index = ++this.lexer.bp) >= this.lexer.len ? 26 : (int)this.lexer.text.charAt(index));
                        } else {
                            this.lexer.nextToken();
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            if (!disableCircularReferenceDetect) {
                this.contex = context;
            }
        }
    }

    protected void addResolveTask(ResolveTask task) {
        if (this.resolveTaskList == null) {
            this.resolveTaskList = new ArrayList<ResolveTask>(2);
        }
        this.resolveTaskList.add(task);
    }

    protected ResolveTask getLastResolveTask() {
        return this.resolveTaskList.get(this.resolveTaskList.size() - 1);
    }

    public List<ExtraProcessor> getExtraProcessors() {
        if (this.extraProcessors == null) {
            this.extraProcessors = new ArrayList<ExtraProcessor>(2);
        }
        return this.extraProcessors;
    }

    public List<ExtraTypeProvider> getExtraTypeProviders() {
        if (this.extraTypeProviders == null) {
            this.extraTypeProviders = new ArrayList<ExtraTypeProvider>(2);
        }
        return this.extraTypeProviders;
    }

    public void setContext(ParseContext context) {
        if (this.lexer.disableCircularReferenceDetect) {
            return;
        }
        this.contex = context;
    }

    protected void popContext() {
        this.contex = this.contex.parent;
        this.contextArray[this.contextArrayIndex - 1] = null;
        --this.contextArrayIndex;
    }

    protected ParseContext setContext(ParseContext parent, Object object, Object fieldName) {
        if (this.lexer.disableCircularReferenceDetect) {
            return null;
        }
        this.contex = new ParseContext(parent, object, fieldName);
        int i = this.contextArrayIndex++;
        if (this.contextArray == null) {
            this.contextArray = new ParseContext[8];
        } else if (i >= this.contextArray.length) {
            int newLen = this.contextArray.length * 3 / 2;
            ParseContext[] newArray = new ParseContext[newLen];
            System.arraycopy(this.contextArray, 0, newArray, 0, this.contextArray.length);
            this.contextArray = newArray;
        }
        this.contextArray[i] = this.contex;
        return this.contex;
    }

    public Object parse() {
        return this.parse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(Object fieldName) {
        switch (this.lexer.token) {
            case 21: {
                this.lexer.nextToken();
                HashSet set = new HashSet();
                this.parseArray(set, fieldName);
                return set;
            }
            case 22: {
                this.lexer.nextToken();
                TreeSet treeSet = new TreeSet();
                this.parseArray(treeSet, fieldName);
                return treeSet;
            }
            case 14: {
                JSONArray array = new JSONArray();
                this.parseArray(array, fieldName);
                return array;
            }
            case 12: {
                JSONObject object = (this.lexer.features & Feature.OrderedField.mask) != 0 ? new JSONObject(new LinkedHashMap<String, Object>()) : new JSONObject();
                return this.parseObject(object, fieldName);
            }
            case 2: {
                Number intValue = this.lexer.integerValue();
                this.lexer.nextToken();
                return intValue;
            }
            case 3: {
                boolean useBigDecimal = (this.lexer.features & Feature.UseBigDecimal.mask) != 0;
                Number value = this.lexer.decimalValue(useBigDecimal);
                this.lexer.nextToken();
                return value;
            }
            case 4: {
                String stringLiteral = this.lexer.stringVal();
                this.lexer.nextToken(16);
                if ((this.lexer.features & Feature.AllowISO8601DateFormat.mask) != 0) {
                    JSONLexer iso8601Lexer = new JSONLexer(stringLiteral);
                    try {
                        if (iso8601Lexer.scanISO8601DateIfMatch(true)) {
                            Date date = iso8601Lexer.calendar.getTime();
                            return date;
                        }
                    }
                    finally {
                        iso8601Lexer.close();
                    }
                }
                return stringLiteral;
            }
            case 8: 
            case 23: {
                this.lexer.nextToken();
                return null;
            }
            case 6: {
                this.lexer.nextToken(16);
                return Boolean.TRUE;
            }
            case 7: {
                this.lexer.nextToken(16);
                return Boolean.FALSE;
            }
            case 9: {
                this.lexer.nextToken(18);
                if (this.lexer.token != 18) {
                    throw new JSONException("syntax error, " + this.lexer.info());
                }
                this.lexer.nextToken(10);
                this.accept(10);
                long time = this.lexer.integerValue().longValue();
                this.accept(2);
                this.accept(11);
                return new Date(time);
            }
            case 20: {
                if (this.lexer.isBlankInput()) {
                    return null;
                }
                throw new JSONException("syntax error, " + this.lexer.info());
            }
        }
        throw new JSONException("syntax error, " + this.lexer.info());
    }

    public void config(Feature feature, boolean state) {
        this.lexer.config(feature, state);
    }

    public final void accept(int token) {
        if (this.lexer.token != token) {
            throw new JSONException("syntax error, expect " + JSONToken.name(token) + ", actual " + JSONToken.name(this.lexer.token));
        }
        this.lexer.nextToken();
    }

    @Override
    public void close() {
        try {
            if (this.lexer.token != 20) {
                throw new JSONException("not close json text, token : " + JSONToken.name(this.lexer.token));
            }
        }
        finally {
            this.lexer.close();
        }
    }

    public void handleResovleTask(Object value) {
        if (this.resolveTaskList == null) {
            return;
        }
        int size = this.resolveTaskList.size();
        for (int i = 0; i < size; ++i) {
            ResolveTask task = this.resolveTaskList.get(i);
            FieldDeserializer fieldDeser = task.fieldDeserializer;
            if (fieldDeser == null) continue;
            Object object = null;
            if (task.ownerContext != null) {
                object = task.ownerContext.object;
            }
            String ref = task.referenceValue;
            Object refValue = null;
            if (ref.startsWith("$")) {
                for (int j = 0; j < this.contextArrayIndex; ++j) {
                    if (!ref.equals(this.contextArray[j].toString())) continue;
                    refValue = this.contextArray[j].object;
                }
            } else {
                refValue = ((ResolveTask)task).context.object;
            }
            fieldDeser.setValue(object, refValue);
        }
    }

    public String parseString() {
        int token = this.lexer.token;
        if (token == 4) {
            String val = this.lexer.stringVal();
            if (this.lexer.ch == ',') {
                int index;
                this.lexer.ch = (char)((index = ++this.lexer.bp) >= this.lexer.len ? 26 : (int)this.lexer.text.charAt(index));
                this.lexer.token = 16;
            } else if (this.lexer.ch == ']') {
                int index;
                this.lexer.ch = (char)((index = ++this.lexer.bp) >= this.lexer.len ? 26 : (int)this.lexer.text.charAt(index));
                this.lexer.token = 15;
            } else if (this.lexer.ch == '}') {
                int index;
                this.lexer.ch = (char)((index = ++this.lexer.bp) >= this.lexer.len ? 26 : (int)this.lexer.text.charAt(index));
                this.lexer.token = 13;
            } else {
                this.lexer.nextToken();
            }
            return val;
        }
        if (token == 2) {
            String val = this.lexer.numberString();
            this.lexer.nextToken(16);
            return val;
        }
        Object value = this.parse();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static class ResolveTask {
        private final ParseContext context;
        private final String referenceValue;
        public FieldDeserializer fieldDeserializer;
        public ParseContext ownerContext;

        public ResolveTask(ParseContext context, String referenceValue) {
            this.context = context;
            this.referenceValue = referenceValue;
        }
    }
}

