/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.DefaultFieldDeserializer;
import com.alibaba.fastjson.parser.EnumDeserializer;
import com.alibaba.fastjson.parser.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.JavaBeanInfo;
import com.alibaba.fastjson.parser.JavaObjectDeserializer;
import com.alibaba.fastjson.parser.ListTypeFieldDeserializer;
import com.alibaba.fastjson.parser.MapDeserializer;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.ThrowableDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ArrayCodec;
import com.alibaba.fastjson.serializer.BigDecimalCodec;
import com.alibaba.fastjson.serializer.BooleanCodec;
import com.alibaba.fastjson.serializer.CollectionCodec;
import com.alibaba.fastjson.serializer.DateCodec;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.MiscCodec;
import com.alibaba.fastjson.serializer.NumberCodec;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.IdentityHashMap;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserConfig {
    public static ParserConfig global = new ParserConfig();
    private final IdentityHashMap<ObjectDeserializer> derializers = new IdentityHashMap(1024);
    public final SymbolTable symbolTable = new SymbolTable(4096);
    public ClassLoader defaultClassLoader;

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    public ParserConfig() {
        this.derializers.put((Type)((Object)SimpleDateFormat.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)java.util.Date.class), DateCodec.instance);
        this.derializers.put((Type)((Object)Calendar.class), DateCodec.instance);
        this.derializers.put((Type)((Object)Map.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)HashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)LinkedHashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)TreeMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)ConcurrentMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)ConcurrentHashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)Collection.class), CollectionCodec.instance);
        this.derializers.put((Type)((Object)List.class), CollectionCodec.instance);
        this.derializers.put((Type)((Object)ArrayList.class), CollectionCodec.instance);
        this.derializers.put((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)String.class), StringCodec.instance);
        this.derializers.put(Character.TYPE, MiscCodec.instance);
        this.derializers.put((Type)((Object)Character.class), MiscCodec.instance);
        this.derializers.put(Byte.TYPE, NumberCodec.instance);
        this.derializers.put((Type)((Object)Byte.class), NumberCodec.instance);
        this.derializers.put(Short.TYPE, NumberCodec.instance);
        this.derializers.put((Type)((Object)Short.class), NumberCodec.instance);
        this.derializers.put(Integer.TYPE, IntegerCodec.instance);
        this.derializers.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.derializers.put(Long.TYPE, IntegerCodec.instance);
        this.derializers.put((Type)((Object)Long.class), IntegerCodec.instance);
        this.derializers.put((Type)((Object)BigInteger.class), BigDecimalCodec.instance);
        this.derializers.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.derializers.put(Float.TYPE, NumberCodec.instance);
        this.derializers.put((Type)((Object)Float.class), NumberCodec.instance);
        this.derializers.put(Double.TYPE, NumberCodec.instance);
        this.derializers.put((Type)((Object)Double.class), NumberCodec.instance);
        this.derializers.put(Boolean.TYPE, BooleanCodec.instance);
        this.derializers.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.derializers.put((Type)((Object)Class.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)char[].class), ArrayCodec.instance);
        this.derializers.put((Type)((Object)Object[].class), ArrayCodec.instance);
        this.derializers.put((Type)((Object)UUID.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)TimeZone.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Locale.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Currency.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)URI.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)URL.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Pattern.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Charset.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Number.class), NumberCodec.instance);
        this.derializers.put((Type)((Object)StackTraceElement.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Serializable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Cloneable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Comparable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Closeable.class), JavaObjectDeserializer.instance);
    }

    public ObjectDeserializer getDeserializer(Type type) {
        ObjectDeserializer derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type instanceof Class) {
            return this.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return this.getDeserializer((Class)rawType, type);
            }
            return this.getDeserializer(rawType);
        }
        return JavaObjectDeserializer.instance;
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type type) {
        Class<?> mappingTo;
        JSONType annotation;
        ObjectDeserializer deserializer = this.derializers.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (type == null) {
            type = clazz;
        }
        if ((deserializer = this.derializers.get(type)) != null) {
            return deserializer;
        }
        if (!this.isPrimitive(clazz) && (annotation = clazz.getAnnotation(JSONType.class)) != null && (mappingTo = annotation.mappingTo()) != Void.class) {
            return this.getDeserializer(mappingTo, mappingTo);
        }
        if (type instanceof WildcardType || type instanceof TypeVariable || type instanceof ParameterizedType) {
            deserializer = this.derializers.get(clazz);
        }
        if (deserializer != null) {
            return deserializer;
        }
        deserializer = this.derializers.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        deserializer = clazz.isEnum() ? new EnumDeserializer(clazz) : (clazz.isArray() ? ArrayCodec.instance : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionCodec.instance : (Collection.class.isAssignableFrom(clazz) ? CollectionCodec.instance : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.instance : (Throwable.class.isAssignableFrom(clazz) ? new ThrowableDeserializer(this, clazz) : new JavaBeanDeserializer(this, clazz, type))))));
        this.putDeserializer(type, deserializer);
        return deserializer;
    }

    public ObjectDeserializer registerIfNotExists(Class<?> clazz) {
        return this.registerIfNotExists(clazz, clazz.getModifiers(), false, true, true, true);
    }

    public ObjectDeserializer registerIfNotExists(Class<?> clazz, int classModifiers, boolean fieldOnly, boolean jsonTypeSupport, boolean jsonFieldSupport, boolean fieldGenericSupport) {
        ObjectDeserializer deserializer = this.derializers.get(clazz);
        if (deserializer != null) {
            return deserializer;
        }
        JavaBeanInfo beanInfo = JavaBeanInfo.build(clazz, classModifiers, clazz, fieldOnly, jsonTypeSupport, jsonFieldSupport, fieldGenericSupport);
        deserializer = new JavaBeanDeserializer(this, clazz, clazz, beanInfo);
        this.putDeserializer(clazz, deserializer);
        return deserializer;
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        Class<?> fieldClass = fieldInfo.fieldClass;
        if (fieldClass == List.class || fieldClass == ArrayList.class || fieldClass.isArray() && !fieldClass.getComponentType().isPrimitive()) {
            return new ListTypeFieldDeserializer(mapping, clazz, fieldInfo);
        }
        return new DefaultFieldDeserializer(mapping, clazz, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer deserializer) {
        this.derializers.put(type, deserializer);
    }

    public boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Time.class || clazz == Timestamp.class;
    }
}

