/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySerializer
implements ObjectSerializer {
    private final Class<?> componentType;
    private final ObjectSerializer compObjectSerializer;

    public ArraySerializer(Class<?> componentType, ObjectSerializer compObjectSerializer) {
        this.componentType = componentType;
        this.compObjectSerializer = compObjectSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            if ((out.features & SerializerFeature.WriteNullListAsEmpty.mask) != 0) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        if (object instanceof boolean[]) {
            boolean[] array = (boolean[])object;
            out.write('[');
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    out.write(',');
                }
                out.write(array[i]);
            }
            out.write(']');
            return;
        }
        if (object instanceof byte[]) {
            byte[] array = (byte[])object;
            out.writeByteArray(array);
            return;
        }
        if (object instanceof char[]) {
            char[] chars = (char[])object;
            out.writeString(new String(chars));
            return;
        }
        if (object instanceof double[]) {
            double[] array = (double[])object;
            int size = array.length;
            int end = size - 1;
            if (end == -1) {
                out.append("[]");
                return;
            }
            out.write('[');
            for (int i = 0; i < end; ++i) {
                double item = array[i];
                if (Double.isNaN(item)) {
                    out.writeNull();
                } else {
                    out.append(Double.toString(item));
                }
                out.write(',');
            }
            double item = array[end];
            if (Double.isNaN(item)) {
                out.writeNull();
            } else {
                out.append(Double.toString(item));
            }
            out.write(']');
            return;
        }
        if (object instanceof float[]) {
            float[] array = (float[])object;
            int size = array.length;
            int end = size - 1;
            if (end == -1) {
                out.append("[]");
                return;
            }
            out.write('[');
            for (int i = 0; i < end; ++i) {
                float item = array[i];
                if (Float.isNaN(item)) {
                    out.writeNull();
                } else {
                    out.append(Float.toString(item));
                }
                out.write(',');
            }
            float item = array[end];
            if (Float.isNaN(item)) {
                out.writeNull();
            } else {
                out.append(Float.toString(item));
            }
            out.write(']');
            return;
        }
        if (object instanceof int[]) {
            int[] array = (int[])object;
            out.write('[');
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    out.write(',');
                }
                out.writeInt(array[i]);
            }
            out.write(']');
            return;
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            out.write('[');
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    out.write(',');
                }
                out.writeLong(array[i]);
            }
            out.write(']');
            return;
        }
        if (object instanceof short[]) {
            short[] array = (short[])object;
            out.write('[');
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    out.write(',');
                }
                out.writeInt(array[i]);
            }
            out.write(']');
            return;
        }
        Object[] array = (Object[])object;
        int size = array.length;
        SerialContext context = serializer.context;
        serializer.setContext(context, object, fieldName, 0);
        try {
            out.write('[');
            for (int i = 0; i < size; ++i) {
                Object item;
                if (i != 0) {
                    out.write(',');
                }
                if ((item = array[i]) == null) {
                    out.append("null");
                    continue;
                }
                if (item.getClass() == this.componentType) {
                    this.compObjectSerializer.write(serializer, item, i, null);
                    continue;
                }
                ObjectSerializer itemSerializer = serializer.getObjectWriter(item.getClass());
                itemSerializer.write(serializer, item, i, null);
            }
            out.write(']');
        }
        finally {
            serializer.context = context;
        }
    }
}

