/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.util.IOUtils;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONLexer {
    public static final byte EOI = 26;
    public static final int NOT_MATCH = -1;
    public static final int NOT_MATCH_NAME = -2;
    public static final int UNKOWN = 0;
    public static final int OBJECT = 1;
    public static final int ARRAY = 2;
    public static final int VALUE = 3;
    public static final int END = 4;
    private static final Map<String, Integer> DEFAULT_KEYWORDS;
    protected int token;
    protected int pos;
    public int features = JSON.DEFAULT_PARSER_FEATURE;
    protected char ch;
    protected int bp;
    protected int eofPos;
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected boolean hasSpecial;
    protected Calendar calendar = null;
    public int matchStat = 0;
    private static final ThreadLocal<SoftReference<char[]>> SBUF_REF_LOCAL;
    protected Map<String, Integer> keywods = DEFAULT_KEYWORDS;
    protected final String text;
    protected final int len;
    protected static boolean[] whitespaceFlags;
    protected static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    protected static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    protected static final int INT_MULTMIN_RADIX_TEN = -214748364;
    protected static final int INT_N_MULTMAX_RADIX_TEN = -214748364;
    protected static final int[] digits;
    static final int ISO8601_LEN_0;
    static final int ISO8601_LEN_1;
    static final int ISO8601_LEN_2;
    public static final char[] CA;
    static final int[] IA;

    public JSONLexer(String input) {
        this(input, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONLexer(char[] input, int inputLength) {
        this(input, inputLength, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONLexer(char[] input, int inputLength, int features) {
        this(new String(input, 0, inputLength), features);
    }

    public JSONLexer(String input, int features) {
        SoftReference<char[]> sbufRef = SBUF_REF_LOCAL.get();
        if (sbufRef != null) {
            this.sbuf = sbufRef.get();
            SBUF_REF_LOCAL.set(null);
        }
        if (this.sbuf == null) {
            this.sbuf = new char[64];
        }
        this.features = features;
        this.text = input;
        this.len = this.text.length();
        this.bp = -1;
        this.next();
        if (this.ch == '\ufeff') {
            this.next();
        }
    }

    public final int token() {
        return this.token;
    }

    public void close() {
        if (this.sbuf.length <= 8192) {
            SBUF_REF_LOCAL.set(new SoftReference<char[]>(this.sbuf));
        }
        this.sbuf = null;
    }

    public final char getCurrent() {
        return this.ch;
    }

    public char next() {
        int index;
        if ((index = ++this.bp) >= this.len) {
            this.ch = '\u001a';
            return '\u001a';
        }
        this.ch = this.text.charAt(index);
        return this.ch;
    }

    public final void config(Feature feature, boolean state) {
        this.features = state ? (this.features |= feature.mask) : (this.features &= ~feature.mask);
    }

    public final boolean isEnabled(Feature feature) {
        return (this.features & feature.mask) != 0;
    }

    public final void nextTokenWithChar(char expect) {
        this.sp = 0;
        while (true) {
            if (this.ch == expect) {
                this.next();
                this.nextToken();
                return;
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        throw new JSONException("not match " + expect + " - " + this.ch);
    }

    public final boolean isRef() {
        if (this.sp != 4) {
            return false;
        }
        return this.charAt(this.np + 1) == '$' && this.charAt(this.np + 2) == 'r' && this.charAt(this.np + 3) == 'e' && this.charAt(this.np + 4) == 'f';
    }

    public final String numberString() {
        int index = this.np + this.sp - 1;
        char chLocal = this.text.charAt(index);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        return this.subString(this.np, sp);
    }

    private char charAt(int index) {
        if (index >= this.len) {
            return '\u001a';
        }
        return this.text.charAt(index);
    }

    public final void nextToken() {
        boolean eof;
        this.sp = 0;
        block17: while (true) {
            this.pos = this.bp;
            if (this.ch == '\"') {
                this.scanString();
                return;
            }
            if (this.ch == ',') {
                this.next();
                this.token = 16;
                return;
            }
            if (this.ch >= '0' && this.ch <= '9') {
                this.scanNumber();
                return;
            }
            if (this.ch == '-') {
                this.scanNumber();
                return;
            }
            switch (this.ch) {
                case '\'': {
                    if ((this.features & Feature.AllowSingleQuotes.mask) == 0) {
                        throw new JSONException("Feature.AllowSingleQuotes is false");
                    }
                    this.scanStringSingleQuote();
                    return;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    this.next();
                    continue block17;
                }
                case 't': {
                    this.scanTrue();
                    return;
                }
                case 'T': {
                    this.scanTreeSet();
                    return;
                }
                case 'S': {
                    this.scanSet();
                    return;
                }
                case 'f': {
                    this.scanFalse();
                    return;
                }
                case 'n': {
                    this.scanNullOrNew();
                    return;
                }
                case 'u': {
                    this.scanUndefined();
                    return;
                }
                case '(': {
                    this.next();
                    this.token = 10;
                    return;
                }
                case ')': {
                    this.next();
                    this.token = 11;
                    return;
                }
                case '[': {
                    this.next();
                    this.token = 14;
                    return;
                }
                case ']': {
                    this.next();
                    this.token = 15;
                    return;
                }
                case '{': {
                    this.next();
                    this.token = 12;
                    return;
                }
                case '}': {
                    this.next();
                    this.token = 13;
                    return;
                }
                case ':': {
                    this.next();
                    this.token = 17;
                    return;
                }
            }
            break;
        }
        boolean bl = eof = this.bp == this.len || this.ch == '\u001a' && this.bp + 1 == this.len;
        if (eof) {
            if (this.token == 20) {
                throw new JSONException("EOF error");
            }
            this.token = 20;
            this.pos = this.bp = this.eofPos;
        } else {
            this.token = 1;
            this.next();
        }
    }

    public final void nextToken(int expect) {
        this.sp = 0;
        while (true) {
            switch (expect) {
                case 12: {
                    if (this.ch == '{') {
                        this.token = 12;
                        this.next();
                        return;
                    }
                    if (this.ch != '[') break;
                    this.token = 14;
                    this.next();
                    return;
                }
                case 16: {
                    if (this.ch == ',') {
                        this.token = 16;
                        this.next();
                        return;
                    }
                    if (this.ch == '}') {
                        this.token = 13;
                        this.next();
                        return;
                    }
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 2: {
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 4: {
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 14: {
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 15: {
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                }
                case 20: {
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 18: {
                    this.nextIdent();
                    return;
                }
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        this.nextToken();
    }

    public final void nextIdent() {
        while (JSONLexer.isWhitespace(this.ch)) {
            this.next();
        }
        if (this.ch == '_' || Character.isLetter(this.ch)) {
            this.scanIdent();
        } else {
            this.nextToken();
        }
    }

    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    public final int pos() {
        return this.pos;
    }

    private String stringDefaultValue() {
        if ((this.features & Feature.InitStringFieldAsEmpty.mask) != 0) {
            return "";
        }
        return null;
    }

    public final Number integerValue() throws NumberFormatException {
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        if (this.np == -1) {
            this.np = 0;
        }
        int i = this.np;
        int max = this.np + this.sp;
        int type = 32;
        switch (this.charAt(max - 1)) {
            case 'L': {
                --max;
                type = 76;
                break;
            }
            case 'S': {
                --max;
                type = 83;
                break;
            }
            case 'B': {
                --max;
                type = 66;
                break;
            }
        }
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max) {
            digit = digits[this.charAt(i++)];
            if (result < multmin) {
                return new BigInteger(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                if (result >= Integer.MIN_VALUE && type != 76) {
                    if (type == 83) {
                        return (short)result;
                    }
                    if (type == 66) {
                        return (byte)result;
                    }
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((result = -result) <= Integer.MAX_VALUE && type != 76) {
            if (type == 83) {
                return (short)result;
            }
            if (type == 66) {
                return (byte)result;
            }
            return (int)result;
        }
        return result;
    }

    public final String scanSymbol(SymbolTable symbolTable) {
        while (this.ch < whitespaceFlags.length && whitespaceFlags[this.ch]) {
            this.next();
        }
        if (this.ch == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.ch == '\'') {
            if ((this.features & Feature.AllowSingleQuotes.mask) == 0) {
                throw new JSONException("syntax error");
            }
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.ch == '}') {
            this.next();
            this.token = 13;
            return null;
        }
        if (this.ch == ',') {
            this.next();
            this.token = 16;
            return null;
        }
        if (this.ch == '\u001a') {
            this.token = 20;
            return null;
        }
        if ((this.features & Feature.AllowUnQuotedFieldNames.mask) == 0) {
            throw new JSONException("syntax error");
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    public final String scanSymbol(SymbolTable symbolTable, char quote) {
        String value;
        char chLocal;
        int hash = 0;
        this.np = this.bp;
        this.sp = 0;
        boolean hasSpecial = false;
        block22: while ((chLocal = this.next()) != quote) {
            if (chLocal == '\u001a') {
                throw new JSONException("unclosed.str");
            }
            if (chLocal == '\\') {
                if (!hasSpecial) {
                    hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        int newCapcity = this.sbuf.length * 2;
                        if (this.sp > newCapcity) {
                            newCapcity = this.sp;
                        }
                        char[] newsbuf = new char[newCapcity];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    this.text.getChars(this.np + 1, this.np + 1 + this.sp, this.sbuf, 0);
                }
                chLocal = this.next();
                switch (chLocal) {
                    case '0': {
                        hash = 31 * hash + chLocal;
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        hash = 31 * hash + chLocal;
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        hash = 31 * hash + chLocal;
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        hash = 31 * hash + chLocal;
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        hash = 31 * hash + chLocal;
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        hash = 31 * hash + chLocal;
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        hash = 31 * hash + chLocal;
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        hash = 31 * hash + chLocal;
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        hash = 31 * hash + 8;
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        hash = 31 * hash + 9;
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        hash = 31 * hash + 10;
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        hash = 31 * hash + 11;
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        hash = 31 * hash + 12;
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        hash = 31 * hash + 13;
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        hash = 31 * hash + 34;
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        hash = 31 * hash + 39;
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        hash = 31 * hash + 47;
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        hash = 31 * hash + 92;
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        char x1 = this.ch = this.next();
                        char x2 = this.ch = this.next();
                        int x_val = digits[x1] * 16 + digits[x2];
                        char x_char = (char)x_val;
                        hash = 31 * hash + x_char;
                        this.putChar(x_char);
                        continue block22;
                    }
                    case 'u': {
                        char c1 = chLocal = this.next();
                        char c2 = chLocal = this.next();
                        char c3 = chLocal = this.next();
                        char c4 = chLocal = this.next();
                        int val = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                        hash = 31 * hash + val;
                        this.putChar((char)val);
                        continue block22;
                    }
                }
                this.ch = chLocal;
                throw new JSONException("unclosed.str.lit");
            }
            hash = 31 * hash + chLocal;
            if (!hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(chLocal);
                continue;
            }
            this.sbuf[this.sp++] = chLocal;
        }
        this.token = 4;
        if (!hasSpecial) {
            int offset = this.np == -1 ? 0 : this.np + 1;
            value = symbolTable.addSymbol(this.text, offset, this.sp, hash);
        } else {
            value = symbolTable.addSymbol(this.sbuf, 0, this.sp, hash);
        }
        this.sp = 0;
        this.next();
        return value;
    }

    public final void resetStringPosition() {
        this.sp = 0;
    }

    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char chLocal;
        boolean firstFlag;
        boolean[] firstIdentifierFlags = IOUtils.firstIdentifierFlags;
        int first = this.ch;
        boolean bl = firstFlag = this.ch >= firstIdentifierFlags.length || firstIdentifierFlags[first];
        if (!firstFlag) {
            throw new JSONException("illegal identifier : " + this.ch);
        }
        boolean[] identifierFlags = IOUtils.identifierFlags;
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        while ((chLocal = this.next()) >= identifierFlags.length || identifierFlags[chLocal]) {
            hash = 31 * hash + chLocal;
            ++this.sp;
        }
        this.ch = this.charAt(this.bp);
        this.token = 18;
        int NULL_HASH = 3392903;
        if (this.sp == 4 && hash == 3392903 && this.charAt(this.np) == 'n' && this.charAt(this.np + 1) == 'u' && this.charAt(this.np + 2) == 'l' && this.charAt(this.np + 3) == 'l') {
            return null;
        }
        return symbolTable.addSymbol(this.text, this.np, this.sp, hash);
    }

    public final void scanString() {
        char ch;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((ch = this.next()) != '\"') {
            if (ch == '\u001a') {
                throw new JSONException("unclosed string : " + ch);
            }
            if (ch == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        int newCapcity = this.sbuf.length * 2;
                        if (this.sp > newCapcity) {
                            newCapcity = this.sp;
                        }
                        char[] newsbuf = new char[newCapcity];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    this.text.getChars(this.np + 1, this.np + 1 + this.sp, this.sbuf, 0);
                }
                ch = this.next();
                switch (ch) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        char x1 = ch = this.next();
                        char x2 = ch = this.next();
                        int x_val = digits[x1] * 16 + digits[x2];
                        char x_char = (char)x_val;
                        this.putChar(x_char);
                        continue block22;
                    }
                    case 'u': {
                        char u1 = ch = this.next();
                        char u2 = ch = this.next();
                        char u3 = ch = this.next();
                        char u4 = ch = this.next();
                        int val = Integer.parseInt(new String(new char[]{u1, u2, u3, u4}), 16);
                        this.putChar((char)val);
                        continue block22;
                    }
                }
                this.ch = ch;
                throw new JSONException("unclosed string : " + ch);
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(ch);
                continue;
            }
            this.sbuf[this.sp++] = ch;
        }
        this.token = 4;
        this.ch = this.next();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public final int intValue() {
        char chLocal;
        int digit;
        int multmin;
        int limit;
        if (this.np == -1) {
            this.np = 0;
        }
        int result = 0;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int n = multmin = negative ? -214748364 : -214748364;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max && (chLocal = this.charAt(i++)) != 'L' && chLocal != 'S' && chLocal != 'B') {
            digit = digits[chLocal];
            if (result < multmin) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10) < limit + digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    public byte[] bytesValue() {
        return JSONLexer.decodeFast(this.text, this.np + 1, this.sp);
    }

    public String scanString(char expectNextChar) {
        char chLocal;
        this.matchStat = 0;
        int offset = 0;
        if ((chLocal = this.charAt(this.bp + offset++)) == 'n') {
            if (this.charAt(this.bp + offset) == 'u' && this.charAt(this.bp + offset + 1) == 'l' && this.charAt(this.bp + offset + 2) == 'l') {
                offset += 3;
            } else {
                this.matchStat = -1;
                return null;
            }
            chLocal = this.charAt(this.bp + offset++);
            if (chLocal == expectNextChar) {
                this.bp += offset - 1;
                this.next();
                this.matchStat = 3;
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        if (chLocal != '\"') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        boolean hasSpecial = false;
        int startIndex = this.bp + 1;
        int endIndex = this.text.indexOf(34, startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str");
        }
        String stringVal = this.subString(this.bp + 1, endIndex - startIndex);
        for (int i = this.bp + 1; i < endIndex; ++i) {
            if (this.charAt(i) != '\\') continue;
            hasSpecial = true;
            break;
        }
        if (hasSpecial) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        offset += endIndex - (this.bp + 1) + 1;
        chLocal = this.charAt(this.bp + offset++);
        String strVal = stringVal;
        if (chLocal == expectNextChar) {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            return strVal;
        }
        this.matchStat = -1;
        return strVal;
    }

    public Enum<?> scanEnum(Class<?> enumClass, SymbolTable symbolTable, char serperator) {
        String name = this.scanSymbolWithSeperator(symbolTable, serperator);
        if (name == null) {
            return null;
        }
        return Enum.valueOf(enumClass, name);
    }

    public String scanSymbolWithSeperator(SymbolTable symbolTable, char serperator) {
        int hash;
        char chLocal;
        int offset;
        block7: {
            this.matchStat = 0;
            offset = 0;
            if ((chLocal = this.charAt(this.bp + offset++)) == 'n') {
                if (this.charAt(this.bp + offset) == 'u' && this.charAt(this.bp + offset + 1) == 'l' && this.charAt(this.bp + offset + 2) == 'l') {
                    offset += 3;
                } else {
                    this.matchStat = -1;
                    return null;
                }
                chLocal = this.charAt(this.bp + offset++);
                if (chLocal == serperator) {
                    this.bp += offset - 1;
                    this.next();
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            if (chLocal != '\"') {
                this.matchStat = -1;
                return null;
            }
            hash = 0;
            do {
                if ((chLocal = this.charAt(this.bp + offset++)) == '\"') break block7;
                hash = 31 * hash + chLocal;
            } while (chLocal != '\\');
            this.matchStat = -1;
            return null;
        }
        int start = this.bp + 0 + 1;
        int len = this.bp + offset - start - 1;
        String strVal = symbolTable.addSymbol(this.text, start, len, hash);
        chLocal = this.charAt(this.bp + offset++);
        if (chLocal == serperator) {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            return strVal;
        }
        this.matchStat = -1;
        return strVal;
    }

    public int scanInt(char expectNext) {
        int value;
        char chLocal;
        this.matchStat = 0;
        int offset = 0;
        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
            value = digits[chLocal];
            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                value = value * 10 + digits[chLocal];
            }
            if (chLocal == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (value < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (chLocal == expectNext) {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        this.matchStat = -1;
        return value;
    }

    public long scanLong(char expectNextChar) {
        long value;
        char chLocal;
        this.matchStat = 0;
        int offset = 0;
        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
            value = digits[chLocal];
            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                value = value * 10L + (long)digits[chLocal];
            }
            if (chLocal == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (value < 0L) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        if (chLocal == expectNextChar) {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        this.matchStat = -1;
        return value;
    }

    private void scanTrue() {
        if (this.ch != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'r') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'u') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b' && this.ch != ':') {
            throw new JSONException("scan true error");
        }
        this.token = 6;
    }

    private void scanTreeSet() {
        if (this.ch != 'T') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'r') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'S') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b' && this.ch != '[' && this.ch != '(') {
            throw new JSONException("scan set error");
        }
        this.token = 22;
    }

    private void scanNullOrNew() {
        if (this.ch != 'n') {
            throw new JSONException("error parse null or new");
        }
        this.next();
        if (this.ch == 'u') {
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse true");
            }
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse true");
            }
            this.next();
            if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
                throw new JSONException("scan true error");
            }
            this.token = 8;
            return;
        }
        if (this.ch != 'e') {
            throw new JSONException("error parse e");
        }
        this.next();
        if (this.ch != 'w') {
            throw new JSONException("error parse w");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan true error");
        }
        this.token = 9;
    }

    private void scanUndefined() {
        if (this.ch != 'u') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'n') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'd') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'f') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'i') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'n') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'd') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan false error");
        }
        this.token = 23;
    }

    private void scanFalse() {
        if (this.ch != 'f') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'a') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'l') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 's') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b' && this.ch != ':') {
            throw new JSONException("scan false error");
        }
        this.token = 7;
    }

    private void scanIdent() {
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            ++this.sp;
            this.next();
        } while (Character.isLetterOrDigit(this.ch));
        String ident = this.stringVal();
        Integer tok = this.keywods.get(ident);
        this.token = tok != null ? tok : 18;
    }

    public final String stringVal() {
        if (!this.hasSpecial) {
            return this.subString(this.np + 1, this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    public final String subString(int offset, int count) {
        char[] chars = new char[count];
        for (int i = offset; i < offset + count; ++i) {
            chars[i - offset] = this.text.charAt(i);
        }
        return new String(chars);
    }

    public final boolean isBlankInput() {
        char chLocal;
        int i = 0;
        while ((chLocal = this.charAt(i)) != '\u001a') {
            if (!JSONLexer.isWhitespace(chLocal)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final void skipWhitespace() {
        while (this.ch < whitespaceFlags.length && whitespaceFlags[this.ch]) {
            this.next();
        }
    }

    private final void scanStringSingleQuote() {
        char chLocal;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((chLocal = this.next()) != '\'') {
            if (chLocal == '\u001a') {
                throw new JSONException("unclosed single-quote string");
            }
            if (chLocal == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp > this.sbuf.length) {
                        char[] newsbuf = new char[this.sp * 2];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    this.text.getChars(this.np + 1, this.np + 1 + this.sp, this.sbuf, 0);
                }
                chLocal = this.next();
                switch (chLocal) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        char x1 = chLocal = this.next();
                        char x2 = chLocal = this.next();
                        int x_val = digits[x1] * 16 + digits[x2];
                        char x_char = (char)x_val;
                        this.putChar(x_char);
                        continue block22;
                    }
                    case 'u': {
                        char c1 = chLocal = this.next();
                        char c2 = chLocal = this.next();
                        char c3 = chLocal = this.next();
                        char c4 = chLocal = this.next();
                        int val = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                        this.putChar((char)val);
                        continue block22;
                    }
                }
                this.ch = chLocal;
                throw new JSONException("unclosed single-quote string");
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(chLocal);
                continue;
            }
            this.sbuf[this.sp++] = chLocal;
        }
        this.token = 4;
        this.next();
    }

    public final void scanSet() {
        if (this.ch != 'S') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b' && this.ch != '[' && this.ch != '(') {
            throw new JSONException("scan set error");
        }
        this.token = 21;
    }

    private void putChar(char ch) {
        if (this.sp == this.sbuf.length) {
            char[] newsbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
            this.sbuf = newsbuf;
        }
        this.sbuf[this.sp++] = ch;
    }

    public final void scanNumber() {
        this.np = this.bp;
        if (this.ch == '-') {
            ++this.sp;
            this.next();
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.next();
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            ++this.sp;
            this.next();
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.next();
            }
        }
        if (this.ch == 'L') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'S') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'B') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'F') {
            ++this.sp;
            this.next();
            isDouble = true;
        } else if (this.ch == 'D') {
            ++this.sp;
            this.next();
            isDouble = true;
        } else if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.next();
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.next();
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.next();
            }
            if (this.ch == 'D' || this.ch == 'F') {
                ++this.sp;
                this.next();
            }
            isDouble = true;
        }
        this.token = isDouble ? 3 : 2;
    }

    public final long longValue() throws NumberFormatException {
        char chLocal;
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max && (chLocal = this.charAt(i++)) != 'L' && chLocal != 'S' && chLocal != 'B') {
            digit = digits[chLocal];
            if (result < multmin) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    public final Number decimalValue(boolean decimal) {
        char chLocal = this.charAt(this.np + this.sp - 1);
        if (chLocal == 'F') {
            return Float.valueOf(Float.parseFloat(this.numberString()));
        }
        if (chLocal == 'D') {
            return Double.parseDouble(this.numberString());
        }
        if (decimal) {
            return this.decimalValue();
        }
        return Double.parseDouble(this.numberString());
    }

    public final BigDecimal decimalValue() {
        return new BigDecimal(this.numberString());
    }

    public static final boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f' || ch == '\b';
    }

    public boolean matchField(char[] fieldName) {
        if (!this.charArrayCompare(fieldName)) {
            return false;
        }
        this.bp += fieldName.length;
        this.ch = this.charAt(this.bp);
        if (this.ch == '{') {
            this.next();
            this.token = 12;
        } else if (this.ch == '[') {
            this.next();
            this.token = 14;
        } else {
            this.nextToken();
        }
        return true;
    }

    private boolean charArrayCompare(char[] chars) {
        int destLen = chars.length;
        if (destLen + this.bp > this.len) {
            return false;
        }
        for (int i = 0; i < destLen; ++i) {
            if (chars[i] == this.text.charAt(this.bp + i)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanFieldInt(char[] fieldName) {
        int value;
        char chLocal;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return 0;
        }
        int offset = fieldName.length;
        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
            value = digits[chLocal];
            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                value = value * 10 + digits[chLocal];
            }
            if (chLocal == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (value < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (chLocal == ',') {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(char[] fieldName) {
        long value;
        char chLocal;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return 0L;
        }
        int offset = fieldName.length;
        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
            value = digits[chLocal];
            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                value = value * 10L + (long)digits[chLocal];
            }
            if (chLocal == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (value < 0L) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        if (chLocal == ',') {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0L;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(char[] fieldName) {
        char chLocal;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
        }
        int offset = fieldName.length;
        if ((chLocal = this.charAt(this.bp + offset++)) != '\"') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        boolean hasSpecial = false;
        int startIndex = this.bp + fieldName.length + 1;
        int endIndex = this.text.indexOf(34, startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str");
        }
        int startIndex2 = this.bp + fieldName.length + 1;
        String stringVal = this.subString(startIndex2, endIndex - startIndex2);
        for (int i = this.bp + fieldName.length + 1; i < endIndex; ++i) {
            if (this.charAt(i) != '\\') continue;
            hasSpecial = true;
            break;
        }
        if (hasSpecial) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        offset += endIndex - (this.bp + fieldName.length + 1) + 1;
        chLocal = this.charAt(this.bp + offset++);
        String strVal = stringVal;
        if (chLocal == ',') {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            return strVal;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return strVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean scanFieldBoolean(char[] fieldName) {
        boolean value;
        char chLocal;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return false;
        }
        int offset = fieldName.length;
        if ((chLocal = this.charAt(this.bp + offset++)) == 't') {
            if (this.charAt(this.bp + offset++) != 'r') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 'u') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            value = true;
        } else {
            if (chLocal != 'f') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 'a') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 'l') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 's') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            value = false;
        }
        chLocal = this.charAt(this.bp + offset++);
        if (chLocal == ',') {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return false;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return false;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final float scanFieldFloat(char[] fieldName) {
        float value;
        char chLocal;
        int offset;
        block15: {
            block16: {
                block14: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(fieldName)) {
                        this.matchStat = -2;
                        return 0.0f;
                    }
                    offset = fieldName.length;
                    if ((chLocal = this.charAt(this.bp + offset++)) < '0' || chLocal > '9') break block14;
                    while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                    }
                    if (chLocal == '.') {
                        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    int start = this.bp + fieldName.length;
                    int count = this.bp + offset - start - 1;
                    String text = this.subString(start, count);
                    value = Float.parseFloat(text);
                    if (chLocal != ',') break block15;
                    break block16;
                }
                this.matchStat = -1;
                return 0.0f;
            }
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0.0f;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0.0f;
            }
            this.bp += offset - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final double scanFieldDouble(char[] fieldName) {
        double value;
        char chLocal;
        int offset;
        block18: {
            block19: {
                block17: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(fieldName)) {
                        this.matchStat = -2;
                        return 0.0;
                    }
                    offset = fieldName.length;
                    if ((chLocal = this.charAt(this.bp + offset++)) < '0' || chLocal > '9') break block17;
                    while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                    }
                    if (chLocal == '.') {
                        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    if (chLocal == 'e' || chLocal == 'E') {
                        if ((chLocal = this.charAt(this.bp + offset++)) == '+' || chLocal == '-') {
                            chLocal = this.charAt(this.bp + offset++);
                        }
                        while (chLocal >= '0' && chLocal <= '9') {
                            chLocal = this.charAt(this.bp + offset++);
                        }
                    }
                    int start = this.bp + fieldName.length;
                    int count = this.bp + offset - start - 1;
                    String text = this.subString(start, count);
                    value = Double.parseDouble(text);
                    if (chLocal != ',') break block18;
                    break block19;
                }
                this.matchStat = -1;
                return 0.0;
            }
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0.0;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0.0;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldSymbol(char[] fieldName, SymbolTable symbolTable) {
        String strVal;
        char chLocal;
        int offset;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(fieldName)) {
                    this.matchStat = -2;
                    return null;
                }
                offset = fieldName.length;
                if ((chLocal = this.charAt(this.bp + offset++)) != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                int hash = 0;
                do {
                    if ((chLocal = this.charAt(this.bp + offset++)) == '\"') {
                        int start = this.bp + fieldName.length + 1;
                        int len = this.bp + offset - start - 1;
                        strVal = symbolTable.addSymbol(this.text, start, len, hash);
                        if ((chLocal = this.charAt(this.bp + offset++)) != ',') break block12;
                        break block13;
                    }
                    hash = 31 * hash + chLocal;
                } while (chLocal != '\\');
                this.matchStat = -1;
                return null;
            }
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            return strVal;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return strVal;
    }

    public boolean scanISO8601DateIfMatch(boolean strict) {
        char S2;
        char s1;
        char s0;
        char m1;
        char m0;
        char h1;
        char d1;
        char d0;
        char M1;
        char M0;
        char y3;
        char y2;
        char y1;
        char y0;
        int rest = this.text.length() - this.bp;
        if (!strict && rest > 13) {
            char c0 = this.charAt(this.bp);
            char c1 = this.charAt(this.bp + 1);
            char c2 = this.charAt(this.bp + 2);
            char c3 = this.charAt(this.bp + 3);
            char c4 = this.charAt(this.bp + 4);
            char c5 = this.charAt(this.bp + 5);
            char c_r0 = this.charAt(this.bp + rest - 1);
            char c_r1 = this.charAt(this.bp + rest - 2);
            if (c0 == '/' && c1 == 'D' && c2 == 'a' && c3 == 't' && c4 == 'e' && c5 == '(' && c_r0 == '/' && c_r1 == ')') {
                int plusIndex = -1;
                for (int i = 6; i < rest; ++i) {
                    char c = this.charAt(this.bp + i);
                    if (c == '+') {
                        plusIndex = i;
                        continue;
                    }
                    if (c < '0' || c > '9') break;
                }
                if (plusIndex == -1) {
                    return false;
                }
                int offset = this.bp + 6;
                String numberText = this.subString(offset, plusIndex - offset);
                long millis = Long.parseLong(numberText);
                Locale local = Locale.getDefault();
                this.calendar = Calendar.getInstance(TimeZone.getDefault(), local);
                this.calendar.setTimeInMillis(millis);
                this.token = 5;
                return true;
            }
        }
        if (rest == 8 || rest == 14 || rest == 17) {
            int seconds;
            int minute;
            int hour;
            int millis;
            if (strict) {
                return false;
            }
            y0 = this.charAt(this.bp);
            if (!JSONLexer.checkDate(y0, y1 = this.charAt(this.bp + 1), y2 = this.charAt(this.bp + 2), y3 = this.charAt(this.bp + 3), M0 = this.charAt(this.bp + 4), M1 = this.charAt(this.bp + 5), d0 = this.charAt(this.bp + 6), d1 = this.charAt(this.bp + 7))) {
                return false;
            }
            this.setCalendar(y0, y1, y2, y3, M0, M1, d0, d1);
            if (rest != 8) {
                char s12;
                char s02;
                char m12;
                char m02;
                char h12;
                char h0 = this.charAt(this.bp + 8);
                if (!JSONLexer.checkTime(h0, h12 = this.charAt(this.bp + 9), m02 = this.charAt(this.bp + 10), m12 = this.charAt(this.bp + 11), s02 = this.charAt(this.bp + 12), s12 = this.charAt(this.bp + 13))) {
                    return false;
                }
                if (rest == 17) {
                    char S0 = this.charAt(this.bp + 14);
                    char S1 = this.charAt(this.bp + 15);
                    char S22 = this.charAt(this.bp + 16);
                    if (S0 < '0' || S0 > '9') {
                        return false;
                    }
                    if (S1 < '0' || S1 > '9') {
                        return false;
                    }
                    if (S22 < '0' || S22 > '9') {
                        return false;
                    }
                    millis = digits[S0] * 100 + digits[S1] * 10 + digits[S22];
                } else {
                    millis = 0;
                }
                hour = digits[h0] * 10 + digits[h12];
                minute = digits[m02] * 10 + digits[m12];
                seconds = digits[s02] * 10 + digits[s12];
            } else {
                hour = 0;
                minute = 0;
                seconds = 0;
                millis = 0;
            }
            this.calendar.set(11, hour);
            this.calendar.set(12, minute);
            this.calendar.set(13, seconds);
            this.calendar.set(14, millis);
            this.token = 5;
            return true;
        }
        if (rest < ISO8601_LEN_0) {
            return false;
        }
        if (this.charAt(this.bp + 4) != '-') {
            return false;
        }
        if (this.charAt(this.bp + 7) != '-') {
            return false;
        }
        y0 = this.charAt(this.bp);
        if (!JSONLexer.checkDate(y0, y1 = this.charAt(this.bp + 1), y2 = this.charAt(this.bp + 2), y3 = this.charAt(this.bp + 3), M0 = this.charAt(this.bp + 5), M1 = this.charAt(this.bp + 6), d0 = this.charAt(this.bp + 8), d1 = this.charAt(this.bp + 9))) {
            return false;
        }
        this.setCalendar(y0, y1, y2, y3, M0, M1, d0, d1);
        char t = this.charAt(this.bp + 10);
        if (t == 'T' || t == ' ' && !strict) {
            if (rest < ISO8601_LEN_1) {
                return false;
            }
        } else {
            if (t == '\"' || t == '\u001a') {
                this.calendar.set(11, 0);
                this.calendar.set(12, 0);
                this.calendar.set(13, 0);
                this.calendar.set(14, 0);
                this.ch = this.charAt(this.bp += 10);
                this.token = 5;
                return true;
            }
            return false;
        }
        if (this.charAt(this.bp + 13) != ':') {
            return false;
        }
        if (this.charAt(this.bp + 16) != ':') {
            return false;
        }
        char h0 = this.charAt(this.bp + 11);
        if (!JSONLexer.checkTime(h0, h1 = this.charAt(this.bp + 12), m0 = this.charAt(this.bp + 14), m1 = this.charAt(this.bp + 15), s0 = this.charAt(this.bp + 17), s1 = this.charAt(this.bp + 18))) {
            return false;
        }
        int hour = digits[h0] * 10 + digits[h1];
        int minute = digits[m0] * 10 + digits[m1];
        int seconds = digits[s0] * 10 + digits[s1];
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, seconds);
        char dot = this.charAt(this.bp + 19);
        if (dot == '.') {
            if (rest < ISO8601_LEN_2) {
                return false;
            }
        } else {
            String[] timeZoneIDs;
            this.calendar.set(14, 0);
            this.ch = this.charAt(this.bp += 19);
            this.token = 5;
            if (dot == 'Z' && this.calendar.getTimeZone().getRawOffset() != 0 && (timeZoneIDs = TimeZone.getAvailableIDs(0)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
                this.calendar.setTimeZone(timeZone);
            }
            return true;
        }
        char S0 = this.charAt(this.bp + 20);
        if (S0 < '0' || S0 > '9') {
            return false;
        }
        int millis = digits[S0];
        int millisLen = 1;
        char S1 = this.charAt(this.bp + 21);
        if (S1 >= '0' && S1 <= '9') {
            millis = millis * 10 + digits[S1];
            millisLen = 2;
        }
        if (millisLen == 2 && (S2 = this.charAt(this.bp + 22)) >= '0' && S2 <= '9') {
            millis = millis * 10 + digits[S2];
            millisLen = 3;
        }
        this.calendar.set(14, millis);
        int timzeZoneLength = 0;
        char timeZoneFlag = this.charAt(this.bp + 20 + millisLen);
        if (timeZoneFlag == '+' || timeZoneFlag == '-') {
            String[] timeZoneIDs;
            char t3;
            char t0 = this.charAt(this.bp + 20 + millisLen + 1);
            if (t0 < '0' || t0 > '1') {
                return false;
            }
            char t1 = this.charAt(this.bp + 20 + millisLen + 2);
            if (t1 < '0' || t1 > '9') {
                return false;
            }
            char t2 = this.charAt(this.bp + 20 + millisLen + 3);
            if (t2 == ':') {
                t3 = this.charAt(this.bp + 20 + millisLen + 4);
                if (t3 != '0') {
                    return false;
                }
                char t4 = this.charAt(this.bp + 20 + millisLen + 5);
                if (t4 != '0') {
                    return false;
                }
                timzeZoneLength = 6;
            } else if (t2 == '0') {
                t3 = this.charAt(this.bp + 20 + millisLen + 4);
                if (t3 != '0') {
                    return false;
                }
                timzeZoneLength = 5;
            } else {
                timzeZoneLength = 3;
            }
            int timeZoneOffset = (digits[t0] * 10 + digits[t1]) * 3600 * 1000;
            if (timeZoneFlag == '-') {
                timeZoneOffset = -timeZoneOffset;
            }
            if (this.calendar.getTimeZone().getRawOffset() != timeZoneOffset && (timeZoneIDs = TimeZone.getAvailableIDs(timeZoneOffset)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
                this.calendar.setTimeZone(timeZone);
            }
        } else if (timeZoneFlag == 'Z') {
            String[] timeZoneIDs;
            timzeZoneLength = 1;
            if (this.calendar.getTimeZone().getRawOffset() != 0 && (timeZoneIDs = TimeZone.getAvailableIDs(0)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
                this.calendar.setTimeZone(timeZone);
            }
        }
        char end = this.charAt(this.bp + (20 + millisLen + timzeZoneLength));
        if (end != '\u001a' && end != '\"') {
            return false;
        }
        this.ch = this.charAt(this.bp += 20 + millisLen + timzeZoneLength);
        this.token = 5;
        return true;
    }

    static boolean checkTime(char h0, char h1, char m0, char m1, char s0, char s1) {
        if (h0 == '0') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '1') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '2') {
            if (h1 < '0' || h1 > '4') {
                return false;
            }
        } else {
            return false;
        }
        if (m0 >= '0' && m0 <= '5') {
            if (m1 < '0' || m1 > '9') {
                return false;
            }
        } else if (m0 == '6') {
            if (m1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        if (s0 >= '0' && s0 <= '5') {
            if (s1 < '0' || s1 > '9') {
                return false;
            }
        } else if (s0 == '6') {
            if (s1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void setCalendar(char y0, char y1, char y2, char y3, char M0, char M1, char d0, char d1) {
        Locale local = Locale.getDefault();
        this.calendar = Calendar.getInstance(TimeZone.getDefault(), local);
        int year = digits[y0] * 1000 + digits[y1] * 100 + digits[y2] * 10 + digits[y3];
        int month = digits[M0] * 10 + digits[M1] - 1;
        int day = digits[d0] * 10 + digits[d1];
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, day);
    }

    static boolean checkDate(char y0, char y1, char y2, char y3, char M0, char M1, int d0, int d1) {
        if (y0 != '1' && y0 != '2') {
            return false;
        }
        if (y1 < '0' || y1 > '9') {
            return false;
        }
        if (y2 < '0' || y2 > '9') {
            return false;
        }
        if (y3 < '0' || y3 > '9') {
            return false;
        }
        if (M0 == '0') {
            if (M1 < '1' || M1 > '9') {
                return false;
            }
        } else if (M0 == '1') {
            if (M1 != '0' && M1 != '1' && M1 != '2') {
                return false;
            }
        } else {
            return false;
        }
        if (d0 == 48) {
            if (d1 < 49 || d1 > 57) {
                return false;
            }
        } else if (d0 == 49 || d0 == 50) {
            if (d1 < 48 || d1 > 57) {
                return false;
            }
        } else if (d0 == 51) {
            if (d1 != 48 && d1 != 49) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static final byte[] decodeFast(char[] chars, int offset, int charsLen) {
        int sIx;
        if (charsLen == 0) {
            return new byte[0];
        }
        int eIx = offset + charsLen - 1;
        for (sIx = offset; sIx < eIx && IA[chars[sIx]] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[chars[eIx]] < 0) {
            --eIx;
        }
        int pad = chars[eIx] == '=' ? (chars[eIx - 1] == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = charsLen > 76 ? (chars[76] == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] bytes = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[chars[sIx++]] << 18 | IA[chars[sIx++]] << 12 | IA[chars[sIx++]] << 6 | IA[chars[sIx++]];
            bytes[d++] = (byte)(i >> 16);
            bytes[d++] = (byte)(i >> 8);
            bytes[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[chars[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                bytes[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return bytes;
    }

    public static final byte[] decodeFast(String chars, int offset, int charsLen) {
        int sIx;
        if (charsLen == 0) {
            return new byte[0];
        }
        int eIx = offset + charsLen - 1;
        for (sIx = offset; sIx < eIx && IA[chars.charAt(sIx)] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[chars.charAt(eIx)] < 0) {
            --eIx;
        }
        int pad = chars.charAt(eIx) == '=' ? (chars.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = charsLen > 76 ? (chars.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] bytes = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[chars.charAt(sIx++)] << 18 | IA[chars.charAt(sIx++)] << 12 | IA[chars.charAt(sIx++)] << 6 | IA[chars.charAt(sIx++)];
            bytes[d++] = (byte)(i >> 16);
            bytes[d++] = (byte)(i >> 8);
            bytes[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[chars.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                bytes[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return bytes;
    }

    public static final byte[] decodeFast(String s) {
        int sIx;
        int sLen = s.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[s.charAt(sIx) & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[s.charAt(eIx) & 0xFF] < 0) {
            --eIx;
        }
        int pad = s.charAt(eIx) == '=' ? (s.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (s.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[s.charAt(sIx++)] << 18 | IA[s.charAt(sIx++)] << 12 | IA[s.charAt(sIx++)] << 6 | IA[s.charAt(sIx++)];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[s.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    static {
        int i;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("null", 8);
        map.put("new", 9);
        map.put("true", 6);
        map.put("false", 7);
        map.put("undefined", 23);
        DEFAULT_KEYWORDS = map;
        SBUF_REF_LOCAL = new ThreadLocal();
        whitespaceFlags = new boolean[256];
        JSONLexer.whitespaceFlags[32] = true;
        JSONLexer.whitespaceFlags[10] = true;
        JSONLexer.whitespaceFlags[13] = true;
        JSONLexer.whitespaceFlags[9] = true;
        JSONLexer.whitespaceFlags[12] = true;
        JSONLexer.whitespaceFlags[8] = true;
        digits = new int[103];
        for (i = 48; i <= 57; ++i) {
            JSONLexer.digits[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            JSONLexer.digits[i] = i - 97 + 10;
        }
        for (i = 65; i <= 70; ++i) {
            JSONLexer.digits[i] = i - 65 + 10;
        }
        ISO8601_LEN_0 = "0000-00-00".length();
        ISO8601_LEN_1 = "0000-00-00T00:00:00".length();
        ISO8601_LEN_2 = "0000-00-00T00:00:00.000".length();
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (i = 0; i < iS; ++i) {
            JSONLexer.IA[JSONLexer.CA[i]] = i;
        }
        JSONLexer.IA[61] = 0;
    }
}

