/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.property;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.converters.AutoConverter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.exception.ExcelCommonException;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.Holder;
import com.alibaba.excel.metadata.property.DateTimeFormatProperty;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.metadata.property.NumberFormatProperty;
import com.alibaba.excel.util.ClassUtils;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.write.metadata.holder.AbstractWriteHolder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelHeadProperty {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelHeadProperty.class);
    private Class headClazz;
    private HeadKindEnum headKind;
    private int headRowNumber;
    private Map<Integer, Head> headMap;
    private Map<Integer, ExcelContentProperty> contentPropertyMap;
    private Map<String, ExcelContentProperty> fieldNameContentPropertyMap;
    private Map<String, Field> ignoreMap;

    public ExcelHeadProperty(Holder holder, Class headClazz, List<List<String>> head, Boolean convertAllFiled) {
        this.headClazz = headClazz;
        this.headMap = new TreeMap<Integer, Head>();
        this.contentPropertyMap = new TreeMap<Integer, ExcelContentProperty>();
        this.fieldNameContentPropertyMap = new HashMap<String, ExcelContentProperty>();
        this.ignoreMap = new HashMap<String, Field>(16);
        this.headKind = HeadKindEnum.NONE;
        this.headRowNumber = 0;
        if (head != null && !head.isEmpty()) {
            int headIndex = 0;
            for (int i = 0; i < head.size(); ++i) {
                if (holder instanceof AbstractWriteHolder && ((AbstractWriteHolder)holder).ignore(null, i)) continue;
                this.headMap.put(headIndex, new Head(headIndex, null, head.get(i), Boolean.FALSE, Boolean.TRUE));
                this.contentPropertyMap.put(headIndex, null);
                ++headIndex;
            }
            this.headKind = HeadKindEnum.STRING;
        }
        this.initColumnProperties(holder, convertAllFiled);
        this.initHeadRowNumber();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The initialization sheet/table 'ExcelHeadProperty' is complete , head kind is {}", (Object)this.headKind);
        }
    }

    private void initHeadRowNumber() {
        List<String> list;
        this.headRowNumber = 0;
        for (Head head : this.headMap.values()) {
            list = head.getHeadNameList();
            if (list == null || list.size() <= this.headRowNumber) continue;
            this.headRowNumber = list.size();
        }
        for (Head head : this.headMap.values()) {
            list = head.getHeadNameList();
            if (list == null || list.isEmpty() || list.size() >= this.headRowNumber) continue;
            int lack = this.headRowNumber - list.size();
            int last = list.size() - 1;
            for (int i = 0; i < lack; ++i) {
                list.add(list.get(last));
            }
        }
    }

    private void initColumnProperties(Holder holder, Boolean convertAllFiled) {
        if (this.headClazz == null) {
            return;
        }
        ArrayList<Field> defaultFieldList = new ArrayList<Field>();
        TreeMap<Integer, Field> customFiledMap = new TreeMap<Integer, Field>();
        ClassUtils.declaredFields(this.headClazz, defaultFieldList, customFiledMap, this.ignoreMap, convertAllFiled);
        int index = 0;
        for (Field field : defaultFieldList) {
            while (customFiledMap.containsKey(index)) {
                Field customFiled = (Field)customFiledMap.get(index);
                customFiledMap.remove(index);
                if (this.initOneColumnProperty(holder, index, customFiled, Boolean.TRUE)) continue;
                ++index;
            }
            this.initOneColumnProperty(holder, index, field, Boolean.FALSE);
            ++index;
        }
        for (Map.Entry entry : customFiledMap.entrySet()) {
            this.initOneColumnProperty(holder, (Integer)entry.getKey(), (Field)entry.getValue(), Boolean.TRUE);
        }
        this.headKind = HeadKindEnum.CLASS;
    }

    private boolean initOneColumnProperty(Holder holder, int index, Field field, Boolean forceIndex) {
        Class<? extends Converter> convertClazz;
        boolean notForceName;
        if (holder instanceof AbstractWriteHolder && ((AbstractWriteHolder)holder).ignore(field.getName(), index)) {
            return true;
        }
        ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
        ArrayList<String> tmpHeadList = new ArrayList<String>();
        boolean bl = notForceName = excelProperty == null || excelProperty.value().length <= 0 || excelProperty.value().length == 1 && StringUtils.isEmpty(excelProperty.value()[0]);
        if (this.headMap.containsKey(index)) {
            tmpHeadList.addAll(this.headMap.get(index).getHeadNameList());
        } else if (notForceName) {
            tmpHeadList.add(field.getName());
        } else {
            Collections.addAll(tmpHeadList, excelProperty.value());
        }
        Head head = new Head(index, field.getName(), tmpHeadList, forceIndex, !notForceName);
        ExcelContentProperty excelContentProperty = new ExcelContentProperty();
        if (excelProperty != null && (convertClazz = excelProperty.converter()) != AutoConverter.class) {
            try {
                Converter converter = convertClazz.newInstance();
                excelContentProperty.setConverter(converter);
            }
            catch (Exception e) {
                throw new ExcelCommonException("Can not instance custom converter:" + convertClazz.getName());
            }
        }
        excelContentProperty.setHead(head);
        excelContentProperty.setField(field);
        excelContentProperty.setDateTimeFormatProperty(DateTimeFormatProperty.build(field.getAnnotation(DateTimeFormat.class)));
        excelContentProperty.setNumberFormatProperty(NumberFormatProperty.build(field.getAnnotation(NumberFormat.class)));
        this.headMap.put(index, head);
        this.contentPropertyMap.put(index, excelContentProperty);
        this.fieldNameContentPropertyMap.put(field.getName(), excelContentProperty);
        return false;
    }

    public Class getHeadClazz() {
        return this.headClazz;
    }

    public void setHeadClazz(Class headClazz) {
        this.headClazz = headClazz;
    }

    public HeadKindEnum getHeadKind() {
        return this.headKind;
    }

    public void setHeadKind(HeadKindEnum headKind) {
        this.headKind = headKind;
    }

    public boolean hasHead() {
        return this.headKind != HeadKindEnum.NONE;
    }

    public int getHeadRowNumber() {
        return this.headRowNumber;
    }

    public void setHeadRowNumber(int headRowNumber) {
        this.headRowNumber = headRowNumber;
    }

    public Map<Integer, Head> getHeadMap() {
        return this.headMap;
    }

    public void setHeadMap(Map<Integer, Head> headMap) {
        this.headMap = headMap;
    }

    public Map<Integer, ExcelContentProperty> getContentPropertyMap() {
        return this.contentPropertyMap;
    }

    public void setContentPropertyMap(Map<Integer, ExcelContentProperty> contentPropertyMap) {
        this.contentPropertyMap = contentPropertyMap;
    }

    public Map<String, ExcelContentProperty> getFieldNameContentPropertyMap() {
        return this.fieldNameContentPropertyMap;
    }

    public void setFieldNameContentPropertyMap(Map<String, ExcelContentProperty> fieldNameContentPropertyMap) {
        this.fieldNameContentPropertyMap = fieldNameContentPropertyMap;
    }

    public Map<String, Field> getIgnoreMap() {
        return this.ignoreMap;
    }

    public void setIgnoreMap(Map<String, Field> ignoreMap) {
        this.ignoreMap = ignoreMap;
    }
}

