/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.metadata.holder;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.DefaultConverterLoader;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.event.NotRepeatExecutor;
import com.alibaba.excel.event.Order;
import com.alibaba.excel.metadata.AbstractHolder;
import com.alibaba.excel.metadata.Font;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.TableStyle;
import com.alibaba.excel.metadata.property.LoopMergeProperty;
import com.alibaba.excel.metadata.property.OnceAbsoluteMergeProperty;
import com.alibaba.excel.metadata.property.RowHeightProperty;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.DefaultWriteHandlerLoader;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.handler.WorkbookWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.merge.LoopMergeStrategy;
import com.alibaba.excel.write.merge.OnceAbsoluteMergeStrategy;
import com.alibaba.excel.write.metadata.WriteBasicParameter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.property.ExcelWriteHeadProperty;
import com.alibaba.excel.write.style.AbstractVerticalCellStyleStrategy;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.AbstractHeadColumnWidthStyleStrategy;
import com.alibaba.excel.write.style.row.SimpleRowHeightStyleStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;

public abstract class AbstractWriteHolder
extends AbstractHolder
implements WriteHolder {
    private Boolean needHead;
    private Integer relativeHeadRowIndex;
    private ExcelWriteHeadProperty excelWriteHeadProperty;
    private Map<Class<? extends WriteHandler>, List<WriteHandler>> writeHandlerMap;
    private Boolean useDefaultStyle;
    private Boolean automaticMergeHead;
    private Collection<Integer> excludeColumnIndexes;
    private Collection<String> excludeColumnFiledNames;
    private Collection<Integer> includeColumnIndexes;
    private Collection<String> includeColumnFiledNames;

    public AbstractWriteHolder(WriteBasicParameter writeBasicParameter, AbstractWriteHolder parentAbstractWriteHolder, Boolean convertAllFiled) {
        super(writeBasicParameter, parentAbstractWriteHolder);
        if (writeBasicParameter.getUse1904windowing() == null) {
            if (parentAbstractWriteHolder == null) {
                this.getGlobalConfiguration().setUse1904windowing(Boolean.FALSE);
            } else {
                this.getGlobalConfiguration().setUse1904windowing(parentAbstractWriteHolder.getGlobalConfiguration().getUse1904windowing());
            }
        } else {
            this.getGlobalConfiguration().setUse1904windowing(writeBasicParameter.getUse1904windowing());
        }
        this.needHead = writeBasicParameter.getNeedHead() == null ? (parentAbstractWriteHolder == null ? Boolean.TRUE : parentAbstractWriteHolder.getNeedHead()) : writeBasicParameter.getNeedHead();
        this.relativeHeadRowIndex = writeBasicParameter.getRelativeHeadRowIndex() == null ? (parentAbstractWriteHolder == null ? Integer.valueOf(0) : parentAbstractWriteHolder.getRelativeHeadRowIndex()) : writeBasicParameter.getRelativeHeadRowIndex();
        this.useDefaultStyle = writeBasicParameter.getUseDefaultStyle() == null ? (parentAbstractWriteHolder == null ? Boolean.TRUE : parentAbstractWriteHolder.getUseDefaultStyle()) : writeBasicParameter.getUseDefaultStyle();
        this.automaticMergeHead = writeBasicParameter.getAutomaticMergeHead() == null ? (parentAbstractWriteHolder == null ? Boolean.TRUE : parentAbstractWriteHolder.getAutomaticMergeHead()) : writeBasicParameter.getAutomaticMergeHead();
        this.excludeColumnFiledNames = writeBasicParameter.getExcludeColumnFiledNames() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getExcludeColumnFiledNames() : writeBasicParameter.getExcludeColumnFiledNames();
        this.excludeColumnIndexes = writeBasicParameter.getExcludeColumnIndexes() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getExcludeColumnIndexes() : writeBasicParameter.getExcludeColumnIndexes();
        this.includeColumnFiledNames = writeBasicParameter.getIncludeColumnFiledNames() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getIncludeColumnFiledNames() : writeBasicParameter.getIncludeColumnFiledNames();
        this.includeColumnIndexes = writeBasicParameter.getIncludeColumnIndexes() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getIncludeColumnIndexes() : writeBasicParameter.getIncludeColumnIndexes();
        this.excelWriteHeadProperty = new ExcelWriteHeadProperty(this, this.getClazz(), this.getHead(), convertAllFiled);
        this.compatibleOldCode(writeBasicParameter);
        ArrayList<WriteHandler> handlerList = new ArrayList<WriteHandler>();
        this.initAnnotationConfig(handlerList);
        if (writeBasicParameter.getCustomWriteHandlerList() != null && !writeBasicParameter.getCustomWriteHandlerList().isEmpty()) {
            handlerList.addAll(writeBasicParameter.getCustomWriteHandlerList());
        }
        Map<Class<? extends WriteHandler>, List<WriteHandler>> parentWriteHandlerMap = null;
        if (parentAbstractWriteHolder != null) {
            parentWriteHandlerMap = parentAbstractWriteHolder.getWriteHandlerMap();
        } else {
            handlerList.addAll(DefaultWriteHandlerLoader.loadDefaultHandler(this.useDefaultStyle));
        }
        this.writeHandlerMap = this.sortAndClearUpHandler(handlerList, parentWriteHandlerMap);
        if (parentAbstractWriteHolder == null) {
            this.setConverterMap(DefaultConverterLoader.loadDefaultWriteConverter());
        } else {
            this.setConverterMap(new HashMap<String, Converter>(parentAbstractWriteHolder.getConverterMap()));
        }
        if (writeBasicParameter.getCustomConverterList() != null && !writeBasicParameter.getCustomConverterList().isEmpty()) {
            for (Converter converter : writeBasicParameter.getCustomConverterList()) {
                this.getConverterMap().put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey()), converter);
            }
        }
    }

    @Deprecated
    private void compatibleOldCode(WriteBasicParameter writeBasicParameter) {
        switch (this.holderType()) {
            case SHEET: {
                this.compatibleOldCodeCreateRowCellStyleStrategy(writeBasicParameter, ((WriteSheet)writeBasicParameter).getTableStyle());
                this.compatibleOldCodeCreateHeadColumnWidthStyleStrategy(writeBasicParameter, ((WriteSheet)writeBasicParameter).getColumnWidthMap());
                return;
            }
            case TABLE: {
                this.compatibleOldCodeCreateRowCellStyleStrategy(writeBasicParameter, ((WriteTable)writeBasicParameter).getTableStyle());
                return;
            }
        }
    }

    @Deprecated
    private void compatibleOldCodeCreateRowCellStyleStrategy(WriteBasicParameter writeBasicParameter, TableStyle tableStyle) {
        if (tableStyle == null) {
            return;
        }
        if (writeBasicParameter.getCustomWriteHandlerList() == null) {
            writeBasicParameter.setCustomWriteHandlerList(new ArrayList<WriteHandler>());
        }
        writeBasicParameter.getCustomWriteHandlerList().add(new HorizontalCellStyleStrategy(this.buildWriteCellStyle(tableStyle.getTableHeadFont(), tableStyle.getTableHeadBackGroundColor()), this.buildWriteCellStyle(tableStyle.getTableContentFont(), tableStyle.getTableContentBackGroundColor())));
    }

    @Deprecated
    private WriteCellStyle buildWriteCellStyle(Font font, IndexedColors indexedColors) {
        WriteCellStyle writeCellStyle = new WriteCellStyle();
        if (indexedColors != null) {
            writeCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
            writeCellStyle.setFillForegroundColor(indexedColors.getIndex());
        }
        if (font != null) {
            WriteFont writeFont = new WriteFont();
            writeFont.setFontName(font.getFontName());
            writeFont.setFontHeightInPoints(font.getFontHeightInPoints());
            writeFont.setBold(font.isBold());
            writeCellStyle.setWriteFont(writeFont);
        }
        return writeCellStyle;
    }

    @Deprecated
    private void compatibleOldCodeCreateHeadColumnWidthStyleStrategy(WriteBasicParameter writeBasicParameter, final Map<Integer, Integer> columnWidthMap) {
        if (columnWidthMap == null || columnWidthMap.isEmpty()) {
            return;
        }
        if (writeBasicParameter.getCustomWriteHandlerList() == null) {
            writeBasicParameter.setCustomWriteHandlerList(new ArrayList<WriteHandler>());
        }
        writeBasicParameter.getCustomWriteHandlerList().add(new AbstractHeadColumnWidthStyleStrategy(){

            @Override
            protected Integer columnWidth(Head head, Integer columnIndex) {
                if (columnWidthMap.containsKey(head.getColumnIndex())) {
                    return (Integer)columnWidthMap.get(head.getColumnIndex()) / 256;
                }
                return 20;
            }
        });
    }

    protected void initAnnotationConfig(List<WriteHandler> handlerList) {
        if (!HeadKindEnum.CLASS.equals((Object)this.getExcelWriteHeadProperty().getHeadKind())) {
            return;
        }
        Map<Integer, Head> headMap = this.getExcelWriteHeadProperty().getHeadMap();
        boolean hasColumnWidth = false;
        boolean hasStyle = false;
        for (Head head : headMap.values()) {
            if (head.getColumnWidthProperty() != null) {
                hasColumnWidth = true;
            }
            if (head.getHeadStyleProperty() != null || head.getHeadFontProperty() != null || head.getContentStyleProperty() != null || head.getContentFontProperty() != null) {
                hasStyle = true;
            }
            this.dealLoopMerge(handlerList, head);
        }
        if (hasColumnWidth) {
            this.dealColumnWidth(handlerList);
        }
        if (hasStyle) {
            this.dealStyle(handlerList);
        }
        this.dealRowHigh(handlerList);
        this.dealOnceAbsoluteMerge(handlerList);
    }

    private void dealStyle(List<WriteHandler> handlerList) {
        AbstractVerticalCellStyleStrategy styleStrategy = new AbstractVerticalCellStyleStrategy(){

            @Override
            protected WriteCellStyle headCellStyle(Head head) {
                return WriteCellStyle.build(head.getHeadStyleProperty(), head.getHeadFontProperty());
            }

            @Override
            protected WriteCellStyle contentCellStyle(Head head) {
                return WriteCellStyle.build(head.getContentStyleProperty(), head.getContentFontProperty());
            }
        };
        handlerList.add(styleStrategy);
    }

    private void dealLoopMerge(List<WriteHandler> handlerList, Head head) {
        LoopMergeProperty loopMergeProperty = head.getLoopMergeProperty();
        if (loopMergeProperty == null) {
            return;
        }
        handlerList.add(new LoopMergeStrategy(loopMergeProperty, head.getColumnIndex()));
    }

    private void dealOnceAbsoluteMerge(List<WriteHandler> handlerList) {
        OnceAbsoluteMergeProperty onceAbsoluteMergeProperty = this.getExcelWriteHeadProperty().getOnceAbsoluteMergeProperty();
        if (onceAbsoluteMergeProperty == null) {
            return;
        }
        handlerList.add(new OnceAbsoluteMergeStrategy(onceAbsoluteMergeProperty));
    }

    private void dealRowHigh(List<WriteHandler> handlerList) {
        RowHeightProperty headRowHeightProperty = this.getExcelWriteHeadProperty().getHeadRowHeightProperty();
        RowHeightProperty contentRowHeightProperty = this.getExcelWriteHeadProperty().getContentRowHeightProperty();
        if (headRowHeightProperty == null && contentRowHeightProperty == null) {
            return;
        }
        Short headRowHeight = null;
        if (headRowHeightProperty != null) {
            headRowHeight = headRowHeightProperty.getHeight();
        }
        Short contentRowHeight = null;
        if (contentRowHeightProperty != null) {
            contentRowHeight = contentRowHeightProperty.getHeight();
        }
        handlerList.add(new SimpleRowHeightStyleStrategy(headRowHeight, contentRowHeight));
    }

    private void dealColumnWidth(List<WriteHandler> handlerList) {
        AbstractHeadColumnWidthStyleStrategy columnWidthStyleStrategy = new AbstractHeadColumnWidthStyleStrategy(){

            @Override
            protected Integer columnWidth(Head head, Integer columnIndex) {
                if (head == null) {
                    return null;
                }
                if (head.getColumnWidthProperty() != null) {
                    return head.getColumnWidthProperty().getWidth();
                }
                return null;
            }
        };
        handlerList.add(columnWidthStyleStrategy);
    }

    protected Map<Class<? extends WriteHandler>, List<WriteHandler>> sortAndClearUpHandler(List<WriteHandler> handlerList, Map<Class<? extends WriteHandler>, List<WriteHandler>> parentHandlerMap) {
        List<WriteHandler> parentWriteHandler;
        if (parentHandlerMap != null && !CollectionUtils.isEmpty(parentWriteHandler = parentHandlerMap.get(WriteHandler.class))) {
            handlerList.addAll(parentWriteHandler);
        }
        TreeMap orderExcelWriteHandlerMap = new TreeMap();
        for (WriteHandler handler : handlerList) {
            int order = Integer.MIN_VALUE;
            if (handler instanceof Order) {
                order = ((Order)((Object)handler)).order();
            }
            if (orderExcelWriteHandlerMap.containsKey(order)) {
                ((List)orderExcelWriteHandlerMap.get(order)).add(handler);
                continue;
            }
            ArrayList<WriteHandler> tempHandlerList = new ArrayList<WriteHandler>();
            tempHandlerList.add(handler);
            orderExcelWriteHandlerMap.put(order, tempHandlerList);
        }
        HashSet<String> alreadyExistedHandlerSet = new HashSet<String>();
        ArrayList<WriteHandler> cleanUpHandlerList = new ArrayList<WriteHandler>();
        for (Map.Entry entry : orderExcelWriteHandlerMap.entrySet()) {
            for (WriteHandler handler : (List)entry.getValue()) {
                if (handler instanceof NotRepeatExecutor) {
                    String uniqueValue = ((NotRepeatExecutor)((Object)handler)).uniqueValue();
                    if (alreadyExistedHandlerSet.contains(uniqueValue)) continue;
                    alreadyExistedHandlerSet.add(uniqueValue);
                }
                cleanUpHandlerList.add(handler);
            }
        }
        HashMap<Class<? extends WriteHandler>, List<WriteHandler>> result = new HashMap<Class<? extends WriteHandler>, List<WriteHandler>>(16);
        result.put(WriteHandler.class, new ArrayList());
        result.put(WorkbookWriteHandler.class, new ArrayList());
        result.put(SheetWriteHandler.class, new ArrayList());
        result.put(RowWriteHandler.class, new ArrayList());
        result.put(CellWriteHandler.class, new ArrayList());
        for (WriteHandler writeHandler : cleanUpHandlerList) {
            if (writeHandler instanceof CellWriteHandler) {
                ((List)result.get(CellWriteHandler.class)).add(writeHandler);
            }
            if (writeHandler instanceof RowWriteHandler) {
                ((List)result.get(RowWriteHandler.class)).add(writeHandler);
            }
            if (writeHandler instanceof SheetWriteHandler) {
                ((List)result.get(SheetWriteHandler.class)).add(writeHandler);
            }
            if (writeHandler instanceof WorkbookWriteHandler) {
                ((List)result.get(WorkbookWriteHandler.class)).add(writeHandler);
            }
            ((List)result.get(WriteHandler.class)).add(writeHandler);
        }
        return result;
    }

    @Override
    public boolean ignore(String fieldName, Integer columnIndex) {
        if (fieldName != null) {
            if (this.includeColumnFiledNames != null && !this.includeColumnFiledNames.contains(fieldName)) {
                return true;
            }
            if (this.excludeColumnFiledNames != null && this.excludeColumnFiledNames.contains(fieldName)) {
                return true;
            }
        }
        if (columnIndex != null) {
            if (this.includeColumnIndexes != null && !this.includeColumnIndexes.contains(columnIndex)) {
                return true;
            }
            if (this.excludeColumnIndexes != null && this.excludeColumnIndexes.contains(columnIndex)) {
                return true;
            }
        }
        return false;
    }

    public Boolean getNeedHead() {
        return this.needHead;
    }

    public void setNeedHead(Boolean needHead) {
        this.needHead = needHead;
    }

    public Map<Class<? extends WriteHandler>, List<WriteHandler>> getWriteHandlerMap() {
        return this.writeHandlerMap;
    }

    public void setWriteHandlerMap(Map<Class<? extends WriteHandler>, List<WriteHandler>> writeHandlerMap) {
        this.writeHandlerMap = writeHandlerMap;
    }

    public ExcelWriteHeadProperty getExcelWriteHeadProperty() {
        return this.excelWriteHeadProperty;
    }

    public void setExcelWriteHeadProperty(ExcelWriteHeadProperty excelWriteHeadProperty) {
        this.excelWriteHeadProperty = excelWriteHeadProperty;
    }

    public Integer getRelativeHeadRowIndex() {
        return this.relativeHeadRowIndex;
    }

    public void setRelativeHeadRowIndex(Integer relativeHeadRowIndex) {
        this.relativeHeadRowIndex = relativeHeadRowIndex;
    }

    public Boolean getUseDefaultStyle() {
        return this.useDefaultStyle;
    }

    public void setUseDefaultStyle(Boolean useDefaultStyle) {
        this.useDefaultStyle = useDefaultStyle;
    }

    public Boolean getAutomaticMergeHead() {
        return this.automaticMergeHead;
    }

    public void setAutomaticMergeHead(Boolean automaticMergeHead) {
        this.automaticMergeHead = automaticMergeHead;
    }

    public Collection<Integer> getExcludeColumnIndexes() {
        return this.excludeColumnIndexes;
    }

    public void setExcludeColumnIndexes(Collection<Integer> excludeColumnIndexes) {
        this.excludeColumnIndexes = excludeColumnIndexes;
    }

    public Collection<String> getExcludeColumnFiledNames() {
        return this.excludeColumnFiledNames;
    }

    public void setExcludeColumnFiledNames(Collection<String> excludeColumnFiledNames) {
        this.excludeColumnFiledNames = excludeColumnFiledNames;
    }

    public Collection<Integer> getIncludeColumnIndexes() {
        return this.includeColumnIndexes;
    }

    public void setIncludeColumnIndexes(Collection<Integer> includeColumnIndexes) {
        this.includeColumnIndexes = includeColumnIndexes;
    }

    public Collection<String> getIncludeColumnFiledNames() {
        return this.includeColumnFiledNames;
    }

    public void setIncludeColumnFiledNames(Collection<String> includeColumnFiledNames) {
        this.includeColumnFiledNames = includeColumnFiledNames;
    }

    @Override
    public ExcelWriteHeadProperty excelWriteHeadProperty() {
        return this.getExcelWriteHeadProperty();
    }

    @Override
    public Map<Class<? extends WriteHandler>, List<WriteHandler>> writeHandlerMap() {
        return this.getWriteHandlerMap();
    }

    @Override
    public boolean needHead() {
        return this.getNeedHead();
    }

    @Override
    public int relativeHeadRowIndex() {
        return this.getRelativeHeadRowIndex();
    }

    @Override
    public boolean automaticMergeHead() {
        return this.getAutomaticMergeHead();
    }
}

