/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.builder;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import java.util.ArrayList;
import java.util.List;

public class ExcelWriterTableBuilder {
    private ExcelWriter excelWriter;
    private WriteSheet writeSheet;
    private WriteTable writeTable;

    public ExcelWriterTableBuilder() {
        this.writeTable = new WriteTable();
    }

    public ExcelWriterTableBuilder(ExcelWriter excelWriter, WriteSheet writeSheet) {
        this.excelWriter = excelWriter;
        this.writeSheet = writeSheet;
        this.writeTable = new WriteTable();
    }

    public ExcelWriterTableBuilder relativeHeadRowIndex(Integer relativeHeadRowIndex) {
        this.writeTable.setRelativeHeadRowIndex(relativeHeadRowIndex);
        return this;
    }

    public ExcelWriterTableBuilder head(List<List<String>> head) {
        this.writeTable.setHead(head);
        return this;
    }

    public ExcelWriterTableBuilder head(Class clazz) {
        this.writeTable.setClazz(clazz);
        return this;
    }

    public ExcelWriterTableBuilder needHead(Boolean needHead) {
        this.writeTable.setNeedHead(needHead);
        return this;
    }

    public ExcelWriterTableBuilder registerConverter(Converter converter) {
        if (this.writeTable.getCustomConverterList() == null) {
            this.writeTable.setCustomConverterList(new ArrayList<Converter>());
        }
        this.writeTable.getCustomConverterList().add(converter);
        return this;
    }

    public ExcelWriterTableBuilder registerWriteHandler(WriteHandler writeHandler) {
        if (this.writeTable.getCustomWriteHandlerList() == null) {
            this.writeTable.setCustomWriteHandlerList(new ArrayList<WriteHandler>());
        }
        this.writeTable.getCustomWriteHandlerList().add(writeHandler);
        return this;
    }

    public ExcelWriterTableBuilder tableNo(Integer tableNo) {
        this.writeTable.setTableNo(tableNo);
        return this;
    }

    public WriteTable build() {
        return this.writeTable;
    }

    public void doWrite(List data) {
        if (this.excelWriter == null) {
            throw new ExcelGenerateException("Must use 'EasyExcelFactory.write().sheet().table()' to call this method");
        }
        this.excelWriter.write(data, this.writeSheet, this.build());
        this.excelWriter.finish();
    }
}

