/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis;

import com.alibaba.excel.analysis.ExcelAnalyser;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.event.AnalysisEventRegisterCenter;
import com.alibaba.excel.event.OneRowAnalysisFinishEvent;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.util.TypeUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseSaxAnalyser
implements AnalysisEventRegisterCenter,
ExcelAnalyser {
    protected AnalysisContext analysisContext;
    private LinkedHashMap<String, AnalysisEventListener> listeners = new LinkedHashMap();

    protected abstract void execute();

    @Override
    public void appendLister(String name, AnalysisEventListener listener) {
        if (!this.listeners.containsKey(name)) {
            this.listeners.put(name, listener);
        }
    }

    @Override
    public void analysis(Sheet sheetParam) {
        this.execute();
    }

    @Override
    public void analysis() {
        this.execute();
    }

    @Override
    public void cleanAllListeners() {
        this.listeners = new LinkedHashMap();
    }

    @Override
    public void notifyListeners(OneRowAnalysisFinishEvent event) {
        this.analysisContext.setCurrentRowAnalysisResult(event.getData());
        if (this.analysisContext.getCurrentRowNum() < this.analysisContext.getCurrentSheet().getHeadLineMun()) {
            if (this.analysisContext.getCurrentRowNum() <= this.analysisContext.getCurrentSheet().getHeadLineMun() - 1) {
                this.analysisContext.buildExcelHeadProperty(null, (List)this.analysisContext.getCurrentRowAnalysisResult());
            }
        } else {
            List<String> content = this.converter((List)event.getData());
            this.analysisContext.setCurrentRowAnalysisResult(content);
            if (this.listeners.size() == 1) {
                this.analysisContext.setCurrentRowAnalysisResult(content);
            }
            for (Map.Entry<String, AnalysisEventListener> entry : this.listeners.entrySet()) {
                entry.getValue().invoke(this.analysisContext.getCurrentRowAnalysisResult(), this.analysisContext);
            }
        }
    }

    private List<String> converter(List<String> data) {
        ArrayList<String> list = new ArrayList<String>();
        if (data != null) {
            for (String str : data) {
                list.add(TypeUtil.formatFloat(str));
            }
        }
        return list;
    }
}

