/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.common.threadpool.support.eager;

import com.alibaba.dubbo.common.threadpool.support.eager.EagerThreadPoolExecutor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class TaskQueue<R extends Runnable>
extends LinkedBlockingQueue<Runnable> {
    private static final long serialVersionUID = -2635853580887179627L;
    private EagerThreadPoolExecutor executor;

    public TaskQueue(int capacity) {
        super(capacity);
    }

    public void setExecutor(EagerThreadPoolExecutor exec) {
        this.executor = exec;
    }

    @Override
    public boolean offer(Runnable runnable) {
        if (this.executor == null) {
            throw new RejectedExecutionException("The task queue does not have executor!");
        }
        int currentPoolThreadSize = this.executor.getPoolSize();
        if (this.executor.getSubmittedTaskCount() < currentPoolThreadSize) {
            return super.offer(runnable);
        }
        if (currentPoolThreadSize < this.executor.getMaximumPoolSize()) {
            return false;
        }
        return super.offer(runnable);
    }

    public boolean retryOffer(Runnable o, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.executor.isShutdown()) {
            throw new RejectedExecutionException("Executor is shutdown!");
        }
        return super.offer(o, timeout, unit);
    }
}

